/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.util.logging;

import org.pentaho.platform.api.engine.ILogger;
import org.pentaho.platform.util.logging.Logger;
import org.pentaho.platform.util.messages.Messages;

public class SimpleLogger
implements ILogger {
    private Object id;

    public SimpleLogger(Object caller) {
        this.id = caller == null ? Messages.getString("Logger.DEBUG_LOG_UNKNOWN") : caller.getClass().getName();
    }

    public SimpleLogger(String callerName) {
        this.id = callerName;
    }

    public String getLogLevelName(int localLogLevel) {
        return Logger.getLogLevelName(localLogLevel);
    }

    public int getLogLevel(String localLogLevel) {
        return Logger.getLogLevel(localLogLevel);
    }

    public int getLoggingLevel() {
        return Logger.getLogLevel();
    }

    public int getLogLevel() {
        return Logger.getLogLevel();
    }

    public void setLoggingLevel(int newLogLevel) {
        Logger.setLogLevel(newLogLevel);
    }

    public void trace(String message) {
        Logger.trace(this.id, message);
    }

    public void debug(String message) {
        Logger.debug(this.id, message);
    }

    public void info(String message) {
        Logger.info(this.id, message);
    }

    public void warn(String message) {
        Logger.warn(this.id, message);
    }

    public void error(String message) {
        Logger.error(this.id, message);
    }

    public void fatal(String message) {
        Logger.fatal(this.id, message);
    }

    public void trace(String message, Throwable error) {
        Logger.trace(this.id, message, error);
    }

    public void debug(String message, Throwable error) {
        Logger.debug(this.id, message, error);
    }

    public void info(String message, Throwable error) {
        Logger.info(this.id, message, error);
    }

    public void warn(String message, Throwable error) {
        Logger.warn(this.id, message, error);
    }

    public void error(String message, Throwable error) {
        Logger.error(this.id, message, error);
    }

    public void fatal(String message, Throwable error) {
        Logger.fatal(this.id, message, error);
    }
}

