/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.util.xml.dom4j;

import java.util.HashMap;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.pentaho.commons.connection.IPentahoMetaData;
import org.pentaho.commons.connection.IPentahoResultSet;
import org.pentaho.platform.util.messages.LocaleHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataGrid {
    public static final int STYLE_ROWS = 1;
    public static final int STYLE_TREE = 2;
    Document gridDocument;
    int documentStyle;

    public DataGrid(int documentStyle) {
        this.documentStyle = documentStyle;
    }

    public Document getDataDocument() {
        return this.gridDocument;
    }

    public int getDocumentStyle() {
        return this.documentStyle;
    }

    public void populate(IPentahoResultSet results) {
        switch (this.documentStyle) {
            case 1: {
                this.populateRowStyle(results);
            }
        }
    }

    protected void populateRowStyle(IPentahoResultSet results) {
        this.gridDocument = DocumentHelper.createDocument();
        this.gridDocument.setXMLEncoding(LocaleHelper.getSystemEncoding());
        Element root = this.gridDocument.addElement("datagrid");
        Element metadataNode = root.addElement("metadata");
        HashMap<String, String> headerMap = new HashMap<String, String>();
        IPentahoMetaData metadata = results.getMetaData();
        Object[][] headers = metadata.getColumnHeaders();
        this.addHeaderMetadata(headers, metadataNode, headerMap);
        Element rowsNode = root.addElement("data");
        Object[] row = results.next();
        while (row != null) {
            Element rowNode;
            Element currentNode = rowNode = rowsNode.addElement("row");
            for (int columnNo = 0; columnNo < row.length; ++columnNo) {
                for (int headerNo = 0; headerNo < headers.length; ++headerNo) {
                    Object columnHeader = headers[headerNo][columnNo];
                    String headerId = headerMap.get(columnHeader);
                    currentNode = currentNode.addElement(headerId);
                    if (headerNo >= row.length) continue;
                    currentNode.addElement("value").setText(row[headerNo].toString());
                }
            }
            row = results.next();
        }
    }

    protected void addHeaderMetadata(Object[][] headers, Element metadataNode, HashMap<String, String> headerMap) {
        if (headers == null) {
            return;
        }
        HashMap<String, String> metadataMap = new HashMap<String, String>();
        for (Object[] element : headers) {
            for (int y = 0; y < element.length; ++y) {
                String headerStr;
                Object header = element[y];
                if (header instanceof String) {
                    headerStr = (String)header;
                    metadataMap.put(headerStr, headerStr);
                    this.createMetadata(headerStr, metadataNode, headerMap);
                    continue;
                }
                headerStr = header.toString();
                metadataMap.put(headerStr, headerStr);
                this.createMetadata(headerStr, metadataNode, headerMap);
            }
        }
    }

    protected void createMetadata(String header, Element metadataNode, HashMap<String, String> headerMap) {
        Element node = metadataNode.addElement("header");
        String id = "header" + headerMap.keySet().size();
        node.addAttribute("id", id);
        node.addElement("name").setText(header);
        node.addAttribute("format", "");
        Element title = node.addElement("title");
        title.setText(header);
        headerMap.put(header, id);
    }
}

