/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.util.xml.dom4j;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.Set;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.pentaho.platform.api.util.XmlParseException;
import org.pentaho.platform.util.messages.Messages;
import org.pentaho.platform.util.xml.XmlHelper;
import org.xml.sax.EntityResolver;

public class XmlDom4JHelper {
    private static final Log logger = LogFactory.getLog(XmlDom4JHelper.class);

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Document getDocFromString(String strXml, String encoding, EntityResolver resolver) throws XmlParseException {
        byte[] bytes = null;
        Document document = null;
        ByteArrayInputStream inStrm = null;
        try {
            bytes = null != encoding ? strXml.getBytes(encoding) : strXml.getBytes();
            inStrm = new ByteArrayInputStream(bytes);
            document = XmlDom4JHelper.getDocFromStream(inStrm, encoding, resolver);
        }
        catch (DocumentException e) {
            try {
                throw new XmlParseException(Messages.getErrorString("XmlDom4JHelper.ERROR_0001_UNABLE_TO_GET_DOCUMENT_FROM_STRING"), (Throwable)e);
                catch (UnsupportedEncodingException e2) {
                    throw new XmlParseException(Messages.getErrorString("XmlDom4JHelper.ERROR_0002_UNSUPPORTED_ENCODING"), (Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                XmlDom4JHelper.closeInputStream(inStrm);
                throw throwable;
            }
        }
        XmlDom4JHelper.closeInputStream(inStrm);
        return document;
    }

    public static Document getDocFromString(String strXml, EntityResolver resolver) throws XmlParseException {
        String encoding = XmlHelper.getEncoding(strXml);
        return XmlDom4JHelper.getDocFromString(strXml, encoding, resolver);
    }

    public static Document getDocFromFile(String path, EntityResolver resolver) throws DocumentException, IOException {
        File file = new File(path);
        return XmlDom4JHelper.getDocFromFile(file, resolver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document getDocFromFile(File file, EntityResolver resolver) throws DocumentException, IOException {
        FileInputStream fInStrm = null;
        Document document = null;
        try {
            String encoding = XmlHelper.getEncoding(file);
            fInStrm = new FileInputStream(file);
            document = XmlDom4JHelper.getDocFromStream(fInStrm, encoding, resolver);
        }
        catch (Throwable throwable) {
            XmlDom4JHelper.closeInputStream(fInStrm);
            throw throwable;
        }
        XmlDom4JHelper.closeInputStream(fInStrm);
        return document;
    }

    private static Document getDocFromStream(InputStream inStream, String encoding, EntityResolver resolver) throws DocumentException {
        SAXReader rdr = new SAXReader();
        if (null != encoding) {
            rdr.setEncoding(encoding);
        }
        if (null != resolver) {
            rdr.setEntityResolver(resolver);
        }
        Document document = rdr.read(inStream);
        return document;
    }

    public static Document getDocFromStream(InputStream inStream, EntityResolver resolver) throws DocumentException, IOException {
        String encoding = XmlHelper.getEncoding(inStream);
        return XmlDom4JHelper.getDocFromStream(inStream, encoding, resolver);
    }

    public static Document getDocFromStream(InputStream inStream) throws DocumentException, IOException {
        return XmlDom4JHelper.getDocFromStream(inStream, null);
    }

    protected static final StringBuffer transformXml(StreamSource xslSrc, StreamSource docSrc, Map params, URIResolver resolver) throws TransformerConfigurationException, TransformerException {
        StringBuffer sb = null;
        StringWriter writer = new StringWriter();
        TransformerFactory tf = TransformerFactory.newInstance();
        if (null != resolver) {
            tf.setURIResolver(resolver);
        }
        Transformer t = tf.newTransformer(xslSrc);
        if (params != null) {
            Set keys = params.keySet();
            for (String key : keys) {
                String val = (String)params.get(key);
                if (val == null) continue;
                t.setParameter(key, val);
            }
        }
        t.transform(docSrc, new StreamResult(writer));
        sb = writer.getBuffer();
        return sb;
    }

    public static final StringBuffer docToString(org.w3c.dom.Document doc) throws TransformerConfigurationException, TransformerException {
        StringBuffer sb = null;
        StringWriter writer = new StringWriter();
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer t = tf.newTransformer();
        DOMSource docSrc = new DOMSource(doc);
        t.transform(docSrc, new StreamResult(writer));
        sb = writer.getBuffer();
        return sb;
    }

    public static String getXmlEncodedString(String rawValue) {
        StringBuffer value = new StringBuffer();
        for (int n = 0; n < rawValue.length(); ++n) {
            char charValue = rawValue.charAt(n);
            if (charValue >= '\u0080') {
                value.append("&#x");
                value.append(Integer.toString(charValue, 16));
                value.append(";");
                continue;
            }
            value.append(charValue);
        }
        return value.toString();
    }

    public static void saveDomToFile(Document doc, String filePath, String encoding) throws IOException {
        File file = new File(filePath);
        XmlDom4JHelper.saveDomToFile(doc, file, encoding);
    }

    public static void saveDomToFile(Document doc, File file, String encoding) throws IOException {
        OutputStreamWriter fWriter = null;
        fWriter = null != encoding ? new OutputStreamWriter((OutputStream)new FileOutputStream(file), encoding) : new OutputStreamWriter(new FileOutputStream(file));
        XmlDom4JHelper.saveDomToWriter(doc, fWriter);
    }

    public static void saveDomToWriter(Document doc, Writer writer) throws IOException {
        writer.write(doc.asXML());
    }

    public static void main(String[] args) {
        String[] xmls;
        String strXml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><root><b>first</b><b>second</b></root>";
        try {
            Document d = XmlDom4JHelper.getDocFromString(strXml, null);
            String enc = d.getXMLEncoding();
            System.out.println("encoding: " + enc);
        }
        catch (Exception e3) {
            e3.printStackTrace();
        }
        String defaultEncoding = new OutputStreamWriter(new ByteArrayOutputStream()).getEncoding();
        Charset cs = Charset.defaultCharset();
        System.out.println("default Char set: " + cs.name() + " " + defaultEncoding);
        ByteArrayInputStream s = new ByteArrayInputStream(strXml.getBytes());
        try {
            for (int ii = 0; ii < 5; ++ii) {
                String pi = XmlHelper.readEncodingProcessingInstruction(s);
                String encoding = XmlHelper.getEncoding(pi);
                System.out.println("encoding: " + encoding);
            }
            s.close();
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        try {
            Document doc = XmlDom4JHelper.getDocFromString(strXml, null);
            Node n = doc.selectSingleNode("/root/b[text()='first']");
            System.out.println(n.getText());
        }
        catch (Exception e1) {
            e1.printStackTrace();
            System.exit(1);
        }
        for (String element : xmls = new String[]{"", "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<pentaho-system></pentaho-system>", "<?xml version=\"1.0\" encoding=\"windows-1252\"?>\n<root></root>", "<?xml encoding=\"UTF-8\" version=\"1.0\"?><root></root>", "<?xml encoding=\"UTF-8\" version='1.0'?><root></root>", "<?xml encoding='UTF-8' version=\"1.0\"?><root></root>", "<?xml encoding='UTF-8' version='1.0'?><root></root>", "<?xml encoding='UTF-8\" version='1.0'?><root></root>", "<?xml version=\"1.0\"?><root></root>", "bart simpson was here", "<root>encoding=bad</root>"}) {
            String enc = XmlHelper.getEncoding(element);
            System.out.println("2xml: {0} enc: {1}" + element + " enc: " + enc);
            enc = "";
        }
        int numTries = 10000;
        String nm = "C:\\projects\\pentaho\\pentaho-reportwizard\\samples\\data\\ClassicCars.xml";
        nm = "C:\\projects\\pentaho1.6\\pentaho-solutions\\system\\pentaho.xml";
        String xml = null;
        try {
            xml = XmlDom4JHelper.getDocFromFile(nm, null).asXML();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        long start0 = System.currentTimeMillis();
        for (int ii = 0; ii < 10000; ++ii) {
            XmlHelper.getEncoding(xml);
        }
        long end0 = System.currentTimeMillis();
        System.out.println("time: " + (end0 - start0));
        long start1 = System.currentTimeMillis();
        for (int ii = 0; ii < 10000; ++ii) {
            for (int jj = 0; jj < xml.length(); ++jj) {
                xml.charAt(jj);
            }
        }
        long end1 = System.currentTimeMillis();
        System.out.println("time: " + (end1 - start1));
    }

    protected static void closeInputStream(InputStream strm) {
        if (null != strm) {
            try {
                strm.close();
            }
            catch (IOException e) {
                logger.warn((Object)"Failed to close InputStream.", (Throwable)e);
            }
        }
    }

    public static String getNodeText(String xpath, Node rootNode) {
        return XmlDom4JHelper.getNodeText(xpath, rootNode, null);
    }

    public static long getNodeText(String xpath, Node rootNode, long defaultValue) {
        String valueStr = XmlDom4JHelper.getNodeText(xpath, rootNode, Long.toString(defaultValue));
        try {
            return Long.parseLong(valueStr);
        }
        catch (Exception ignored) {
            return defaultValue;
        }
    }

    public static double getNodeText(String xpath, Node rootNode, double defaultValue) {
        String valueStr = XmlDom4JHelper.getNodeText(xpath, rootNode, null);
        if (valueStr == null) {
            return defaultValue;
        }
        try {
            return Double.parseDouble(valueStr);
        }
        catch (Exception ignored) {
            return defaultValue;
        }
    }

    public static String getNodeText(String xpath, Node rootNode, String defaultValue) {
        if (rootNode == null) {
            return defaultValue;
        }
        Node node = rootNode.selectSingleNode(xpath);
        if (node == null) {
            return defaultValue;
        }
        return node.getText();
    }
}

