/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GlyphMetrics;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.internal.carbon.ATSFontMetrics;
import org.eclipse.swt.internal.carbon.ATSTrapezoid;
import org.eclipse.swt.internal.carbon.ATSUCaret;
import org.eclipse.swt.internal.carbon.ATSUTab;
import org.eclipse.swt.internal.carbon.ATSUUnhighlightData;
import org.eclipse.swt.internal.carbon.CGRect;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.internal.carbon.RGBColor;
import org.eclipse.swt.internal.carbon.Rect;

public final class TextLayout
extends Resource {
    Font font;
    String text;
    int textPtr;
    StyleItem[] styles;
    int layout;
    int spacing;
    int ascent;
    int descent;
    int indent;
    int indentStyle;
    int[] tabs;
    int[] segments;
    int tabsPtr;
    int[] breaks;
    int[] hardBreaks;
    int[] lineX;
    int[] lineWidth;
    int[] lineHeight;
    int[] lineAscent;
    static final int TAB_COUNT = 32;
    int[] invalidOffsets;
    static final char LTR_MARK = '\u200e';
    static final char RTL_MARK = '\u200f';
    static final char ZWS = '\u200b';
    static final int UNDERLINE_IME_INPUT = 65536;
    static final int UNDERLINE_IME_TARGET_CONVERTED = 131072;
    static final int UNDERLINE_IME_CONVERTED = 196608;

    public TextLayout(Device device) {
        super(device);
        int[] nArray = new int[1];
        OS.ATSUCreateTextLayout(nArray);
        if (nArray[0] == 0) {
            SWT.error(2);
        }
        this.layout = nArray[0];
        this.setLayoutControl(3, 0, 1);
        int n = 16777256;
        this.setLayoutControl(7, n, 4);
        OS.ATSUSetHighlightingMethod(this.layout, 1, new ATSUUnhighlightData());
        this.descent = -1;
        this.ascent = -1;
        this.text = "";
        this.styles = new StyleItem[2];
        this.styles[0] = new StyleItem();
        this.styles[1] = new StyleItem();
        this.init();
    }

    void checkLayout() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
    }

    void computeRuns() {
        int n;
        Object object;
        char c;
        if (this.breaks != null) {
            return;
        }
        String string = this.getSegmentsText();
        int n2 = string.length();
        char[] cArray = new char[n2 + 1];
        string.getChars(0, n2, cArray, 1);
        cArray[0] = 8203;
        int n3 = 1;
        int n4 = 0;
        while (n4 < cArray.length) {
            c = cArray[n4];
            if (c == '\n' || c == '\r') {
                ++n3;
            }
            ++n4;
        }
        this.hardBreaks = new int[n3];
        n3 = 0;
        n4 = 0;
        while (n4 < cArray.length) {
            c = cArray[n4];
            if (c == '\n' || c == '\r') {
                cArray[n4] = 8203;
                this.hardBreaks[n3++] = n4;
            }
            ++n4;
        }
        if (this.invalidOffsets != null) {
            n4 = 0;
            while (n4 < this.invalidOffsets.length) {
                int n5 = n4++;
                this.invalidOffsets[n5] = this.invalidOffsets[n5] + 1;
            }
        } else {
            this.invalidOffsets = new int[0];
        }
        this.hardBreaks[n3] = cArray.length;
        n4 = OS.NewPtr(cArray.length * 2);
        OS.memmove(n4, cArray, cArray.length * 2);
        OS.ATSUSetTextPointerLocation(this.layout, n4, 0, cArray.length, cArray.length);
        OS.ATSUSetTransientFontMatching(this.layout, true);
        if (this.textPtr != 0) {
            OS.DisposePtr(this.textPtr);
        }
        this.textPtr = n4;
        int[] nArray = new int[1];
        Font font = this.font != null ? this.font : this.device.systemFont;
        int n6 = 0;
        while (n6 < this.styles.length - 1) {
            object = this.styles[n6];
            ((StyleItem)object).createStyle(this.device, font);
            int n7 = n2 != 0 ? this.translateOffset(((StyleItem)object).start) : 0;
            int n8 = this.translateOffset(this.styles[n6 + 1].start) - n7;
            OS.ATSUSetRunStyle(this.layout, ((StyleItem)object).atsuStyle, n7, n8);
            ++n6;
        }
        n6 = OS.NewPtr(12);
        int[] nArray2 = new int[3];
        nArray2[0] = OS.Long2Fix(this.indent);
        nArray = nArray2;
        OS.memmove(n6, nArray, 12);
        object = new int[]{266, 284, 285};
        int[] nArray3 = new int[]{4, 4, 4};
        int[] nArray4 = new int[]{n6, n6 + 4, n6 + 8};
        OS.ATSUCreateStyle(nArray);
        this.indentStyle = nArray[0];
        OS.ATSUSetAttributes(this.indentStyle, ((Object)object).length, (int[])object, nArray3, nArray4);
        OS.DisposePtr(n6);
        OS.ATSUSetRunStyle(this.layout, this.indentStyle, 0, 1);
        int n9 = 0;
        while (n9 < this.hardBreaks.length - 1) {
            n = this.hardBreaks[n9];
            OS.ATSUSetRunStyle(this.layout, this.indentStyle, n, 1);
            ++n9;
        }
        OS.ATSUGetLayoutControl(this.layout, 1, 4, nArray, null);
        n9 = nArray[0];
        n = 0;
        int n10 = 0;
        while (n < this.hardBreaks.length) {
            int n11 = this.hardBreaks[n];
            nArray[0] = 0;
            if (n9 != 0) {
                OS.ATSUBatchBreakLines(this.layout, n10, n11 - n10, n9, nArray);
            }
            OS.ATSUSetSoftLineBreak(this.layout, n11);
            n10 = n11;
            ++n;
        }
        OS.ATSUGetSoftLineBreaks(this.layout, 0, -1, 0, null, nArray);
        n = nArray[0];
        this.breaks = new int[n];
        OS.ATSUGetSoftLineBreaks(this.layout, 0, -1, n, this.breaks, null);
        n10 = this.breaks.length;
        this.lineX = new int[n10];
        this.lineWidth = new int[n10];
        this.lineHeight = new int[n10];
        this.lineAscent = new int[n10];
        ATSTrapezoid aTSTrapezoid = new ATSTrapezoid();
        int n12 = 0;
        int n13 = 0;
        while (n12 < n10) {
            if (this.ascent != -1) {
                n6 = OS.NewPtr(4);
                nArray[0] = Integer.MAX_VALUE;
                OS.memmove(n6, nArray, 4);
                object = new int[]{8};
                nArray3 = new int[]{4};
                nArray4 = new int[]{n6};
                OS.ATSUSetLineControls(this.layout, n13, ((Object)object).length, (int[])object, nArray3, nArray4);
                OS.ATSUGetLineControl(this.layout, n13, 8, 4, nArray, null);
                nArray[0] = OS.Long2Fix(Math.max(this.ascent, OS.Fix2Long(nArray[0])));
                OS.memmove(n6, nArray, 4);
                OS.ATSUSetLineControls(this.layout, n13, ((Object)object).length, (int[])object, nArray3, nArray4);
                OS.DisposePtr(n6);
            }
            if (this.descent != -1) {
                n6 = OS.NewPtr(4);
                nArray[0] = Integer.MAX_VALUE;
                OS.memmove(n6, nArray, 4);
                object = new int[]{9};
                nArray3 = new int[]{4};
                nArray4 = new int[]{n6};
                OS.ATSUSetLineControls(this.layout, n13, ((Object)object).length, (int[])object, nArray3, nArray4);
                OS.ATSUGetLineControl(this.layout, n13, 9, 4, nArray, null);
                nArray[0] = OS.Long2Fix(Math.max(this.descent, OS.Fix2Long(nArray[0])));
                OS.memmove(n6, nArray, 4);
                OS.ATSUSetLineControls(this.layout, n13, ((Object)object).length, (int[])object, nArray3, nArray4);
                OS.DisposePtr(n6);
            }
            int n14 = this.breaks[n12];
            int n15 = n14 - n13;
            OS.ATSUGetGlyphBounds(this.layout, 0, 0, n13, n15, (short)1, 1, aTSTrapezoid, null);
            this.lineX[n12] = OS.Fix2Long(aTSTrapezoid.lowerLeft_x);
            this.lineAscent[n12] = -OS.Fix2Long(aTSTrapezoid.upperRight_y);
            if (n15 != 0) {
                this.lineWidth[n12] = OS.Fix2Long(aTSTrapezoid.lowerRight_x) - OS.Fix2Long(aTSTrapezoid.lowerLeft_x);
            }
            this.lineHeight[n12] = OS.Fix2Long(aTSTrapezoid.lowerRight_y) + this.lineAscent[n12] + this.spacing;
            n13 = n14;
            ++n12;
        }
    }

    float[] computePolyline(int n, int n2, int n3, int n4) {
        int n5;
        int n6 = n4 - n2;
        int n7 = 2 * n6;
        int n8 = Compatibility.ceil(n3 - n, n7);
        if (n8 == 0 && n3 - n > 2) {
            n8 = 1;
        }
        if ((n5 = (2 * n8 + 1) * 2) < 0) {
            return new float[0];
        }
        float[] fArray = new float[n5];
        int n9 = 0;
        while (n9 < n8) {
            int n10 = 4 * n9;
            fArray[n10] = n + n7 * n9;
            fArray[n10 + 1] = n4;
            fArray[n10 + 2] = fArray[n10] + (float)(n7 / 2);
            fArray[n10 + 3] = n2;
            ++n9;
        }
        fArray[n5 - 2] = n + n7 * n8;
        fArray[n5 - 1] = n4;
        return fArray;
    }

    void destroy() {
        this.freeRuns();
        this.font = null;
        this.text = null;
        this.styles = null;
        if (this.layout != 0) {
            OS.ATSUDisposeTextLayout(this.layout);
        }
        this.layout = 0;
        if (this.textPtr != 0) {
            OS.DisposePtr(this.textPtr);
        }
        this.textPtr = 0;
        if (this.tabsPtr != 0) {
            OS.DisposePtr(this.tabsPtr);
        }
        this.tabsPtr = 0;
        if (this.indentStyle != 0) {
            OS.ATSUDisposeStyle(this.indentStyle);
        }
        this.indentStyle = 0;
    }

    public void draw(GC gC, int n, int n2) {
        this.draw(gC, n, n2, -1, -1, null, null);
    }

    public void draw(GC gC, int n, int n2, int n3, int n4, Color color, Color color2) {
        this.draw(gC, n, n2, n3, n4, color, color2, 0);
    }

    public void draw(GC gC, int n, int n2, int n3, int n4, Color color, Color color2, int n5) {
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        int n12;
        int n13;
        int n14;
        int n15;
        int n16;
        int n17;
        int n18;
        this.checkLayout();
        this.computeRuns();
        if (gC == null) {
            SWT.error(4);
        }
        if (gC.isDisposed()) {
            SWT.error(5);
        }
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        if (color2 != null && color2.isDisposed()) {
            SWT.error(5);
        }
        if ((n18 = this.translateOffset(this.text.length())) == 0 && n5 == 0) {
            return;
        }
        gC.checkGC(256);
        if (gC.data.updateClip) {
            gC.setCGClipping();
        }
        OS.CGContextSaveGState(gC.handle);
        this.setLayoutControl(Short.MAX_VALUE, gC.handle, 4);
        boolean bl = n3 <= n4 && n3 != -1 && n4 != -1;
        boolean bl2 = false;
        if (bl || (n5 & 0x100000) != 0) {
            if (color2 != null) {
                bl2 = true;
                n17 = OS.CGColorCreate(this.device.colorspace, color2.handle);
                this.setLayoutControl(17, n17, 4);
                OS.CGColorRelease(n17);
            } else {
                color2 = this.device.getSystemColor(25);
            }
        }
        n17 = 0;
        CGRect cGRect = null;
        int n19 = 0;
        while (n19 < this.styles.length) {
            StyleItem styleItem = this.styles[n19];
            TextStyle textStyle = styleItem.style;
            if (textStyle != null && textStyle.background != null) {
                n16 = this.translateOffset(styleItem.start);
                n15 = n19 + 1 < this.styles.length ? this.translateOffset(this.styles[n19 + 1].start - 1) : n18;
                n14 = 0;
                n13 = 0;
                n12 = 0;
                while (n14 < this.breaks.length) {
                    n11 = this.breaks[n14];
                    n10 = n11 - 1;
                    if (n16 <= n10 && n15 >= n13) {
                        n9 = Math.max(n13, n16);
                        n8 = Math.min(n10, n15);
                        n7 = n8 - n9 + 1;
                        if (n7 > 0) {
                            OS.CGContextSaveGState(gC.handle);
                            if (n17 == 0) {
                                n17 = OS.NewRgn();
                            }
                            OS.ATSUGetTextHighlight(this.layout, OS.Long2Fix(n), OS.Long2Fix(n2 + n12 + this.lineAscent[n14]), n9, n7, n17);
                            n6 = OS.HIShapeCreateWithQDRgn(n17);
                            OS.HIShapeReplacePathInCGContext(n6, gC.handle);
                            if (cGRect == null) {
                                cGRect = new CGRect();
                            }
                            OS.CGContextGetPathBoundingBox(gC.handle, cGRect);
                            OS.CGContextEOClip(gC.handle);
                            OS.CGContextSetFillColorSpace(gC.handle, this.device.colorspace);
                            OS.CGContextSetFillColor(gC.handle, textStyle.background.handle);
                            OS.CGContextFillRect(gC.handle, cGRect);
                            OS.DisposeControl(n6);
                            OS.CGContextRestoreGState(gC.handle);
                        }
                    }
                    if (n10 > n15) break;
                    n12 += this.lineHeight[n14];
                    n13 = n11;
                    ++n14;
                }
            }
            ++n19;
        }
        n3 = this.translateOffset(n3);
        n4 = this.translateOffset(n4);
        OS.CGContextScaleCTM(gC.handle, 1.0f, -1.0f);
        n19 = OS.Long2Fix(n);
        int n20 = n2;
        int n21 = 0;
        n16 = 0;
        while (n21 < this.breaks.length) {
            n15 = this.breaks[n21];
            n14 = n15 - n16;
            if (n14 > 0) {
                n13 = OS.Long2Fix(-(n20 + this.lineAscent[n21]));
                OS.ATSUDrawText(this.layout, n16, n14, n19, n13);
                n12 = n16 + n14 - 1;
                if (n5 != 0 && (bl || (n5 & 0x100000) != 0)) {
                    n11 = 0;
                    if (n21 == this.breaks.length - 1 && (n5 & 0x100000) != 0) {
                        n11 = 1;
                    } else {
                        n10 = 0;
                        n9 = 0;
                        while (n9 < this.hardBreaks.length) {
                            if (n12 + 1 == this.hardBreaks[n9]) {
                                n10 = 1;
                                break;
                            }
                            ++n9;
                        }
                        if (n10 != 0) {
                            if (n3 <= n12 + 1 && n12 + 1 <= n4) {
                                n11 = 1;
                            }
                        } else if (n3 <= n12 + 1 && n12 + 1 < n4 && (n5 & 0x10000) != 0) {
                            n11 = 1;
                        }
                    }
                    if (n11 != 0) {
                        if (cGRect == null) {
                            cGRect = new CGRect();
                        }
                        cGRect.x = n + this.lineWidth[n21];
                        cGRect.y = n20;
                        cGRect.width = (n5 & 0x10000) != 0 ? Integer.MAX_VALUE : this.lineHeight[n21] / 3;
                        cGRect.height = this.lineHeight[n21];
                        OS.CGContextSaveGState(gC.handle);
                        OS.CGContextTranslateCTM(gC.handle, 0.0f, -(this.lineHeight[n21] + 2 * n20));
                        OS.CGContextSetFillColorSpace(gC.handle, this.device.colorspace);
                        OS.CGContextSetFillColor(gC.handle, color2.handle);
                        OS.CGContextFillRect(gC.handle, cGRect);
                        OS.CGContextRestoreGState(gC.handle);
                    }
                }
                if (bl && n3 <= n12 && n16 <= n4) {
                    n11 = Math.max(n3, n16);
                    n10 = Math.min(n4, n12);
                    OS.ATSUHighlightText(this.layout, n19, n13, n11, n10 - n11 + 1);
                }
            }
            n20 += this.lineHeight[n21];
            n16 = n15;
            ++n21;
        }
        if (bl2) {
            this.setLayoutControl(17, 0, 4);
        }
        OS.CGContextRestoreGState(gC.handle);
        n21 = 0;
        while (n21 < this.styles.length) {
            StyleItem styleItem = this.styles[n21];
            TextStyle textStyle = styleItem.style;
            if (textStyle != null) {
                n14 = textStyle.underline && textStyle.underlineStyle != 0 && textStyle.underlineStyle != 1 ? 1 : 0;
                n14 = n14 != 0 && (n21 + 1 == this.styles.length || !textStyle.isAdherentUnderline(this.styles[n21 + 1].style)) ? 1 : 0;
                n13 = textStyle.borderStyle != 0 ? 1 : 0;
                int n22 = n13 = n13 != 0 && (n21 + 1 == this.styles.length || !textStyle.isAdherentBorder(this.styles[n21 + 1].style)) ? 1 : 0;
                if (n14 != 0 || n13 != 0) {
                    n12 = n21 + 1 < this.styles.length ? this.translateOffset(this.styles[n21 + 1].start - 1) : n18;
                    n11 = 0;
                    n10 = 0;
                    n9 = 0;
                    while (n11 < this.breaks.length) {
                        int n23;
                        int n24;
                        int n25;
                        int n26;
                        int n27;
                        n8 = this.breaks[n11];
                        n7 = n8 - 1;
                        if (n14 != 0) {
                            n6 = styleItem.start;
                            n27 = n21;
                            while (n27 > 0 && textStyle.isAdherentUnderline(this.styles[n27 - 1].style)) {
                                n6 = this.styles[n27 - 1].start;
                                --n27;
                            }
                            if ((n6 = this.translateOffset(n6)) <= n7 && n12 >= n10) {
                                n27 = Math.max(n10, n6);
                                n26 = Math.min(n7, n12);
                                n25 = n26 - n27 + 1;
                                if (n25 > 0) {
                                    Object object;
                                    OS.CGContextSaveGState(gC.handle);
                                    float f = n2 + n9;
                                    float[] fArray = gC.data.foreground;
                                    float f2 = 1.0f;
                                    float[] fArray2 = null;
                                    n24 = 0;
                                    n23 = 0;
                                    switch (textStyle.underlineStyle) {
                                        case 2: {
                                            f2 = 2.0f;
                                            fArray2 = new float[]{1.0f, 3.0f};
                                            n24 = 1;
                                            n23 = 1;
                                        }
                                        case 3: {
                                            if (textStyle.underlineColor != null) {
                                                fArray = textStyle.underlineColor.handle;
                                            } else if (textStyle.foreground != null) {
                                                fArray = textStyle.foreground.handle;
                                            }
                                            f += (float)(2 * this.lineAscent[n11]) + f2;
                                            break;
                                        }
                                        case 65536: 
                                        case 131072: 
                                        case 196608: {
                                            float[] fArray3;
                                            f2 = 1.5f;
                                            if (textStyle.underlineStyle == 196608) {
                                                float[] fArray4 = new float[4];
                                                fArray4[0] = 0.5f;
                                                fArray4[1] = 0.5f;
                                                fArray4[2] = 0.5f;
                                                fArray3 = fArray4;
                                                fArray4[3] = 1.0f;
                                            } else {
                                                float[] fArray5 = new float[4];
                                                fArray5[0] = 0.0f;
                                                fArray5[1] = 0.0f;
                                                fArray5[2] = 0.0f;
                                                fArray3 = fArray5;
                                                fArray5[3] = 1.0f;
                                            }
                                            fArray = fArray3;
                                            object = textStyle.font;
                                            if (object == null) {
                                                object = this.font != null ? this.font : this.device.systemFont;
                                            }
                                            ATSFontMetrics aTSFontMetrics = new ATSFontMetrics();
                                            OS.ATSFontGetHorizontalMetrics(((Font)object).handle, 0, aTSFontMetrics);
                                            f += (float)(this.lineAscent[n11] + this.lineHeight[n11]) + aTSFontMetrics.descent * ((Font)object).size;
                                        }
                                    }
                                    OS.CGContextSetStrokeColorSpace(gC.handle, this.device.colorspace);
                                    OS.CGContextSetStrokeColor(gC.handle, fArray);
                                    OS.CGContextSetLineWidth(gC.handle, f2);
                                    OS.CGContextSetLineCap(gC.handle, n24);
                                    OS.CGContextSetLineJoin(gC.handle, n23);
                                    OS.CGContextSetLineDash(gC.handle, 0.0f, fArray2, fArray2 != null ? fArray2.length : 0);
                                    OS.CGContextTranslateCTM(gC.handle, 0.5f, 0.5f);
                                    object = new int[1];
                                    OS.ATSUGetGlyphBounds(this.layout, OS.Long2Fix(n), OS.X2Fix(f), n27, n25, (short)1, 0, 0, (int[])object);
                                    int n28 = OS.malloc((int)(object[0] * 32));
                                    OS.ATSUGetGlyphBounds(this.layout, OS.Long2Fix(n), OS.X2Fix(f), n27, n25, (short)1, (int)object[0], n28, (int[])object);
                                    ATSTrapezoid aTSTrapezoid = new ATSTrapezoid();
                                    int n29 = 0;
                                    while (n29 < object[0]) {
                                        float f3;
                                        float f4;
                                        float f5;
                                        float f6;
                                        float f7;
                                        float f8;
                                        float f9;
                                        float f10;
                                        OS.memmove(aTSTrapezoid, n28 + n29 * 32, 32);
                                        if (aTSTrapezoid.upperLeft_x != aTSTrapezoid.lowerLeft_x) {
                                            f10 = OS.Fix2Long(aTSTrapezoid.upperLeft_x);
                                            f9 = OS.Fix2Long(aTSTrapezoid.upperLeft_y);
                                            f8 = OS.Fix2Long(aTSTrapezoid.lowerLeft_x);
                                            f7 = OS.Fix2Long(aTSTrapezoid.lowerLeft_y);
                                            f6 = (f9 - f7) / (f10 - f8);
                                            f5 = f9 - f10 * f6;
                                            f4 = (f - f5) / f6;
                                        } else {
                                            f4 = OS.Fix2Long(aTSTrapezoid.upperLeft_x);
                                        }
                                        if (aTSTrapezoid.upperRight_x != aTSTrapezoid.lowerRight_x) {
                                            f10 = OS.Fix2Long(aTSTrapezoid.upperRight_x);
                                            f9 = OS.Fix2Long(aTSTrapezoid.upperRight_y);
                                            f8 = OS.Fix2Long(aTSTrapezoid.lowerRight_x);
                                            f7 = OS.Fix2Long(aTSTrapezoid.lowerRight_y);
                                            f6 = (f9 - f7) / (f10 - f8);
                                            f5 = f9 - f10 * f6;
                                            f3 = (f - f5) / f6;
                                        } else {
                                            f3 = OS.Fix2Long(aTSTrapezoid.upperRight_x);
                                        }
                                        switch (textStyle.underlineStyle) {
                                            case 131072: 
                                            case 196608: {
                                                f4 += 1.0f;
                                                f3 -= 1.0f;
                                            }
                                        }
                                        if (textStyle.underlineStyle == 3) {
                                            int n30 = n2 + n9 + this.lineHeight[n11];
                                            int n31 = 1;
                                            int n32 = 2 * n31;
                                            f7 = Math.min(OS.Fix2Long(aTSTrapezoid.upperLeft_y) - n32 / 2, n30 - n32 - 1);
                                            float[] fArray6 = this.computePolyline((int)f4, (int)f7, (int)f3, (int)(f7 + (float)n32));
                                            OS.CGContextBeginPath(gC.handle);
                                            OS.CGContextAddLines(gC.handle, fArray6, fArray6.length / 2);
                                        } else {
                                            OS.CGContextMoveToPoint(gC.handle, f4, OS.Fix2Long(aTSTrapezoid.upperLeft_y));
                                            OS.CGContextAddLineToPoint(gC.handle, f3, OS.Fix2Long(aTSTrapezoid.upperRight_y));
                                        }
                                        ++n29;
                                    }
                                    OS.free(n28);
                                    OS.CGContextStrokePath(gC.handle);
                                    OS.CGContextRestoreGState(gC.handle);
                                }
                            }
                        }
                        if (n13 != 0) {
                            n6 = styleItem.start;
                            n27 = n21;
                            while (n27 > 0 && textStyle.isAdherentBorder(this.styles[n27 - 1].style)) {
                                n6 = this.styles[n27 - 1].start;
                                --n27;
                            }
                            if ((n6 = this.translateOffset(n6)) <= n7 && n12 >= n10) {
                                n27 = Math.max(n10, n6);
                                n26 = Math.min(n7, n12);
                                n25 = n26 - n27 + 1;
                                if (n25 > 0) {
                                    OS.CGContextSaveGState(gC.handle);
                                    int[] nArray = new int[1];
                                    OS.ATSUGetGlyphBounds(this.layout, OS.Long2Fix(n), OS.Long2Fix(n2 + n9 + this.lineAscent[n11]), n27, n25, (short)1, 0, 0, nArray);
                                    int n33 = OS.malloc(nArray[0] * 32);
                                    OS.ATSUGetGlyphBounds(this.layout, OS.Long2Fix(n), OS.Long2Fix(n2 + n9 + this.lineAscent[n11]), n27, n25, (short)1, nArray[0], n33, nArray);
                                    ATSTrapezoid aTSTrapezoid = new ATSTrapezoid();
                                    int n34 = 0;
                                    while (n34 < nArray[0]) {
                                        OS.memmove(aTSTrapezoid, n33 + n34 * 32, 32);
                                        n24 = n2 + n9 + 1;
                                        n23 = n2 + n9 + this.lineHeight[n11];
                                        OS.CGContextMoveToPoint(gC.handle, OS.Fix2Long(aTSTrapezoid.lowerLeft_x), n23);
                                        OS.CGContextAddLineToPoint(gC.handle, OS.Fix2Long(aTSTrapezoid.upperLeft_x), n24);
                                        OS.CGContextAddLineToPoint(gC.handle, OS.Fix2Long(aTSTrapezoid.upperRight_x) - 1, n24);
                                        OS.CGContextAddLineToPoint(gC.handle, OS.Fix2Long(aTSTrapezoid.lowerRight_x) - 1, n23);
                                        OS.CGContextClosePath(gC.handle);
                                        ++n34;
                                    }
                                    OS.free(n33);
                                    n34 = 1;
                                    OS.CGContextSetShouldAntialias(gC.handle, false);
                                    OS.CGContextSetLineCap(gC.handle, 0);
                                    OS.CGContextSetLineJoin(gC.handle, 0);
                                    OS.CGContextSetLineWidth(gC.handle, n34);
                                    float[] fArray = null;
                                    switch (textStyle.borderStyle) {
                                        case 1: {
                                            break;
                                        }
                                        case 2: {
                                            fArray = n34 != 0 ? GC.LINE_DASH : GC.LINE_DASH_ZERO;
                                            break;
                                        }
                                        case 4: {
                                            fArray = n34 != 0 ? GC.LINE_DOT : GC.LINE_DOT_ZERO;
                                        }
                                    }
                                    OS.CGContextSetLineDash(gC.handle, 0.0f, fArray, fArray != null ? fArray.length : 0);
                                    float[] fArray7 = null;
                                    if (textStyle.borderColor != null) {
                                        fArray7 = textStyle.borderColor.handle;
                                    }
                                    if (fArray7 == null && textStyle.foreground != null) {
                                        fArray7 = textStyle.foreground.handle;
                                    }
                                    if (fArray7 != null) {
                                        OS.CGContextSetStrokeColorSpace(gC.handle, this.device.colorspace);
                                        OS.CGContextSetStrokeColor(gC.handle, fArray7);
                                    }
                                    OS.CGContextTranslateCTM(gC.handle, 0.5f, 0.5f);
                                    OS.CGContextStrokePath(gC.handle);
                                    OS.CGContextRestoreGState(gC.handle);
                                }
                            }
                        }
                        if (n7 > n12) break;
                        n9 += this.lineHeight[n11];
                        n10 = n8;
                        ++n11;
                    }
                }
            }
            ++n21;
        }
        if (n17 != 0) {
            OS.DisposeRgn(n17);
        }
    }

    void freeRuns() {
        if (this.breaks == null) {
            return;
        }
        int n = 0;
        while (n < this.styles.length) {
            StyleItem styleItem = this.styles[n];
            styleItem.freeStyle();
            ++n;
        }
        if (this.indentStyle != 0) {
            OS.ATSUDisposeStyle(this.indentStyle);
        }
        this.indentStyle = 0;
        this.lineAscent = null;
        this.lineHeight = null;
        this.lineWidth = null;
        this.lineX = null;
        this.breaks = null;
        this.invalidOffsets = null;
    }

    public int getAlignment() {
        this.checkLayout();
        int[] nArray = new int[1];
        OS.ATSUGetLayoutControl(this.layout, 5, 4, nArray, null);
        switch (nArray[0]) {
            case 0x20000000: {
                return 0x1000000;
            }
            case 0x40000000: {
                return 131072;
            }
        }
        return 16384;
    }

    public int getAscent() {
        this.checkLayout();
        return this.ascent;
    }

    public Rectangle getBounds() {
        Object object;
        this.checkLayout();
        this.computeRuns();
        int n = 0;
        int n2 = 0;
        int n3 = this.text.length();
        if (n3 == 0) {
            object = this.font != null ? this.font : this.device.systemFont;
            ATSFontMetrics aTSFontMetrics = new ATSFontMetrics();
            OS.ATSFontGetVerticalMetrics(((Font)object).handle, 0, aTSFontMetrics);
            OS.ATSFontGetHorizontalMetrics(((Font)object).handle, 0, aTSFontMetrics);
            int n4 = (int)(0.5f + aTSFontMetrics.ascent * ((Font)object).size);
            int n5 = (int)(0.5f + (-aTSFontMetrics.descent + aTSFontMetrics.leading) * ((Font)object).size);
            n4 = Math.max(n4, this.ascent);
            n5 = Math.max(n5, this.descent);
            n2 = n4 + n5;
        } else {
            int n6 = 0;
            while (n6 < this.breaks.length) {
                n = Math.max(n, this.lineWidth[n6]);
                n2 += this.lineHeight[n6];
                ++n6;
            }
        }
        object = new int[1];
        OS.ATSUGetLayoutControl(this.layout, 1, 4, (int[])object, null);
        int n7 = OS.Fix2Long((int)object[0]);
        if (n7 != 0) {
            n = Math.max(n, n7);
        }
        return new Rectangle(0, 0, n, n2);
    }

    public Rectangle getBounds(int n, int n2) {
        this.checkLayout();
        this.computeRuns();
        int n3 = this.text.length();
        if (n3 == 0) {
            return new Rectangle(0, 0, 0, 0);
        }
        if (n > n2) {
            return new Rectangle(0, 0, 0, 0);
        }
        n = Math.min(Math.max(0, n), n3 - 1);
        n2 = Math.min(Math.max(0, n2), n3 - 1);
        n = this.translateOffset(n);
        n2 = this.translateOffset(n2);
        int n4 = 0;
        while (n4 < this.hardBreaks.length) {
            if (n == this.hardBreaks[n4] && n > 0) {
                --n;
            }
            if (n2 == this.hardBreaks[n4] && n2 > 0) {
                --n2;
            }
            ++n4;
        }
        n4 = OS.NewRgn();
        Rect rect = new Rect();
        Rect rect2 = new Rect();
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        while (n5 < this.breaks.length) {
            int n8 = this.breaks[n5];
            int n9 = n8 - 1;
            if (n <= n9 && n2 >= n6) {
                int n10 = Math.max(n6, n);
                int n11 = Math.min(n9, n2);
                int n12 = n11 - n10 + 1;
                if (n12 > 0) {
                    OS.ATSUGetTextHighlight(this.layout, 0, OS.Long2Fix(n7 + this.lineAscent[n5]), n10, n12, n4);
                    OS.GetRegionBounds(n4, rect2);
                    OS.UnionRect(rect, rect2, rect);
                }
            }
            if (n9 > n2) break;
            n7 += this.lineHeight[n5];
            n6 = n8;
            ++n5;
        }
        OS.DisposeRgn(n4);
        return new Rectangle(rect.left, rect.top, rect.right - rect.left, rect.bottom - rect.top);
    }

    public int getDescent() {
        this.checkLayout();
        return this.descent;
    }

    public Font getFont() {
        this.checkLayout();
        return this.font;
    }

    public int getIndent() {
        this.checkLayout();
        return this.indent;
    }

    public boolean getJustify() {
        this.checkLayout();
        int[] nArray = new int[1];
        OS.ATSUGetLayoutControl(this.layout, 4, 4, nArray, null);
        return nArray[0] == 0x40000000;
    }

    public int getLevel(int n) {
        this.checkLayout();
        this.computeRuns();
        int n2 = this.text.length();
        if (n < 0 || n > n2) {
            SWT.error(6);
        }
        n = this.translateOffset(n);
        int n3 = 0;
        return n3;
    }

    public int[] getLineOffsets() {
        this.checkLayout();
        this.computeRuns();
        int[] nArray = new int[this.breaks.length + 1];
        int n = 1;
        while (n < nArray.length) {
            nArray[n] = this.untranslateOffset(this.breaks[n - 1]);
            ++n;
        }
        return nArray;
    }

    public int getLineIndex(int n) {
        this.checkLayout();
        this.computeRuns();
        int n2 = this.text.length();
        if (n < 0 || n > n2) {
            SWT.error(5);
        }
        n = this.translateOffset(n);
        int n3 = 0;
        while (n3 < this.breaks.length - 1) {
            int n4 = this.breaks[n3];
            if (n4 > n) {
                return n3;
            }
            ++n3;
        }
        return this.breaks.length - 1;
    }

    public Rectangle getLineBounds(int n) {
        this.checkLayout();
        this.computeRuns();
        int n2 = this.breaks.length;
        if (n < 0 || n >= n2) {
            SWT.error(6);
        }
        int n3 = 0;
        int n4 = 0;
        while (n4 < n) {
            n3 += this.lineHeight[n4];
            ++n4;
        }
        n4 = this.lineX[n];
        int n5 = this.lineWidth[n];
        int n6 = this.lineHeight[n] - this.spacing;
        return new Rectangle(n4, n3, n5, n6);
    }

    public int getLineCount() {
        this.checkLayout();
        this.computeRuns();
        return this.breaks.length;
    }

    public FontMetrics getLineMetrics(int n) {
        int n2;
        this.checkLayout();
        this.computeRuns();
        int n3 = this.breaks.length;
        if (n < 0 || n >= n3) {
            SWT.error(6);
        }
        if ((n2 = this.text.length()) == 0) {
            Font font = this.font != null ? this.font : this.device.systemFont;
            ATSFontMetrics aTSFontMetrics = new ATSFontMetrics();
            OS.ATSFontGetVerticalMetrics(font.handle, 0, aTSFontMetrics);
            OS.ATSFontGetHorizontalMetrics(font.handle, 0, aTSFontMetrics);
            int n4 = (int)(0.5f + aTSFontMetrics.ascent * font.size);
            int n5 = (int)(0.5f + (-aTSFontMetrics.descent + aTSFontMetrics.leading) * font.size);
            n4 = Math.max(n4, this.ascent);
            n5 = Math.max(n5, this.descent);
            return FontMetrics.carbon_new(n4, n5, 0, 0, n4 + n5);
        }
        int n6 = n == 0 ? 0 : this.breaks[n - 1];
        int n7 = this.breaks[n] - n6;
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        OS.ATSUGetUnjustifiedBounds(this.layout, n6, n7, null, null, nArray, nArray2);
        int n8 = OS.Fix2Long(nArray[0]) + OS.Fix2Long(nArray2[0]);
        return FontMetrics.carbon_new(OS.Fix2Long(nArray[0]), OS.Fix2Long(nArray2[0]), 0, 0, n8);
    }

    public Point getLocation(int n, boolean bl) {
        this.checkLayout();
        this.computeRuns();
        int n2 = this.text.length();
        if (n < 0 || n > n2) {
            SWT.error(6);
        }
        if (n2 == 0) {
            return new Point(0, 0);
        }
        n = this.translateOffset(n);
        int n3 = 0;
        while (n3 < this.hardBreaks.length) {
            if (n == this.hardBreaks[n3]) {
                bl = true;
                if (n <= 0) break;
                --n;
                break;
            }
            ++n3;
        }
        n3 = 0;
        int n4 = 0;
        while (n4 < this.breaks.length - 1) {
            int n5 = this.breaks[n4];
            if (n5 > n) break;
            n3 += this.lineHeight[n4];
            ++n4;
        }
        if (bl) {
            ++n;
        }
        ATSUCaret aTSUCaret = new ATSUCaret();
        OS.ATSUOffsetToPosition(this.layout, n, !bl, aTSUCaret, null, null);
        return new Point(Math.min(OS.Fix2Long(aTSUCaret.fX), OS.Fix2Long(aTSUCaret.fDeltaX)), n3);
    }

    public int getNextOffset(int n, int n2) {
        return this._getOffset(n, n2, true);
    }

    int _getOffset(int n, int n2, boolean bl) {
        int n3;
        block14: {
            int n4;
            block13: {
                this.checkLayout();
                this.computeRuns();
                int n5 = this.text.length();
                if (n < 0 || n > n5) {
                    SWT.error(6);
                }
                if (n5 == 0) {
                    return 0;
                }
                n = this.translateOffset(n);
                n4 = 0;
                switch (n2) {
                    case 2: {
                        n4 = 3;
                        break;
                    }
                    case 4: {
                        n4 = 2;
                    }
                }
                if (!bl) break block13;
                n = this._getNativeOffset(n, n4, bl);
                n3 = this.untranslateOffset(n);
                if (n2 == 4 || n2 == 8) {
                    while (n3 < n5 && (Compatibility.isLetterOrDigit(this.text.charAt(n3)) || !Compatibility.isLetterOrDigit(this.text.charAt(n3 - 1)))) {
                        n = this._getNativeOffset(n, n4, bl);
                        n3 = this.untranslateOffset(n);
                    }
                }
                if (n2 != 16) break block14;
                while (n3 < n5 && (!Compatibility.isLetterOrDigit(this.text.charAt(n3)) || Compatibility.isLetterOrDigit(this.text.charAt(n3 - 1)))) {
                    n = this._getNativeOffset(n, n4, bl);
                    n3 = this.untranslateOffset(n);
                }
                break block14;
            }
            n = this._getNativeOffset(n, n4, bl);
            n3 = this.untranslateOffset(n);
            if (n2 == 4 || n2 == 16) {
                while (n3 > 0 && (!Compatibility.isLetterOrDigit(this.text.charAt(n3)) || Compatibility.isLetterOrDigit(this.text.charAt(n3 - 1)))) {
                    n = this._getNativeOffset(n, n4, bl);
                    n3 = this.untranslateOffset(n);
                }
            }
            if (n2 == 8) {
                while (n3 > 0 && (Compatibility.isLetterOrDigit(this.text.charAt(n3)) || !Compatibility.isLetterOrDigit(this.text.charAt(n3 - 1)))) {
                    n = this._getNativeOffset(n, n4, bl);
                    n3 = this.untranslateOffset(n);
                }
            }
        }
        return n3;
    }

    int _getNativeOffset(int n, int n2, boolean bl) {
        int[] nArray = new int[1];
        boolean bl2 = false;
        block0: do {
            if (bl) {
                OS.ATSUNextCursorPosition(this.layout, n, n2, nArray);
            } else {
                OS.ATSUPreviousCursorPosition(this.layout, n, n2, nArray);
            }
            if (nArray[0] == n) {
                return n;
            }
            n = nArray[0];
            bl2 = false;
            int n3 = 0;
            while (n3 < this.invalidOffsets.length) {
                if (n == this.invalidOffsets[n3]) {
                    bl2 = true;
                    continue block0;
                }
                ++n3;
            }
        } while (bl2);
        return n;
    }

    public int getOffset(Point point, int[] nArray) {
        this.checkLayout();
        this.computeRuns();
        if (point == null) {
            SWT.error(4);
        }
        return this.getOffset(point.x, point.y, nArray);
    }

    public int getOffset(int n, int n2, int[] nArray) {
        int n3;
        this.checkLayout();
        this.computeRuns();
        if (nArray != null && nArray.length < 1) {
            SWT.error(5);
        }
        if ((n3 = this.text.length()) == 0) {
            return 0;
        }
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        while (n6 < this.breaks.length - 1) {
            int n7 = this.breaks[n6];
            int n8 = this.lineHeight[n6];
            if (n4 + n8 > n2) break;
            n4 += n8;
            n5 = n7;
            ++n6;
        }
        int[] nArray2 = new int[]{n5};
        boolean[] blArray = new boolean[1];
        OS.ATSUPositionToOffset(this.layout, OS.Long2Fix(n), OS.Long2Fix(n2 - n4), nArray2, blArray, null);
        if (nArray != null) {
            int n9 = nArray[0] = blArray[0] ? 0 : 1;
        }
        if (!blArray[0]) {
            nArray2[0] = nArray2[0] - 1;
        }
        int n10 = 0;
        while (n10 < this.hardBreaks.length) {
            if (nArray2[0] == this.hardBreaks[n10]) {
                nArray2[0] = nArray2[0] + 1;
                break;
            }
            ++n10;
        }
        nArray2[0] = this.untranslateOffset(nArray2[0]);
        if (nArray2[0] > n3 - 1) {
            nArray2[0] = n3 - 1;
            if (nArray != null) {
                nArray[0] = 1;
            }
        }
        return nArray2[0];
    }

    public int getOrientation() {
        this.checkLayout();
        int[] nArray = new int[1];
        OS.ATSUGetLayoutControl(this.layout, 3, 1, nArray, null);
        return nArray[0] == 1 ? 0x4000000 : 0x2000000;
    }

    public int getPreviousOffset(int n, int n2) {
        return this._getOffset(n, n2, false);
    }

    public int[] getRanges() {
        this.checkLayout();
        int[] nArray = new int[this.styles.length * 2];
        int n = 0;
        int n2 = 0;
        while (n2 < this.styles.length - 1) {
            if (this.styles[n2].style != null) {
                nArray[n++] = this.styles[n2].start;
                nArray[n++] = this.styles[n2 + 1].start - 1;
            }
            ++n2;
        }
        if (n != nArray.length) {
            int[] nArray2 = new int[n];
            System.arraycopy(nArray, 0, nArray2, 0, n);
            nArray = nArray2;
        }
        return nArray;
    }

    public int[] getSegments() {
        this.checkLayout();
        return this.segments;
    }

    String getSegmentsText() {
        if (this.segments == null) {
            return this.text;
        }
        int n = this.segments.length;
        if (n <= 1) {
            return this.text;
        }
        int n2 = this.text.length();
        if (n2 == 0) {
            return this.text;
        }
        if (n == 2 && this.segments[0] == 0 && this.segments[1] == n2) {
            return this.text;
        }
        this.invalidOffsets = new int[n];
        char[] cArray = new char[n2];
        this.text.getChars(0, n2, cArray, 0);
        char[] cArray2 = new char[n2 + n];
        int n3 = 0;
        int n4 = 0;
        int n5 = this.getOrientation() == 0x4000000 ? 8207 : 8206;
        while (n3 < n2) {
            if (n4 < n && n3 == this.segments[n4]) {
                this.invalidOffsets[n4] = n3 + n4;
                cArray2[n3 + n4++] = n5;
                continue;
            }
            cArray2[n3 + n4] = cArray[n3++];
        }
        if (n4 < n) {
            this.invalidOffsets[n4] = n3 + n4;
            this.segments[n4] = n3;
            cArray2[n3 + n4++] = n5;
        }
        if (n4 != n) {
            int[] nArray = new int[n4];
            System.arraycopy(this.invalidOffsets, 0, nArray, 0, n4);
            this.invalidOffsets = nArray;
        }
        return new String(cArray2, 0, Math.min(n3 + n4, cArray2.length));
    }

    public int getSpacing() {
        this.checkLayout();
        return this.spacing;
    }

    public TextStyle getStyle(int n) {
        this.checkLayout();
        int n2 = this.text.length();
        if (n < 0 || n >= n2) {
            SWT.error(6);
        }
        int n3 = 1;
        while (n3 < this.styles.length) {
            StyleItem styleItem = this.styles[n3];
            if (styleItem.start > n) {
                return this.styles[n3 - 1].style;
            }
            ++n3;
        }
        return null;
    }

    public TextStyle[] getStyles() {
        this.checkLayout();
        TextStyle[] textStyleArray = new TextStyle[this.styles.length];
        int n = 0;
        int n2 = 0;
        while (n2 < this.styles.length) {
            if (this.styles[n2].style != null) {
                textStyleArray[n++] = this.styles[n2].style;
            }
            ++n2;
        }
        if (n != textStyleArray.length) {
            TextStyle[] textStyleArray2 = new TextStyle[n];
            System.arraycopy(textStyleArray, 0, textStyleArray2, 0, n);
            textStyleArray = textStyleArray2;
        }
        return textStyleArray;
    }

    public int[] getTabs() {
        this.checkLayout();
        return this.tabs;
    }

    public String getText() {
        this.checkLayout();
        return this.text;
    }

    public int getWidth() {
        this.checkLayout();
        int[] nArray = new int[1];
        OS.ATSUGetLayoutControl(this.layout, 1, 4, nArray, null);
        int n = OS.Fix2Long(nArray[0]);
        return n == 0 ? -1 : n;
    }

    public boolean isDisposed() {
        return this.layout == 0;
    }

    public void setAlignment(int n) {
        this.checkLayout();
        int n2 = 16924672;
        if ((n &= n2) == 0) {
            return;
        }
        if (n == this.getAlignment()) {
            return;
        }
        this.freeRuns();
        if ((n & 0x4000) != 0) {
            n = 16384;
        }
        if ((n & 0x20000) != 0) {
            n = 131072;
        }
        int n3 = 0;
        switch (n) {
            case 0x1000000: {
                n3 = 0x20000000;
                break;
            }
            case 131072: {
                n3 = 0x40000000;
            }
        }
        this.setLayoutControl(5, n3, 4);
    }

    public void setAscent(int n) {
        this.checkLayout();
        if (n < -1) {
            SWT.error(5);
        }
        if (this.ascent == n) {
            return;
        }
        this.freeRuns();
        this.ascent = n;
    }

    public void setDescent(int n) {
        this.checkLayout();
        if (n < -1) {
            SWT.error(5);
        }
        if (this.descent == n) {
            return;
        }
        this.freeRuns();
        this.descent = n;
    }

    void setLayoutControl(int n, int n2, int n3) {
        Object[] objectArray;
        int n4 = OS.NewPtr(n3);
        if (n3 == 1) {
            objectArray = new byte[]{(byte)n2};
            OS.memmove(n4, objectArray, n3);
        } else {
            objectArray = new int[1];
            objectArray[0] = n2;
            OS.memmove(n4, (int[])objectArray, n3);
        }
        objectArray = new int[]{n};
        int[] nArray = new int[]{n3};
        int[] nArray2 = new int[]{n4};
        OS.ATSUSetLayoutControls(this.layout, objectArray.length, objectArray, nArray, nArray2);
        OS.DisposePtr(n4);
    }

    public void setFont(Font font) {
        Font font2;
        this.checkLayout();
        if (font != null && font.isDisposed()) {
            SWT.error(5);
        }
        if ((font2 = this.font) == font) {
            return;
        }
        this.font = font;
        if (font2 != null && font2.equals(font)) {
            return;
        }
        this.freeRuns();
    }

    public void setIndent(int n) {
        this.checkLayout();
        if (n < 0) {
            return;
        }
        if (this.indent == n) {
            return;
        }
        this.freeRuns();
        this.indent = n;
    }

    public void setJustify(boolean bl) {
        this.checkLayout();
        if (bl == this.getJustify()) {
            return;
        }
        this.freeRuns();
        this.setLayoutControl(4, bl ? 0x40000000 : 0, 4);
    }

    public void setOrientation(int n) {
        this.checkLayout();
        int n2 = 0x6000000;
        if ((n &= n2) == 0) {
            return;
        }
        if ((n & 0x2000000) != 0) {
            n = 0x2000000;
        }
        if (n == this.getOrientation()) {
            return;
        }
        this.freeRuns();
        int n3 = 0;
        if (n == 0x4000000) {
            n3 = 1;
        }
        this.setLayoutControl(3, n3, 1);
    }

    public void setSegments(int[] nArray) {
        this.checkLayout();
        if (this.segments == null && nArray == null) {
            return;
        }
        if (this.segments != null && nArray != null && this.segments.length == nArray.length) {
            int n = 0;
            while (n < nArray.length) {
                if (this.segments[n] != nArray[n]) break;
                ++n;
            }
            if (n == nArray.length) {
                return;
            }
        }
        this.freeRuns();
        this.segments = nArray;
    }

    public void setSpacing(int n) {
        this.checkLayout();
        if (n < 0) {
            SWT.error(5);
        }
        if (this.spacing == n) {
            return;
        }
        this.freeRuns();
        this.spacing = n;
    }

    public void setStyle(TextStyle textStyle, int n, int n2) {
        int n3;
        int n4;
        this.checkLayout();
        int n5 = this.text.length();
        if (n5 == 0) {
            return;
        }
        if (n > n2) {
            return;
        }
        n = Math.min(Math.max(0, n), n5 - 1);
        n2 = Math.min(Math.max(0, n2), n5 - 1);
        int n6 = -1;
        int n7 = this.styles.length;
        while (n7 - n6 > 1) {
            n4 = (n7 + n6) / 2;
            if (this.styles[n4 + 1].start > n) {
                n7 = n4;
                continue;
            }
            n6 = n4;
        }
        if (n7 >= 0 && n7 < this.styles.length) {
            StyleItem styleItem = this.styles[n7];
            if (styleItem.start == n && this.styles[n7 + 1].start - 1 == n2 && (textStyle == null ? styleItem.style == null : textStyle.equals(styleItem.style))) {
                return;
            }
        }
        this.freeRuns();
        int n8 = n4 = n7;
        while (n8 < this.styles.length) {
            if (this.styles[n8 + 1].start > n2) break;
            ++n8;
        }
        if (n4 == n8) {
            n3 = this.styles[n4].start;
            int n9 = this.styles[n8 + 1].start - 1;
            if (n3 == n && n9 == n2) {
                this.styles[n4].style = textStyle;
                return;
            }
            if (n3 != n && n9 != n2) {
                StyleItem[] styleItemArray = new StyleItem[this.styles.length + 2];
                System.arraycopy(this.styles, 0, styleItemArray, 0, n4 + 1);
                StyleItem styleItem = new StyleItem();
                styleItem.start = n;
                styleItem.style = textStyle;
                styleItemArray[n4 + 1] = styleItem;
                styleItem = new StyleItem();
                styleItem.start = n2 + 1;
                styleItem.style = this.styles[n4].style;
                styleItemArray[n4 + 2] = styleItem;
                System.arraycopy(this.styles, n8 + 1, styleItemArray, n8 + 3, this.styles.length - n8 - 1);
                this.styles = styleItemArray;
                return;
            }
        }
        if (n == this.styles[n4].start) {
            --n4;
        }
        if (n2 == this.styles[n8 + 1].start - 1) {
            ++n8;
        }
        n3 = this.styles.length + 1 - (n8 - n4 - 1);
        StyleItem[] styleItemArray = new StyleItem[n3];
        System.arraycopy(this.styles, 0, styleItemArray, 0, n4 + 1);
        StyleItem styleItem = new StyleItem();
        styleItem.start = n;
        styleItem.style = textStyle;
        styleItemArray[n4 + 1] = styleItem;
        this.styles[n8].start = n2 + 1;
        System.arraycopy(this.styles, n8, styleItemArray, n4 + 2, this.styles.length - n8);
        this.styles = styleItemArray;
    }

    public void setTabs(int[] nArray) {
        this.checkLayout();
        if (this.tabs == null && nArray == null) {
            return;
        }
        if (this.tabs != null && nArray != null && this.tabs.length == nArray.length) {
            int n = 0;
            while (n < nArray.length) {
                if (this.tabs[n] != nArray[n]) break;
                ++n;
            }
            if (n == nArray.length) {
                return;
            }
        }
        this.freeRuns();
        this.tabs = nArray;
        if (this.tabsPtr != 0) {
            OS.DisposePtr(this.tabsPtr);
        }
        this.tabsPtr = 0;
        if (nArray == null) {
            OS.ATSUSetTabArray(this.layout, 0, 0);
        } else {
            int n;
            ATSUTab aTSUTab = new ATSUTab();
            aTSUTab.tabPosition = OS.Long2Fix(0);
            int n2 = Math.max(32, nArray.length);
            int n3 = this.tabsPtr = OS.NewPtr(6 * n2);
            int n4 = 0;
            int n5 = n3;
            while (n4 < nArray.length) {
                aTSUTab.tabType = 0;
                aTSUTab.tabPosition = OS.Long2Fix(nArray[n4]);
                OS.memmove(n5, aTSUTab, 6);
                ++n4;
                n5 += 6;
            }
            int n6 = n = n4 - 2 >= 0 ? nArray[n4 - 1] - nArray[n4 - 2] : nArray[n4 - 1];
            if (n > 0) {
                while (n4 < n2) {
                    aTSUTab.tabType = 0;
                    aTSUTab.tabPosition += OS.Long2Fix(n);
                    OS.memmove(n5, aTSUTab, 6);
                    ++n4;
                    n5 += 6;
                }
            }
            OS.ATSUSetTabArray(this.layout, n3, n4);
        }
    }

    public void setText(String string) {
        this.checkLayout();
        if (string == null) {
            SWT.error(4);
        }
        if (string.equals(this.text)) {
            return;
        }
        this.freeRuns();
        this.text = string;
        this.styles = new StyleItem[2];
        this.styles[0] = new StyleItem();
        this.styles[1] = new StyleItem();
        this.styles[this.styles.length - 1].start = string.length();
    }

    public void setWidth(int n) {
        this.checkLayout();
        if (n < -1 || n == 0) {
            SWT.error(5);
        }
        if (n == this.getWidth()) {
            return;
        }
        this.freeRuns();
        this.setLayoutControl(1, OS.Long2Fix(Math.max(0, n)), 4);
    }

    public String toString() {
        if (this.isDisposed()) {
            return "TextLayout {*DISPOSED*}";
        }
        return "TextLayout {" + this.layout + "}";
    }

    int translateOffset(int n) {
        ++n;
        int n2 = 0;
        while (n2 < this.invalidOffsets.length) {
            if (n < this.invalidOffsets[n2]) break;
            ++n;
            ++n2;
        }
        return n;
    }

    int untranslateOffset(int n) {
        int n2 = 0;
        while (n2 < this.invalidOffsets.length) {
            if (n == this.invalidOffsets[n2]) {
                ++n;
            } else if (n < this.invalidOffsets[n2]) {
                return Math.max(0, n - n2 - 1);
            }
            ++n2;
        }
        return Math.max(0, n - this.invalidOffsets.length - 1);
    }

    static class StyleItem {
        TextStyle style;
        int start;
        int atsuStyle;

        StyleItem() {
        }

        void createStyle(Device device, Font font) {
            Object object;
            int n;
            if (this.atsuStyle != 0) {
                return;
            }
            int[] nArray = new int[1];
            OS.ATSUCreateStyle(nArray);
            this.atsuStyle = nArray[0];
            if (this.atsuStyle == 0) {
                SWT.error(2);
            }
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            Font font2 = null;
            Color color = null;
            GlyphMetrics glyphMetrics = null;
            if (this.style != null) {
                font2 = this.style.font;
                color = this.style.foreground;
                glyphMetrics = this.style.metrics;
                if (this.style.underline && (this.style.underlineStyle == 0 || this.style.underlineStyle == 1)) {
                    ++n2;
                    ++n3;
                    if (this.style.underlineStyle == 1) {
                        ++n2;
                        n3 += 2;
                    }
                    if (this.style.underlineColor != null) {
                        ++n2;
                        n3 += 4;
                    }
                }
                if (this.style.strikeout) {
                    ++n2;
                    ++n3;
                    if (this.style.strikeoutColor != null) {
                        ++n2;
                        n3 += 4;
                    }
                }
                if (glyphMetrics != null) {
                    n2 += 4;
                    n3 += 28;
                }
                if (this.style.rise != 0) {
                    ++n2;
                    n3 += 4;
                }
            }
            if (font2 == null) {
                font2 = font;
            }
            boolean bl = false;
            if (font2 != null) {
                n2 += 2;
                n3 += 8;
                boolean bl2 = bl = font2.style != 0;
                if (bl) {
                    n2 += 2;
                    n3 += 2;
                }
            }
            if (color != null && glyphMetrics == null) {
                ++n2;
                n3 += 6;
            }
            byte[] byArray = new byte[1];
            int[] nArray2 = new int[n2];
            int[] nArray3 = new int[n2];
            int[] nArray4 = new int[n2];
            int n5 = n = OS.NewPtr(n3);
            if (font2 != null) {
                nArray[0] = font2.handle;
                nArray2[n4] = 261;
                nArray3[n4] = 4;
                nArray4[n4] = n5;
                OS.memmove(nArray4[n4], nArray, nArray3[n4]);
                n5 += nArray3[n4];
                nArray[0] = OS.X2Fix(font2.size);
                nArray2[++n4] = 262;
                nArray3[n4] = 4;
                nArray4[n4] = n5;
                OS.memmove(nArray4[n4], nArray, nArray3[n4]);
                n5 += nArray3[n4];
                ++n4;
                if (bl) {
                    byArray[0] = (font2.style & 2) != 0 ? (byte)1 : 0;
                    nArray2[n4] = 257;
                    nArray3[n4] = 1;
                    nArray4[n4] = n5;
                    OS.memmove(nArray4[n4], byArray, nArray3[n4]);
                    n5 += nArray3[n4];
                    byArray[0] = (font2.style & 1) != 0 ? (byte)1 : 0;
                    nArray2[++n4] = 256;
                    nArray3[n4] = 1;
                    nArray4[n4] = n5;
                    OS.memmove(nArray4[n4], byArray, nArray3[n4]);
                    n5 += nArray3[n4];
                    ++n4;
                }
            }
            int n6 = 0;
            int n7 = 0;
            if (this.style != null && this.style.underline && (this.style.underlineStyle == 0 || this.style.underlineStyle == 1)) {
                byArray[0] = 1;
                nArray2[n4] = 258;
                nArray3[n4] = 1;
                nArray4[n4] = n5;
                OS.memmove(nArray4[n4], byArray, nArray3[n4]);
                n5 += nArray3[n4];
                ++n4;
                if (this.style.underlineStyle == 1) {
                    object = new short[]{2};
                    nArray2[n4] = 290;
                    nArray3[n4] = 2;
                    nArray4[n4] = n5;
                    OS.memmove(nArray4[n4], (short[])object, nArray3[n4]);
                    n5 += nArray3[n4];
                    ++n4;
                }
                if (this.style.underlineColor != null) {
                    nArray[0] = n6 = OS.CGColorCreate(device.colorspace, this.style.underlineColor.handle);
                    nArray2[n4] = 291;
                    nArray3[n4] = 4;
                    nArray4[n4] = n5;
                    OS.memmove(nArray4[n4], nArray, nArray3[n4]);
                    n5 += nArray3[n4];
                    ++n4;
                }
            }
            if (this.style != null && this.style.strikeout) {
                byArray[0] = 1;
                nArray2[n4] = 292;
                nArray3[n4] = 1;
                nArray4[n4] = n5;
                OS.memmove(nArray4[n4], byArray, nArray3[n4]);
                n5 += nArray3[n4];
                ++n4;
                if (this.style.strikeoutColor != null) {
                    nArray[0] = n7 = OS.CGColorCreate(device.colorspace, this.style.strikeoutColor.handle);
                    nArray2[n4] = 294;
                    nArray3[n4] = 4;
                    nArray4[n4] = n5;
                    OS.memmove(nArray4[n4], nArray, nArray3[n4]);
                    n5 += nArray3[n4];
                    ++n4;
                }
            }
            if (glyphMetrics != null) {
                nArray[0] = OS.Long2Fix(glyphMetrics.ascent);
                nArray2[n4] = 284;
                nArray3[n4] = 4;
                nArray4[n4] = n5;
                OS.memmove(nArray4[n4], nArray, nArray3[n4]);
                n5 += nArray3[n4];
                nArray[0] = OS.Long2Fix(glyphMetrics.descent);
                nArray2[++n4] = 285;
                nArray3[n4] = 4;
                nArray4[n4] = n5;
                OS.memmove(nArray4[n4], nArray, nArray3[n4]);
                n5 += nArray3[n4];
                nArray[0] = OS.Long2Fix(glyphMetrics.width);
                nArray2[++n4] = 266;
                nArray3[n4] = 4;
                nArray4[n4] = n5;
                OS.memmove(nArray4[n4], nArray, nArray3[n4]);
                n5 += nArray3[n4];
                object = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
                nArray2[++n4] = 288;
                nArray3[n4] = 16;
                nArray4[n4] = n5;
                OS.memmove(nArray4[n4], (float[])object, nArray3[n4]);
                n5 += nArray3[n4];
                ++n4;
            }
            if (this.style != null && this.style.rise != 0) {
                nArray[0] = OS.Long2Fix(this.style.rise);
                nArray2[n4] = 269;
                nArray3[n4] = 4;
                nArray4[n4] = n5;
                OS.memmove(nArray4[n4], nArray, nArray3[n4]);
                n5 += nArray3[n4];
                ++n4;
            }
            if (color != null && glyphMetrics == null) {
                object = new RGBColor();
                float[] fArray = color.handle;
                ((RGBColor)object).red = (short)(fArray[0] * 65535.0f);
                ((RGBColor)object).green = (short)(fArray[1] * 65535.0f);
                ((RGBColor)object).blue = (short)(fArray[2] * 65535.0f);
                nArray2[n4] = 263;
                nArray3[n4] = 6;
                nArray4[n4] = n5;
                OS.memmove(nArray4[n4], (RGBColor)object, nArray3[n4]);
                n5 += nArray3[n4];
                ++n4;
            }
            OS.ATSUSetAttributes(this.atsuStyle, nArray2.length, nArray2, nArray3, nArray4);
            OS.DisposePtr(n);
            if (n6 != 0) {
                OS.CGColorRelease(n6);
            }
            if (n7 != 0) {
                OS.CGColorRelease(n7);
            }
        }

        void freeStyle() {
            if (this.atsuStyle == 0) {
                return;
            }
            OS.ATSUDisposeStyle(this.atsuStyle);
            this.atsuStyle = 0;
        }

        public String toString() {
            return "StyleItem {" + this.start + ", " + this.style + "}";
        }
    }
}

