/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.extensions.datasources.olap4j;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import javax.swing.table.TableModel;
import org.olap4j.OlapException;
import org.olap4j.PreparedOlapStatement;
import org.pentaho.reporting.engine.classic.core.DataFactory;
import org.pentaho.reporting.engine.classic.core.DataRow;
import org.pentaho.reporting.engine.classic.core.ReportDataFactoryException;
import org.pentaho.reporting.engine.classic.core.ResourceBundleFactory;
import org.pentaho.reporting.engine.classic.core.modules.misc.datafactory.DataFactoryScriptingSupport;
import org.pentaho.reporting.engine.classic.extensions.datasources.olap4j.AbstractMDXDataFactory;
import org.pentaho.reporting.engine.classic.extensions.datasources.olap4j.connections.OlapConnectionProvider;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractNamedMDXDataFactory
extends AbstractMDXDataFactory {
    private DataFactoryScriptingSupport scriptingSupport = new DataFactoryScriptingSupport();

    public AbstractNamedMDXDataFactory(OlapConnectionProvider connectionProvider) {
        super(connectionProvider);
    }

    @Override
    public boolean isQueryExecutable(String query, DataRow parameters) {
        return this.scriptingSupport.containsQuery(query);
    }

    public void setQuery(String name, String queryString) {
        if (queryString == null) {
            this.scriptingSupport.remove(name);
        } else {
            this.scriptingSupport.setQuery(name, queryString, null, null);
        }
    }

    public void setQuery(String name, String queryString, String queryScriptLanguage, String queryScript) {
        if (name == null) {
            throw new NullPointerException();
        }
        this.scriptingSupport.setQuery(name, queryString, queryScriptLanguage, queryScript);
    }

    public void remove(String name) {
        this.scriptingSupport.remove(name);
    }

    public String getGlobalScriptLanguage() {
        return this.scriptingSupport.getGlobalScriptLanguage();
    }

    public void setGlobalScriptLanguage(String scriptLanguage) {
        this.scriptingSupport.setGlobalScriptLanguage(scriptLanguage);
    }

    public String getGlobalScript() {
        return this.scriptingSupport.getGlobalScript();
    }

    public void setGlobalScript(String globalScript) {
        this.scriptingSupport.setGlobalScript(globalScript);
    }

    public String getScriptingLanguage(String name) {
        return this.scriptingSupport.getScriptingLanguage(name);
    }

    public String getScript(String name) {
        return this.scriptingSupport.getScript(name);
    }

    public String getQuery(String name) {
        return this.scriptingSupport.getQuery(name);
    }

    @Override
    public String[] getQueryNames() {
        return this.scriptingSupport.getQueryNames();
    }

    @Override
    public void initialize(Configuration configuration, ResourceManager resourceManager, ResourceKey contextKey, ResourceBundleFactory resourceBundleFactory) throws ReportDataFactoryException {
        super.initialize(configuration, resourceManager, contextKey, resourceBundleFactory);
        this.scriptingSupport.initialize((DataFactory)this, configuration, resourceManager, contextKey, resourceBundleFactory);
    }

    @Override
    protected PreparedOlapStatement getStatement(String queryName, DataRow parameters) throws ReportDataFactoryException, OlapException {
        String query = this.scriptingSupport.computeQuery(queryName, parameters);
        if (query == null) {
            throw new ReportDataFactoryException("No such query: " + queryName);
        }
        return super.getStatement(query, parameters);
    }

    protected TableModel postProcess(String queryName, DataRow parameters, TableModel tableModel) throws ReportDataFactoryException {
        return this.scriptingSupport.postProcessResult(queryName, parameters, tableModel);
    }

    @Override
    protected String computedQuery(String queryName, DataRow parameters) throws ReportDataFactoryException {
        return this.scriptingSupport.computeQuery(queryName, parameters);
    }

    @Override
    protected String translateQuery(String query) {
        return this.scriptingSupport.getQuery(query);
    }

    @Override
    public String[] getReferencedFields(String query, DataRow parameter) throws ReportDataFactoryException {
        String[] additionalFields = this.scriptingSupport.computeAdditionalQueryFields(query, parameter);
        if (additionalFields == null) {
            return null;
        }
        LinkedHashSet<String> fields = new LinkedHashSet<String>(Arrays.asList(super.getReferencedFields(query, parameter)));
        fields.addAll(Arrays.asList(additionalFields));
        return fields.toArray(new String[fields.size()]);
    }

    @Override
    public ArrayList<Object> getQueryHash(String queryName, DataRow parameters) throws ReportDataFactoryException {
        ArrayList<Object> queryHash = super.getQueryHash(queryName, parameters);
        queryHash.add(this.scriptingSupport.getScriptingLanguage(queryName));
        queryHash.add(this.scriptingSupport.getScript(queryName));
        return queryHash;
    }

    @Override
    public void close() {
        this.scriptingSupport.shutdown();
        super.close();
    }

    @Override
    public Object clone() {
        AbstractNamedMDXDataFactory dataFactory = (AbstractNamedMDXDataFactory)super.clone();
        dataFactory.scriptingSupport = (DataFactoryScriptingSupport)this.scriptingSupport.clone();
        return dataFactory;
    }
}

