/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.extensions.datasources.olap4j;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.olap4j.Cell;
import org.olap4j.CellSet;
import org.olap4j.CellSetAxis;
import org.olap4j.Position;
import org.olap4j.PreparedOlapStatement;
import org.olap4j.metadata.Dimension;
import org.olap4j.metadata.Member;
import org.pentaho.reporting.engine.classic.core.MetaTableModel;
import org.pentaho.reporting.engine.classic.core.util.CloseableTableModel;
import org.pentaho.reporting.engine.classic.core.wizard.DataAttributes;
import org.pentaho.reporting.engine.classic.core.wizard.DefaultConceptQueryMapper;
import org.pentaho.reporting.engine.classic.core.wizard.DefaultDataAttributes;
import org.pentaho.reporting.engine.classic.core.wizard.EmptyDataAttributes;
import org.pentaho.reporting.engine.classic.extensions.datasources.olap4j.MDXMetaDataCellAttributes;
import org.pentaho.reporting.engine.classic.extensions.datasources.olap4j.MDXMetaDataMemberAttributes;
import org.pentaho.reporting.engine.classic.extensions.datasources.olap4j.Olap4jUtil;
import org.pentaho.reporting.engine.classic.extensions.datasources.olap4j.QueryResultWrapper;
import org.pentaho.reporting.libraries.base.util.FastStack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BandedMDXTableModel
extends AbstractTableModel
implements CloseableTableModel,
MetaTableModel {
    private static final Log logger = LogFactory.getLog(BandedMDXTableModel.class);
    private boolean noMeasures;
    private CellSet resultSet;
    private int rowCount;
    private int columnCount;
    private String[] columnNames;
    private int[] axesSize;
    private int[] columnToAxisPosition;
    private Dimension[] columnToDimensionMapping;
    private QueryResultWrapper resultWrapper;

    public BandedMDXTableModel(QueryResultWrapper resultWrapper, int rowLimit) {
        int i;
        if (resultWrapper == null) {
            throw new NullPointerException("ResultSet returned was null");
        }
        this.resultWrapper = resultWrapper;
        this.resultSet = resultWrapper.getCellSet();
        List axes = this.resultSet.getAxes();
        this.rowCount = 0;
        this.axesSize = new int[axes.size()];
        int[] axesMembers = new int[axes.size()];
        List[] dimensionsForMembersPerAxis = new List[axes.size()];
        List[] membersPerAxis = new List[axes.size()];
        if (this.axesSize.length > 0) {
            CellSetAxis axis = (CellSetAxis)axes.get(0);
            List positions = axis.getPositions();
            this.axesSize[0] = positions.size();
            if (positions.isEmpty()) {
                this.noMeasures = true;
            }
        }
        for (int axesIndex = axes.size() - 1; axesIndex >= 1; --axesIndex) {
            CellSetAxis axis = (CellSetAxis)axes.get(axesIndex);
            List positions = axis.getPositions();
            this.axesSize[axesIndex] = positions.size();
            if (positions.isEmpty()) {
                this.noMeasures = true;
            }
            ArrayList<Integer> memberList = new ArrayList<Integer>();
            ArrayList<Dimension> dimensionsForMembers = new ArrayList<Dimension>();
            for (int positionsIndex = 0; positionsIndex < positions.size(); ++positionsIndex) {
                Position position = (Position)positions.get(positionsIndex);
                List members = position.getMembers();
                for (int positionIndex = 0; positionIndex < members.size(); ++positionIndex) {
                    Member m;
                    LinkedHashSet<String> columnNamesSet = new LinkedHashSet<String>();
                    Dimension dimension = m.getDimension();
                    int hierarchyLevelCount = 0;
                    for (m = (Member)members.get(positionIndex); m != null; m = m.getParentMember()) {
                        String name = m.getLevel().getUniqueName();
                        if (columnNamesSet.contains(name)) continue;
                        columnNamesSet.add(name);
                    }
                    hierarchyLevelCount = columnNamesSet.size();
                    if (memberList.size() <= positionIndex) {
                        memberList.add(hierarchyLevelCount);
                        dimensionsForMembers.add(dimension);
                        continue;
                    }
                    Integer existingLevel = (Integer)memberList.get(positionIndex);
                    if (existingLevel >= hierarchyLevelCount) continue;
                    memberList.set(positionIndex, hierarchyLevelCount);
                    dimensionsForMembers.set(positionIndex, dimension);
                }
            }
            int memberCount = 0;
            for (int i2 = 0; i2 < memberList.size(); ++i2) {
                memberCount += ((Integer)memberList.get(i2)).intValue();
            }
            axesMembers[axesIndex] = memberCount;
            dimensionsForMembersPerAxis[axesIndex] = dimensionsForMembers;
            membersPerAxis[axesIndex] = memberList;
        }
        if (this.axesSize.length > 1) {
            this.rowCount = this.axesSize[1];
            for (i = 2; i < this.axesSize.length; ++i) {
                int size = this.axesSize[i];
                this.rowCount *= size;
            }
        }
        if (!this.noMeasures) {
            this.rowCount = Math.max(1, this.rowCount);
        }
        if (this.axesSize.length == 0) {
            this.columnCount = 1;
        } else if (this.axesSize.length > 0) {
            this.columnCount = this.axesSize[0];
        }
        for (i = 1; i < axesMembers.length; ++i) {
            this.columnCount += axesMembers[i];
        }
        this.columnNames = new String[this.columnCount];
        this.columnToDimensionMapping = new Dimension[this.columnCount];
        this.columnToAxisPosition = new int[this.columnCount];
        int columnIndex = 0;
        int dimColIndex = 0;
        FastStack memberStack = new FastStack();
        for (int axesIndex = axes.size() - 1; axesIndex >= 1; --axesIndex) {
            CellSetAxis axis = (CellSetAxis)axes.get(axesIndex);
            List positions = axis.getPositions();
            LinkedHashSet<String> columnNamesSet = new LinkedHashSet<String>();
            for (int positionsIndex = 0; positionsIndex < positions.size(); ++positionsIndex) {
                Position position = (Position)positions.get(positionsIndex);
                List members = position.getMembers();
                for (int positionIndex = 0; positionIndex < members.size(); ++positionIndex) {
                    Member m;
                    memberStack.clear();
                    for (m = (Member)members.get(positionIndex); m != null; m = m.getParentMember()) {
                        memberStack.push((Object)m);
                    }
                    while (!memberStack.isEmpty()) {
                        m = (Member)memberStack.pop();
                        String name = m.getLevel().getUniqueName();
                        if (columnNamesSet.contains(name)) continue;
                        columnNamesSet.add(name);
                    }
                }
            }
            if (columnNamesSet.size() != axesMembers[axesIndex]) {
                logger.error((Object)"ERROR: Number of names is not equal the pre-counted number.");
            }
            List dimForMemberPerAxis = dimensionsForMembersPerAxis[axesIndex];
            List memberCntPerAxis = membersPerAxis[axesIndex];
            for (int i3 = 0; i3 < memberCntPerAxis.size(); ++i3) {
                Integer count = (Integer)memberCntPerAxis.get(i3);
                Dimension dim = (Dimension)dimForMemberPerAxis.get(i3);
                for (int x = 0; x < count; ++x) {
                    this.columnToDimensionMapping[dimColIndex + x] = dim;
                    this.columnToAxisPosition[dimColIndex + x] = axesIndex;
                }
                dimColIndex = count + dimColIndex;
            }
            String[] names = columnNamesSet.toArray(new String[columnNamesSet.size()]);
            System.arraycopy(names, 0, this.columnNames, columnIndex, names.length);
            columnIndex += names.length;
        }
        if (this.axesSize.length > 0) {
            CellSetAxis axis = (CellSetAxis)axes.get(0);
            List positions = axis.getPositions();
            for (int i4 = 0; i4 < positions.size(); ++i4) {
                Position position = (Position)positions.get(i4);
                StringBuilder positionName = new StringBuilder(100);
                List memberList = position.getMembers();
                for (int j = 0; j < memberList.size(); ++j) {
                    if (j != 0) {
                        positionName.append('/');
                    }
                    Member member = (Member)memberList.get(j);
                    positionName.append(Olap4jUtil.getUniqueMemberName(member));
                }
                this.columnNames[columnIndex] = positionName.toString();
                ++columnIndex;
            }
        }
        if (this.axesSize.length == 0) {
            this.columnNames[0] = "Measure";
        }
        if (rowLimit > 0) {
            this.rowCount = Math.min(rowLimit, this.rowCount);
        }
    }

    @Override
    public int getRowCount() {
        return this.rowCount;
    }

    @Override
    public int getColumnCount() {
        return this.columnCount;
    }

    @Override
    public String getColumnName(int column) {
        return this.columnNames[column];
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        if (this.getRowCount() == 0) {
            return Object.class;
        }
        try {
            Object targetClassObj = this.getValueAt(0, columnIndex);
            if (targetClassObj == null) {
                return Object.class;
            }
            return targetClassObj.getClass();
        }
        catch (Exception e) {
            return Object.class;
        }
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        String name;
        int startOfColumnIndex;
        if (columnIndex >= this.columnNames.length) {
            throw new IndexOutOfBoundsException();
        }
        int correctedColIndex = this.axesSize.length > 0 ? (columnIndex < (startOfColumnIndex = this.columnCount - this.axesSize[0]) ? -1 : columnIndex - startOfColumnIndex) : 0;
        List<Integer> cellKey = this.computeCellKey(rowIndex, correctedColIndex);
        Dimension dimension = this.columnToDimensionMapping[columnIndex];
        if (dimension == null) {
            Cell cell = this.resultSet.getCell(cellKey);
            if (cell.isNull()) {
                return null;
            }
            return cell.getValue();
        }
        Member contextMember = this.getContextMember(dimension, columnIndex, cellKey);
        String string = name = contextMember.getParentMember() == null ? contextMember.getName() : null;
        while (contextMember != null) {
            if (contextMember.getLevel().getUniqueName().equals(this.getColumnName(columnIndex))) {
                return contextMember.getName();
            }
            contextMember = contextMember.getParentMember();
        }
        return name;
    }

    private List<Integer> computeCellKey(int rowIndex, int columnIndex) {
        ArrayList<Integer> cellKey = new ArrayList<Integer>(this.axesSize.length);
        int tmpRowIdx = rowIndex;
        if (this.axesSize.length > 0) {
            cellKey.add(columnIndex);
        }
        for (int i = 1; i < this.axesSize.length; ++i) {
            int axisSize = this.axesSize[i];
            if (axisSize == 0) {
                cellKey.add(0);
                continue;
            }
            int pos = tmpRowIdx % axisSize;
            cellKey.add(pos);
            tmpRowIdx /= axisSize;
        }
        return cellKey;
    }

    private Member getContextMember(Dimension dimension, int columnIndex, List<Integer> cellKey) {
        int axisIndex = this.columnToAxisPosition[columnIndex];
        CellSetAxis axis = (CellSetAxis)this.resultSet.getAxes().get(axisIndex);
        Integer posIndex = cellKey.get(axisIndex);
        List positionList = axis.getPositions();
        if (positionList.isEmpty()) {
            return null;
        }
        Position position = (Position)positionList.get(posIndex);
        List memberList = position.getMembers();
        for (int i = 0; i < memberList.size(); ++i) {
            Member member = (Member)memberList.get(i);
            if (!dimension.equals(member.getDimension())) continue;
            return member;
        }
        return null;
    }

    public void close() {
        try {
            this.resultSet.close();
        }
        catch (SQLException e) {
            // empty catch block
        }
        try {
            PreparedOlapStatement statement = this.resultWrapper.getStatement();
            statement.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public DataAttributes getCellDataAttributes(int rowIndex, int columnIndex) {
        String name;
        if (columnIndex >= this.columnNames.length) {
            throw new IndexOutOfBoundsException();
        }
        List<Integer> cellKey = this.computeCellKey(rowIndex, columnIndex);
        Dimension dimension = this.columnToDimensionMapping[columnIndex];
        if (dimension == null) {
            Cell cell = this.resultSet.getCell(cellKey);
            return new MDXMetaDataCellAttributes((DataAttributes)EmptyDataAttributes.INSTANCE, cell);
        }
        Member contextMember = this.getContextMember(dimension, columnIndex, cellKey);
        String string = name = contextMember.getParentMember() == null ? contextMember.getName() : null;
        while (contextMember != null) {
            if (contextMember.getLevel().getUniqueName().equals(this.getColumnName(columnIndex))) {
                return new MDXMetaDataMemberAttributes((DataAttributes)EmptyDataAttributes.INSTANCE, contextMember);
            }
            contextMember = contextMember.getParentMember();
        }
        return EmptyDataAttributes.INSTANCE;
    }

    public boolean isCellDataAttributesSupported() {
        return true;
    }

    public DataAttributes getColumnAttributes(int column) {
        return EmptyDataAttributes.INSTANCE;
    }

    public DataAttributes getTableAttributes() {
        DefaultDataAttributes dataAttributes = new DefaultDataAttributes();
        dataAttributes.setMetaAttribute("http://reporting.pentaho.org/namespaces/engine/meta-attributes/core", "crosstab-mode", DefaultConceptQueryMapper.INSTANCE, (Object)"normalized");
        return dataAttributes;
    }
}

