/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.extensions.datasources.olap4j;

import org.olap4j.OlapException;
import org.olap4j.metadata.Member;
import org.olap4j.metadata.Property;
import org.pentaho.reporting.engine.classic.core.wizard.ConceptQueryMapper;
import org.pentaho.reporting.engine.classic.core.wizard.DataAttributeContext;
import org.pentaho.reporting.engine.classic.core.wizard.DataAttributes;
import org.pentaho.reporting.engine.classic.core.wizard.DefaultConceptQueryMapper;
import org.pentaho.reporting.engine.classic.extensions.datasources.olap4j.types.LocalizedString;
import org.pentaho.reporting.engine.classic.extensions.datasources.olap4j.types.LocalizedStringConceptMapper;
import org.pentaho.reporting.libraries.base.util.StringUtils;

public class MDXMetaDataMemberAttributes
implements DataAttributes {
    private static final String[] NAMESPACES = new String[]{"http://reporting.pentaho.org/namespaces/engine/meta-attributes/mdx"};
    private static final String[] PROPERTIES = new String[]{"BACKGROUND_COLOR", "FOREGROUND_COLOR", "FONT_FLAGS", "FONT_SIZE", "FONT_NAME", "FORMAT_STRING", "LANGUAGE", "MDX::ALL_MEMBER", "MDX::CALCULATED", "MDX::HIDDEN", "MDX::CAPTION", "MDX::DESCRIPTION"};
    private DataAttributes backend;
    private Member cell;

    public MDXMetaDataMemberAttributes(DataAttributes backend, Member cell) {
        if (cell == null) {
            throw new NullPointerException();
        }
        if (backend == null) {
            throw new NullPointerException();
        }
        this.cell = cell;
        this.backend = backend;
    }

    public String[] getMetaAttributeDomains() {
        String[] backendDomains = this.backend.getMetaAttributeDomains();
        return StringUtils.merge((String[])NAMESPACES, (String[])backendDomains);
    }

    public String[] getMetaAttributeNames(String domainName) {
        if ("http://reporting.pentaho.org/namespaces/engine/meta-attributes/mdx".equals(domainName)) {
            return (String[])PROPERTIES.clone();
        }
        return this.backend.getMetaAttributeNames(domainName);
    }

    public Object getMetaAttribute(String domain, String name, Class type, DataAttributeContext context) {
        return this.getMetaAttribute(domain, name, type, context, null);
    }

    public Object getMetaAttribute(String domain, String name, Class type, DataAttributeContext context, Object defaultValue) {
        if ("http://reporting.pentaho.org/namespaces/engine/meta-attributes/mdx".equals(domain)) {
            if (name.equals("MDX::ALL_MEMBER")) {
                return this.cell.isAll();
            }
            if (name.equals("MDX::CALCULATED")) {
                return this.cell.isCalculated();
            }
            if (name.equals("MDX::HIDDEN")) {
                return this.cell.isHidden();
            }
            if (name.equals("MDX::CAPTION")) {
                return new LocalizedString(this.cell, false);
            }
            if (name.equals("MDX::DESCRIPTION")) {
                return new LocalizedString(this.cell, false);
            }
            try {
                Object attribute = this.cell.getPropertyValue((Property)Property.StandardMemberProperty.valueOf((String)name));
                if (attribute == null) {
                    return defaultValue;
                }
                return attribute;
            }
            catch (OlapException ex) {
                throw new IllegalStateException("Failed to retrieve property from OLAP member", ex);
            }
        }
        return this.backend.getMetaAttribute(domain, name, type, context, defaultValue);
    }

    public Object clone() throws CloneNotSupportedException {
        MDXMetaDataMemberAttributes attributes = (MDXMetaDataMemberAttributes)super.clone();
        attributes.backend = (DataAttributes)this.backend.clone();
        return attributes;
    }

    public ConceptQueryMapper getMetaAttributeMapper(String domain, String name) {
        if ("http://reporting.pentaho.org/namespaces/engine/meta-attributes/mdx".equals(domain)) {
            if ("MDX::CAPTION".equals(name)) {
                return new LocalizedStringConceptMapper();
            }
            if ("MDX::DESCRIPTION".equals(name)) {
                return new LocalizedStringConceptMapper();
            }
        }
        return DefaultConceptQueryMapper.INSTANCE;
    }
}

