/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.extensions.datasources.olap4j.writer;

import java.io.IOException;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.modules.parser.bundle.writer.BundleWriterException;
import org.pentaho.reporting.engine.classic.extensions.datasources.olap4j.AbstractMDXDataFactory;
import org.pentaho.reporting.engine.classic.extensions.datasources.olap4j.connections.OlapConnectionProvider;
import org.pentaho.reporting.engine.classic.extensions.datasources.olap4j.writer.DenormalizedMDXDataFactoryBundleWriteHandler;
import org.pentaho.reporting.engine.classic.extensions.datasources.olap4j.writer.OlapConnectionProviderWriteHandler;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.base.util.StringUtils;
import org.pentaho.reporting.libraries.xmlns.writer.XmlWriter;

public abstract class AbstractMDXDataFactoryBundleWriteHandler {
    protected void writeBody(AbstractMDXDataFactory dataFactory, XmlWriter xmlWriter) throws IOException, BundleWriterException {
        String jdbcPasswordField;
        String jdbcUserField;
        this.writeConnectionInfo(xmlWriter, dataFactory.getConnectionProvider());
        String roleField = dataFactory.getRoleField();
        if (!StringUtils.isEmpty((String)roleField)) {
            xmlWriter.writeTag("http://jfreereport.sourceforge.net/namespaces/datasources/olap4j", "role-field", false);
            xmlWriter.writeTextNormalized(roleField, false);
            xmlWriter.writeCloseTag();
        }
        if (!StringUtils.isEmpty((String)(jdbcUserField = dataFactory.getJdbcUserField()))) {
            xmlWriter.writeTag("http://jfreereport.sourceforge.net/namespaces/datasources/olap4j", "jdbc-user-field", false);
            xmlWriter.writeTextNormalized(jdbcUserField, false);
            xmlWriter.writeCloseTag();
        }
        if (!StringUtils.isEmpty((String)(jdbcPasswordField = dataFactory.getJdbcPasswordField()))) {
            xmlWriter.writeTag("http://jfreereport.sourceforge.net/namespaces/datasources/olap4j", "jdbc-password-field", false);
            xmlWriter.writeTextNormalized(jdbcPasswordField, false);
            xmlWriter.writeCloseTag();
        }
    }

    private void writeConnectionInfo(XmlWriter xmlWriter, OlapConnectionProvider connectionProvider) throws IOException, BundleWriterException {
        if (connectionProvider == null) {
            throw new NullPointerException();
        }
        String configKey = "org.pentaho.reporting.engine.classic.extensions.datasources.olap4j.writer.handler.sql-connection-provider." + connectionProvider.getClass().getName();
        Configuration globalConfig = ClassicEngineBoot.getInstance().getGlobalConfig();
        String value = globalConfig.getConfigProperty(configKey);
        if (value == null) {
            throw new BundleWriterException("Unable to find writer for connection info of type " + connectionProvider.getClass());
        }
        OlapConnectionProviderWriteHandler handler = (OlapConnectionProviderWriteHandler)ObjectUtilities.loadAndInstantiate((String)value, DenormalizedMDXDataFactoryBundleWriteHandler.class, OlapConnectionProviderWriteHandler.class);
        if (handler != null) {
            handler.writeReport(xmlWriter, connectionProvider);
        }
    }
}

