/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.extensions.datasources.olap4j.writer;

import java.io.IOException;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.PasswordEncryptionService;
import org.pentaho.reporting.engine.classic.core.modules.parser.bundle.writer.BundleWriterException;
import org.pentaho.reporting.engine.classic.extensions.datasources.olap4j.connections.DriverConnectionProvider;
import org.pentaho.reporting.engine.classic.extensions.datasources.olap4j.connections.OlapConnectionProvider;
import org.pentaho.reporting.engine.classic.extensions.datasources.olap4j.writer.OlapConnectionProviderWriteHandler;
import org.pentaho.reporting.libraries.xmlns.writer.XmlWriter;

public class DriverConnectionProviderWriteHandler
implements OlapConnectionProviderWriteHandler {
    public String writeReport(XmlWriter xmlWriter, OlapConnectionProvider connectionProvider) throws IOException, BundleWriterException {
        if (xmlWriter == null) {
            throw new NullPointerException();
        }
        if (connectionProvider == null) {
            throw new NullPointerException();
        }
        DriverConnectionProvider driverProvider = (DriverConnectionProvider)connectionProvider;
        xmlWriter.writeTag("http://jfreereport.sourceforge.net/namespaces/datasources/olap4j", "connection", false);
        xmlWriter.writeTag("http://jfreereport.sourceforge.net/namespaces/datasources/olap4j", "driver", false);
        xmlWriter.writeTextNormalized(driverProvider.getDriver(), false);
        xmlWriter.writeCloseTag();
        xmlWriter.writeTag("http://jfreereport.sourceforge.net/namespaces/datasources/olap4j", "url", false);
        xmlWriter.writeTextNormalized(driverProvider.getUrl(), false);
        xmlWriter.writeCloseTag();
        xmlWriter.writeTag("http://jfreereport.sourceforge.net/namespaces/datasources/olap4j", "properties", false);
        String[] propertyNames = driverProvider.getPropertyNames();
        for (int i = 0; i < propertyNames.length; ++i) {
            String name = propertyNames[i];
            String value = driverProvider.getProperty(name);
            xmlWriter.writeTag("http://jfreereport.sourceforge.net/namespaces/datasources/olap4j", "property", "name", name, false);
            if (name.toLowerCase().contains("password")) {
                xmlWriter.writeTextNormalized(PasswordEncryptionService.getInstance().encrypt(value), false);
            } else {
                xmlWriter.writeTextNormalized(value, false);
            }
            xmlWriter.writeCloseTag();
        }
        xmlWriter.writeCloseTag();
        xmlWriter.writeCloseTag();
        return null;
    }
}

