/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.resourceloader;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.libraries.base.util.CSVQuoter;
import org.pentaho.reporting.libraries.base.util.CSVTokenizer;
import org.pentaho.reporting.libraries.base.util.IOUtils;
import org.pentaho.reporting.libraries.resourceloader.FactoryParameterKey;
import org.pentaho.reporting.libraries.resourceloader.LoaderParameterKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceData;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceKeyCreationException;
import org.pentaho.reporting.libraries.resourceloader.ResourceKeyData;
import org.pentaho.reporting.libraries.resourceloader.ResourceLoadingException;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;

public class ResourceKeyUtils {
    private static final String DELIMITER = ";";
    private static final String SERIALIZATION_PREFIX = "resourcekey:";
    private static final Log logger = LogFactory.getLog(ResourceManager.class);

    public static String createStringResourceKey(String schema, String identifier, Map factoryParameters) {
        String factoryParamString = ResourceKeyUtils.convertFactoryParametersToString(factoryParameters);
        CSVQuoter quoter = new CSVQuoter(';');
        return quoter.doQuoting(SERIALIZATION_PREFIX + schema) + DELIMITER + quoter.doQuoting(identifier) + (factoryParamString == null ? "" : DELIMITER + quoter.doQuoting(factoryParamString));
    }

    public static ResourceKeyData parse(String resourceKeyString) throws ResourceKeyCreationException {
        if (resourceKeyString == null) {
            throw new IllegalArgumentException("Source string can not be null");
        }
        if (!resourceKeyString.startsWith(SERIALIZATION_PREFIX)) {
            throw new ResourceKeyCreationException("The source string does not start with the string [resourcekey:]");
        }
        CSVTokenizer tokenizer = new CSVTokenizer(resourceKeyString, DELIMITER, "\"", false);
        if (!tokenizer.hasMoreElements()) {
            throw new ResourceKeyCreationException("Schema is missing");
        }
        String rawSchema = tokenizer.nextToken();
        if (!rawSchema.startsWith(SERIALIZATION_PREFIX)) {
            throw new ResourceKeyCreationException("Prefix is wrong");
        }
        String schema = rawSchema.substring(SERIALIZATION_PREFIX.length());
        if (!tokenizer.hasMoreElements()) {
            throw new ResourceKeyCreationException("Identifier is missing");
        }
        String id = tokenizer.nextToken();
        Map parameters = tokenizer.hasMoreElements() ? ResourceKeyUtils.parseFactoryParametersFromString(tokenizer.nextToken()) : null;
        return new ResourceKeyData(schema, id, parameters);
    }

    public static String convertFactoryParametersToString(Map factoryParameters) {
        if (factoryParameters == null || factoryParameters.size() <= 0) {
            return null;
        }
        CSVQuoter innerQuoter = new CSVQuoter('=');
        CSVQuoter quoter = new CSVQuoter(':');
        StringBuilder sb = new StringBuilder();
        Iterator iterator = factoryParameters.keySet().iterator();
        while (iterator.hasNext()) {
            Serializable fkey;
            if (sb.length() > 0) {
                sb.append(':');
            }
            StringBuilder entrySb = new StringBuilder();
            Object key = iterator.next();
            if (key instanceof FactoryParameterKey) {
                fkey = (FactoryParameterKey)key;
                entrySb.append(innerQuoter.doQuoting("f:" + ((FactoryParameterKey)fkey).getName()));
            } else if (key instanceof LoaderParameterKey) {
                fkey = (LoaderParameterKey)key;
                entrySb.append(innerQuoter.doQuoting("l:" + ((LoaderParameterKey)fkey).getName()));
            } else {
                throw new IllegalArgumentException();
            }
            Object value = factoryParameters.get(key);
            entrySb.append('=');
            if (value != null) {
                entrySb.append(innerQuoter.doQuoting(String.valueOf(value)));
            }
            sb.append(quoter.doQuoting(entrySb.toString()));
        }
        logger.debug((Object)("Converted ResourceKey's Factory Parameters to String: [" + sb.toString() + "]"));
        return sb.toString();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Map parseFactoryParametersFromString(String factoryParameters) {
        if (factoryParameters == null) {
            return null;
        }
        HashMap<void, String> params = new HashMap<void, String>();
        CSVTokenizer tokenizer = new CSVTokenizer(factoryParameters, ":", "\"", false);
        while (tokenizer.hasMoreTokens()) {
            void var5_5;
            String entry = tokenizer.nextToken();
            CSVTokenizer innerTokenizer = new CSVTokenizer(entry, "=", "\"", false);
            if (!innerTokenizer.hasMoreElements()) throw new IllegalStateException();
            String keyString = innerTokenizer.nextToken();
            if (keyString.startsWith("f:")) {
                FactoryParameterKey factoryParameterKey = new FactoryParameterKey(keyString.substring(2));
            } else {
                if (!keyString.startsWith("l:")) throw new IllegalStateException();
                LoaderParameterKey loaderParameterKey = new LoaderParameterKey(keyString.substring(2));
            }
            String value = innerTokenizer.hasMoreElements() ? innerTokenizer.nextToken() : null;
            params.put(var5_5, value);
        }
        if (!logger.isDebugEnabled()) return params;
        logger.debug((Object)("Converted ResourceKey's Factory Parameter String to a Map: [" + factoryParameters + "] -> map of size " + params.size()));
        return params;
    }

    public static Object readSchemaFromString(String data) {
        if (data == null) {
            return null;
        }
        CSVTokenizer tokenizer = new CSVTokenizer(data, DELIMITER, "\"", false);
        if (!tokenizer.hasMoreElements()) {
            return null;
        }
        String tempData = tokenizer.nextToken();
        if (tempData.startsWith(SERIALIZATION_PREFIX)) {
            return tempData.substring(SERIALIZATION_PREFIX.length());
        }
        return null;
    }

    public static ResourceKey toResourceKey(Object value, ResourceManager resourceManager, ResourceKey contextKey, Map parameters) throws ResourceKeyCreationException {
        if (value == null) {
            return null;
        }
        if (value instanceof ResourceKey) {
            return (ResourceKey)value;
        }
        if (resourceManager == null) {
            throw new NullPointerException("ResourceManager is null");
        }
        Object tempObject = value;
        if (tempObject instanceof String) {
            String spec = (String)value;
            if (contextKey != null) {
                try {
                    return resourceManager.deriveKey(contextKey, spec, parameters);
                }
                catch (ResourceKeyCreationException e) {
                    // empty catch block
                }
            }
            try {
                tempObject = new URL(spec);
            }
            catch (MalformedURLException e) {
                tempObject = new File(spec);
            }
        }
        return resourceManager.createKey(tempObject, parameters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ResourceKey embedResourceInKey(ResourceManager manager, ResourceKey source, Map factoryParameters) throws IOException, ResourceKeyCreationException, ResourceLoadingException {
        if (manager == null) {
            throw new IllegalArgumentException();
        }
        if (source == null) {
            throw new IllegalArgumentException();
        }
        ResourceData resourceData = manager.load(source);
        InputStream in = resourceData.getResourceAsStream(manager);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            IOUtils.getInstance().copyStreams(in, (OutputStream)out);
            ResourceKey resourceKey = manager.createKey(out.toByteArray(), factoryParameters);
            return resourceKey;
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {
                logger.error((Object)"Error closing input stream", (Throwable)e);
            }
        }
    }
}

