/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.resourceloader.cache;

import java.util.WeakHashMap;
import org.pentaho.reporting.libraries.resourceloader.ResourceBundleData;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceLoadingException;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;
import org.pentaho.reporting.libraries.resourceloader.cache.CachingResourceBundleData;
import org.pentaho.reporting.libraries.resourceloader.cache.DefaultResourceBundleDataCacheEntry;
import org.pentaho.reporting.libraries.resourceloader.cache.ResourceBundleDataCache;
import org.pentaho.reporting.libraries.resourceloader.cache.ResourceBundleDataCacheEntry;

public class NullResourceBundleDataCache
implements ResourceBundleDataCache {
    private WeakHashMap<ResourceKey, ResourceBundleDataCacheEntry> keys = new WeakHashMap();

    public synchronized ResourceBundleData put(ResourceManager caller, ResourceBundleData data) throws ResourceLoadingException {
        ResourceBundleData retval = CachingResourceBundleData.createCached(data);
        this.keys.put(retval.getBundleKey(), new DefaultResourceBundleDataCacheEntry(retval, caller));
        return retval;
    }

    public synchronized ResourceBundleDataCacheEntry get(ResourceKey key) {
        return this.keys.get(key);
    }

    public synchronized void remove(ResourceBundleData data) {
        this.keys.remove(data.getBundleKey());
    }

    public synchronized void clear() {
        this.keys.clear();
    }

    public synchronized void shutdown() {
        this.keys.clear();
    }
}

