/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.resourceloader.factory;

import java.util.HashSet;
import java.util.Iterator;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.resourceloader.ContentNotRecognizedException;
import org.pentaho.reporting.libraries.resourceloader.LibLoaderBoot;
import org.pentaho.reporting.libraries.resourceloader.Resource;
import org.pentaho.reporting.libraries.resourceloader.ResourceCreationException;
import org.pentaho.reporting.libraries.resourceloader.ResourceData;
import org.pentaho.reporting.libraries.resourceloader.ResourceFactory;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceLoadingException;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;
import org.pentaho.reporting.libraries.resourceloader.factory.FactoryModule;

public abstract class AbstractResourceFactory
implements ResourceFactory {
    private static Log logger = LogFactory.getLog(AbstractResourceFactory.class);
    private HashSet factoryModules;
    private Class factoryType;

    protected AbstractResourceFactory(Class factoryType) {
        if (factoryType == null) {
            throw new NullPointerException();
        }
        this.factoryType = factoryType;
        this.factoryModules = new HashSet();
    }

    public Class getFactoryType() {
        return this.factoryType;
    }

    public void initializeDefaults() {
        String type = this.getFactoryType().getName();
        String prefix = "org.pentaho.reporting.libraries.resourceloader.factory.modules." + type;
        Configuration config = LibLoaderBoot.getInstance().getGlobalConfig();
        Iterator itType = config.findPropertyKeys(prefix);
        while (itType.hasNext()) {
            String key = (String)itType.next();
            String modClass = config.getConfigProperty(key);
            Object maybeFactory = ObjectUtilities.loadAndInstantiate((String)modClass, AbstractResourceFactory.class, FactoryModule.class);
            if (!(maybeFactory instanceof FactoryModule)) continue;
            this.registerModule((FactoryModule)maybeFactory);
        }
    }

    public synchronized boolean registerModule(String className) {
        try {
            ClassLoader loader = ObjectUtilities.getClassLoader(this.getClass());
            Class<?> c = Class.forName(className, false, loader);
            this.registerModule((FactoryModule)c.newInstance());
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public synchronized void registerModule(FactoryModule module) {
        if (this.factoryModules.contains(module)) {
            return;
        }
        this.factoryModules.add(module);
    }

    public synchronized Resource create(ResourceManager manager, ResourceData data, ResourceKey context) throws ResourceCreationException, ResourceLoadingException {
        TreeSet<ResourceFactoryEntry> sortedEntries = new TreeSet<ResourceFactoryEntry>();
        for (FactoryModule mod : this.factoryModules) {
            int weight = mod.canHandleResource(manager, data);
            if (weight < 0) continue;
            sortedEntries.add(new ResourceFactoryEntry(mod, weight));
        }
        for (ResourceFactoryEntry entry : sortedEntries) {
            try {
                return entry.getModule().create(manager, data, context);
            }
            catch (ResourceCreationException ex) {
                if (!(ex instanceof ContentNotRecognizedException)) continue;
                throw ex;
            }
            catch (Exception ex) {
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)("Failed to load content with module " + entry.getModule() + ":"), (Throwable)ex);
            }
        }
        throw new ContentNotRecognizedException("No valid handler for the given content.");
    }

    private static class ResourceFactoryEntry
    implements Comparable {
        private FactoryModule module;
        private int weight;

        private ResourceFactoryEntry(FactoryModule module, int weight) {
            this.module = module;
            this.weight = weight;
        }

        public FactoryModule getModule() {
            return this.module;
        }

        public int getWeight() {
            return this.weight;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ResourceFactoryEntry that = (ResourceFactoryEntry)o;
            if (this.weight != that.weight) {
                return false;
            }
            return !(this.module != null ? !this.module.equals(that.module) : that.module != null);
        }

        public int hashCode() {
            int result = this.module != null ? this.module.hashCode() : 0;
            result = 31 * result + this.weight;
            return result;
        }

        public int compareTo(Object o) {
            ResourceFactoryEntry entry = (ResourceFactoryEntry)o;
            if (this.weight == entry.weight) {
                return 0;
            }
            if (this.weight < entry.weight) {
                return -1;
            }
            return 1;
        }
    }
}

