/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.resourceloader.factory.drawable;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DrawableWrapper {
    private static final Log logger = LogFactory.getLog(DrawableWrapper.class);
    private static final Map drawables = Collections.synchronizedMap(new HashMap());
    private Object backend;
    private Method drawMethod;
    private Method getPreferredSizeMethod;
    private Method isKeepAspectRatioMethod;
    private static final Object[] EMPTY_ARGS = new Object[0];
    private static final Class[] EMPTY_PARAMS = new Class[0];
    private static final Class[] PARAMETER_TYPES = new Class[]{Graphics2D.class, Rectangle2D.class};

    public DrawableWrapper(Object maybeDrawable) {
        int modifiers;
        if (maybeDrawable == null) {
            throw new NullPointerException("Drawable must not be null");
        }
        if (maybeDrawable instanceof DrawableWrapper) {
            throw new IllegalArgumentException("Cannot wrap around a drawable-wrapper");
        }
        Class<?> aClass = maybeDrawable.getClass();
        try {
            this.drawMethod = aClass.getMethod("draw", PARAMETER_TYPES);
            modifiers = this.drawMethod.getModifiers();
            if (!Modifier.isPublic(modifiers) || Modifier.isAbstract(modifiers) || Modifier.isStatic(modifiers)) {
                if (logger.isWarnEnabled()) {
                    logger.warn((Object)("DrawMethod is not valid: " + aClass + '#' + this.drawMethod));
                }
                this.drawMethod = null;
            }
        }
        catch (NoSuchMethodException e) {
            if (logger.isWarnEnabled()) {
                logger.warn((Object)("The object is not a drawable: " + aClass));
            }
            this.drawMethod = null;
        }
        if (this.drawMethod != null) {
            try {
                this.isKeepAspectRatioMethod = aClass.getMethod("isPreserveAspectRatio", EMPTY_PARAMS);
                modifiers = this.isKeepAspectRatioMethod.getModifiers();
                if (!Modifier.isPublic(modifiers) || Modifier.isAbstract(modifiers) || Modifier.isStatic(modifiers) || !Boolean.TYPE.equals(this.isKeepAspectRatioMethod.getReturnType())) {
                    this.isKeepAspectRatioMethod = null;
                }
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
            try {
                this.getPreferredSizeMethod = aClass.getMethod("getPreferredSize", EMPTY_PARAMS);
                int modifiers2 = this.getPreferredSizeMethod.getModifiers();
                if (!Modifier.isPublic(modifiers2) || Modifier.isAbstract(modifiers2) || Modifier.isStatic(modifiers2) || !Dimension.class.isAssignableFrom(this.getPreferredSizeMethod.getReturnType())) {
                    this.getPreferredSizeMethod = null;
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        this.backend = maybeDrawable;
    }

    public Object getBackend() {
        return this.backend;
    }

    public void draw(Graphics2D g2, Rectangle2D bounds) {
        block3: {
            if (this.drawMethod == null) {
                return;
            }
            try {
                this.drawMethod.invoke(this.backend, g2, bounds);
            }
            catch (Exception e) {
                if (!logger.isDebugEnabled()) break block3;
                logger.warn((Object)"Invoking draw failed:", (Throwable)e);
            }
        }
    }

    public Dimension getPreferredSize() {
        if (this.getPreferredSizeMethod == null) {
            return null;
        }
        try {
            return (Dimension)this.getPreferredSizeMethod.invoke(this.backend, EMPTY_ARGS);
        }
        catch (Exception e) {
            if (logger.isWarnEnabled()) {
                logger.warn((Object)"Invoking getPreferredSize failed:", (Throwable)e);
            }
            return null;
        }
    }

    public boolean isPreserveAspectRatio() {
        if (this.isKeepAspectRatioMethod == null) {
            return false;
        }
        try {
            return Boolean.TRUE.equals(this.isKeepAspectRatioMethod.invoke(this.backend, EMPTY_ARGS));
        }
        catch (Exception e) {
            if (logger.isWarnEnabled()) {
                logger.warn((Object)"Invoking isKeepAspectRatio failed:", (Throwable)e);
            }
            return false;
        }
    }

    public static boolean isDrawable(Object maybeDrawable) {
        if (maybeDrawable == null) {
            throw new NullPointerException("A <null> value can never be a drawable.");
        }
        String key = maybeDrawable.getClass().getName();
        Boolean result = (Boolean)drawables.get(key);
        if (result != null) {
            return result;
        }
        boolean b = DrawableWrapper.computeIsDrawable(maybeDrawable);
        if (b) {
            drawables.put(key, Boolean.TRUE);
        } else {
            drawables.put(key, Boolean.FALSE);
        }
        return b;
    }

    private static boolean computeIsDrawable(Object maybeDrawable) {
        Class<?> aClass = maybeDrawable.getClass();
        try {
            Method drawMethod = aClass.getMethod("draw", PARAMETER_TYPES);
            int modifiers = drawMethod.getModifiers();
            return Modifier.isPublic(modifiers) && !Modifier.isAbstract(modifiers) && !Modifier.isStatic(modifiers);
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }
}

