/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.resourceloader.loader.raw;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Arrays;
import org.pentaho.reporting.libraries.resourceloader.ResourceData;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceLoadingException;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;

public class RawResourceData
implements ResourceData {
    private ResourceKey rawKey;
    private byte[] data;
    private volatile transient Long hashCode;

    public RawResourceData(ResourceKey rawKey) {
        if (rawKey == null) {
            throw new NullPointerException();
        }
        this.rawKey = rawKey;
        byte[] data = (byte[])rawKey.getIdentifier();
        this.data = (byte[])data.clone();
    }

    public byte[] getResource(ResourceManager caller) throws ResourceLoadingException {
        return (byte[])this.data.clone();
    }

    public long getLength() {
        return this.data.length;
    }

    public InputStream getResourceAsStream(ResourceManager caller) throws ResourceLoadingException {
        return new ByteArrayInputStream(this.data);
    }

    public int getResource(ResourceManager caller, byte[] target, long offset, int length) throws ResourceLoadingException {
        if (offset > (long)this.data.length) {
            return -1;
        }
        int iOffset = (int)(Integer.MAX_VALUE & offset);
        int remaining = this.data.length - iOffset;
        int maxReadable = Math.min(target.length, Math.min(remaining, length));
        System.arraycopy(this.data, iOffset, target, 0, maxReadable);
        return maxReadable;
    }

    public Object getAttribute(String key) {
        return null;
    }

    public ResourceKey getKey() {
        return this.rawKey;
    }

    public long getVersion(ResourceManager caller) throws ResourceLoadingException {
        if (this.hashCode == null) {
            this.hashCode = new Long((long)Arrays.hashCode(this.data) & 0xFFFFFFFFL);
        }
        return this.hashCode;
    }
}

