/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.resourceloader.modules.cache.ehcache;

import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.libraries.resourceloader.cache.ResourceBundleDataCache;
import org.pentaho.reporting.libraries.resourceloader.cache.ResourceBundleDataCacheProvider;
import org.pentaho.reporting.libraries.resourceloader.cache.ResourceDataCache;
import org.pentaho.reporting.libraries.resourceloader.cache.ResourceDataCacheProvider;
import org.pentaho.reporting.libraries.resourceloader.cache.ResourceFactoryCache;
import org.pentaho.reporting.libraries.resourceloader.cache.ResourceFactoryCacheProvider;
import org.pentaho.reporting.libraries.resourceloader.modules.cache.ehcache.EHResourceBundleDataCache;
import org.pentaho.reporting.libraries.resourceloader.modules.cache.ehcache.EHResourceDataCache;
import org.pentaho.reporting.libraries.resourceloader.modules.cache.ehcache.EHResourceFactoryCache;

public class EHCacheProvider
implements ResourceDataCacheProvider,
ResourceFactoryCacheProvider,
ResourceBundleDataCacheProvider {
    private static CacheManager cacheManager;
    private static final Log logger;

    public static synchronized CacheManager getCacheManager() throws CacheException {
        if (cacheManager == null) {
            cacheManager = CacheManager.create();
        }
        return cacheManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResourceDataCache createDataCache() {
        try {
            CacheManager manager;
            CacheManager cacheManager = manager = EHCacheProvider.getCacheManager();
            synchronized (cacheManager) {
                if (!manager.cacheExists("libloader-data")) {
                    manager.addCache("libloader-data");
                }
                return new EHResourceDataCache(manager.getCache("libloader-data"));
            }
        }
        catch (CacheException e) {
            logger.debug((Object)"Failed to create EHCache libloader-data cache", (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResourceBundleDataCache createBundleDataCache() {
        try {
            CacheManager manager;
            CacheManager cacheManager = manager = EHCacheProvider.getCacheManager();
            synchronized (cacheManager) {
                if (!manager.cacheExists("libloader-bundles")) {
                    manager.addCache("libloader-bundles");
                }
                return new EHResourceBundleDataCache(manager.getCache("libloader-bundles"));
            }
        }
        catch (CacheException e) {
            logger.debug((Object)"Failed to create EHCache libloader-bundles cache", (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResourceFactoryCache createFactoryCache() {
        try {
            CacheManager manager;
            CacheManager cacheManager = manager = EHCacheProvider.getCacheManager();
            synchronized (cacheManager) {
                if (!manager.cacheExists("libloader-factory")) {
                    manager.addCache("libloader-factory");
                }
                return new EHResourceFactoryCache(manager.getCache("libloader-factory"));
            }
        }
        catch (CacheException e) {
            logger.debug((Object)"Failed to create EHCache libloader-factory cache", (Throwable)e);
            return null;
        }
    }

    static {
        logger = LogFactory.getLog(EHCacheProvider.class);
    }
}

