/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.commons.connection;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.dom.DOMDocumentFactory;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.pentaho.commons.connection.IPentahoDataTypes;
import org.pentaho.commons.connection.IPentahoResultSet;
import org.pentaho.commons.connection.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataUtilities
implements IPentahoDataTypes {
    public static Object[][] pivotDimensions(Object[][] source) {
        Object[][] result = null;
        if (source.length > 0) {
            result = new Object[source[0].length][source.length];
            for (int row = 0; row < source.length; ++row) {
                for (int column = 0; column < source[row].length; ++column) {
                    result[column][row] = source[row][column];
                }
            }
        } else {
            result = source;
        }
        return result;
    }

    public static Object[][] filterDataByRows(Object[][] data, Integer[] rowsToInclude) {
        if (rowsToInclude == null) {
            return data;
        }
        Object[][] result = new Object[rowsToInclude.length][data[0].length];
        for (int row = 0; row < rowsToInclude.length; ++row) {
            Object[] rowHeaderRow = data[rowsToInclude[row]];
            for (int column = 0; column < rowHeaderRow.length; ++column) {
                result[row][column] = rowHeaderRow[column];
            }
        }
        return result;
    }

    public static Object[][] filterDataByColumns(Object[][] data, Integer[] columnsToInclude) {
        if (columnsToInclude == null) {
            return data;
        }
        Object[][] result = new Object[data.length][columnsToInclude.length];
        for (int column = 0; column < columnsToInclude.length; ++column) {
            for (int row = 0; row < data.length; ++row) {
                result[row][column] = data[row][columnsToInclude[column]];
            }
        }
        return result;
    }

    public static Object[][] filterData(Object[][] data, Integer[] rowsToInclude, Integer[] columnsToInclude) {
        Object[][] result = DataUtilities.filterDataByColumns(data, columnsToInclude);
        result = DataUtilities.filterDataByRows(result, rowsToInclude);
        return result;
    }

    public static String getXMLString(IPentahoResultSet resultSet) {
        Document document = DOMDocumentFactory.getInstance().createDocument();
        Element resultSetNode = document.addElement("result-set");
        Object[] colHeaders = resultSet.getMetaData().getColumnHeaders()[0];
        String metaDataStr = "";
        Object[] firstDataRow = resultSet.getDataRow(0);
        for (int i = 0; i < firstDataRow.length; ++i) {
            metaDataStr = metaDataStr + firstDataRow[i].getClass().getName() + (i == firstDataRow.length - 1 ? "" : ",");
        }
        resultSetNode.addComment(metaDataStr);
        int rowCount = resultSet.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            Object[] row = resultSet.getDataRow(i);
            Element rowNode = resultSetNode.addElement("row");
            for (int j = 0; j < row.length; ++j) {
                String value;
                String column = colHeaders[j].toString();
                String string = value = row[j] != null ? row[j].toString() : "";
                if (row[j] instanceof Timestamp || row[j] instanceof Date) {
                    value = String.valueOf(((Timestamp)row[j]).getTime());
                }
                Element dataNode = rowNode.addElement(column);
                dataNode.setText(value);
            }
        }
        OutputFormat format = OutputFormat.createPrettyPrint();
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        try {
            XMLWriter writer = new XMLWriter((OutputStream)outStream, format);
            writer.write(document);
            return outStream.toString();
        }
        catch (Exception e) {
            return document.asXML();
        }
    }

    public static List<Number> toNumbers(Object[] rowData, NumberFormat ... formats) {
        ArrayList<Number> numberList = new ArrayList<Number>();
        block2: for (int i = 0; i < rowData.length; ++i) {
            if (rowData[i] == null) {
                throw new IllegalArgumentException(Messages.getString("DataUtilities.ERROR_0001_CANNOT_COVERT_NULL_DATA"));
            }
            if (Number.class.isAssignableFrom(rowData[i].getClass())) {
                numberList.add((Number)rowData[i]);
                continue;
            }
            for (int j = 0; j < formats.length; ++j) {
                Number num;
                try {
                    num = formats[j].parse(rowData[i].toString());
                }
                catch (ParseException e) {
                    if (j < formats.length - 1) continue;
                    throw new IllegalArgumentException(e);
                }
                numberList.add(num);
                continue block2;
            }
        }
        return numberList;
    }

    public static Number toNumber(Object data, NumberFormat ... formats) {
        return DataUtilities.toNumbers(new Object[]{data}, formats).get(0);
    }
}

