/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.commons.connection.marshal;

import java.io.Serializable;
import java.util.ArrayList;
import org.pentaho.commons.connection.IPentahoMetaData;
import org.pentaho.commons.connection.IPentahoResultSet;
import org.pentaho.commons.connection.marshal.MarshallableColumnNames;
import org.pentaho.commons.connection.marshal.MarshallableColumnTypes;
import org.pentaho.commons.connection.marshal.MarshallableRow;

public class MarshallableResultSet
implements Serializable {
    private static final long serialVersionUID = 3272001968807944367L;
    private MarshallableRow[] rows;
    private MarshallableColumnTypes columnTypes;
    private MarshallableColumnNames columnNames;
    private int numColumnHeaderSets = 0;
    private int numRowHeaderSets = 0;

    public void setResultSet(IPentahoResultSet results) {
        int colCount = results.getColumnCount();
        IPentahoMetaData metadata = results.getMetaData();
        String[] tmp = new String[colCount];
        Object[][] colHeaders = metadata.getColumnHeaders();
        for (int colNo = 0; colNo < colHeaders[0].length; ++colNo) {
            tmp[colNo] = colHeaders[0][colNo].toString();
        }
        this.columnNames = new MarshallableColumnNames();
        this.columnNames.setColumnNames(tmp);
        this.columnTypes = new MarshallableColumnTypes();
        ArrayList<MarshallableRow> rowList = new ArrayList<MarshallableRow>();
        int unknownTypes = colCount;
        String[] tmpTypes = new String[colCount];
        Object[] rowObjects = results.next();
        while (rowObjects != null) {
            MarshallableRow row = new MarshallableRow();
            row.setCell(rowObjects);
            rowList.add(row);
            if (unknownTypes > 0) {
                for (int colNo = 0; colNo < rowObjects.length; ++colNo) {
                    if (tmpTypes[colNo] != null || rowObjects[colNo] == null) continue;
                    tmpTypes[colNo] = MarshallableColumnTypes.getDataType(rowObjects[colNo].getClass().getName());
                    --unknownTypes;
                }
            }
            rowObjects = results.next();
        }
        this.rows = new MarshallableRow[rowList.size()];
        rowList.toArray(this.rows);
        if (unknownTypes > 0) {
            for (int colNo = 0; colNo < tmpTypes.length; ++colNo) {
                if (tmpTypes[colNo] != null) continue;
                tmpTypes[colNo] = "string";
            }
        }
        this.columnTypes.setColumnType(tmpTypes);
    }

    public MarshallableRow[] getRows() {
        return this.rows;
    }

    public MarshallableColumnNames getColumnNames() {
        return this.columnNames;
    }

    public MarshallableColumnTypes getColumnTypes() {
        return this.columnTypes;
    }

    public int getNumColumnHeaderSets() {
        return this.numColumnHeaderSets;
    }

    public void setNumColumnHeaderSets(int numColumnHeaderSets) {
        this.numColumnHeaderSets = numColumnHeaderSets;
    }

    public int getNumRowHeaderSets() {
        return this.numRowHeaderSets;
    }

    public void setNumRowHeaderSets(int numRowHeaderSets) {
        this.numRowHeaderSets = numRowHeaderSets;
    }
}

