/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig;

import java.io.IOException;
import java.net.URI;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.pig.LoadCaster;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigSplit;
import org.apache.pig.builtin.Utf8StorageConverter;
import org.apache.pig.classification.InterfaceAudience;
import org.apache.pig.classification.InterfaceStability;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.logicalLayer.FrontendException;

@InterfaceAudience.Public
@InterfaceStability.Stable
public abstract class LoadFunc {
    public String relativeToAbsolutePath(String location, Path curDir) throws IOException {
        return LoadFunc.getAbsolutePath(location, curDir);
    }

    public abstract void setLocation(String var1, Job var2) throws IOException;

    public abstract InputFormat getInputFormat() throws IOException;

    public LoadCaster getLoadCaster() throws IOException {
        return new Utf8StorageConverter();
    }

    public abstract void prepareToRead(RecordReader var1, PigSplit var2) throws IOException;

    public abstract Tuple getNext() throws IOException;

    public static String join(AbstractCollection<String> s, String delimiter) {
        if (s.isEmpty()) {
            return "";
        }
        Iterator<String> iter = s.iterator();
        StringBuffer buffer = new StringBuffer(iter.next());
        while (iter.hasNext()) {
            buffer.append(delimiter);
            buffer.append(iter.next());
        }
        return buffer.toString();
    }

    public static String[] getPathStrings(String commaSeparatedPaths) {
        int length = commaSeparatedPaths.length();
        int curlyOpen = 0;
        int pathStart = 0;
        boolean globPattern = false;
        ArrayList<String> pathStrings = new ArrayList<String>();
        block5: for (int i = 0; i < length; ++i) {
            char ch = commaSeparatedPaths.charAt(i);
            switch (ch) {
                case '{': {
                    ++curlyOpen;
                    if (globPattern) continue block5;
                    globPattern = true;
                    continue block5;
                }
                case '}': {
                    if (--curlyOpen != 0 || !globPattern) continue block5;
                    globPattern = false;
                    continue block5;
                }
                case ',': {
                    if (globPattern) continue block5;
                    pathStrings.add(commaSeparatedPaths.substring(pathStart, i));
                    pathStart = i + 1;
                }
            }
        }
        pathStrings.add(commaSeparatedPaths.substring(pathStart, length));
        return pathStrings.toArray(new String[0]);
    }

    public static String getAbsolutePath(String location, Path curDir) throws FrontendException {
        String[] fnames;
        if (location == null || curDir == null) {
            throw new FrontendException("location: " + location + " curDir: " + curDir);
        }
        URI fsUri = curDir.toUri();
        String fsScheme = fsUri.getScheme();
        if (fsScheme == null) {
            throw new FrontendException("curDir: " + curDir);
        }
        fsScheme = fsScheme.toLowerCase();
        String authority = fsUri.getAuthority();
        if (authority == null) {
            authority = "";
        }
        Path rootDir = new Path(fsScheme, authority, "/");
        ArrayList<String> pathStrings = new ArrayList<String>();
        for (String fname : fnames = LoadFunc.getPathStrings(location)) {
            Path p = new Path(fname = fname.trim());
            URI uri = p.toUri();
            if (!uri.isAbsolute() && !p.isAbsolute()) {
                String scheme = uri.getScheme();
                if (scheme != null) {
                    scheme = scheme.toLowerCase();
                }
                if (scheme != null && !scheme.equals(fsScheme)) {
                    throw new FrontendException("Incompatible file URI scheme: " + scheme + " : " + fsScheme);
                }
                String path = uri.getPath();
                fname = p.isAbsolute() ? new Path(rootDir, path).toString() : new Path(curDir, path).toString();
            }
            fname = fname.replaceFirst("^file:/([^/])", "file:///$1");
            fname = fname.replaceFirst("/$", "");
            pathStrings.add(fname);
        }
        return LoadFunc.join(pathStrings, ",");
    }

    public void setUDFContextSignature(String signature) {
    }
}

