/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig;

import java.io.IOException;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.pig.LoadFunc;
import org.apache.pig.ResourceSchema;
import org.apache.pig.StoreFuncInterface;
import org.apache.pig.classification.InterfaceAudience;
import org.apache.pig.classification.InterfaceStability;
import org.apache.pig.data.Tuple;

@InterfaceAudience.Public
@InterfaceStability.Stable
public abstract class StoreFunc
implements StoreFuncInterface {
    @Override
    public String relToAbsPathForStoreLocation(String location, Path curDir) throws IOException {
        return LoadFunc.getAbsolutePath(location, curDir);
    }

    @Override
    public abstract OutputFormat getOutputFormat() throws IOException;

    @Override
    public abstract void setStoreLocation(String var1, Job var2) throws IOException;

    @Override
    public void checkSchema(ResourceSchema s) throws IOException {
    }

    @Override
    public abstract void prepareToWrite(RecordWriter var1) throws IOException;

    @Override
    public abstract void putNext(Tuple var1) throws IOException;

    @Override
    public void setStoreFuncUDFContextSignature(String signature) {
    }

    @Override
    public void cleanupOnFailure(String location, Job job) throws IOException {
        StoreFunc.cleanupOnFailureImpl(location, job);
    }

    public static void cleanupOnFailureImpl(String location, Job job) throws IOException {
        Path path = new Path(location);
        FileSystem fs = path.getFileSystem(job.getConfiguration());
        if (fs.exists(path)) {
            fs.delete(path, true);
        }
    }
}

