/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine;

import java.io.IOException;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketImplFactory;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.mapred.JobConf;
import org.apache.pig.ExecType;
import org.apache.pig.backend.datastorage.DataStorage;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.datastorage.HDataStorage;
import org.apache.pig.backend.hadoop.executionengine.MapRedResult;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.PhysicalOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhysicalPlan;
import org.apache.pig.impl.PigContext;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.util.ObjectSerializer;
import org.apache.pig.newplan.Operator;
import org.apache.pig.newplan.OperatorPlan;
import org.apache.pig.newplan.logical.optimizer.DanglingNestedNodeRemover;
import org.apache.pig.newplan.logical.optimizer.LogicalPlanOptimizer;
import org.apache.pig.newplan.logical.optimizer.SchemaResetter;
import org.apache.pig.newplan.logical.optimizer.UidResetter;
import org.apache.pig.newplan.logical.relational.LOForEach;
import org.apache.pig.newplan.logical.relational.LogToPhyTranslationVisitor;
import org.apache.pig.newplan.logical.relational.LogicalPlan;
import org.apache.pig.newplan.logical.relational.LogicalRelationalOperator;
import org.apache.pig.newplan.logical.rules.InputOutputFileValidator;
import org.apache.pig.newplan.logical.rules.LoadStoreFuncDupSignatureValidator;
import org.apache.pig.newplan.logical.visitor.SortInfoSetter;
import org.apache.pig.newplan.logical.visitor.StoreAliasSetter;
import org.apache.pig.pen.POOptimizeDisabler;

public class HExecutionEngine {
    public static final String JOB_TRACKER_LOCATION = "mapred.job.tracker";
    private static final String FILE_SYSTEM_LOCATION = "fs.default.name";
    private static final String ALTERNATIVE_FILE_SYSTEM_LOCATION = "fs.defaultFS";
    private static final String HADOOP_SITE = "hadoop-site.xml";
    private static final String CORE_SITE = "core-site.xml";
    private static final String YARN_SITE = "yarn-site.xml";
    private final Log log = LogFactory.getLog(this.getClass());
    public static final String LOCAL = "local";
    protected PigContext pigContext;
    protected DataStorage ds;
    protected JobConf jobConf;
    protected Map<OperatorKey, OperatorKey> logicalToPhysicalKeys;
    protected Map<OperatorKey, MapRedResult> materializedResults;
    protected Map<Operator, PhysicalOperator> newLogToPhyMap;
    private LogicalPlan newPreoptimizedPlan;

    public HExecutionEngine(PigContext pigContext) {
        this.pigContext = pigContext;
        this.logicalToPhysicalKeys = new HashMap<OperatorKey, OperatorKey>();
        this.materializedResults = new HashMap<OperatorKey, MapRedResult>();
        this.ds = null;
        this.jobConf = null;
    }

    public JobConf getJobConf() {
        return this.jobConf;
    }

    public Map<OperatorKey, MapRedResult> getMaterializedResults() {
        return this.materializedResults;
    }

    public DataStorage getDataStorage() {
        return this.ds;
    }

    public void init() throws ExecException {
        this.init(this.pigContext.getProperties());
    }

    private void init(Properties properties) throws ExecException {
        this.setSSHFactory();
        String cluster = null;
        String nameNode = null;
        JobConf jc = null;
        if (this.pigContext.getExecType() == ExecType.MAPREDUCE) {
            Configuration testConf = new Configuration();
            ClassLoader cl = testConf.getClassLoader();
            URL hadoop_site = cl.getResource(HADOOP_SITE);
            URL core_site = cl.getResource(CORE_SITE);
            if (hadoop_site == null && core_site == null) {
                throw new ExecException("Cannot find hadoop configurations in classpath (neither hadoop-site.xml nor core-site.xml was found in the classpath). If you plan to use local mode, please put -x local option in command line", 4010);
            }
            jc = new JobConf();
            jc.addResource("pig-cluster-hadoop-site.xml");
            jc.addResource(YARN_SITE);
            new DistributedFileSystem();
            this.recomputeProperties(jc, properties);
        } else {
            jc = new JobConf(false);
            jc.addResource("core-default.xml");
            jc.addResource("mapred-default.xml");
            jc.addResource("yarn-default.xml");
            this.recomputeProperties(jc, properties);
            properties.setProperty("mapreduce.framework.name", LOCAL);
            properties.setProperty(JOB_TRACKER_LOCATION, LOCAL);
            properties.setProperty(FILE_SYSTEM_LOCATION, "file:///");
            properties.setProperty(ALTERNATIVE_FILE_SYSTEM_LOCATION, "file:///");
        }
        cluster = properties.getProperty(JOB_TRACKER_LOCATION);
        nameNode = properties.getProperty(FILE_SYSTEM_LOCATION);
        if (nameNode == null) {
            nameNode = (String)this.pigContext.getProperties().get(ALTERNATIVE_FILE_SYSTEM_LOCATION);
        }
        if (cluster != null && cluster.length() > 0) {
            if (!cluster.contains(":") && !cluster.equalsIgnoreCase(LOCAL)) {
                cluster = cluster + ":50020";
            }
            properties.setProperty(JOB_TRACKER_LOCATION, cluster);
        }
        if (nameNode != null && nameNode.length() > 0) {
            if (!nameNode.contains(":") && !nameNode.equalsIgnoreCase(LOCAL)) {
                nameNode = nameNode + ":8020";
            }
            properties.setProperty(FILE_SYSTEM_LOCATION, nameNode);
        }
        this.log.info((Object)("Connecting to hadoop file system at: " + (nameNode == null ? LOCAL : nameNode)));
        this.ds = new HDataStorage(properties);
        if (cluster != null && !cluster.equalsIgnoreCase(LOCAL)) {
            this.log.info((Object)("Connecting to map-reduce job tracker at: " + jc.get(JOB_TRACKER_LOCATION)));
        }
        this.jobConf = jc;
    }

    public void updateConfiguration(Properties newConfiguration) throws ExecException {
        this.init(newConfiguration);
    }

    public PhysicalPlan compile(LogicalPlan plan, Properties properties) throws FrontendException {
        if (plan == null) {
            int errCode = 2041;
            String msg = "No Plan to compile";
            throw new FrontendException(msg, errCode, 4);
        }
        this.newPreoptimizedPlan = new LogicalPlan(plan);
        if (this.pigContext.inIllustrator) {
            POOptimizeDisabler pod = new POOptimizeDisabler(plan);
            pod.visit();
        }
        DanglingNestedNodeRemover DanglingNestedNodeRemover2 = new DanglingNestedNodeRemover(plan);
        DanglingNestedNodeRemover2.visit();
        UidResetter uidResetter = new UidResetter(plan);
        uidResetter.visit();
        SchemaResetter schemaResetter = new SchemaResetter(plan);
        schemaResetter.visit();
        HashSet<String> optimizerRules = null;
        try {
            optimizerRules = (HashSet<String>)ObjectSerializer.deserialize(this.pigContext.getProperties().getProperty("pig.optimizer.rules"));
        }
        catch (IOException ioe) {
            int errCode = 2110;
            String msg = "Unable to deserialize optimizer rules.";
            throw new FrontendException(msg, errCode, 4, (Throwable)ioe);
        }
        if (this.pigContext.inIllustrator) {
            if (optimizerRules == null) {
                optimizerRules = new HashSet<String>();
            }
            optimizerRules.add("MergeForEach");
            optimizerRules.add("PartitionFilterOptimizer");
            optimizerRules.add("LimitOptimizer");
            optimizerRules.add("SplitFilter");
            optimizerRules.add("PushUpFilter");
            optimizerRules.add("MergeFilter");
            optimizerRules.add("PushDownForEachFlatten");
            optimizerRules.add("ColumnMapKeyPrune");
            optimizerRules.add("AddForEach");
            optimizerRules.add("GroupByConstParallelSetter");
        }
        LoadStoreFuncDupSignatureValidator loadStoreFuncDupSignatureValidator = new LoadStoreFuncDupSignatureValidator(plan);
        loadStoreFuncDupSignatureValidator.validate();
        StoreAliasSetter storeAliasSetter = new StoreAliasSetter(plan);
        storeAliasSetter.visit();
        LogicalPlanOptimizer optimizer = new LogicalPlanOptimizer((OperatorPlan)plan, 100, optimizerRules);
        optimizer.optimize();
        SortInfoSetter sortInfoSetter = new SortInfoSetter(plan);
        sortInfoSetter.visit();
        if (!this.pigContext.inExplain) {
            InputOutputFileValidator validator = new InputOutputFileValidator(plan, this.pigContext);
            validator.validate();
        }
        LogToPhyTranslationVisitor translator = new LogToPhyTranslationVisitor(plan);
        translator.setPigContext(this.pigContext);
        translator.visit();
        this.newLogToPhyMap = translator.getLogToPhyMap();
        return translator.getPhysicalPlan();
    }

    public Map<Operator, PhysicalOperator> getLogToPhyMap() {
        return this.newLogToPhyMap;
    }

    public Map<LOForEach, Map<LogicalRelationalOperator, PhysicalOperator>> getForEachInnerLogToPhyMap(LogicalPlan plan) {
        HashMap<LOForEach, Map<LogicalRelationalOperator, PhysicalOperator>> result = new HashMap<LOForEach, Map<LogicalRelationalOperator, PhysicalOperator>>();
        Iterator<Operator> outerIter = plan.getOperators();
        while (outerIter.hasNext()) {
            Operator oper = outerIter.next();
            if (!(oper instanceof LOForEach)) continue;
            LogicalPlan innerPlan = ((LOForEach)oper).getInnerPlan();
            HashMap<LogicalRelationalOperator, PhysicalOperator> innerOpMap = new HashMap<LogicalRelationalOperator, PhysicalOperator>();
            Iterator<Operator> innerIter = innerPlan.getOperators();
            while (innerIter.hasNext()) {
                Operator innerOper = innerIter.next();
                innerOpMap.put((LogicalRelationalOperator)innerOper, this.newLogToPhyMap.get(innerOper));
            }
            result.put((LOForEach)oper, innerOpMap);
        }
        return result;
    }

    public LogicalPlan getNewPlan() {
        return this.newPreoptimizedPlan;
    }

    private void setSSHFactory() {
        Properties properties = this.pigContext.getProperties();
        String g = properties.getProperty("ssh.gateway");
        if (g == null || g.length() == 0) {
            return;
        }
        try {
            Class<?> clazz = Class.forName("org.apache.pig.shock.SSHSocketImplFactory");
            SocketImplFactory f = (SocketImplFactory)clazz.getMethod("getFactory", new Class[0]).invoke((Object)0, new Object[0]);
            Socket.setSocketImplFactory(f);
        }
        catch (SocketException e) {
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void recomputeProperties(JobConf jobConf, Properties properties) {
        if (jobConf != null && properties != null) {
            Enumeration<Object> propertiesIter = properties.keys();
            while (propertiesIter.hasMoreElements()) {
                String key = (String)propertiesIter.nextElement();
                String val = properties.getProperty(key);
                if (key.equals("user.name")) continue;
                jobConf.set(key, val);
            }
            properties.clear();
            for (Map.Entry entry : jobConf) {
                properties.put(entry.getKey(), entry.getValue());
            }
        }
    }
}

