/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.mapReduceLayer;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.pig.CollectableLoadFunc;
import org.apache.pig.ExecType;
import org.apache.pig.FuncSpec;
import org.apache.pig.IndexableLoadFunc;
import org.apache.pig.LoadFunc;
import org.apache.pig.OrderedLoadFunc;
import org.apache.pig.PigWarning;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.datastorage.ConfigurationUtil;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.MRCompilerException;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.MRUtil;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.MapReduceOper;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.MergeJoinIndexer;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.NativeMapReduceOper;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.plans.MROpPlanVisitor;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.plans.MROperPlan;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.plans.ScalarPhyFinder;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.plans.UDFFinder;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.PhysicalOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.ConstantExpression;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.POProject;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.POUserFunc;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhyPlanVisitor;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhysicalPlan;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POCollectedGroup;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.PODistinct;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POFRJoin;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POFilter;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POForEach;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POGlobalRearrange;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POJoinPackage;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POLimit;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POLoad;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POLocalRearrange;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POMergeCogroup;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POMergeJoin;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.PONative;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POPackage;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POPackageLite;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POPartitionRearrange;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POSkewedJoin;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POSort;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POSplit;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POStore;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POStream;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POUnion;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.util.PlanHelper;
import org.apache.pig.backend.hadoop.executionengine.shims.HadoopShims;
import org.apache.pig.backend.hadoop.executionengine.util.MapRedUtil;
import org.apache.pig.impl.PigContext;
import org.apache.pig.impl.builtin.DefaultIndexableLoader;
import org.apache.pig.impl.builtin.FindQuantiles;
import org.apache.pig.impl.builtin.GetMemNumRows;
import org.apache.pig.impl.builtin.PartitionSkewedKeys;
import org.apache.pig.impl.builtin.PoissonSampleLoader;
import org.apache.pig.impl.builtin.RandomSampleLoader;
import org.apache.pig.impl.io.FileLocalizer;
import org.apache.pig.impl.io.FileSpec;
import org.apache.pig.impl.plan.CompilationMessageCollector;
import org.apache.pig.impl.plan.DepthFirstWalker;
import org.apache.pig.impl.plan.NodeIdGenerator;
import org.apache.pig.impl.plan.Operator;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.plan.OperatorPlan;
import org.apache.pig.impl.plan.PlanException;
import org.apache.pig.impl.plan.PlanWalker;
import org.apache.pig.impl.plan.VisitorException;
import org.apache.pig.impl.util.CompilerUtils;
import org.apache.pig.impl.util.MultiMap;
import org.apache.pig.impl.util.ObjectSerializer;
import org.apache.pig.impl.util.Pair;
import org.apache.pig.impl.util.UriUtil;
import org.apache.pig.impl.util.Utils;

public class MRCompiler
extends PhyPlanVisitor {
    PigContext pigContext;
    PhysicalPlan plan;
    MROperPlan MRPlan;
    MapReduceOper curMROp;
    MapReduceOper[] compiledInputs = null;
    Map<OperatorKey, MapReduceOper> splitsSeen;
    NodeIdGenerator nig;
    private String scope;
    private Random r;
    private UDFFinder udfFinder;
    private CompilationMessageCollector messageCollector = null;
    private Map<PhysicalOperator, MapReduceOper> phyToMROpMap;
    public static final String USER_COMPARATOR_MARKER = "user.comparator.func:";
    private static final Log LOG = LogFactory.getLog(MRCompiler.class);
    public static final String FILE_CONCATENATION_THRESHOLD = "pig.files.concatenation.threshold";
    public static final String OPTIMISTIC_FILE_CONCATENATION = "pig.optimistic.files.concatenation";
    private int fileConcatenationThreshold = 100;
    private boolean optimisticFileConcatenation = false;

    public MRCompiler(PhysicalPlan plan) throws MRCompilerException {
        this(plan, (PigContext)null);
    }

    public MRCompiler(PhysicalPlan plan, PigContext pigContext) throws MRCompilerException {
        super(plan, (PlanWalker<PhysicalOperator, PhysicalPlan>)new DepthFirstWalker<PhysicalOperator, PhysicalPlan>(plan));
        this.plan = plan;
        this.pigContext = pigContext;
        this.splitsSeen = new HashMap<OperatorKey, MapReduceOper>();
        this.MRPlan = new MROperPlan();
        this.nig = NodeIdGenerator.getGenerator();
        this.r = new Random(1331L);
        FileLocalizer.setR(this.r);
        this.udfFinder = new UDFFinder();
        List roots = plan.getRoots();
        if (roots == null || roots.size() <= 0) {
            int errCode = 2053;
            String msg = "Internal error. Did not find roots in the physical plan.";
            throw new MRCompilerException(msg, errCode, 4);
        }
        this.scope = ((PhysicalOperator)roots.get(0)).getOperatorKey().getScope();
        this.messageCollector = new CompilationMessageCollector();
        this.phyToMROpMap = new HashMap<PhysicalOperator, MapReduceOper>();
        this.fileConcatenationThreshold = Integer.parseInt(pigContext.getProperties().getProperty(FILE_CONCATENATION_THRESHOLD, "100"));
        this.optimisticFileConcatenation = pigContext.getProperties().getProperty(OPTIMISTIC_FILE_CONCATENATION, "false").equals("true");
        LOG.info((Object)("File concatenation threshold: " + this.fileConcatenationThreshold + " optimistic? " + this.optimisticFileConcatenation));
    }

    public void aggregateScalarsFiles() throws PlanException, IOException {
        ArrayList<MapReduceOper> mrOpList = new ArrayList<MapReduceOper>();
        for (MapReduceOper mrOp : this.MRPlan) {
            mrOpList.add(mrOp);
        }
        Configuration conf = ConfigurationUtil.toConfiguration(this.pigContext.getProperties());
        boolean combinable = !conf.getBoolean("pig.noSplitCombination", false);
        HashMap<FileSpec, MapReduceOper> seen = new HashMap<FileSpec, MapReduceOper>();
        for (MapReduceOper mrOp : mrOpList) {
            for (PhysicalOperator scalar : mrOp.scalars) {
                MapReduceOper mro = this.phyToMROpMap.get(scalar);
                if (!(scalar instanceof POStore)) continue;
                FileSpec oldSpec = ((POStore)scalar).getSFile();
                MapReduceOper mro2 = (MapReduceOper)seen.get(oldSpec);
                boolean hasSeen = false;
                if (mro2 != null) {
                    hasSeen = true;
                    mro = mro2;
                }
                if (!hasSeen && combinable && (mro.reducePlan.isEmpty() ? this.hasTooManyInputFiles(mro, conf) : mro.requestedParallelism >= this.fileConcatenationThreshold)) {
                    PhysicalPlan pl = mro.reducePlan.isEmpty() ? mro.mapPlan : mro.reducePlan;
                    FileSpec newSpec = this.getTempFileSpec();
                    new FindStoreNameVisitor(pl, newSpec, oldSpec).visit();
                    POStore newSto = this.getStore();
                    newSto.setSFile(oldSpec);
                    if (this.MRPlan.getPredecessors(mrOp) != null && this.MRPlan.getPredecessors(mrOp).contains(mro)) {
                        this.MRPlan.disconnect(mro, mrOp);
                    }
                    MapReduceOper catMROp = this.getConcatenateJob(newSpec, mro, newSto);
                    this.MRPlan.connect(catMROp, mrOp);
                    seen.put(oldSpec, catMROp);
                    continue;
                }
                if (hasSeen) continue;
                seen.put(oldSpec, mro);
            }
        }
    }

    public void randomizeFileLocalizer() {
        FileLocalizer.setR(new Random());
    }

    public MROperPlan getMRPlan() {
        return this.MRPlan;
    }

    @Override
    public PhysicalPlan getPlan() {
        return this.plan;
    }

    public CompilationMessageCollector getMessageCollector() {
        return this.messageCollector;
    }

    public MROperPlan compile() throws IOException, PlanException, VisitorException {
        ArrayList<PhysicalOperator> ops;
        List leaves = this.plan.getLeaves();
        if (!this.pigContext.inIllustrator) {
            for (PhysicalOperator op : leaves) {
                if (op instanceof POStore) continue;
                int errCode = 2025;
                String msg = "Expected leaf of reduce plan to always be POStore. Found " + op.getClass().getSimpleName();
                throw new MRCompilerException(msg, errCode, 4);
            }
        }
        LinkedList<POStore> stores = PlanHelper.getStores(this.plan);
        LinkedList<PONative> nativeMRs = PlanHelper.getNativeMRs(this.plan);
        if (!this.pigContext.inIllustrator) {
            ops = new ArrayList<PhysicalOperator>(stores.size() + nativeMRs.size());
            ops.addAll(stores);
        } else {
            ops = new ArrayList(leaves.size() + nativeMRs.size());
            ops.addAll(leaves);
        }
        ops.addAll(nativeMRs);
        Collections.sort(ops);
        for (PhysicalOperator op : ops) {
            this.compile(op);
        }
        this.connectSoftLink();
        return this.MRPlan;
    }

    public void connectSoftLink() throws PlanException, IOException {
        for (PhysicalOperator op : this.plan) {
            if (this.plan.getSoftLinkPredecessors(op) == null) continue;
            for (PhysicalOperator pred : this.plan.getSoftLinkPredecessors(op)) {
                MapReduceOper to;
                MapReduceOper from = this.phyToMROpMap.get(pred);
                if (from == (to = this.phyToMROpMap.get(op)) || this.MRPlan.getPredecessors(to) != null && this.MRPlan.getPredecessors(to).contains(from)) continue;
                this.MRPlan.connect(from, to);
            }
        }
    }

    private void compile(PhysicalOperator op) throws IOException, PlanException, VisitorException {
        MapReduceOper[] prevCompInp = this.compiledInputs;
        List<PhysicalOperator> predecessors = this.plan.getPredecessors(op);
        if (!(op instanceof PONative)) {
            if (predecessors != null && predecessors.size() > 0) {
                if (op instanceof POLoad) {
                    if (predecessors.size() != 1) {
                        int errCode = 2125;
                        String msg = "Expected at most one predecessor of load. Got " + predecessors.size();
                        throw new PlanException(msg, errCode, 4);
                    }
                    PhysicalOperator p = predecessors.get(0);
                    MapReduceOper oper = null;
                    if (!(p instanceof POStore) && !(p instanceof PONative)) {
                        int errCode = 2126;
                        String msg = "Predecessor of load should be a store or mapreduce operator. Got " + p.getClass();
                        throw new PlanException(msg, errCode, 4);
                    }
                    oper = this.phyToMROpMap.get(p);
                    this.curMROp = this.getMROp();
                    this.curMROp.mapPlan.add(op);
                    this.MRPlan.add(this.curMROp);
                    this.plan.disconnect(op, p);
                    this.MRPlan.connect(oper, this.curMROp);
                    this.phyToMROpMap.put(op, this.curMROp);
                    return;
                }
                Collections.sort(predecessors);
                this.compiledInputs = new MapReduceOper[predecessors.size()];
                int i = -1;
                for (PhysicalOperator pred : predecessors) {
                    if (pred instanceof POSplit && this.splitsSeen.containsKey(pred.getOperatorKey())) {
                        this.compiledInputs[++i] = this.startNew(((POSplit)pred).getSplitStore(), this.splitsSeen.get(pred.getOperatorKey()));
                        continue;
                    }
                    this.compile(pred);
                    this.compiledInputs[++i] = this.curMROp;
                }
            } else {
                this.curMROp = this.getMROp();
                this.curMROp.mapPlan.add(op);
                if (op != null && op instanceof POLoad && ((POLoad)op).getLFile() != null && ((POLoad)op).getLFile().getFuncSpec() != null) {
                    this.curMROp.UDFs.add(((POLoad)op).getLFile().getFuncSpec().toString());
                }
                this.MRPlan.add(this.curMROp);
                this.phyToMROpMap.put(op, this.curMROp);
                return;
            }
        }
        op.visit(this);
        if (op.getRequestedParallelism() > this.curMROp.requestedParallelism && !this.curMROp.isSkewedJoin()) {
            this.curMROp.requestedParallelism = op.getRequestedParallelism();
        }
        this.compiledInputs = prevCompInp;
    }

    private MapReduceOper getMROp() {
        return new MapReduceOper(new OperatorKey(this.scope, this.nig.getNextNodeId(this.scope)));
    }

    private NativeMapReduceOper getNativeMROp(String mrJar, String[] parameters) {
        return new NativeMapReduceOper(new OperatorKey(this.scope, this.nig.getNextNodeId(this.scope)), mrJar, parameters);
    }

    private POLoad getLoad() {
        POLoad ld = new POLoad(new OperatorKey(this.scope, this.nig.getNextNodeId(this.scope)));
        ld.setPc(this.pigContext);
        return ld;
    }

    private POStore getStore() {
        POStore st = new POStore(new OperatorKey(this.scope, this.nig.getNextNodeId(this.scope)));
        st.setIsTmpStore(true);
        return st;
    }

    private void nonBlocking(PhysicalOperator op) throws PlanException, IOException {
        if (this.compiledInputs.length == 1) {
            MapReduceOper mro = this.compiledInputs[0];
            if (!mro.isMapDone()) {
                mro.mapPlan.addAsLeaf(op);
            } else if (mro.isMapDone() && !mro.isReduceDone()) {
                mro.reducePlan.addAsLeaf(op);
            } else {
                int errCode = 2022;
                String msg = "Both map and reduce phases have been done. This is unexpected while compiling.";
                throw new PlanException(msg, errCode, 4);
            }
            this.curMROp = mro;
        } else {
            List<MapReduceOper> mergedPlans = this.merge(this.compiledInputs);
            MapReduceOper mro = mergedPlans.remove(0);
            mro.mapPlan.addAsLeaf(op);
            if (mergedPlans.size() > 0) {
                this.connRedOper(mergedPlans, mro);
            }
            this.curMROp = mro;
        }
    }

    private void addToMap(PhysicalOperator op) throws PlanException, IOException {
        if (this.compiledInputs.length == 1) {
            MapReduceOper mro = this.compiledInputs[0];
            if (!mro.isMapDone()) {
                mro.mapPlan.addAsLeaf(op);
            } else if (mro.isMapDone() && !mro.isReduceDone()) {
                FileSpec fSpec = this.getTempFileSpec();
                POStore st = this.getStore();
                st.setSFile(fSpec);
                mro.reducePlan.addAsLeaf(st);
                mro.setReduceDone(true);
                mro = this.startNew(fSpec, mro);
                mro.mapPlan.addAsLeaf(op);
                this.compiledInputs[0] = mro;
            } else {
                int errCode = 2022;
                String msg = "Both map and reduce phases have been done. This is unexpected while compiling.";
                throw new PlanException(msg, errCode, 4);
            }
            this.curMROp = mro;
        } else {
            List<MapReduceOper> mergedPlans = this.merge(this.compiledInputs);
            MapReduceOper mro = mergedPlans.remove(0);
            mro.mapPlan.addAsLeaf(op);
            if (mergedPlans.size() > 0) {
                this.connRedOper(mergedPlans, mro);
            }
            this.curMROp = mro;
        }
    }

    private void blocking(PhysicalOperator op) throws IOException, PlanException {
        if (this.compiledInputs.length == 1) {
            MapReduceOper mro = this.compiledInputs[0];
            if (!mro.isMapDone()) {
                mro.setMapDoneSingle(true);
                this.curMROp = mro;
            } else if (mro.isMapDone() && !mro.isReduceDone()) {
                FileSpec fSpec = this.getTempFileSpec();
                POStore st = this.getStore();
                st.setSFile(fSpec);
                mro.reducePlan.addAsLeaf(st);
                mro.setReduceDone(true);
                this.curMROp = this.startNew(fSpec, mro);
                this.curMROp.setMapDone(true);
            }
        } else {
            List<MapReduceOper> mergedPlans = this.merge(this.compiledInputs);
            MapReduceOper mro = mergedPlans.remove(0);
            if (mergedPlans.size() > 0) {
                mro.setMapDoneMultiple(true);
            } else {
                mro.setMapDoneSingle(true);
            }
            if (mergedPlans.size() > 0) {
                this.connRedOper(mergedPlans, mro);
            }
            this.curMROp = mro;
        }
    }

    private void connRedOper(List<MapReduceOper> mergedPlans, MapReduceOper mro) throws PlanException, IOException {
        PhysicalOperator leaf = null;
        List leaves = mro.mapPlan.getLeaves();
        if (leaves != null && leaves.size() > 0) {
            leaf = (PhysicalOperator)leaves.get(0);
        }
        for (MapReduceOper mmro : mergedPlans) {
            mmro.setReduceDone(true);
            FileSpec fileSpec = this.getTempFileSpec();
            POLoad ld = this.getLoad();
            ld.setLFile(fileSpec);
            POStore str = this.getStore();
            str.setSFile(fileSpec);
            mmro.reducePlan.addAsLeaf(str);
            mro.mapPlan.add(ld);
            if (leaf != null) {
                mro.mapPlan.connect(ld, leaf);
            }
            this.MRPlan.connect(mmro, mro);
        }
    }

    private MapReduceOper endSingleInputPlanWithStr(FileSpec fSpec) throws PlanException {
        if (this.compiledInputs.length > 1) {
            int errCode = 2023;
            String msg = "Received a multi input plan when expecting only a single input one.";
            throw new PlanException(msg, errCode, 4);
        }
        MapReduceOper mro = this.compiledInputs[0];
        POStore str = this.getStore();
        str.setSFile(fSpec);
        if (!mro.isMapDone()) {
            mro.mapPlan.addAsLeaf(str);
            mro.setMapDoneSingle(true);
        } else if (mro.isMapDone() && !mro.isReduceDone()) {
            mro.reducePlan.addAsLeaf(str);
            mro.setReduceDone(true);
        } else {
            int errCode = 2022;
            String msg = "Both map and reduce phases have been done. This is unexpected while compiling.";
            throw new PlanException(msg, errCode, 4);
        }
        return mro;
    }

    private MapReduceOper startNew(FileSpec fSpec, MapReduceOper old) throws PlanException {
        POLoad ld = this.getLoad();
        ld.setLFile(fSpec);
        MapReduceOper ret = this.getMROp();
        ret.mapPlan.add(ld);
        this.MRPlan.add(ret);
        this.MRPlan.connect(old, ret);
        return ret;
    }

    private FileSpec getTempFileSpec() throws IOException {
        return new FileSpec(FileLocalizer.getTemporaryPath(this.pigContext).toString(), new FuncSpec(Utils.getTmpFileCompressorName(this.pigContext)));
    }

    private List<MapReduceOper> merge(MapReduceOper[] compiledInputs) throws PlanException {
        ArrayList<MapReduceOper> ret = new ArrayList<MapReduceOper>();
        MapReduceOper mergedMap = this.getMROp();
        ret.add(mergedMap);
        this.MRPlan.add(mergedMap);
        HashSet<MapReduceOper> toBeConnected = new HashSet<MapReduceOper>();
        ArrayList<MapReduceOper> remLst = new ArrayList<MapReduceOper>();
        ArrayList<PhysicalPlan> mpLst = new ArrayList<PhysicalPlan>();
        for (MapReduceOper mro : compiledInputs) {
            if (!mro.isMapDone()) {
                remLst.add(mro);
                mpLst.add(mro.mapPlan);
                List<MapReduceOper> pmros = this.MRPlan.getPredecessors(mro);
                if (pmros == null) continue;
                for (MapReduceOper pmro : pmros) {
                    toBeConnected.add(pmro);
                }
                continue;
            }
            if (mro.isMapDone() && !mro.isReduceDone()) {
                ret.add(mro);
                continue;
            }
            int errCode = 2027;
            String msg = "Both map and reduce phases have been done. This is unexpected for a merge.";
            throw new PlanException(msg, errCode, 4);
        }
        this.merge(((MapReduceOper)ret.get((int)0)).mapPlan, mpLst);
        Iterator it = toBeConnected.iterator();
        while (it.hasNext()) {
            this.MRPlan.connect((Operator)it.next(), mergedMap);
        }
        for (MapReduceOper rmro : remLst) {
            if (rmro.requestedParallelism > mergedMap.requestedParallelism) {
                mergedMap.requestedParallelism = rmro.requestedParallelism;
            }
            for (String udf : rmro.UDFs) {
                if (mergedMap.UDFs.contains(udf)) continue;
                mergedMap.UDFs.add(udf);
            }
            for (PhysicalOperator physOp : rmro.scalars) {
                if (mergedMap.scalars.contains(physOp)) continue;
                mergedMap.scalars.add(physOp);
            }
            HashSet<PhysicalOperator> opsToChange = new HashSet<PhysicalOperator>();
            for (Map.Entry<PhysicalOperator, MapReduceOper> entry : this.phyToMROpMap.entrySet()) {
                if (entry.getValue() != rmro) continue;
                opsToChange.add(entry.getKey());
            }
            for (PhysicalOperator op : opsToChange) {
                this.phyToMROpMap.put(op, mergedMap);
            }
            this.MRPlan.remove(rmro);
        }
        return ret;
    }

    private <O extends Operator, E extends OperatorPlan<O>> void merge(E finPlan, List<E> plans) throws PlanException {
        for (OperatorPlan e : plans) {
            finPlan.merge(e);
        }
    }

    private void processUDFs(PhysicalPlan plan) throws VisitorException {
        if (plan != null) {
            ScalarPhyFinder scalarPhyFinder = new ScalarPhyFinder(plan);
            scalarPhyFinder.visit();
            this.curMROp.scalars.addAll(scalarPhyFinder.getScalars());
            this.udfFinder.setPlan(plan);
            this.udfFinder.visit();
            this.curMROp.UDFs.addAll(this.udfFinder.getUDFs());
        }
    }

    @Override
    public void visitSplit(POSplit op) throws VisitorException {
        try {
            FileSpec fSpec = op.getSplitStore();
            MapReduceOper mro = this.endSingleInputPlanWithStr(fSpec);
            mro.setSplitter(true);
            this.splitsSeen.put(op.getOperatorKey(), mro);
            this.curMROp = this.startNew(fSpec, mro);
            this.phyToMROpMap.put(op, this.curMROp);
        }
        catch (Exception e) {
            int errCode = 2034;
            String msg = "Error compiling operator " + op.getClass().getSimpleName();
            throw new MRCompilerException(msg, errCode, 4, (Throwable)e);
        }
    }

    @Override
    public void visitLoad(POLoad op) throws VisitorException {
        try {
            this.nonBlocking(op);
            this.phyToMROpMap.put(op, this.curMROp);
        }
        catch (Exception e) {
            int errCode = 2034;
            String msg = "Error compiling operator " + op.getClass().getSimpleName();
            throw new MRCompilerException(msg, errCode, 4, (Throwable)e);
        }
    }

    @Override
    public void visitNative(PONative op) throws VisitorException {
        try {
            NativeMapReduceOper nativeMROper = this.getNativeMROp(op.getNativeMRjar(), op.getParams());
            this.MRPlan.add(nativeMROper);
            this.MRPlan.connect(this.curMROp, nativeMROper);
            this.phyToMROpMap.put(op, nativeMROper);
            this.curMROp = nativeMROper;
        }
        catch (Exception e) {
            int errCode = 2034;
            String msg = "Error compiling operator " + op.getClass().getSimpleName();
            throw new MRCompilerException(msg, errCode, 4, (Throwable)e);
        }
    }

    @Override
    public void visitStore(POStore op) throws VisitorException {
        try {
            this.nonBlocking(op);
            this.phyToMROpMap.put(op, this.curMROp);
            if (op.getSFile() != null && op.getSFile().getFuncSpec() != null) {
                this.curMROp.UDFs.add(op.getSFile().getFuncSpec().toString());
            }
        }
        catch (Exception e) {
            int errCode = 2034;
            String msg = "Error compiling operator " + op.getClass().getSimpleName();
            throw new MRCompilerException(msg, errCode, 4, (Throwable)e);
        }
    }

    @Override
    public void visitFilter(POFilter op) throws VisitorException {
        try {
            this.nonBlocking(op);
            this.processUDFs(op.getPlan());
            this.phyToMROpMap.put(op, this.curMROp);
        }
        catch (Exception e) {
            int errCode = 2034;
            String msg = "Error compiling operator " + op.getClass().getSimpleName();
            throw new MRCompilerException(msg, errCode, 4, (Throwable)e);
        }
    }

    @Override
    public void visitStream(POStream op) throws VisitorException {
        try {
            this.nonBlocking(op);
            this.phyToMROpMap.put(op, this.curMROp);
        }
        catch (Exception e) {
            int errCode = 2034;
            String msg = "Error compiling operator " + op.getClass().getSimpleName();
            throw new MRCompilerException(msg, errCode, 4, (Throwable)e);
        }
    }

    @Override
    public void visitLimit(POLimit op) throws VisitorException {
        try {
            MapReduceOper mro = this.compiledInputs[0];
            mro.limit = op.getLimit();
            if (!mro.isMapDone()) {
                if (!this.pigContext.inIllustrator) {
                    mro.mapPlan.addAsLeaf(op);
                    mro.setMapDone(true);
                }
                if (mro.reducePlan.isEmpty()) {
                    MRUtil.simpleConnectMapToReduce(mro, this.scope, this.nig);
                    mro.requestedParallelism = 1;
                    if (!this.pigContext.inIllustrator) {
                        POLimit pLimit2 = new POLimit(new OperatorKey(this.scope, this.nig.getNextNodeId(this.scope)));
                        pLimit2.setLimit(op.getLimit());
                        mro.reducePlan.addAsLeaf(pLimit2);
                    } else {
                        mro.reducePlan.addAsLeaf(op);
                    }
                } else {
                    this.messageCollector.collect("Something in the reduce plan while map plan is not done. Something wrong!", CompilationMessageCollector.MessageType.Warning, PigWarning.REDUCE_PLAN_NOT_EMPTY_WHILE_MAP_PLAN_UNDER_PROCESS);
                }
            } else if (mro.isMapDone() && !mro.isReduceDone()) {
                mro.reducePlan.addAsLeaf(op);
            } else {
                this.messageCollector.collect("Both map and reduce phases have been done. This is unexpected while compiling!", CompilationMessageCollector.MessageType.Warning, PigWarning.UNREACHABLE_CODE_BOTH_MAP_AND_REDUCE_PLANS_PROCESSED);
            }
            this.phyToMROpMap.put(op, mro);
        }
        catch (Exception e) {
            int errCode = 2034;
            String msg = "Error compiling operator " + op.getClass().getSimpleName();
            throw new MRCompilerException(msg, errCode, 4, (Throwable)e);
        }
    }

    @Override
    public void visitLocalRearrange(POLocalRearrange op) throws VisitorException {
        try {
            this.addToMap(op);
            List<PhysicalPlan> plans = op.getPlans();
            if (plans != null) {
                for (PhysicalPlan ep : plans) {
                    this.processUDFs(ep);
                }
            }
            this.phyToMROpMap.put(op, this.curMROp);
        }
        catch (Exception e) {
            int errCode = 2034;
            String msg = "Error compiling operator " + op.getClass().getSimpleName();
            throw new MRCompilerException(msg, errCode, 4, (Throwable)e);
        }
    }

    @Override
    public void visitCollectedGroup(POCollectedGroup op) throws VisitorException {
        if (!this.curMROp.mapDone) {
            List roots = this.curMROp.mapPlan.getRoots();
            if (roots.size() != 1) {
                int errCode = 2171;
                String errMsg = "Expected one but found more then one root physical operator in physical plan.";
                throw new MRCompilerException(errMsg, errCode, 4);
            }
            PhysicalOperator phyOp = (PhysicalOperator)roots.get(0);
            if (!(phyOp instanceof POLoad)) {
                int errCode = 2172;
                String errMsg = "Expected physical operator at root to be POLoad. Found : " + phyOp.getClass().getCanonicalName();
                throw new MRCompilerException(errMsg, errCode, 4);
            }
            LoadFunc loadFunc = ((POLoad)phyOp).getLoadFunc();
            try {
                if (!CollectableLoadFunc.class.isAssignableFrom(loadFunc.getClass())) {
                    int errCode = 2249;
                    throw new MRCompilerException("While using 'collected' on group; data must be loaded via loader implementing CollectableLoadFunc.", errCode);
                }
                ((CollectableLoadFunc)((Object)loadFunc)).ensureAllKeyInstancesInSameSplit();
            }
            catch (MRCompilerException e) {
                throw e;
            }
            catch (IOException e) {
                int errCode = 2034;
                String msg = "Error compiling operator " + op.getClass().getSimpleName();
                throw new MRCompilerException(msg, errCode, 4, (Throwable)e);
            }
            try {
                this.nonBlocking(op);
                List<PhysicalPlan> plans = op.getPlans();
                if (plans != null) {
                    for (PhysicalPlan ep : plans) {
                        this.processUDFs(ep);
                    }
                }
                this.phyToMROpMap.put(op, this.curMROp);
            }
            catch (Exception e) {
                int errCode = 2034;
                String msg = "Error compiling operator " + op.getClass().getSimpleName();
                throw new MRCompilerException(msg, errCode, 4, (Throwable)e);
            }
        }
        if (!this.curMROp.reduceDone) {
            int errCode = 2250;
            String msg = "Blocking operators are not allowed before Collected Group. Consider dropping using 'collected'.";
            throw new MRCompilerException(msg, errCode, 4);
        }
        int errCode = 2022;
        String msg = "Both map and reduce phases have been done. This is unexpected while compiling.";
        throw new MRCompilerException(msg, errCode, 4);
    }

    @Override
    public void visitPOForEach(POForEach op) throws VisitorException {
        try {
            this.nonBlocking(op);
            List<PhysicalPlan> plans = op.getInputPlans();
            if (plans != null) {
                for (PhysicalPlan plan : plans) {
                    this.processUDFs(plan);
                }
            }
            this.phyToMROpMap.put(op, this.curMROp);
        }
        catch (Exception e) {
            int errCode = 2034;
            String msg = "Error compiling operator " + op.getClass().getSimpleName();
            throw new MRCompilerException(msg, errCode, 4, (Throwable)e);
        }
    }

    @Override
    public void visitGlobalRearrange(POGlobalRearrange op) throws VisitorException {
        try {
            this.blocking(op);
            this.curMROp.customPartitioner = op.getCustomPartitioner();
            this.phyToMROpMap.put(op, this.curMROp);
        }
        catch (Exception e) {
            int errCode = 2034;
            String msg = "Error compiling operator " + op.getClass().getSimpleName();
            throw new MRCompilerException(msg, errCode, 4, (Throwable)e);
        }
    }

    @Override
    public void visitPackage(POPackage op) throws VisitorException {
        try {
            this.nonBlocking(op);
            this.phyToMROpMap.put(op, this.curMROp);
            if (op.getPackageType() == POPackage.PackageType.JOIN) {
                this.curMROp.markRegularJoin();
            } else if (op.getPackageType() == POPackage.PackageType.GROUP) {
                if (op.getNumInps() == 1) {
                    this.curMROp.markGroupBy();
                } else if (op.getNumInps() > 1) {
                    this.curMROp.markCogroup();
                }
            }
        }
        catch (Exception e) {
            int errCode = 2034;
            String msg = "Error compiling operator " + op.getClass().getSimpleName();
            throw new MRCompilerException(msg, errCode, 4, (Throwable)e);
        }
    }

    @Override
    public void visitUnion(POUnion op) throws VisitorException {
        try {
            this.nonBlocking(op);
            this.phyToMROpMap.put(op, this.curMROp);
        }
        catch (Exception e) {
            int errCode = 2034;
            String msg = "Error compiling operator " + op.getClass().getSimpleName();
            throw new MRCompilerException(msg, errCode, 4, (Throwable)e);
        }
    }

    @Override
    public void visitFRJoin(POFRJoin op) throws VisitorException {
        try {
            int i;
            FileSpec[] replFiles = new FileSpec[op.getInputs().size()];
            for (i = 0; i < replFiles.length; ++i) {
                if (i == op.getFragment()) continue;
                replFiles[i] = this.getTempFileSpec();
            }
            op.setReplFiles(replFiles);
            this.curMROp = this.phyToMROpMap.get(op.getInputs().get(op.getFragment()));
            for (i = 0; i < this.compiledInputs.length; ++i) {
                MapReduceOper catMROp;
                FileSpec fSpec;
                POStore tmpSto;
                boolean combinable;
                MapReduceOper mro = this.compiledInputs[i];
                if (this.curMROp.equals(mro)) continue;
                POStore str = this.getStore();
                str.setSFile(replFiles[i]);
                Configuration conf = ConfigurationUtil.toConfiguration(this.pigContext.getProperties());
                boolean bl = combinable = !conf.getBoolean("pig.noSplitCombination", false);
                if (!mro.isMapDone()) {
                    if (combinable && this.hasTooManyInputFiles(mro, conf)) {
                        tmpSto = this.getStore();
                        fSpec = this.getTempFileSpec();
                        tmpSto.setSFile(fSpec);
                        mro.mapPlan.addAsLeaf(tmpSto);
                        mro.setMapDoneSingle(true);
                        catMROp = this.getConcatenateJob(fSpec, mro, str);
                        this.MRPlan.connect(catMROp, this.curMROp);
                        continue;
                    }
                    mro.mapPlan.addAsLeaf(str);
                    mro.setMapDoneSingle(true);
                    this.MRPlan.connect(mro, this.curMROp);
                    continue;
                }
                if (mro.isMapDone() && !mro.isReduceDone()) {
                    if (combinable && mro.requestedParallelism >= this.fileConcatenationThreshold) {
                        tmpSto = this.getStore();
                        fSpec = this.getTempFileSpec();
                        tmpSto.setSFile(fSpec);
                        mro.reducePlan.addAsLeaf(tmpSto);
                        mro.setReduceDone(true);
                        catMROp = this.getConcatenateJob(fSpec, mro, str);
                        this.MRPlan.connect(catMROp, this.curMROp);
                        continue;
                    }
                    mro.reducePlan.addAsLeaf(str);
                    mro.setReduceDone(true);
                    this.MRPlan.connect(mro, this.curMROp);
                    continue;
                }
                int errCode = 2022;
                String msg = "Both map and reduce phases have been done. This is unexpected while compiling.";
                throw new PlanException(msg, errCode, 4);
            }
            if (!this.curMROp.isMapDone()) {
                this.curMROp.mapPlan.addAsLeaf(op);
            } else if (this.curMROp.isMapDone() && !this.curMROp.isReduceDone()) {
                this.curMROp.reducePlan.addAsLeaf(op);
            } else {
                int errCode = 2022;
                String msg = "Both map and reduce phases have been done. This is unexpected while compiling.";
                throw new PlanException(msg, errCode, 4);
            }
            List<List<PhysicalPlan>> joinPlans = op.getJoinPlans();
            if (joinPlans != null) {
                for (List<PhysicalPlan> joinPlan : joinPlans) {
                    if (joinPlan == null) continue;
                    for (PhysicalPlan plan : joinPlan) {
                        this.processUDFs(plan);
                    }
                }
            }
            this.phyToMROpMap.put(op, this.curMROp);
        }
        catch (Exception e) {
            int errCode = 2034;
            String msg = "Error compiling operator " + op.getClass().getSimpleName();
            throw new MRCompilerException(msg, errCode, 4, (Throwable)e);
        }
    }

    private boolean hasTooManyInputFiles(MapReduceOper mro, Configuration conf) {
        if (this.pigContext == null || this.pigContext.getExecType() == ExecType.LOCAL) {
            return false;
        }
        if (mro instanceof NativeMapReduceOper) {
            return !this.optimisticFileConcatenation;
        }
        PhysicalPlan mapPlan = mro.mapPlan;
        List roots = mapPlan.getRoots();
        if (roots == null || roots.size() == 0) {
            return false;
        }
        int numFiles = 0;
        boolean ret = false;
        try {
            block3: for (PhysicalOperator root : roots) {
                String[] locations;
                POLoad ld = (POLoad)root;
                String fileName = ld.getLFile().getFileName();
                if (!UriUtil.isHDFSFile(fileName)) continue;
                for (String location : locations = LoadFunc.getPathStrings(fileName)) {
                    if (!UriUtil.isHDFSFile(location)) continue;
                    Path path = new Path(location);
                    FileSystem fs = path.getFileSystem(conf);
                    if (fs.exists(path)) {
                        LoadFunc loader = (LoadFunc)PigContext.instantiateFuncFromSpec(ld.getLFile().getFuncSpec());
                        Job job = new Job(conf);
                        loader.setLocation(location, job);
                        InputFormat inf = loader.getInputFormat();
                        List splits = inf.getSplits(HadoopShims.cloneJobContext((JobContext)job));
                        List<List<InputSplit>> results = MapRedUtil.getCombinePigSplits(splits, fs.getDefaultBlockSize(), conf);
                        numFiles += results.size();
                        continue;
                    }
                    List<MapReduceOper> preds = this.MRPlan.getPredecessors(mro);
                    if (preds != null && preds.size() == 1) {
                        MapReduceOper pred = preds.get(0);
                        if (!pred.reducePlan.isEmpty()) {
                            numFiles += pred.requestedParallelism;
                            continue;
                        }
                        ret = this.hasTooManyInputFiles(pred, conf);
                        continue block3;
                    }
                    if (this.optimisticFileConcatenation) continue;
                    numFiles = this.fileConcatenationThreshold;
                    continue block3;
                }
            }
        }
        catch (IOException e) {
            LOG.warn((Object)"failed to get number of input files", (Throwable)e);
        }
        catch (InterruptedException e) {
            LOG.warn((Object)"failed to get number of input files", (Throwable)e);
        }
        LOG.info((Object)("number of input files: " + numFiles));
        return ret ? true : numFiles >= this.fileConcatenationThreshold;
    }

    private MapReduceOper getConcatenateJob(FileSpec fSpec, MapReduceOper old, POStore str) throws PlanException, ExecException {
        MapReduceOper mro = this.startNew(fSpec, old);
        mro.mapPlan.addAsLeaf(str);
        mro.setMapDone(true);
        LOG.info((Object)"Insert a file-concatenation job");
        return mro;
    }

    @Override
    public void visitMergeCoGroup(POMergeCogroup poCoGrp) throws VisitorException {
        if (this.compiledInputs.length < 2) {
            int errCode = 2251;
            String errMsg = "Merge Cogroup work on two or more relations.To use map-side group-by on single relation, use 'collected' qualifier.";
            throw new MRCompilerException(errMsg, errCode);
        }
        ArrayList<FuncSpec> funcSpecs = new ArrayList<FuncSpec>(this.compiledInputs.length - 1);
        ArrayList<String> fileSpecs = new ArrayList<String>(this.compiledInputs.length - 1);
        ArrayList<String> loaderSigns = new ArrayList<String>(this.compiledInputs.length - 1);
        try {
            for (int i = 0; i < this.compiledInputs.length; ++i) {
                MapReduceOper mrOper = this.compiledInputs[i];
                PhysicalPlan mapPlan = mrOper.mapPlan;
                if (mapPlan.getRoots().size() != 1) {
                    int errCode = 2171;
                    String errMsg = "Expected one but found more then one root physical operator in physical plan.";
                    throw new MRCompilerException(errMsg, errCode, 4);
                }
                PhysicalOperator rootPOOp = (PhysicalOperator)mapPlan.getRoots().get(0);
                if (!(rootPOOp instanceof POLoad)) {
                    int errCode = 2172;
                    String errMsg = "Expected physical operator at root to be POLoad. Found : " + rootPOOp.getClass().getCanonicalName();
                    throw new MRCompilerException(errMsg, errCode);
                }
                POLoad sideLoader = (POLoad)rootPOOp;
                FileSpec loadFileSpec = sideLoader.getLFile();
                FuncSpec funcSpec = loadFileSpec.getFuncSpec();
                LoadFunc loadfunc = sideLoader.getLoadFunc();
                if (i == 0) {
                    if (!CollectableLoadFunc.class.isAssignableFrom(loadfunc.getClass())) {
                        int errCode = 2252;
                        throw new MRCompilerException("Base loader in Cogroup must implement CollectableLoadFunc.", errCode);
                    }
                    ((CollectableLoadFunc)((Object)loadfunc)).ensureAllKeyInstancesInSameSplit();
                    continue;
                }
                if (!IndexableLoadFunc.class.isAssignableFrom(loadfunc.getClass())) {
                    int errCode = 2253;
                    throw new MRCompilerException("Side loaders in cogroup must implement IndexableLoadFunc.", errCode);
                }
                funcSpecs.add(funcSpec);
                fileSpecs.add(loadFileSpec.getFileName());
                loaderSigns.add(sideLoader.getSignature());
                this.MRPlan.remove(mrOper);
            }
            poCoGrp.setSideLoadFuncs(funcSpecs);
            poCoGrp.setSideFileSpecs(fileSpecs);
            poCoGrp.setLoaderSignatures(loaderSigns);
            MapReduceOper baseMROp = this.phyToMROpMap.get(poCoGrp.getInputs().get(0));
            if (baseMROp.mapDone || !baseMROp.reducePlan.isEmpty()) {
                int errCode = 2254;
                throw new MRCompilerException("Currently merged cogroup is not supported after blocking operators.", errCode);
            }
            MapReduceOper indexerMROp = this.getMROp();
            FileSpec idxFileSpec = this.getIndexingJob(indexerMROp, baseMROp, poCoGrp.getLRInnerPlansOf(0));
            poCoGrp.setIdxFuncSpec(idxFileSpec.getFuncSpec());
            poCoGrp.setIndexFileName(idxFileSpec.getFileName());
            baseMROp.mapPlan.addAsLeaf(poCoGrp);
            for (FuncSpec funcSpec : funcSpecs) {
                baseMROp.UDFs.add(funcSpec.toString());
            }
            this.MRPlan.add(indexerMROp);
            this.MRPlan.connect(indexerMROp, baseMROp);
            this.phyToMROpMap.put(poCoGrp, baseMROp);
            this.curMROp = baseMROp;
        }
        catch (ExecException e) {
            throw new MRCompilerException(e.getDetailedMessage(), e.getErrorCode(), e.getErrorSource(), (Throwable)e);
        }
        catch (MRCompilerException mrce) {
            throw mrce;
        }
        catch (CloneNotSupportedException e) {
            throw new MRCompilerException(e);
        }
        catch (PlanException e) {
            int errCode = 2034;
            String msg = "Error compiling operator " + poCoGrp.getClass().getCanonicalName();
            throw new MRCompilerException(msg, errCode, 4, (Throwable)e);
        }
        catch (IOException e) {
            int errCode = 3000;
            String errMsg = "IOException caught while compiling POMergeCoGroup";
            throw new MRCompilerException(errMsg, errCode, e);
        }
    }

    private FileSpec getIndexingJob(MapReduceOper indexerMROp, MapReduceOper baseMROp, List<PhysicalPlan> mapperLRInnerPlans) throws MRCompilerException, PlanException, ExecException, IOException, CloneNotSupportedException {
        PhysicalPlan phyPlan;
        PhysicalPlan baseMapPlan = baseMROp.mapPlan;
        POLoad baseLoader = (POLoad)baseMapPlan.getRoots().get(0);
        FileSpec origLoaderFileSpec = baseLoader.getLFile();
        FuncSpec funcSpec = origLoaderFileSpec.getFuncSpec();
        LoadFunc loadFunc = baseLoader.getLoadFunc();
        if (!OrderedLoadFunc.class.isAssignableFrom(loadFunc.getClass())) {
            int errCode = 1104;
            String errMsg = "Base relation of merge-coGroup must implement OrderedLoadFunc interface. The specified loader " + funcSpec + " doesn't implement it";
            throw new MRCompilerException(errMsg, errCode);
        }
        String[] indexerArgs = new String[6];
        indexerArgs[0] = funcSpec.toString();
        indexerArgs[1] = ObjectSerializer.serialize((Serializable)((Object)mapperLRInnerPlans));
        indexerArgs[3] = baseLoader.getSignature();
        indexerArgs[4] = baseLoader.getOperatorKey().scope;
        indexerArgs[5] = Boolean.toString(false);
        if (baseMapPlan.getSuccessors(baseLoader) == null || baseMapPlan.getSuccessors(baseLoader).isEmpty()) {
            phyPlan = null;
        } else {
            phyPlan = baseMapPlan.clone();
            PhysicalOperator root = (PhysicalOperator)phyPlan.getRoots().get(0);
            phyPlan.disconnect(root, (Operator)phyPlan.getSuccessors(root).get(0));
            phyPlan.remove(root);
        }
        indexerArgs[2] = ObjectSerializer.serialize(phyPlan);
        POLoad idxJobLoader = this.getLoad();
        idxJobLoader.setLFile(new FileSpec(origLoaderFileSpec.getFileName(), new FuncSpec(MergeJoinIndexer.class.getName(), indexerArgs)));
        indexerMROp.mapPlan.add(idxJobLoader);
        indexerMROp.UDFs.add(baseLoader.getLFile().getFuncSpec().toString());
        MRUtil.simpleConnectMapToReduce(indexerMROp, this.scope, this.nig);
        indexerMROp.requestedParallelism = 1;
        indexerMROp.useTypedComparator(true);
        POStore st = this.getStore();
        FileSpec strFile = this.getTempFileSpec();
        st.setSFile(strFile);
        indexerMROp.reducePlan.addAsLeaf(st);
        indexerMROp.setReduceDone(true);
        return strFile;
    }

    @Override
    public void visitMergeJoin(POMergeJoin joinOp) throws VisitorException {
        try {
            PhysicalPlan rightPipelinePlan;
            if (this.compiledInputs.length != 2 || joinOp.getInputs().size() != 2) {
                int errCode = 1101;
                throw new MRCompilerException("Merge Join must have exactly two inputs. Found : " + this.compiledInputs.length, errCode);
            }
            OperatorKey leftPhyOpKey = joinOp.getInputs().get(0).getOperatorKey();
            OperatorKey rightPhyOpKey = joinOp.getInputs().get(1).getOperatorKey();
            if (((PhysicalOperator)this.compiledInputs[0].mapPlan.getLeaves().get(0)).getOperatorKey().equals(leftPhyOpKey) || ((PhysicalOperator)this.compiledInputs[0].reducePlan.getLeaves().get(0)).getOperatorKey().equals(leftPhyOpKey)) {
                this.curMROp = this.compiledInputs[0];
            } else if (((PhysicalOperator)this.compiledInputs[1].mapPlan.getLeaves().get(0)).getOperatorKey().equals(leftPhyOpKey) || ((PhysicalOperator)this.compiledInputs[1].reducePlan.getLeaves().get(0)).getOperatorKey().equals(leftPhyOpKey)) {
                this.curMROp = this.compiledInputs[1];
            } else {
                int errCode = 2169;
                String errMsg = "Physical operator preceding left predicate not found in compiled MR jobs.";
                throw new MRCompilerException(errMsg, errCode, 4);
            }
            MapReduceOper rightMROpr = null;
            if (((PhysicalOperator)this.compiledInputs[1].mapPlan.getLeaves().get(0)).getOperatorKey().equals(rightPhyOpKey) || ((PhysicalOperator)this.compiledInputs[1].reducePlan.getLeaves().get(0)).getOperatorKey().equals(rightPhyOpKey)) {
                rightMROpr = this.compiledInputs[1];
            } else if (((PhysicalOperator)this.compiledInputs[0].mapPlan.getLeaves().get(0)).getOperatorKey().equals(rightPhyOpKey) || ((PhysicalOperator)this.compiledInputs[0].reducePlan.getLeaves().get(0)).getOperatorKey().equals(rightPhyOpKey)) {
                rightMROpr = this.compiledInputs[0];
            } else {
                int errCode = 2169;
                String errMsg = "Physical operator preceding right predicate not found in compiled MR jobs.";
                throw new MRCompilerException(errMsg, errCode, 4);
            }
            if (this.curMROp == null || rightMROpr == null) {
                int errCode = 2173;
                String errMsg = "One of the preceding compiled MR operator is null. This is not expected.";
                throw new MRCompilerException(errMsg, errCode, 4);
            }
            if (this.curMROp.equals(rightMROpr)) {
                int errCode = 2170;
                String errMsg = "Physical operator preceding both left and right predicate found to be same. This is not expected.";
                throw new MRCompilerException(errMsg, errCode, 4);
            }
            if (!rightMROpr.mapDone) {
                PhysicalPlan rightMapPlan = rightMROpr.mapPlan;
                if (rightMapPlan.getRoots().size() != 1) {
                    int errCode = 2171;
                    String errMsg = "Expected one but found more then one root physical operator in physical plan.";
                    throw new MRCompilerException(errMsg, errCode, 4);
                }
                PhysicalOperator rightLoader = (PhysicalOperator)rightMapPlan.getRoots().get(0);
                if (!(rightLoader instanceof POLoad)) {
                    int errCode = 2172;
                    String errMsg = "Expected physical operator at root to be POLoad. Found : " + rightLoader.getClass().getCanonicalName();
                    throw new MRCompilerException(errMsg, errCode);
                }
                if (rightMapPlan.getSuccessors(rightLoader) == null || rightMapPlan.getSuccessors(rightLoader).isEmpty()) {
                    rightPipelinePlan = null;
                } else {
                    rightPipelinePlan = rightMapPlan.clone();
                    PhysicalOperator root = (PhysicalOperator)rightPipelinePlan.getRoots().get(0);
                    rightPipelinePlan.disconnect(root, (Operator)rightPipelinePlan.getSuccessors(root).get(0));
                    rightPipelinePlan.remove(root);
                    rightMapPlan.trimBelow(rightLoader);
                }
            } else if (!rightMROpr.reduceDone) {
                POStore rightStore = this.getStore();
                FileSpec rightStrFile = this.getTempFileSpec();
                rightStore.setSFile(rightStrFile);
                rightMROpr.setReduceDone(true);
                rightMROpr = this.startNew(rightStrFile, rightMROpr);
                rightPipelinePlan = null;
            } else {
                int errCode = 2022;
                String msg = "Both map and reduce phases have been done. This is unexpected while compiling.";
                throw new PlanException(msg, errCode, 4);
            }
            joinOp.setupRightPipeline(rightPipelinePlan);
            rightMROpr.requestedParallelism = 1;
            POLoad rightLoader = (POLoad)rightMROpr.mapPlan.getRoots().get(0);
            joinOp.setSignature(rightLoader.getSignature());
            LoadFunc rightLoadFunc = rightLoader.getLoadFunc();
            ArrayList<String> udfs = new ArrayList<String>();
            if (IndexableLoadFunc.class.isAssignableFrom(rightLoadFunc.getClass())) {
                joinOp.setRightLoaderFuncSpec(rightLoader.getLFile().getFuncSpec());
                joinOp.setRightInputFileName(rightLoader.getLFile().getFileName());
                udfs.add(rightLoader.getLFile().getFuncSpec().toString());
                this.MRPlan.remove(rightMROpr);
                if (rightMROpr == this.compiledInputs[0]) {
                    this.compiledInputs[0] = null;
                } else if (rightMROpr == this.compiledInputs[1]) {
                    this.compiledInputs[1] = null;
                }
                rightMROpr = null;
                int numInputs = ((PhysicalPlan)this.mPlan).getPredecessors(joinOp).size();
                for (int i = 0; i < numInputs; ++i) {
                    List<PhysicalPlan> keyPlans = joinOp.getInnerPlansOf(i);
                    for (PhysicalPlan keyPlan : keyPlans) {
                        for (PhysicalOperator op : keyPlan) {
                            if (op instanceof POProject) continue;
                            int errCode = 1106;
                            String errMsg = "Merge join is possible only for simple column or '*' join keys when using " + rightLoader.getLFile().getFuncSpec() + " as the loader";
                            throw new MRCompilerException(errMsg, errCode, 2);
                        }
                    }
                }
            } else {
                LoadFunc loadFunc = rightLoader.getLoadFunc();
                if (!OrderedLoadFunc.class.isAssignableFrom(loadFunc.getClass())) {
                    int errCode = 1104;
                    String errMsg = "Right input of merge-join must implement OrderedLoadFunc interface. The specified loader " + loadFunc + " doesn't implement it";
                    throw new MRCompilerException(errMsg, errCode);
                }
                String[] indexerArgs = new String[6];
                List<PhysicalPlan> rightInpPlans = joinOp.getInnerPlansOf(1);
                FileSpec origRightLoaderFileSpec = rightLoader.getLFile();
                indexerArgs[0] = origRightLoaderFileSpec.getFuncSpec().toString();
                indexerArgs[1] = ObjectSerializer.serialize((Serializable)((Object)rightInpPlans));
                indexerArgs[2] = ObjectSerializer.serialize(rightPipelinePlan);
                indexerArgs[3] = rightLoader.getSignature();
                indexerArgs[4] = rightLoader.getOperatorKey().scope;
                indexerArgs[5] = Boolean.toString(true);
                FileSpec lFile = new FileSpec(rightLoader.getLFile().getFileName(), new FuncSpec(MergeJoinIndexer.class.getName(), indexerArgs));
                rightLoader.setLFile(lFile);
                MRUtil.simpleConnectMapToReduce(rightMROpr, this.scope, this.nig);
                rightMROpr.useTypedComparator(true);
                POStore st = this.getStore();
                FileSpec strFile = this.getTempFileSpec();
                st.setSFile(strFile);
                rightMROpr.reducePlan.addAsLeaf(st);
                rightMROpr.setReduceDone(true);
                String[] defaultIndexableLoaderArgs = new String[]{origRightLoaderFileSpec.getFuncSpec().toString(), strFile.getFileName(), strFile.getFuncSpec().toString(), joinOp.getOperatorKey().scope, origRightLoaderFileSpec.getFileName()};
                joinOp.setRightLoaderFuncSpec(new FuncSpec(DefaultIndexableLoader.class.getName(), defaultIndexableLoaderArgs));
                joinOp.setRightInputFileName(origRightLoaderFileSpec.getFileName());
                joinOp.setIndexFile(strFile.getFileName());
                udfs.add(origRightLoaderFileSpec.getFuncSpec().toString());
            }
            if (!this.curMROp.mapDone) {
                this.curMROp.mapPlan.addAsLeaf(joinOp);
            } else if (!this.curMROp.reduceDone) {
                POStore leftStore = this.getStore();
                FileSpec leftStrFile = this.getTempFileSpec();
                leftStore.setSFile(leftStrFile);
                this.curMROp.setReduceDone(true);
                this.curMROp = this.startNew(leftStrFile, this.curMROp);
                this.curMROp.mapPlan.addAsLeaf(joinOp);
            } else {
                int errCode = 2022;
                String msg = "Both map and reduce phases have been done. This is unexpected while compiling.";
                throw new PlanException(msg, errCode, 4);
            }
            if (rightMROpr != null) {
                rightMROpr.markIndexer();
                this.MRPlan.connect(rightMROpr, this.curMROp);
            }
            this.phyToMROpMap.put(joinOp, this.curMROp);
            this.curMROp.noCombineSmallSplits();
            this.curMROp.UDFs.addAll(udfs);
        }
        catch (PlanException e) {
            int errCode = 2034;
            String msg = "Error compiling operator " + joinOp.getClass().getCanonicalName();
            throw new MRCompilerException(msg, errCode, 4, (Throwable)e);
        }
        catch (IOException e) {
            int errCode = 3000;
            String errMsg = "IOException caught while compiling POMergeJoin";
            throw new MRCompilerException(errMsg, errCode, e);
        }
        catch (CloneNotSupportedException e) {
            int errCode = 2127;
            String errMsg = "Cloning exception caught while compiling POMergeJoin";
            throw new MRCompilerException(errMsg, errCode, 4, (Throwable)e);
        }
    }

    @Override
    public void visitDistinct(PODistinct op) throws VisitorException {
        try {
            PhysicalPlan ep = new PhysicalPlan();
            POProject prjStar = new POProject(new OperatorKey(this.scope, this.nig.getNextNodeId(this.scope)));
            prjStar.setResultType((byte)110);
            prjStar.setStar(true);
            ep.add(prjStar);
            ArrayList<PhysicalPlan> eps = new ArrayList<PhysicalPlan>();
            eps.add(ep);
            POLocalRearrange lr = new POLocalRearrange(new OperatorKey(this.scope, this.nig.getNextNodeId(this.scope)));
            lr.setIndex(0);
            lr.setKeyType((byte)110);
            lr.setPlans(eps);
            lr.setResultType((byte)110);
            lr.setDistinct(true);
            this.addToMap(lr);
            this.blocking(op);
            POPackage pkg = new POPackage(new OperatorKey(this.scope, this.nig.getNextNodeId(this.scope)));
            pkg.setKeyType((byte)110);
            pkg.setDistinct(true);
            pkg.setNumInps(1);
            boolean[] inner = new boolean[]{false};
            pkg.setInner(inner);
            this.curMROp.reducePlan.add(pkg);
            ArrayList<PhysicalPlan> eps1 = new ArrayList<PhysicalPlan>();
            ArrayList<Boolean> flat1 = new ArrayList<Boolean>();
            PhysicalPlan ep1 = new PhysicalPlan();
            POProject prj1 = new POProject(new OperatorKey(this.scope, this.nig.getNextNodeId(this.scope)));
            prj1.setResultType((byte)110);
            prj1.setStar(false);
            prj1.setColumn(0);
            prj1.setOverloaded(false);
            ep1.add(prj1);
            eps1.add(ep1);
            flat1.add(true);
            POForEach nfe1 = new POForEach(new OperatorKey(this.scope, this.nig.getNextNodeId(this.scope)), op.getRequestedParallelism(), eps1, flat1);
            nfe1.setResultType((byte)120);
            this.curMROp.reducePlan.addAsLeaf(nfe1);
            this.curMROp.setNeedsDistinctCombiner(true);
            this.phyToMROpMap.put(op, this.curMROp);
            this.curMROp.phyToMRMap.put((PhysicalOperator)op, nfe1);
        }
        catch (Exception e) {
            int errCode = 2034;
            String msg = "Error compiling operator " + op.getClass().getSimpleName();
            throw new MRCompilerException(msg, errCode, 4, (Throwable)e);
        }
    }

    @Override
    public void visitSkewedJoin(POSkewedJoin op) throws VisitorException {
        try {
            if (this.compiledInputs.length != 2) {
                int errCode = 2255;
                throw new VisitorException("POSkewedJoin operator has " + this.compiledInputs.length + " inputs. It should have 2.", errCode);
            }
            FileSpec fSpec = this.getTempFileSpec();
            MapReduceOper mro = this.compiledInputs[0];
            POStore str = this.getStore();
            str.setSFile(fSpec);
            if (!mro.isMapDone()) {
                mro.mapPlan.addAsLeaf(str);
                mro.setMapDoneSingle(true);
            } else if (mro.isMapDone() && !mro.isReduceDone()) {
                mro.reducePlan.addAsLeaf(str);
                mro.setReduceDone(true);
            } else {
                int errCode = 2022;
                String msg = "Both map and reduce phases have been done. This is unexpected while compiling.";
                throw new PlanException(msg, errCode, 4);
            }
            FileSpec partitionFile = this.getTempFileSpec();
            int rp = op.getRequestedParallelism();
            Pair<MapReduceOper, Integer> sampleJobPair = this.getSkewedJoinSampleJob(op, mro, fSpec, partitionFile, rp);
            rp = (Integer)sampleJobPair.second;
            op.setRequestedParallelism(rp);
            MapReduceOper[] joinInputs = new MapReduceOper[]{this.startNew(fSpec, (MapReduceOper)sampleJobPair.first), this.compiledInputs[1]};
            MapReduceOper[] rearrangeOutputs = new MapReduceOper[2];
            this.compiledInputs = new MapReduceOper[]{joinInputs[0]};
            POLocalRearrange lr = new POLocalRearrange(new OperatorKey(this.scope, this.nig.getNextNodeId(this.scope)), rp);
            try {
                lr.setIndex(0);
            }
            catch (ExecException e) {
                int errCode = 2058;
                String msg = "Unable to set index on newly created POLocalRearrange.";
                throw new PlanException(msg, errCode, 4, (Throwable)e);
            }
            List<POSkewedJoin> l = this.plan.getPredecessors(op);
            MultiMap<PhysicalOperator, PhysicalPlan> joinPlans = op.getJoinPlans();
            List<PhysicalPlan> groups = joinPlans.get(l.get(0));
            byte type = 110;
            if (groups.size() == 1) {
                type = ((PhysicalOperator)groups.get(0).getLeaves().get(0)).getResultType();
            }
            lr.setKeyType(type);
            lr.setPlans(groups);
            lr.setResultType((byte)110);
            lr.visit(this);
            if (lr.getRequestedParallelism() > this.curMROp.requestedParallelism) {
                this.curMROp.requestedParallelism = lr.getRequestedParallelism();
            }
            rearrangeOutputs[0] = this.curMROp;
            this.compiledInputs = new MapReduceOper[]{joinInputs[1]};
            if (this.compiledInputs[0].isMapDone() && !this.compiledInputs[0].isReduceDone()) {
                FileSpec f = this.getTempFileSpec();
                POStore s = this.getStore();
                s.setSFile(f);
                this.compiledInputs[0].reducePlan.addAsLeaf(s);
                this.compiledInputs[0].setReduceDone(true);
                this.compiledInputs[0] = this.startNew(f, this.compiledInputs[0]);
            }
            POPartitionRearrange pr = new POPartitionRearrange(new OperatorKey(this.scope, this.nig.getNextNodeId(this.scope)), rp);
            pr.setPigContext(this.pigContext);
            lr = pr;
            try {
                lr.setIndex(1);
            }
            catch (ExecException e) {
                int errCode = 2058;
                String msg = "Unable to set index on newly created POLocalRearrange.";
                throw new PlanException(msg, errCode, 4, (Throwable)e);
            }
            groups = joinPlans.get(l.get(1));
            lr.setPlans(groups);
            lr.setKeyType(type);
            lr.setResultType((byte)120);
            lr.visit(this);
            if (lr.getRequestedParallelism() > this.curMROp.requestedParallelism) {
                this.curMROp.requestedParallelism = lr.getRequestedParallelism();
            }
            rearrangeOutputs[1] = this.curMROp;
            this.compiledInputs = rearrangeOutputs;
            POGlobalRearrange gr = new POGlobalRearrange(new OperatorKey(this.scope, this.nig.getNextNodeId(this.scope)), rp);
            gr.setResultType((byte)110);
            gr.visit(this);
            if (gr.getRequestedParallelism() > this.curMROp.requestedParallelism) {
                this.curMROp.requestedParallelism = gr.getRequestedParallelism();
            }
            this.compiledInputs = new MapReduceOper[]{this.curMROp};
            POPackage pkg = new POPackage(new OperatorKey(this.scope, this.nig.getNextNodeId(this.scope)), rp);
            pkg.setKeyType(type);
            pkg.setResultType((byte)110);
            pkg.setNumInps(2);
            boolean[] inner = op.getInnerFlags();
            pkg.setInner(inner);
            pkg.visit(this);
            this.compiledInputs = new MapReduceOper[]{this.curMROp};
            ArrayList<PhysicalPlan> eps = new ArrayList<PhysicalPlan>();
            ArrayList<Boolean> flat = new ArrayList<Boolean>();
            for (int i = 0; i < 2; ++i) {
                PhysicalPlan ep = new PhysicalPlan();
                POProject prj = new POProject(new OperatorKey(this.scope, this.nig.getNextNodeId(this.scope)));
                prj.setColumn(i + 1);
                prj.setOverloaded(false);
                prj.setResultType((byte)120);
                ep.add(prj);
                eps.add(ep);
                if (!inner[i]) {
                    CompilerUtils.addEmptyBagOuterJoin(ep, op.getSchema(i));
                }
                flat.add(true);
            }
            POForEach fe = new POForEach(new OperatorKey(this.scope, this.nig.getNextNodeId(this.scope)), -1, eps, flat);
            fe.setResultType((byte)110);
            fe.visit(this);
            this.curMROp.setSkewedJoinPartitionFile(partitionFile.getFileName());
            this.phyToMROpMap.put(op, this.curMROp);
        }
        catch (PlanException e) {
            int errCode = 2034;
            String msg = "Error compiling operator " + op.getClass().getSimpleName();
            throw new MRCompilerException(msg, errCode, 4, (Throwable)e);
        }
        catch (IOException e) {
            int errCode = 2034;
            String msg = "Error compiling operator " + op.getClass().getSimpleName();
            throw new MRCompilerException(msg, errCode, 4, (Throwable)e);
        }
    }

    @Override
    public void visitSort(POSort op) throws VisitorException {
        try {
            FileSpec fSpec = this.getTempFileSpec();
            MapReduceOper mro = this.endSingleInputPlanWithStr(fSpec);
            FileSpec quantFile = this.getTempFileSpec();
            int rp = op.getRequestedParallelism();
            Pair<POProject, Byte>[] fields = this.getSortCols(op.getSortPlans());
            Pair<MapReduceOper, Integer> quantJobParallelismPair = this.getQuantileJob(op, mro, fSpec, quantFile, rp);
            this.curMROp = this.getSortJob(op, (MapReduceOper)quantJobParallelismPair.first, fSpec, quantFile, (Integer)quantJobParallelismPair.second, fields);
            if (op.isUDFComparatorUsed) {
                this.curMROp.UDFs.add(op.getMSortFunc().getFuncSpec().toString());
                this.curMROp.isUDFComparatorUsed = true;
            }
            this.phyToMROpMap.put(op, this.curMROp);
        }
        catch (Exception e) {
            int errCode = 2034;
            String msg = "Error compiling operator " + op.getClass().getSimpleName();
            throw new MRCompilerException(msg, errCode, 4, (Throwable)e);
        }
    }

    private Pair<POProject, Byte>[] getSortCols(List<PhysicalPlan> plans) throws PlanException, ExecException {
        if (plans != null) {
            Pair[] ret = new Pair[plans.size()];
            int i = -1;
            for (PhysicalPlan plan : plans) {
                POProject proj;
                PhysicalOperator op = (PhysicalOperator)plan.getLeaves().get(0);
                if (op instanceof POProject) {
                    if (((POProject)op).isStar()) {
                        return null;
                    }
                    proj = (POProject)op;
                } else {
                    proj = null;
                }
                byte type = op.getResultType();
                ret[++i] = new Pair<POProject, Byte>(proj, type);
            }
            return ret;
        }
        int errCode = 2026;
        String msg = "No expression plan found in POSort.";
        throw new PlanException(msg, errCode, 4);
    }

    private MapReduceOper getSortJob(POSort sort, MapReduceOper quantJob, FileSpec lFile, FileSpec quantFile, int rp, Pair<POProject, Byte>[] fields) throws PlanException {
        long limit;
        MapReduceOper mro = this.startNew(lFile, quantJob);
        mro.setQuantFile(quantFile.getFileName());
        mro.setGlobalSort(true);
        mro.requestedParallelism = rp;
        mro.limit = limit = sort.getLimit();
        ArrayList<PhysicalPlan> eps1 = new ArrayList<PhysicalPlan>();
        byte keyType = 0;
        List<Boolean> sortOrderList = sort.getMAscCols();
        if (sortOrderList != null) {
            boolean[] sortOrder = new boolean[sortOrderList.size()];
            for (int i = 0; i < sortOrderList.size(); ++i) {
                sortOrder[i] = sortOrderList.get(i);
            }
            mro.setSortOrder(sortOrder);
        }
        if (fields == null) {
            PhysicalPlan ep = new PhysicalPlan();
            POProject prj = new POProject(new OperatorKey(this.scope, this.nig.getNextNodeId(this.scope)));
            prj.setStar(true);
            prj.setOverloaded(false);
            prj.setResultType((byte)110);
            ep.add(prj);
            eps1.add(ep);
        } else {
            eps1.addAll(sort.getSortPlans());
            try {
                FindKeyTypeVisitor fktv = new FindKeyTypeVisitor(sort.getSortPlans().get(0));
                fktv.visit();
                keyType = fktv.keyType;
            }
            catch (VisitorException ve) {
                int errCode = 2035;
                String msg = "Internal error. Could not compute key type of sort operator.";
                throw new PlanException(msg, errCode, 4, (Throwable)ve);
            }
        }
        POLocalRearrange lr = new POLocalRearrange(new OperatorKey(this.scope, this.nig.getNextNodeId(this.scope)));
        try {
            lr.setIndex(0);
        }
        catch (ExecException e) {
            int errCode = 2058;
            String msg = "Unable to set index on newly created POLocalRearrange.";
            throw new PlanException(msg, errCode, 4, (Throwable)e);
        }
        lr.setKeyType(fields == null || fields.length > 1 ? (byte)110 : keyType);
        lr.setPlans(eps1);
        lr.setResultType((byte)110);
        lr.setAlias(sort.getAlias());
        mro.mapPlan.addAsLeaf(lr);
        mro.setMapDone(true);
        if (limit != -1L) {
            POPackageLite pkg_c = new POPackageLite(new OperatorKey(this.scope, this.nig.getNextNodeId(this.scope)));
            pkg_c.setKeyType(fields.length > 1 ? (byte)110 : (byte)keyType);
            pkg_c.setNumInps(1);
            mro.combinePlan.add(pkg_c);
            ArrayList<PhysicalPlan> eps_c1 = new ArrayList<PhysicalPlan>();
            ArrayList<Boolean> flat_c1 = new ArrayList<Boolean>();
            PhysicalPlan ep_c1 = new PhysicalPlan();
            POProject prj_c1 = new POProject(new OperatorKey(this.scope, this.nig.getNextNodeId(this.scope)));
            prj_c1.setColumn(1);
            prj_c1.setOverloaded(false);
            prj_c1.setResultType((byte)120);
            ep_c1.add(prj_c1);
            eps_c1.add(ep_c1);
            flat_c1.add(true);
            POForEach fe_c1 = new POForEach(new OperatorKey(this.scope, this.nig.getNextNodeId(this.scope)), -1, eps_c1, flat_c1);
            fe_c1.setResultType((byte)110);
            mro.combinePlan.addAsLeaf(fe_c1);
            POLimit pLimit = new POLimit(new OperatorKey(this.scope, this.nig.getNextNodeId(this.scope)));
            pLimit.setLimit(limit);
            mro.combinePlan.addAsLeaf(pLimit);
            ArrayList<PhysicalPlan> eps_c2 = new ArrayList<PhysicalPlan>();
            eps_c2.addAll(sort.getSortPlans());
            POLocalRearrange lr_c2 = new POLocalRearrange(new OperatorKey(this.scope, this.nig.getNextNodeId(this.scope)));
            try {
                lr_c2.setIndex(0);
            }
            catch (ExecException e) {
                int errCode = 2058;
                String msg = "Unable to set index on newly created POLocalRearrange.";
                throw new PlanException(msg, errCode, 4, (Throwable)e);
            }
            lr_c2.setKeyType(fields.length > 1 ? (byte)110 : (byte)keyType);
            lr_c2.setPlans(eps_c2);
            lr_c2.setResultType((byte)110);
            mro.combinePlan.addAsLeaf(lr_c2);
        }
        POPackageLite pkg = new POPackageLite(new OperatorKey(this.scope, this.nig.getNextNodeId(this.scope)));
        pkg.setKeyType(fields == null || fields.length > 1 ? (byte)110 : keyType);
        pkg.setNumInps(1);
        mro.reducePlan.add(pkg);
        PhysicalPlan ep = new PhysicalPlan();
        POProject prj = new POProject(new OperatorKey(this.scope, this.nig.getNextNodeId(this.scope)));
        prj.setColumn(1);
        prj.setOverloaded(false);
        prj.setResultType((byte)120);
        ep.add(prj);
        ArrayList<PhysicalPlan> eps2 = new ArrayList<PhysicalPlan>();
        eps2.add(ep);
        ArrayList<Boolean> flattened = new ArrayList<Boolean>();
        flattened.add(true);
        POForEach nfe1 = new POForEach(new OperatorKey(this.scope, this.nig.getNextNodeId(this.scope)), -1, eps2, flattened);
        mro.reducePlan.add(nfe1);
        mro.reducePlan.connect(pkg, nfe1);
        mro.phyToMRMap.put((PhysicalOperator)sort, nfe1);
        if (limit != -1L) {
            POLimit pLimit2 = new POLimit(new OperatorKey(this.scope, this.nig.getNextNodeId(this.scope)));
            pLimit2.setLimit(limit);
            mro.reducePlan.addAsLeaf(pLimit2);
            mro.phyToMRMap.put((PhysicalOperator)sort, pLimit2);
        }
        return mro;
    }

    private Pair<MapReduceOper, Integer> getQuantileJob(POSort inpSort, MapReduceOper prevJob, FileSpec lFile, FileSpec quantFile, int rp) throws PlanException, VisitorException {
        POSort sort = new POSort(inpSort.getOperatorKey(), inpSort.getRequestedParallelism(), null, inpSort.getSortPlans(), inpSort.getMAscCols(), inpSort.getMSortFunc());
        sort.setAlias(inpSort.getAlias());
        List<Boolean> ascCols = inpSort.getMAscCols();
        String[] ascs = new String[ascCols.size()];
        for (int i = 0; i < ascCols.size(); ++i) {
            ascs[i] = ascCols.get(i).toString();
        }
        String[] ctorArgs = ascs;
        if (sort.isUDFComparatorUsed) {
            String userComparatorFuncSpec = sort.getMSortFunc().getFuncSpec().toString();
            ctorArgs = new String[ascs.length + 1];
            ctorArgs[0] = USER_COMPARATOR_MARKER + userComparatorFuncSpec;
            for (int j = 0; j < ascs.length; ++j) {
                ctorArgs[j + 1] = ascs[j];
            }
        }
        return this.getSamplingJob(sort, prevJob, null, lFile, quantFile, rp, null, FindQuantiles.class.getName(), ctorArgs, RandomSampleLoader.class.getName());
    }

    private Pair<MapReduceOper, Integer> getSkewedJoinSampleJob(POSkewedJoin op, MapReduceOper prevJob, FileSpec lFile, FileSpec sampleFile, int rp) throws PlanException, VisitorException {
        MultiMap<PhysicalOperator, PhysicalPlan> joinPlans = op.getJoinPlans();
        List<POSkewedJoin> l = this.plan.getPredecessors(op);
        List<PhysicalPlan> groups = joinPlans.get(l.get(0));
        ArrayList<Boolean> ascCol = new ArrayList<Boolean>();
        for (int i = 0; i < groups.size(); ++i) {
            ascCol.add(false);
        }
        POSort sort = new POSort(op.getOperatorKey(), op.getRequestedParallelism(), null, groups, ascCol, null);
        ArrayList<PhysicalPlan> transformPlans = new ArrayList<PhysicalPlan>();
        transformPlans.addAll(groups);
        POProject prjStar = new POProject(new OperatorKey(this.scope, this.nig.getNextNodeId(this.scope)));
        prjStar.setResultType((byte)110);
        prjStar.setStar(true);
        ArrayList<PhysicalOperator> ufInps = new ArrayList<PhysicalOperator>();
        ufInps.add(prjStar);
        PhysicalPlan ep = new PhysicalPlan();
        POUserFunc uf = new POUserFunc(new OperatorKey(this.scope, this.nig.getNextNodeId(this.scope)), -1, ufInps, new FuncSpec(GetMemNumRows.class.getName(), (String[])null));
        uf.setResultType((byte)110);
        ep.add(uf);
        ep.add(prjStar);
        ep.connect(prjStar, uf);
        transformPlans.add(ep);
        try {
            String per = this.pigContext.getProperties().getProperty("pig.skewedjoin.reduce.memusage", String.valueOf(0.3f));
            String mc = this.pigContext.getProperties().getProperty("pig.skewedjoin.reduce.maxtuple", "0");
            String inputFile = lFile.getFileName();
            return this.getSamplingJob(sort, prevJob, transformPlans, lFile, sampleFile, rp, null, PartitionSkewedKeys.class.getName(), new String[]{per, mc, inputFile}, PoissonSampleLoader.class.getName());
        }
        catch (Exception e) {
            throw new PlanException(e);
        }
    }

    /*
     * Unable to fully structure code
     */
    private Pair<MapReduceOper, Integer> getSamplingJob(POSort sort, MapReduceOper prevJob, List<PhysicalPlan> transformPlans, FileSpec lFile, FileSpec sampleFile, int rp, List<PhysicalPlan> sortKeyPlans, String udfClassName, String[] udfArgs, String sampleLdrClassName) throws PlanException, VisitorException {
        rslargs = new String[]{new FuncSpec(Utils.getTmpFileCompressorName(this.pigContext)).toString(), "100"};
        quantLdFilName = new FileSpec(lFile.getFileName(), new FuncSpec(sampleLdrClassName, rslargs));
        mro = this.startNew(quantLdFilName, prevJob);
        if (sort.isUDFComparatorUsed) {
            mro.UDFs.add(sort.getMSortFunc().getFuncSpec().toString());
            this.curMROp.isUDFComparatorUsed = true;
        }
        flat1 = new ArrayList<Boolean>();
        eps1 = new ArrayList<PhysicalPlan>();
        if (transformPlans == null) {
            sortProjs = null;
            try {
                sortProjs = this.getSortCols(sort.getSortPlans());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            if (sortProjs == null) {
                ep = new PhysicalPlan();
                prj = new POProject(new OperatorKey(this.scope, this.nig.getNextNodeId(this.scope)));
                prj.setStar(true);
                prj.setOverloaded(false);
                prj.setResultType((byte)110);
                ep.add(prj);
                eps1.add(ep);
                flat1.add(true);
            } else {
                for (Pair<POProject, Byte> sortProj : sortProjs) {
                    if (sortProj == null) {
                        errCode = 2174;
                        msg = "Internal exception. Could not create a sampler job";
                        throw new MRCompilerException(msg, errCode, 4);
                    }
                    ep = new PhysicalPlan();
                    try {
                        prj = ((POProject)sortProj.first).clone();
                    }
                    catch (CloneNotSupportedException e) {
                        throw new AssertionError((Object)("Error cloning project caught exception" + e));
                    }
                    ep.add(prj);
                    eps1.add(ep);
                    flat1.add(true);
                }
            }
        } else {
            for (i = 0; i < transformPlans.size(); ++i) {
                eps1.add(transformPlans.get(i));
                flat1.add(true);
            }
        }
        nfe1 = new POForEach(new OperatorKey(this.scope, this.nig.getNextNodeId(this.scope)), -1, eps1, flat1);
        mro.mapPlan.addAsLeaf(nfe1);
        ep1 = new PhysicalPlan();
        ce = new ConstantExpression(new OperatorKey(this.scope, this.nig.getNextNodeId(this.scope)));
        ce.setValue("all");
        ce.setResultType((byte)55);
        ep1.add(ce);
        eps = new ArrayList<PhysicalPlan>();
        eps.add(ep1);
        lr = new POLocalRearrange(new OperatorKey(this.scope, this.nig.getNextNodeId(this.scope)));
        try {
            lr.setIndex(0);
        }
        catch (ExecException e) {
            errCode = 2058;
            msg = "Unable to set index on newly created POLocalRearrange.";
            throw new PlanException(msg, errCode, 4, (Throwable)e);
        }
        lr.setKeyType((byte)55);
        lr.setPlans(eps);
        lr.setResultType((byte)110);
        lr.setAlias(sort.getAlias());
        mro.mapPlan.add(lr);
        mro.mapPlan.connect(nfe1, lr);
        mro.setMapDone(true);
        pkg = new POPackage(new OperatorKey(this.scope, this.nig.getNextNodeId(this.scope)));
        pkg.setKeyType((byte)55);
        pkg.setNumInps(1);
        inner = new boolean[]{false};
        pkg.setInner(inner);
        mro.reducePlan.add(pkg);
        fe2Plan = new PhysicalPlan();
        topPrj = new POProject(new OperatorKey(this.scope, this.nig.getNextNodeId(this.scope)));
        topPrj.setColumn(1);
        topPrj.setResultType((byte)120);
        topPrj.setOverloaded(true);
        fe2Plan.add(topPrj);
        nesSortPlanLst = new ArrayList<PhysicalPlan>();
        if (sortKeyPlans != null) {
            for (i = 0; i < sortKeyPlans.size(); ++i) {
                nesSortPlanLst.add(sortKeyPlans.get(i));
            }
        } else {
            sortProjs = null;
            try {
                sortProjs = this.getSortCols(sort.getSortPlans());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            if (sortProjs == null) {
                ep = new PhysicalPlan();
                prj = new POProject(new OperatorKey(this.scope, this.nig.getNextNodeId(this.scope)));
                prj.setStar(true);
                prj.setOverloaded(false);
                prj.setResultType((byte)110);
                ep.add(prj);
                nesSortPlanLst.add(ep);
            } else {
                for (i = 0; i < sortProjs.length; ++i) {
                    prj = new POProject(new OperatorKey(this.scope, this.nig.getNextNodeId(this.scope)));
                    prj.setResultType((Byte)sortProjs[i].second);
                    if (sortProjs[i].first != null && ((POProject)sortProjs[i].first).isProjectToEnd()) {
                        if (i != sortProjs.length - 1) {
                            throw new AssertionError((Object)"Project-range to end (x..) is supported in order-by only as last sort column");
                        }
                        prj.setProjectToEnd(i);
                        break;
                    }
                    prj.setColumn(i);
                    prj.setOverloaded(false);
                    ep = new PhysicalPlan();
                    ep.add(prj);
                    nesSortPlanLst.add(ep);
                }
            }
        }
        sort.setSortPlans(nesSortPlanLst);
        sort.setResultType((byte)120);
        fe2Plan.add(sort);
        fe2Plan.connect(topPrj, sort);
        rpep = new PhysicalPlan();
        rpce = new ConstantExpression(new OperatorKey(this.scope, this.nig.getNextNodeId(this.scope)));
        rpce.setRequestedParallelism(rp);
        val = rp;
        if (val <= 0) {
            eng = this.pigContext.getExecutionEngine();
            if (this.pigContext.getExecType() != ExecType.LOCAL) {
                try {
                    if (val <= 0) {
                        val = this.pigContext.defaultParallel;
                    }
                    if (val <= 0) {
                        val = eng.getJobConf().getNumReduceTasks();
                    }
                    if (val > 0) ** GOTO lbl153
                    val = 1;
                }
                catch (Exception e) {
                    errCode = 6015;
                    msg = "Problem getting the default number of reduces from the Job Client.";
                    throw new MRCompilerException(msg, errCode, 16, (Throwable)e);
                }
            } else {
                val = 1;
            }
        }
lbl153:
        // 5 sources

        parallelismForSort = rp <= 0 ? val : rp;
        rpce.setValue(parallelismForSort);
        rpce.setResultType((byte)10);
        rpep.add(rpce);
        genEps = new ArrayList<PhysicalPlan>();
        genEps.add(rpep);
        genEps.add(fe2Plan);
        flattened2 = new ArrayList<Boolean>();
        flattened2.add(false);
        flattened2.add(false);
        nfe2 = new POForEach(new OperatorKey(this.scope, this.nig.getNextNodeId(this.scope)), -1, genEps, flattened2);
        mro.reducePlan.add(nfe2);
        mro.reducePlan.connect(pkg, nfe2);
        ep4 = new PhysicalPlan();
        prjStar4 = new POProject(new OperatorKey(this.scope, this.nig.getNextNodeId(this.scope)));
        prjStar4.setResultType((byte)110);
        prjStar4.setStar(true);
        ep4.add(prjStar4);
        ufInps = new ArrayList<PhysicalOperator>();
        ufInps.add(prjStar4);
        uf = new POUserFunc(new OperatorKey(this.scope, this.nig.getNextNodeId(this.scope)), -1, ufInps, new FuncSpec(udfClassName, udfArgs));
        ep4.add(uf);
        ep4.connect(prjStar4, uf);
        ep4s = new ArrayList<PhysicalPlan>();
        ep4s.add(ep4);
        flattened3 = new ArrayList<Boolean>();
        flattened3.add(false);
        nfe3 = new POForEach(new OperatorKey(this.scope, this.nig.getNextNodeId(this.scope)), -1, ep4s, flattened3);
        mro.reducePlan.add(nfe3);
        mro.reducePlan.connect(nfe2, nfe3);
        str = this.getStore();
        str.setSFile(sampleFile);
        mro.reducePlan.add(str);
        mro.reducePlan.connect(nfe3, str);
        mro.setReduceDone(true);
        mro.requestedParallelism = 1;
        mro.markSampler();
        return new Pair<MapReduceOper, Integer>(mro, parallelismForSort);
    }

    private static class FindStoreNameVisitor
    extends PhyPlanVisitor {
        FileSpec newSpec;
        FileSpec oldSpec;

        FindStoreNameVisitor(PhysicalPlan plan, FileSpec newSpec, FileSpec oldSpec) {
            super(plan, (PlanWalker<PhysicalOperator, PhysicalPlan>)new DepthFirstWalker<PhysicalOperator, PhysicalPlan>(plan));
            this.newSpec = newSpec;
            this.oldSpec = oldSpec;
        }

        @Override
        public void visitStore(POStore sto) throws VisitorException {
            FileSpec spec = sto.getSFile();
            if (this.oldSpec.equals(spec)) {
                sto.setSFile(this.newSpec);
            }
        }
    }

    private static class FindKeyTypeVisitor
    extends PhyPlanVisitor {
        byte keyType = 0;

        FindKeyTypeVisitor(PhysicalPlan plan) {
            super(plan, (PlanWalker<PhysicalOperator, PhysicalPlan>)new DepthFirstWalker<PhysicalOperator, PhysicalPlan>(plan));
        }

        @Override
        public void visitProject(POProject p) throws VisitorException {
            this.keyType = p.getResultType();
        }
    }

    static class LastInputStreamingOptimizer
    extends MROpPlanVisitor {
        String chunkSize;

        LastInputStreamingOptimizer(MROperPlan plan, String chunkSize) {
            super(plan, (PlanWalker<MapReduceOper, MROperPlan>)new DepthFirstWalker<MapReduceOper, MROperPlan>(plan));
            this.chunkSize = chunkSize;
        }

        @Override
        public void visitMROp(MapReduceOper mr) throws VisitorException {
            if (mr.mapPlan.isEmpty()) {
                return;
            }
            if (mr.reducePlan.isEmpty()) {
                return;
            }
            if (!mr.combinePlan.isEmpty()) {
                return;
            }
            List mpLeaves = mr.mapPlan.getLeaves();
            if (mpLeaves.size() != 1) {
                return;
            }
            PhysicalOperator op = (PhysicalOperator)mpLeaves.get(0);
            if (!(op instanceof POUnion)) {
                return;
            }
            List mrRoots = mr.reducePlan.getRoots();
            if (mrRoots.size() != 1) {
                return;
            }
            op = (PhysicalOperator)mrRoots.get(0);
            if (!(op instanceof POPackage)) {
                return;
            }
            POPackage pack = (POPackage)op;
            List<POPackage> sucs = mr.reducePlan.getSuccessors(pack);
            if (sucs == null || sucs.size() != 1) {
                return;
            }
            op = sucs.get(0);
            boolean lastInputFlattened = true;
            boolean allSimple = true;
            if (op instanceof POForEach) {
                POForEach forEach = (POForEach)op;
                List<PhysicalPlan> planList = forEach.getInputPlans();
                List<Boolean> flatten = forEach.getToBeFlattened();
                POProject projOfLastInput = null;
                int i = 0;
                for (PhysicalPlan p : planList) {
                    PhysicalOperator succ;
                    PhysicalOperator opProj = (PhysicalOperator)p.getRoots().get(0);
                    if (!(opProj instanceof POProject)) {
                        allSimple = false;
                        break;
                    }
                    POProject proj = (POProject)opProj;
                    if (proj.isProjectToEnd() || proj.getColumns().size() != 1) {
                        allSimple = false;
                        break;
                    }
                    try {
                        if (proj.getColumn() == pack.getNumInps()) {
                            if (projOfLastInput != null) {
                                allSimple = false;
                                break;
                            }
                            projOfLastInput = proj;
                            if (!flatten.get(i).booleanValue() || proj.getResultType() != 120) {
                                lastInputFlattened = false;
                                break;
                            }
                        }
                    }
                    catch (ExecException e) {
                        int errCode = 2069;
                        String msg = "Error during map reduce compilation. Problem in accessing column from project operator.";
                        throw new MRCompilerException(msg, errCode, 4, (Throwable)e);
                    }
                    PhysicalOperator physicalOperator = succ = p.getSuccessors(proj) != null ? (PhysicalOperator)p.getSuccessors(proj).get(0) : null;
                    while (succ != null) {
                        if (!(succ instanceof POProject)) {
                            allSimple = false;
                            break;
                        }
                        if (proj == projOfLastInput && ((POProject)succ).getResultType() != 120) {
                            allSimple = false;
                            break;
                        }
                        succ = p.getSuccessors(succ) != null ? p.getSuccessors(succ).get(0) : null;
                    }
                    ++i;
                    if (allSimple) continue;
                    break;
                }
                if (lastInputFlattened && allSimple && projOfLastInput != null) {
                    LastInputStreamingOptimizer.replaceWithPOJoinPackage(mr.reducePlan, mr, pack, forEach, this.chunkSize);
                }
            }
        }

        public static void replaceWithPOJoinPackage(PhysicalPlan plan, MapReduceOper mr, POPackage pack, POForEach forEach, String chunkSize) throws VisitorException {
            String scope = pack.getOperatorKey().scope;
            NodeIdGenerator nig = NodeIdGenerator.getGenerator();
            POJoinPackage joinPackage = new POJoinPackage(new OperatorKey(scope, nig.getNextNodeId(scope)), -1, pack, forEach);
            joinPackage.setChunkSize(Long.parseLong(chunkSize));
            List<POForEach> succs = plan.getSuccessors(forEach);
            if (succs != null && succs.size() != 1) {
                int errCode = 2028;
                String msg = "ForEach can only have one successor. Found " + succs.size() + " successors.";
                throw new MRCompilerException(msg, errCode, 4);
            }
            plan.remove(pack);
            try {
                plan.replace(forEach, joinPackage);
            }
            catch (PlanException e) {
                int errCode = 2029;
                String msg = "Error rewriting POJoinPackage.";
                throw new MRCompilerException(msg, errCode, 4, (Throwable)e);
            }
            mr.phyToMRMap.put((PhysicalOperator)forEach, joinPackage);
            LogFactory.getLog(LastInputStreamingOptimizer.class).info((Object)"Rewrite: POPackage->POForEach to POJoinPackage");
        }
    }
}

