/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.physicalLayer;

import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.PigLogger;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.PigProgressable;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.Result;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhyPlanVisitor;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhysicalPlan;
import org.apache.pig.data.BagFactory;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.DataType;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.plan.Operator;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.plan.VisitorException;
import org.apache.pig.pen.Illustrable;
import org.apache.pig.pen.Illustrator;
import org.apache.pig.pen.util.LineageTracer;

public abstract class PhysicalOperator
extends Operator<PhyPlanVisitor>
implements Illustrable,
Cloneable {
    private static final Log log = LogFactory.getLog(PhysicalOperator.class);
    protected static final long serialVersionUID = 1L;
    protected int requestedParallelism;
    protected List<PhysicalOperator> inputs;
    protected List<PhysicalOperator> outputs;
    protected byte resultType = (byte)110;
    protected PhysicalPlan parentPlan;
    protected boolean inputAttached = false;
    protected Tuple input = null;
    protected Result res = null;
    protected String alias = null;
    public static PigProgressable reporter;
    protected static PigLogger pigLogger;
    protected static final DataByteArray dummyDBA;
    protected static final String dummyString;
    protected static final Double dummyDouble;
    protected static final Float dummyFloat;
    protected static final Integer dummyInt;
    protected static final Long dummyLong;
    protected static final Boolean dummyBool;
    protected static final Tuple dummyTuple;
    protected static final DataBag dummyBag;
    protected static final Map dummyMap;
    protected LineageTracer lineageTracer;
    protected transient Illustrator illustrator = null;
    private boolean accum;
    private transient boolean accumStart;

    public PhysicalOperator(OperatorKey k) {
        this(k, -1, null);
    }

    public PhysicalOperator(OperatorKey k, int rp) {
        this(k, rp, null);
    }

    public PhysicalOperator(OperatorKey k, List<PhysicalOperator> inp) {
        this(k, -1, inp);
    }

    public PhysicalOperator(OperatorKey k, int rp, List<PhysicalOperator> inp) {
        super(k);
        this.requestedParallelism = rp;
        this.inputs = inp;
        this.res = new Result();
    }

    @Override
    public void setIllustrator(Illustrator illustrator) {
        this.illustrator = illustrator;
    }

    public Illustrator getIllustrator() {
        return this.illustrator;
    }

    public int getRequestedParallelism() {
        return this.requestedParallelism;
    }

    public void setRequestedParallelism(int requestedParallelism) {
        this.requestedParallelism = requestedParallelism;
    }

    public byte getResultType() {
        return this.resultType;
    }

    public String getAlias() {
        return this.alias;
    }

    protected String getAliasString() {
        return this.alias == null ? "" : this.alias + ": ";
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public void setAccumulative() {
        this.accum = true;
    }

    public boolean isAccumulative() {
        return this.accum;
    }

    public void setAccumStart() {
        if (!this.accum) {
            throw new IllegalStateException("Accumulative is not turned on.");
        }
        this.accumStart = true;
    }

    public boolean isAccumStarted() {
        return this.accumStart;
    }

    public void setAccumEnd() {
        if (!this.accum) {
            throw new IllegalStateException("Accumulative is not turned on.");
        }
        this.accumStart = false;
    }

    public void setResultType(byte resultType) {
        this.resultType = resultType;
    }

    public List<PhysicalOperator> getInputs() {
        return this.inputs;
    }

    public void setInputs(List<PhysicalOperator> inputs) {
        this.inputs = inputs;
    }

    public boolean isInputAttached() {
        return this.inputAttached;
    }

    public void attachInput(Tuple t) {
        this.input = t;
        this.inputAttached = true;
    }

    public void detachInput() {
        this.input = null;
        this.inputAttached = false;
    }

    public boolean isBlocking() {
        return false;
    }

    public Result processInput() throws ExecException {
        Result res = new Result();
        if (this.input == null && (this.inputs == null || this.inputs.size() == 0)) {
            res.returnStatus = (byte)3;
            return res;
        }
        if (reporter != null) {
            reporter.progress();
        }
        if (!this.isInputAttached()) {
            return this.inputs.get(0).getNext(dummyTuple);
        }
        res.result = this.input;
        res.returnStatus = res.result == null ? (byte)1 : 0;
        this.detachInput();
        return res;
    }

    @Override
    public abstract void visit(PhyPlanVisitor var1) throws VisitorException;

    public Result getNext(Object obj, byte dataType) throws ExecException {
        switch (dataType) {
            case 120: {
                return this.getNext((DataBag)obj);
            }
            case 5: {
                return this.getNext((Boolean)obj);
            }
            case 50: {
                return this.getNext((DataByteArray)obj);
            }
            case 55: {
                return this.getNext((String)obj);
            }
            case 25: {
                return this.getNext((Double)obj);
            }
            case 20: {
                return this.getNext((Float)obj);
            }
            case 10: {
                return this.getNext((Integer)obj);
            }
            case 15: {
                return this.getNext((Long)obj);
            }
            case 100: {
                return this.getNext((Map)obj);
            }
            case 110: {
                return this.getNext((Tuple)obj);
            }
        }
        throw new ExecException("Unsupported type for getNext: " + DataType.findTypeName(dataType));
    }

    public static Object getDummy(byte dataType) throws ExecException {
        switch (dataType) {
            case 120: {
                return dummyBag;
            }
            case 5: {
                return dummyBool;
            }
            case 50: {
                return dummyDBA;
            }
            case 55: {
                return dummyString;
            }
            case 25: {
                return dummyDouble;
            }
            case 20: {
                return dummyFloat;
            }
            case 10: {
                return dummyFloat;
            }
            case 15: {
                return dummyLong;
            }
            case 100: {
                return dummyMap;
            }
            case 110: {
                return dummyTuple;
            }
        }
        throw new ExecException("Unsupported type for getDummy: " + DataType.findTypeName(dataType));
    }

    public Result getNext(Integer i) throws ExecException {
        return this.res;
    }

    public Result getNext(Long l) throws ExecException {
        return this.res;
    }

    public Result getNext(Double d) throws ExecException {
        return this.res;
    }

    public Result getNext(Float f) throws ExecException {
        return this.res;
    }

    public Result getNext(String s) throws ExecException {
        return this.res;
    }

    public Result getNext(DataByteArray ba) throws ExecException {
        return this.res;
    }

    public Result getNext(Map m) throws ExecException {
        return this.res;
    }

    public Result getNext(Boolean b) throws ExecException {
        return this.res;
    }

    public Result getNext(Tuple t) throws ExecException {
        return this.res;
    }

    public Result getNext(DataBag db) throws ExecException {
        Result ret = null;
        DataBag tmpBag = BagFactory.getInstance().newDefaultBag();
        ret = this.getNext(dummyTuple);
        while (ret.returnStatus != 3) {
            if (ret.returnStatus == 2) {
                return ret;
            }
            tmpBag.add((Tuple)ret.result);
            ret = this.getNext(dummyTuple);
        }
        ret.result = tmpBag;
        ret.returnStatus = (byte)(tmpBag.size() == 0L ? 3 : 0);
        return ret;
    }

    public void reset() {
    }

    public static void setReporter(PigProgressable reporter) {
        PhysicalOperator.reporter = reporter;
    }

    @Override
    public PhysicalOperator clone() throws CloneNotSupportedException {
        return (PhysicalOperator)super.clone();
    }

    protected void cloneHelper(PhysicalOperator op) {
        this.resultType = op.resultType;
    }

    public void setParentPlan(PhysicalPlan physicalPlan) {
        this.parentPlan = physicalPlan;
    }

    public Log getLogger() {
        return log;
    }

    public static void setPigLogger(PigLogger logger) {
        pigLogger = logger;
    }

    public static PigLogger getPigLogger() {
        return pigLogger;
    }

    static {
        dummyDBA = null;
        dummyString = null;
        dummyDouble = null;
        dummyFloat = null;
        dummyInt = null;
        dummyLong = null;
        dummyBool = null;
        dummyTuple = null;
        dummyBag = null;
        dummyMap = null;
    }
}

