/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators;

import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.PhysicalOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.Result;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.POUserFunc;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhyPlanVisitor;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.plan.VisitorException;
import org.apache.pig.pen.Illustrator;

public abstract class ExpressionOperator
extends PhysicalOperator {
    private static final Log log = LogFactory.getLog(ExpressionOperator.class);
    private static final long serialVersionUID = 1L;

    public ExpressionOperator(OperatorKey k) {
        this(k, -1);
    }

    public ExpressionOperator(OperatorKey k, int rp) {
        super(k, rp);
    }

    @Override
    public void setIllustrator(Illustrator illustrator) {
        this.illustrator = illustrator;
    }

    @Override
    public boolean supportsMultipleOutputs() {
        return false;
    }

    @Override
    public Result getNext(DataBag db) throws ExecException {
        return new Result();
    }

    @Override
    public abstract void visit(PhyPlanVisitor var1) throws VisitorException;

    @Override
    public ExpressionOperator clone() throws CloneNotSupportedException {
        String s = "This expression operator does not implement clone.";
        log.error((Object)s);
        throw new CloneNotSupportedException(s);
    }

    protected abstract List<ExpressionOperator> getChildExpressions();

    public boolean containUDF() {
        if (this instanceof POUserFunc) {
            return true;
        }
        List<ExpressionOperator> l = this.getChildExpressions();
        if (l != null) {
            for (ExpressionOperator e : l) {
                if (!e.containUDF()) continue;
                return true;
            }
        }
        return false;
    }

    protected Result accumChild(List<ExpressionOperator> child, Object o, byte dataType) throws ExecException {
        if (this.isAccumStarted()) {
            if (child == null) {
                child = this.getChildExpressions();
            }
            Result res = null;
            if (child != null) {
                for (ExpressionOperator e : child) {
                    if (!e.containUDF()) continue;
                    res = e.getNext(o, dataType);
                    if (res.returnStatus == 5) continue;
                    return res;
                }
            }
            res = new Result();
            res.returnStatus = (byte)5;
            return res;
        }
        return null;
    }

    protected Result accumChild(List<ExpressionOperator> child, Double d) throws ExecException {
        return this.accumChild(child, d, (byte)25);
    }

    protected Result accumChild(List<ExpressionOperator> child, Integer v) throws ExecException {
        return this.accumChild(child, v, (byte)10);
    }

    protected Result accumChild(List<ExpressionOperator> child, Long l) throws ExecException {
        return this.accumChild(child, l, (byte)15);
    }

    protected Result accumChild(List<ExpressionOperator> child, Float f) throws ExecException {
        return this.accumChild(child, f, (byte)20);
    }

    protected Result accumChild(List<ExpressionOperator> child, Boolean b) throws ExecException {
        return this.accumChild(child, b, (byte)5);
    }

    protected Result accumChild(List<ExpressionOperator> child, String s) throws ExecException {
        return this.accumChild(child, s, (byte)55);
    }

    protected Result accumChild(List<ExpressionOperator> child, DataByteArray dba) throws ExecException {
        return this.accumChild(child, dba, (byte)50);
    }

    protected Result accumChild(List<ExpressionOperator> child, Map map) throws ExecException {
        return this.accumChild(child, map, (byte)100);
    }

    protected Result accumChild(List<ExpressionOperator> child, Tuple t) throws ExecException {
        return this.accumChild(child, t, (byte)110);
    }

    protected Result accumChild(List<ExpressionOperator> child, DataBag db) throws ExecException {
        return this.accumChild(child, db, (byte)120);
    }
}

