/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators;

import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.Result;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.BinaryExpressionOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhyPlanVisitor;
import org.apache.pig.data.DataType;
import org.apache.pig.impl.plan.NodeIdGenerator;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.plan.VisitorException;

public class Mod
extends BinaryExpressionOperator {
    private static final long serialVersionUID = 1L;

    public Mod(OperatorKey k) {
        super(k);
    }

    public Mod(OperatorKey k, int rp) {
        super(k, rp);
    }

    @Override
    public void visit(PhyPlanVisitor v) throws VisitorException {
        v.visitMod(this);
    }

    @Override
    public String name() {
        return "Mod[" + DataType.findTypeName(this.resultType) + "]" + " - " + this.mKey.toString();
    }

    protected <T extends Number> T mod(T a, T b, byte dataType) throws ExecException {
        switch (dataType) {
            case 10: {
                return (T)Integer.valueOf((Integer)a % (Integer)b);
            }
            case 15: {
                return (T)Long.valueOf((Long)a % (Long)b);
            }
        }
        throw new ExecException("called on unsupported Number class " + DataType.findTypeName(dataType));
    }

    protected <T extends Number> Result genericGetNext(T number, byte dataType) throws ExecException {
        Result r = this.accumChild(null, number, dataType);
        if (r != null) {
            return r;
        }
        Number left = null;
        Number right = null;
        Result res = this.lhs.getNext(left, dataType);
        byte status = res.returnStatus;
        if (status != 0 || res.result == null) {
            return res;
        }
        left = (Number)res.result;
        res = this.rhs.getNext(right, dataType);
        status = res.returnStatus;
        if (status != 0 || res.result == null) {
            return res;
        }
        right = (Number)res.result;
        res.result = this.mod(left, right, dataType);
        return res;
    }

    @Override
    public Result getNext(Integer i) throws ExecException {
        return this.genericGetNext(i, (byte)10);
    }

    @Override
    public Result getNext(Long i) throws ExecException {
        return this.genericGetNext(i, (byte)15);
    }

    @Override
    public Mod clone() throws CloneNotSupportedException {
        Mod clone = new Mod(new OperatorKey(this.mKey.scope, NodeIdGenerator.getGenerator().getNextNodeId(this.mKey.scope)));
        clone.cloneHelper(this);
        return clone;
    }
}

