/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pig.FuncSpec;
import org.apache.pig.LoadCaster;
import org.apache.pig.LoadFunc;
import org.apache.pig.PigWarning;
import org.apache.pig.ResourceSchema;
import org.apache.pig.StreamToPig;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.PhysicalOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.Result;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.ExpressionOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhyPlanVisitor;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.DataType;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.PigContext;
import org.apache.pig.impl.plan.NodeIdGenerator;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.plan.VisitorException;
import org.apache.pig.impl.util.CastUtils;
import org.apache.pig.impl.util.LogUtils;

public class POCast
extends ExpressionOperator {
    private static final Log log = LogFactory.getLog(POCast.class);
    private FuncSpec funcSpec = null;
    private transient LoadCaster caster;
    private boolean castNotNeeded = false;
    private Byte realType = null;
    private transient List<ExpressionOperator> child;
    private ResourceSchema.ResourceFieldSchema fieldSchema = null;
    private static final long serialVersionUID = 1L;

    public POCast(OperatorKey k) {
        super(k);
    }

    public POCast(OperatorKey k, int rp) {
        super(k, rp);
    }

    private void instantiateFunc() throws IOException {
        if (this.caster != null) {
            return;
        }
        if (this.funcSpec != null) {
            Object obj = PigContext.instantiateFuncFromSpec(this.funcSpec);
            if (obj instanceof LoadFunc) {
                this.caster = ((LoadFunc)obj).getLoadCaster();
            } else if (obj instanceof StreamToPig) {
                this.caster = ((StreamToPig)obj).getLoadCaster();
            } else {
                throw new IOException("Invalid class type " + this.funcSpec.getClassName());
            }
        }
    }

    public void setFuncSpec(FuncSpec lf) throws IOException {
        this.funcSpec = lf;
        this.instantiateFunc();
    }

    @Override
    public void visit(PhyPlanVisitor v) throws VisitorException {
        v.visitCast(this);
    }

    @Override
    public String name() {
        if (DataType.isSchemaType(this.resultType)) {
            return "Cast[" + DataType.findTypeName(this.resultType) + ":" + this.fieldSchema.calcCastString() + "]" + " - " + this.mKey.toString();
        }
        return "Cast[" + DataType.findTypeName(this.resultType) + "]" + " - " + this.mKey.toString();
    }

    @Override
    public boolean supportsMultipleInputs() {
        return false;
    }

    @Override
    public Result getNext(Integer i) throws ExecException {
        PhysicalOperator in = (PhysicalOperator)this.inputs.get(0);
        Byte resultType = in.getResultType();
        switch (resultType) {
            case 120: {
                Result res = new Result();
                res.returnStatus = (byte)2;
                return res;
            }
            case 110: {
                Result res = new Result();
                res.returnStatus = (byte)2;
                return res;
            }
            case 50: {
                DataByteArray dba = null;
                Result res = in.getNext(dba);
                if (res.returnStatus == 0 && res.result != null) {
                    try {
                        dba = (DataByteArray)res.result;
                    }
                    catch (ClassCastException e) {
                        if (this.realType == null) {
                            this.realType = DataType.findType(res.result);
                        }
                        try {
                            res.result = DataType.toInteger(res.result, this.realType);
                        }
                        catch (ClassCastException cce) {
                            this.realType = DataType.findType(res.result);
                            res.result = DataType.toInteger(res.result, this.realType);
                        }
                        return res;
                    }
                    try {
                        if (null == this.caster) {
                            int errCode = 1075;
                            String msg = "Received a bytearray from the UDF. Cannot determine how to convert the bytearray to int.";
                            throw new ExecException(msg, errCode, 2);
                        }
                        res.result = this.caster.bytesToInteger(dba.get());
                    }
                    catch (ExecException ee) {
                        throw ee;
                    }
                    catch (IOException e) {
                        log.error((Object)"Error while casting from ByteArray to Integer");
                    }
                }
                return res;
            }
            case 100: {
                Result res = new Result();
                res.returnStatus = (byte)2;
                return res;
            }
            case 5: {
                Boolean b = null;
                Result res = in.getNext(b);
                if (res.returnStatus == 0 && res.result != null) {
                    res.result = (Boolean)res.result == true ? Integer.valueOf(1) : Integer.valueOf(0);
                }
                return res;
            }
            case 10: {
                Result res = in.getNext(i);
                return res;
            }
            case 25: {
                Double d = null;
                Result res = in.getNext(d);
                if (res.returnStatus == 0 && res.result != null) {
                    res.result = ((Double)res.result).intValue();
                }
                return res;
            }
            case 15: {
                Long l = null;
                Result res = in.getNext(l);
                if (res.returnStatus == 0 && res.result != null) {
                    res.result = ((Long)res.result).intValue();
                }
                return res;
            }
            case 20: {
                Float f = null;
                Result res = in.getNext(f);
                if (res.returnStatus == 0 && res.result != null) {
                    res.result = ((Float)res.result).intValue();
                }
                return res;
            }
            case 55: {
                String str = null;
                Result res = in.getNext(str);
                if (res.returnStatus == 0 && res.result != null) {
                    res.result = CastUtils.stringToInteger((String)res.result);
                }
                return res;
            }
        }
        Result res = new Result();
        res.returnStatus = (byte)2;
        return res;
    }

    @Override
    public Result getNext(Long l) throws ExecException {
        PhysicalOperator in = (PhysicalOperator)this.inputs.get(0);
        Byte resultType = in.getResultType();
        switch (resultType) {
            case 120: {
                Result res = new Result();
                res.returnStatus = (byte)2;
                return res;
            }
            case 110: {
                Result res = new Result();
                res.returnStatus = (byte)2;
                return res;
            }
            case 100: {
                Result res = new Result();
                res.returnStatus = (byte)2;
                return res;
            }
            case 50: {
                DataByteArray dba = null;
                Result res = in.getNext(dba);
                if (res.returnStatus == 0 && res.result != null) {
                    try {
                        dba = (DataByteArray)res.result;
                    }
                    catch (ClassCastException e) {
                        if (this.realType == null) {
                            this.realType = DataType.findType(res.result);
                        }
                        try {
                            res.result = DataType.toLong(res.result, this.realType);
                        }
                        catch (ClassCastException cce) {
                            this.realType = DataType.findType(res.result);
                            res.result = DataType.toLong(res.result, this.realType);
                        }
                        return res;
                    }
                    try {
                        if (null == this.caster) {
                            int errCode = 1075;
                            String msg = "Received a bytearray from the UDF. Cannot determine how to convert the bytearray to long.";
                            throw new ExecException(msg, errCode, 2);
                        }
                        res.result = this.caster.bytesToLong(dba.get());
                    }
                    catch (ExecException ee) {
                        throw ee;
                    }
                    catch (IOException e) {
                        log.error((Object)"Error while casting from ByteArray to Long");
                    }
                }
                return res;
            }
            case 5: {
                Boolean b = null;
                Result res = in.getNext(b);
                if (res.returnStatus == 0 && res.result != null) {
                    res.result = (Boolean)res.result == true ? Long.valueOf(1L) : Long.valueOf(0L);
                }
                return res;
            }
            case 10: {
                Integer dummyI = null;
                Result res = in.getNext(dummyI);
                if (res.returnStatus == 0 && res.result != null) {
                    res.result = ((Integer)res.result).longValue();
                }
                return res;
            }
            case 25: {
                Double d = null;
                Result res = in.getNext(d);
                if (res.returnStatus == 0 && res.result != null) {
                    res.result = ((Double)res.result).longValue();
                }
                return res;
            }
            case 15: {
                Result res = in.getNext(l);
                return res;
            }
            case 20: {
                Float f = null;
                Result res = in.getNext(f);
                if (res.returnStatus == 0 && res.result != null) {
                    res.result = ((Float)res.result).longValue();
                }
                return res;
            }
            case 55: {
                String str = null;
                Result res = in.getNext(str);
                if (res.returnStatus == 0 && res.result != null) {
                    res.result = CastUtils.stringToLong((String)res.result);
                }
                return res;
            }
        }
        Result res = new Result();
        res.returnStatus = (byte)2;
        return res;
    }

    @Override
    public Result getNext(Double d) throws ExecException {
        PhysicalOperator in = (PhysicalOperator)this.inputs.get(0);
        Byte resultType = in.getResultType();
        switch (resultType) {
            case 120: {
                Result res = new Result();
                res.returnStatus = (byte)2;
                return res;
            }
            case 110: {
                Result res = new Result();
                res.returnStatus = (byte)2;
                return res;
            }
            case 100: {
                Result res = new Result();
                res.returnStatus = (byte)2;
                return res;
            }
            case 50: {
                DataByteArray dba = null;
                Result res = in.getNext(dba);
                if (res.returnStatus == 0 && res.result != null) {
                    try {
                        dba = (DataByteArray)res.result;
                    }
                    catch (ClassCastException e) {
                        if (this.realType == null) {
                            this.realType = DataType.findType(res.result);
                        }
                        try {
                            res.result = DataType.toDouble(res.result, this.realType);
                        }
                        catch (ClassCastException cce) {
                            this.realType = DataType.findType(res.result);
                            res.result = DataType.toDouble(res.result, this.realType);
                        }
                        return res;
                    }
                    try {
                        if (null == this.caster) {
                            int errCode = 1075;
                            String msg = "Received a bytearray from the UDF. Cannot determine how to convert the bytearray to double.";
                            throw new ExecException(msg, errCode, 2);
                        }
                        res.result = this.caster.bytesToDouble(dba.get());
                    }
                    catch (ExecException ee) {
                        throw ee;
                    }
                    catch (IOException e) {
                        log.error((Object)"Error while casting from ByteArray to Double");
                    }
                }
                return res;
            }
            case 5: {
                Boolean b = null;
                Result res = in.getNext(b);
                if (res.returnStatus == 0 && res.result != null) {
                    res.result = (Boolean)res.result == true ? new Double(1.0) : new Double(0.0);
                }
                return res;
            }
            case 10: {
                Integer dummyI = null;
                Result res = in.getNext(dummyI);
                if (res.returnStatus == 0 && res.result != null) {
                    res.result = new Double(((Integer)res.result).doubleValue());
                }
                return res;
            }
            case 25: {
                Result res = in.getNext(d);
                return res;
            }
            case 15: {
                Long l = null;
                Result res = in.getNext(l);
                if (res.returnStatus == 0 && res.result != null) {
                    res.result = new Double(((Long)res.result).doubleValue());
                }
                return res;
            }
            case 20: {
                Float f = null;
                Result res = in.getNext(f);
                if (res.returnStatus == 0 && res.result != null) {
                    res.result = new Double(((Float)res.result).doubleValue());
                }
                return res;
            }
            case 55: {
                String str = null;
                Result res = in.getNext(str);
                if (res.returnStatus == 0 && res.result != null) {
                    res.result = CastUtils.stringToDouble((String)res.result);
                }
                return res;
            }
        }
        Result res = new Result();
        res.returnStatus = (byte)2;
        return res;
    }

    @Override
    public Result getNext(Float f) throws ExecException {
        PhysicalOperator in = (PhysicalOperator)this.inputs.get(0);
        Byte resultType = in.getResultType();
        switch (resultType) {
            case 120: {
                Result res = new Result();
                res.returnStatus = (byte)2;
                return res;
            }
            case 110: {
                Result res = new Result();
                res.returnStatus = (byte)2;
                return res;
            }
            case 100: {
                Result res = new Result();
                res.returnStatus = (byte)2;
                return res;
            }
            case 50: {
                DataByteArray dba = null;
                Result res = in.getNext(dba);
                if (res.returnStatus == 0 && res.result != null) {
                    try {
                        dba = (DataByteArray)res.result;
                    }
                    catch (ClassCastException e) {
                        if (this.realType == null) {
                            this.realType = DataType.findType(res.result);
                        }
                        try {
                            res.result = DataType.toFloat(res.result, this.realType);
                        }
                        catch (ClassCastException cce) {
                            this.realType = DataType.findType(res.result);
                            res.result = DataType.toFloat(res.result, this.realType);
                        }
                        return res;
                    }
                    try {
                        if (null == this.caster) {
                            int errCode = 1075;
                            String msg = "Received a bytearray from the UDF. Cannot determine how to convert the bytearray to float.";
                            throw new ExecException(msg, errCode, 2);
                        }
                        res.result = this.caster.bytesToFloat(dba.get());
                    }
                    catch (ExecException ee) {
                        throw ee;
                    }
                    catch (IOException e) {
                        log.error((Object)"Error while casting from ByteArray to Float");
                    }
                }
                return res;
            }
            case 5: {
                Boolean b = null;
                Result res = in.getNext(b);
                if (res.returnStatus == 0 && res.result != null) {
                    res.result = (Boolean)res.result == true ? new Float(1.0f) : new Float(0.0f);
                }
                return res;
            }
            case 10: {
                Integer dummyI = null;
                Result res = in.getNext(dummyI);
                if (res.returnStatus == 0 && res.result != null) {
                    res.result = new Float(((Integer)res.result).floatValue());
                }
                return res;
            }
            case 25: {
                Double d = null;
                Result res = in.getNext(d);
                if (res.returnStatus == 0 && res.result != null) {
                    res.result = new Float(((Double)res.result).floatValue());
                }
                return res;
            }
            case 15: {
                Long l = null;
                Result res = in.getNext(l);
                if (res.returnStatus == 0 && res.result != null) {
                    res.result = new Float(((Long)res.result).floatValue());
                }
                return res;
            }
            case 20: {
                Result res = in.getNext(f);
                return res;
            }
            case 55: {
                String str = null;
                Result res = in.getNext(str);
                if (res.returnStatus == 0 && res.result != null) {
                    res.result = CastUtils.stringToFloat((String)res.result);
                }
                return res;
            }
        }
        Result res = new Result();
        res.returnStatus = (byte)2;
        return res;
    }

    @Override
    public Result getNext(String str) throws ExecException {
        PhysicalOperator in = (PhysicalOperator)this.inputs.get(0);
        Byte resultType = in.getResultType();
        switch (resultType) {
            case 120: {
                Result res = new Result();
                res.returnStatus = (byte)2;
                return res;
            }
            case 110: {
                Result res = new Result();
                res.returnStatus = (byte)2;
                return res;
            }
            case 100: {
                Result res = new Result();
                res.returnStatus = (byte)2;
                return res;
            }
            case 50: {
                DataByteArray dba = null;
                Result res = in.getNext(dba);
                if (res.returnStatus == 0 && res.result != null) {
                    try {
                        dba = (DataByteArray)res.result;
                    }
                    catch (ClassCastException e) {
                        if (this.realType == null) {
                            this.realType = DataType.findType(res.result);
                        }
                        try {
                            res.result = DataType.toString(res.result, this.realType);
                        }
                        catch (ClassCastException cce) {
                            this.realType = DataType.findType(res.result);
                            res.result = DataType.toString(res.result, this.realType);
                        }
                        return res;
                    }
                    try {
                        if (null == this.caster) {
                            int errCode = 1075;
                            String msg = "Received a bytearray from the UDF. Cannot determine how to convert the bytearray to string.";
                            throw new ExecException(msg, errCode, 2);
                        }
                        res.result = this.caster.bytesToCharArray(dba.get());
                    }
                    catch (ExecException ee) {
                        throw ee;
                    }
                    catch (IOException e) {
                        log.error((Object)"Error while casting from ByteArray to CharArray");
                    }
                }
                return res;
            }
            case 5: {
                Boolean b = null;
                Result res = in.getNext(b);
                if (res.returnStatus == 0 && res.result != null) {
                    res.result = (Boolean)res.result == true ? "1" : "0";
                }
                return res;
            }
            case 10: {
                Integer dummyI = null;
                Result res = in.getNext(dummyI);
                if (res.returnStatus == 0 && res.result != null) {
                    res.result = ((Integer)res.result).toString();
                }
                return res;
            }
            case 25: {
                Double d = null;
                Result res = in.getNext(d);
                if (res.returnStatus == 0 && res.result != null) {
                    res.result = ((Double)res.result).toString();
                }
                return res;
            }
            case 15: {
                Long l = null;
                Result res = in.getNext(l);
                if (res.returnStatus == 0 && res.result != null) {
                    res.result = ((Long)res.result).toString();
                }
                return res;
            }
            case 20: {
                Float f = null;
                Result res = in.getNext(f);
                if (res.returnStatus == 0 && res.result != null) {
                    res.result = ((Float)res.result).toString();
                }
                return res;
            }
            case 55: {
                Result res = in.getNext(str);
                return res;
            }
        }
        Result res = new Result();
        res.returnStatus = (byte)2;
        return res;
    }

    @Override
    public Result getNext(Tuple t) throws ExecException {
        PhysicalOperator in = (PhysicalOperator)this.inputs.get(0);
        Byte castToType = 110;
        Byte resultType = in.getResultType();
        switch (resultType) {
            case 110: {
                Result res = in.getNext(t);
                if (res.returnStatus == 0 && res.result != null) {
                    try {
                        res.result = this.convertWithSchema(res.result, this.fieldSchema);
                    }
                    catch (IOException e) {
                        LogUtils.warn(this, "Unable to interpret value " + res.result + " in field being " + "converted to type tuple, caught ParseException <" + e.getMessage() + "> field discarded", PigWarning.FIELD_DISCARDED_TYPE_CONVERSION_FAILED, log);
                        res.result = null;
                    }
                }
                return res;
            }
            case 50: {
                DataByteArray dba = null;
                Result res = in.getNext(dba);
                if (res.returnStatus == 0 && res.result != null) {
                    if (this.castNotNeeded) {
                        return res;
                    }
                    try {
                        dba = (DataByteArray)res.result;
                    }
                    catch (ClassCastException e) {
                        if (DataType.findType(res.result) == castToType) {
                            this.castNotNeeded = true;
                            return res;
                        }
                        int errCode = 1081;
                        String msg = "Cannot cast to tuple. Expected bytearray but received: " + DataType.findTypeName(res.result);
                        throw new ExecException(msg, errCode, 2, e);
                    }
                    try {
                        if (null == this.caster) {
                            int errCode = 1075;
                            String msg = "Received a bytearray from the UDF. Cannot determine how to convert the bytearray to tuple.";
                            throw new ExecException(msg, errCode, 2);
                        }
                        res.result = this.caster.bytesToTuple(dba.get(), this.fieldSchema);
                    }
                    catch (ExecException ee) {
                        throw ee;
                    }
                    catch (IOException e) {
                        log.error((Object)"Error while casting from ByteArray to Tuple");
                    }
                }
                return res;
            }
            case 5: 
            case 10: 
            case 15: 
            case 20: 
            case 25: 
            case 55: 
            case 100: 
            case 120: {
                Result res = new Result();
                res.returnStatus = (byte)2;
                return res;
            }
        }
        Result res = new Result();
        res.returnStatus = (byte)2;
        return res;
    }

    private Object convertWithSchema(Object obj, ResourceSchema.ResourceFieldSchema fs) throws IOException {
        Object result = null;
        if (fs == null) {
            return obj;
        }
        if (obj == null) {
            return null;
        }
        block2 : switch (fs.getType()) {
            case 120: {
                if (obj instanceof DataBag) {
                    DataBag db = (DataBag)((Object)obj);
                    if (fs.getSchema() != null) {
                        ResourceSchema.ResourceFieldSchema tupleFs = fs.getSchema().getFields()[0];
                        for (Tuple t : db) {
                            this.convertWithSchema(t, tupleFs);
                        }
                    }
                    result = db;
                    break;
                }
                if (obj instanceof DataByteArray) {
                    if (null != this.caster) {
                        result = this.caster.bytesToBag(((DataByteArray)((Object)obj)).get(), fs);
                        break;
                    }
                    int errCode = 1075;
                    String msg = "Received a bytearray from the UDF. Cannot determine how to convert the bytearray to bag.";
                    throw new ExecException(msg, errCode, 2);
                }
                throw new ExecException("Cannot cast " + obj + " to bag.", 1120, 2);
            }
            case 110: {
                if (obj instanceof Tuple) {
                    try {
                        Tuple t = (Tuple)((Object)obj);
                        ResourceSchema innerSchema = fs.getSchema();
                        if (innerSchema == null) {
                            return t;
                        }
                        if (innerSchema.getFields().length != t.size()) {
                            return null;
                        }
                        int i = 0;
                        for (ResourceSchema.ResourceFieldSchema fieldSchema : innerSchema.getFields()) {
                            Object field = this.convertWithSchema(t.get(i), fieldSchema);
                            t.set(i, field);
                            ++i;
                        }
                        result = t;
                        break;
                    }
                    catch (Exception e) {
                        throw new ExecException("Cannot convert " + obj + " to " + fs);
                    }
                }
                if (obj instanceof DataByteArray) {
                    if (null != this.caster) {
                        result = this.caster.bytesToTuple(((DataByteArray)((Object)obj)).get(), fs);
                        break;
                    }
                    int errCode = 1075;
                    String msg = "Received a bytearray from the UDF. Cannot determine how to convert the bytearray to tuple.";
                    throw new ExecException(msg, errCode, 2);
                }
                throw new ExecException("Cannot cast " + obj + " to tuple.", 1120, 2);
            }
            case 100: {
                if (obj instanceof Map) {
                    if (fs != null && fs.getSchema() != null) {
                        ResourceSchema.ResourceFieldSchema innerFieldSchema = fs.getSchema().getFields()[0];
                        Map m = obj;
                        for (Map.Entry entry : m.entrySet()) {
                            Object newValue = this.convertWithSchema(entry.getValue(), innerFieldSchema);
                            m.put(entry.getKey(), newValue);
                        }
                        result = m;
                        break;
                    }
                    result = obj;
                    break;
                }
                if (obj instanceof DataByteArray) {
                    if (null != this.caster) {
                        try {
                            result = this.caster.bytesToMap(((DataByteArray)((Object)obj)).get(), fs);
                        }
                        catch (AbstractMethodError e) {
                            result = this.caster.bytesToMap(((DataByteArray)((Object)obj)).get());
                        }
                        break;
                    }
                    int errCode = 1075;
                    String msg = "Received a bytearray from the UDF. Cannot determine how to convert the bytearray to tuple.";
                    throw new ExecException(msg, errCode, 2);
                }
                throw new ExecException("Cannot cast " + obj + " to map.", 1120, 2);
            }
            case 10: {
                switch (DataType.findType(obj)) {
                    case 50: {
                        if (null != this.caster) {
                            result = this.caster.bytesToInteger(((DataByteArray)((Object)obj)).get());
                            break block2;
                        }
                        int errCode = 1075;
                        String msg = "Received a bytearray from the UDF. Cannot determine how to convert the bytearray to int.";
                        throw new ExecException(msg, errCode, 2);
                    }
                    case 5: {
                        if (((Boolean)((Object)obj)).booleanValue()) {
                            result = 1;
                            break block2;
                        }
                        result = 0;
                        break block2;
                    }
                    case 10: {
                        result = obj;
                        break block2;
                    }
                    case 25: {
                        result = ((Double)((Object)obj)).intValue();
                        break block2;
                    }
                    case 15: {
                        result = ((Long)((Object)obj)).intValue();
                        break block2;
                    }
                    case 20: {
                        result = ((Float)((Object)obj)).intValue();
                        break block2;
                    }
                    case 55: {
                        result = CastUtils.stringToInteger((String)((Object)obj));
                        break block2;
                    }
                }
                throw new ExecException("Cannot convert " + obj + " to " + fs, 1120, 2);
            }
            case 25: {
                switch (DataType.findType(obj)) {
                    case 50: {
                        if (null != this.caster) {
                            result = this.caster.bytesToDouble(((DataByteArray)((Object)obj)).get());
                            break block2;
                        }
                        int errCode = 1075;
                        String msg = "Received a bytearray from the UDF. Cannot determine how to convert the bytearray to double.";
                        throw new ExecException(msg, errCode, 2);
                    }
                    case 5: {
                        if (((Boolean)((Object)obj)).booleanValue()) {
                            result = new Double(1.0);
                            break block2;
                        }
                        result = new Double(1.0);
                        break block2;
                    }
                    case 10: {
                        result = new Double(((Integer)((Object)obj)).doubleValue());
                        break block2;
                    }
                    case 25: {
                        result = (Double)((Object)obj);
                        break block2;
                    }
                    case 15: {
                        result = new Double(((Long)((Object)obj)).doubleValue());
                        break block2;
                    }
                    case 20: {
                        result = new Double(((Float)((Object)obj)).doubleValue());
                        break block2;
                    }
                    case 55: {
                        result = CastUtils.stringToDouble((String)((Object)obj));
                        break block2;
                    }
                }
                throw new ExecException("Cannot convert " + obj + " to " + fs, 1120, 2);
            }
            case 15: {
                switch (DataType.findType(obj)) {
                    case 50: {
                        if (null != this.caster) {
                            result = this.caster.bytesToLong(((DataByteArray)((Object)obj)).get());
                            break block2;
                        }
                        int errCode = 1075;
                        String msg = "Received a bytearray from the UDF. Cannot determine how to convert the bytearray to long.";
                        throw new ExecException(msg, errCode, 2);
                    }
                    case 5: {
                        if (((Boolean)((Object)obj)).booleanValue()) {
                            result = 1L;
                            break block2;
                        }
                        result = 0L;
                        break block2;
                    }
                    case 10: {
                        result = ((Integer)((Object)obj)).longValue();
                        break block2;
                    }
                    case 25: {
                        result = ((Double)((Object)obj)).longValue();
                        break block2;
                    }
                    case 15: {
                        result = (Long)((Object)obj);
                        break block2;
                    }
                    case 20: {
                        result = ((Float)((Object)obj)).longValue();
                        break block2;
                    }
                    case 55: {
                        result = CastUtils.stringToLong((String)((Object)obj));
                        break block2;
                    }
                }
                throw new ExecException("Cannot convert " + obj + " to " + fs, 1120, 2);
            }
            case 20: {
                switch (DataType.findType(obj)) {
                    case 50: {
                        if (null != this.caster) {
                            result = this.caster.bytesToFloat(((DataByteArray)((Object)obj)).get());
                            break block2;
                        }
                        int errCode = 1075;
                        String msg = "Received a bytearray from the UDF. Cannot determine how to convert the bytearray to float.";
                        throw new ExecException(msg, errCode, 2);
                    }
                    case 5: {
                        if (((Boolean)((Object)obj)).booleanValue()) {
                            result = new Float(1.0f);
                            break block2;
                        }
                        result = new Float(0.0f);
                        break block2;
                    }
                    case 10: {
                        result = new Float(((Integer)((Object)obj)).floatValue());
                        break block2;
                    }
                    case 25: {
                        result = new Float(((Double)((Object)obj)).floatValue());
                        break block2;
                    }
                    case 15: {
                        result = new Float(((Long)((Object)obj)).floatValue());
                        break block2;
                    }
                    case 20: {
                        result = obj;
                        break block2;
                    }
                    case 55: {
                        result = CastUtils.stringToFloat((String)((Object)obj));
                        break block2;
                    }
                }
                throw new ExecException("Cannot convert " + obj + " to " + fs, 1120, 2);
            }
            case 55: {
                switch (DataType.findType(obj)) {
                    case 50: {
                        if (null != this.caster) {
                            result = this.caster.bytesToCharArray(((DataByteArray)((Object)obj)).get());
                            break block2;
                        }
                        int errCode = 1075;
                        String msg = "Received a bytearray from the UDF. Cannot determine how to convert the bytearray to float.";
                        throw new ExecException(msg, errCode, 2);
                    }
                    case 5: {
                        if (((Boolean)((Object)obj)).booleanValue()) {
                            result = "1";
                            break block2;
                        }
                        result = "0";
                        break block2;
                    }
                    case 10: {
                        result = ((Integer)((Object)obj)).toString();
                        break block2;
                    }
                    case 25: {
                        result = ((Double)((Object)obj)).toString();
                        break block2;
                    }
                    case 15: {
                        result = ((Long)((Object)obj)).toString();
                        break block2;
                    }
                    case 20: {
                        result = ((Float)((Object)obj)).toString();
                        break block2;
                    }
                    case 55: {
                        result = obj;
                        break block2;
                    }
                }
                throw new ExecException("Cannot convert " + obj + " to " + fs, 1120, 2);
            }
            default: {
                throw new ExecException("Don't know how to convert " + obj + " to " + fs, 1120, 2);
            }
        }
        return result;
    }

    @Override
    public Result getNext(DataBag bag) throws ExecException {
        PhysicalOperator in = (PhysicalOperator)this.inputs.get(0);
        Byte castToType = 120;
        Byte resultType = in.getResultType();
        switch (resultType) {
            case 120: {
                this.res = in.getNext(bag);
                if (this.res.returnStatus == 0 && this.res.result != null) {
                    try {
                        this.res.result = this.convertWithSchema(this.res.result, this.fieldSchema);
                    }
                    catch (IOException e) {
                        LogUtils.warn(this, "Unable to interpret value " + this.res.result + " in field being " + "converted to type bag, caught ParseException <" + e.getMessage() + "> field discarded", PigWarning.FIELD_DISCARDED_TYPE_CONVERSION_FAILED, log);
                        this.res.result = null;
                    }
                }
                return this.res;
            }
            case 50: {
                DataByteArray dba = null;
                Result res = in.getNext(dba);
                if (res.returnStatus == 0 && res.result != null) {
                    if (this.castNotNeeded) {
                        return res;
                    }
                    try {
                        dba = (DataByteArray)res.result;
                    }
                    catch (ClassCastException e) {
                        if (DataType.findType(res.result) == castToType) {
                            this.castNotNeeded = true;
                            return res;
                        }
                        int errCode = 1081;
                        String msg = "Cannot cast to bag. Expected bytearray but received: " + DataType.findTypeName(res.result);
                        throw new ExecException(msg, errCode, 2, e);
                    }
                    try {
                        if (null == this.caster) {
                            int errCode = 1075;
                            String msg = "Received a bytearray from the UDF. Cannot determine how to convert the bytearray to bag.";
                            throw new ExecException(msg, errCode, 2);
                        }
                        res.result = this.caster.bytesToBag(dba.get(), this.fieldSchema);
                    }
                    catch (ExecException ee) {
                        throw ee;
                    }
                    catch (IOException e) {
                        log.error((Object)"Error while casting from ByteArray to DataBag");
                    }
                }
                return res;
            }
            case 5: 
            case 10: 
            case 15: 
            case 20: 
            case 25: 
            case 55: 
            case 100: 
            case 110: {
                Result res = new Result();
                res.returnStatus = (byte)2;
                return res;
            }
        }
        Result res = new Result();
        res.returnStatus = (byte)2;
        return res;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Result getNext(Map m) throws ExecException {
        PhysicalOperator in = (PhysicalOperator)this.inputs.get(0);
        Byte castToType = 100;
        Byte resultType = in.getResultType();
        switch (resultType) {
            case 100: {
                Result res = in.getNext(m);
                if (res.returnStatus != 0 || res.result == null) return res;
                try {
                    res.result = this.convertWithSchema(res.result, this.fieldSchema);
                    return res;
                }
                catch (IOException e) {
                    LogUtils.warn(this, "Unable to interpret value " + res.result + " in field being " + "converted to type map, caught ParseException <" + e.getMessage() + "> field discarded", PigWarning.FIELD_DISCARDED_TYPE_CONVERSION_FAILED, log);
                    res.result = null;
                }
                return res;
            }
            case 50: {
                DataByteArray dba = null;
                Result res = in.getNext(dba);
                if (res.returnStatus != 0 || res.result == null) return res;
                if (this.castNotNeeded) {
                    return res;
                }
                try {
                    dba = (DataByteArray)res.result;
                }
                catch (ClassCastException e) {
                    if (DataType.findType(res.result) == castToType) {
                        this.castNotNeeded = true;
                        return res;
                    }
                    int errCode = 1081;
                    String msg = "Cannot cast to map. Expected bytearray but received: " + DataType.findTypeName(res.result);
                    throw new ExecException(msg, errCode, 2, e);
                }
                try {
                    if (null != this.caster) {
                        try {
                            res.result = this.caster.bytesToMap(dba.get(), this.fieldSchema);
                            return res;
                        }
                        catch (AbstractMethodError e) {
                            res.result = this.caster.bytesToMap(dba.get());
                        }
                        return res;
                    }
                    int errCode = 1075;
                    String msg = "Received a bytearray from the UDF. Cannot determine how to convert the bytearray to map.";
                    throw new ExecException(msg, errCode, 2);
                }
                catch (ExecException ee) {
                    throw ee;
                }
                catch (IOException e) {
                    log.error((Object)"Error while casting from ByteArray to Map");
                }
                return res;
            }
            case 5: 
            case 10: 
            case 15: 
            case 20: 
            case 25: 
            case 55: 
            case 110: 
            case 120: {
                Result res = new Result();
                res.returnStatus = (byte)2;
                return res;
            }
        }
        Result res = new Result();
        res.returnStatus = (byte)2;
        return res;
    }

    @Override
    public Result getNext(DataByteArray dba) throws ExecException {
        Result res = new Result();
        res.returnStatus = (byte)2;
        return res;
    }

    private void readObject(ObjectInputStream is) throws IOException, ClassNotFoundException {
        is.defaultReadObject();
        this.instantiateFunc();
    }

    @Override
    public POCast clone() throws CloneNotSupportedException {
        POCast clone = new POCast(new OperatorKey(this.mKey.scope, NodeIdGenerator.getGenerator().getNextNodeId(this.mKey.scope)));
        clone.cloneHelper(this);
        clone.funcSpec = this.funcSpec;
        clone.fieldSchema = this.fieldSchema;
        try {
            clone.instantiateFunc();
        }
        catch (IOException e) {
            CloneNotSupportedException cnse = new CloneNotSupportedException();
            cnse.initCause(e);
            throw cnse;
        }
        return clone;
    }

    @Override
    public List<ExpressionOperator> getChildExpressions() {
        if (this.child == null) {
            this.child = new ArrayList<ExpressionOperator>();
            if (this.inputs.get(0) instanceof ExpressionOperator) {
                this.child.add((ExpressionOperator)this.inputs.get(0));
            }
        }
        return this.child;
    }

    public void setFieldSchema(ResourceSchema.ResourceFieldSchema s) {
        this.fieldSchema = s;
    }

    public FuncSpec getFuncSpec() {
        return this.funcSpec;
    }

    @Override
    public Tuple illustratorMarkup(Object in, Object out, int eqClassIndex) {
        return (Tuple)out;
    }
}

