/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import org.apache.pig.Accumulator;
import org.apache.pig.Algebraic;
import org.apache.pig.EvalFunc;
import org.apache.pig.FuncSpec;
import org.apache.pig.PigException;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.PhysicalOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.Result;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.ExpressionOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.POProject;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhyPlanVisitor;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.util.MonitoredUDFExecutor;
import org.apache.pig.builtin.MonitoredUDF;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.DataType;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.PigContext;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import org.apache.pig.impl.plan.NodeIdGenerator;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.plan.VisitorException;

public class POUserFunc
extends ExpressionOperator {
    private static final long serialVersionUID = 1L;
    transient EvalFunc func;
    private transient String[] cacheFiles = null;
    FuncSpec funcSpec;
    FuncSpec origFSpec;
    public static final byte INITIAL = 0;
    public static final byte INTERMEDIATE = 1;
    public static final byte FINAL = 2;
    private boolean initialized = false;
    private MonitoredUDFExecutor executor = null;
    private PhysicalOperator referencedOperator = null;
    private boolean isAccumulationDone;

    public PhysicalOperator getReferencedOperator() {
        return this.referencedOperator;
    }

    public void setReferencedOperator(PhysicalOperator referencedOperator) {
        this.referencedOperator = referencedOperator;
    }

    public POUserFunc(OperatorKey k, int rp, List<PhysicalOperator> inp) {
        super(k, rp);
        this.inputs = inp;
    }

    public POUserFunc(OperatorKey k, int rp, List<PhysicalOperator> inp, FuncSpec funcSpec) {
        this(k, rp, inp, funcSpec, null);
    }

    public POUserFunc(OperatorKey k, int rp, List<PhysicalOperator> inp, FuncSpec funcSpec, EvalFunc func) {
        super(k, rp);
        super.setInputs(inp);
        this.funcSpec = funcSpec;
        this.origFSpec = funcSpec;
        this.func = func;
        this.instantiateFunc(funcSpec);
    }

    private void instantiateFunc(FuncSpec fSpec) {
        this.func = (EvalFunc)PigContext.instantiateFuncFromSpec(fSpec);
        if (this.func.getClass().isAnnotationPresent(MonitoredUDF.class)) {
            this.executor = new MonitoredUDFExecutor(this.func);
        }
        this.func.setReporter(reporter);
        this.func.setPigLogger(pigLogger);
    }

    @Override
    public Result processInput() throws ExecException {
        if (!this.initialized) {
            this.func.setReporter(reporter);
            this.func.setPigLogger(pigLogger);
            this.initialized = true;
        }
        Result res = new Result();
        Object inpValue = null;
        if (this.input == null && (this.inputs == null || this.inputs.size() == 0)) {
            res.returnStatus = (byte)3;
            return res;
        }
        if (reporter != null) {
            reporter.progress();
        }
        if (this.isInputAttached()) {
            res.result = this.input;
            res.returnStatus = 0;
            this.detachInput();
            return res;
        }
        res.result = TupleFactory.getInstance().newTuple();
        Result temp = null;
        for (PhysicalOperator op : this.inputs) {
            POProject projOp;
            temp = op.getNext(POUserFunc.getDummy(op.getResultType()), op.getResultType());
            if (temp.returnStatus != 0) {
                return temp;
            }
            if (op instanceof POProject && op.getResultType() == 110 && (projOp = (POProject)op).isProjectToEnd()) {
                Tuple trslt = (Tuple)temp.result;
                Tuple rslt = (Tuple)res.result;
                for (int i = 0; i < trslt.size(); ++i) {
                    rslt.append(trslt.get(i));
                }
                continue;
            }
            ((Tuple)res.result).append(temp.result);
        }
        res.returnStatus = temp.returnStatus;
        return res;
    }

    private Result getNext() throws ExecException {
        Result result = this.processInput();
        String errMsg = "";
        try {
            if (result.returnStatus == 0) {
                if (this.isAccumulative()) {
                    if (this.isAccumStarted()) {
                        ((Accumulator)((Object)this.func)).accumulate((Tuple)result.result);
                        result.returnStatus = (byte)5;
                        result.result = null;
                        this.isAccumulationDone = false;
                    } else if (this.isAccumulationDone) {
                        result.result = null;
                        result.returnStatus = (byte)3;
                    } else {
                        result.result = ((Accumulator)((Object)this.func)).getValue();
                        result.returnStatus = 0;
                        ((Accumulator)((Object)this.func)).cleanup();
                        this.isAccumulationDone = true;
                    }
                } else {
                    result.result = this.executor != null ? this.executor.monitorExec((Tuple)result.result) : this.func.exec((Tuple)result.result);
                }
                return result;
            }
            return result;
        }
        catch (ExecException ee) {
            throw ee;
        }
        catch (IOException ioe) {
            int errCode = 2078;
            String msg = "Caught error from UDF: " + this.funcSpec.getClassName();
            String footer = " [" + ioe.getMessage() + "]";
            if (ioe instanceof PigException) {
                int udfErrorCode = ((PigException)ioe).getErrorCode();
                if (udfErrorCode != 0) {
                    errCode = udfErrorCode;
                    msg = ((PigException)ioe).getMessage();
                } else {
                    msg = msg + " [" + ((PigException)ioe).getMessage() + " ]";
                }
            } else {
                msg = msg + footer;
            }
            throw new ExecException(msg, errCode, 4, ioe);
        }
        catch (IndexOutOfBoundsException ie) {
            int errCode = 2078;
            String msg = "Caught error from UDF: " + this.funcSpec.getClassName() + ", Out of bounds access [" + ie.getMessage() + "]";
            throw new ExecException(msg, errCode, 4, ie);
        }
    }

    @Override
    public Result getNext(Tuple tIn) throws ExecException {
        return this.getNext();
    }

    @Override
    public Result getNext(DataBag db) throws ExecException {
        return this.getNext();
    }

    @Override
    public Result getNext(Integer i) throws ExecException {
        return this.getNext();
    }

    @Override
    public Result getNext(Boolean b) throws ExecException {
        return this.getNext();
    }

    @Override
    public Result getNext(DataByteArray ba) throws ExecException {
        return this.getNext();
    }

    @Override
    public Result getNext(Double d) throws ExecException {
        return this.getNext();
    }

    @Override
    public Result getNext(Float f) throws ExecException {
        return this.getNext();
    }

    @Override
    public Result getNext(Long l) throws ExecException {
        return this.getNext();
    }

    @Override
    public Result getNext(Map m) throws ExecException {
        return this.getNext();
    }

    @Override
    public Result getNext(String s) throws ExecException {
        return this.getNext();
    }

    public void setAlgebraicFunction(byte Function2) throws ExecException {
        switch (Function2) {
            case 0: {
                this.funcSpec = new FuncSpec(this.getInitial());
                break;
            }
            case 1: {
                this.funcSpec = new FuncSpec(this.getIntermed());
                break;
            }
            case 2: {
                this.funcSpec = new FuncSpec(this.getFinal());
            }
        }
        this.funcSpec.setCtorArgs(this.origFSpec.getCtorArgs());
        this.instantiateFunc(this.funcSpec);
        this.setResultType(DataType.findType(this.func.getReturnType()));
    }

    public String getInitial() throws ExecException {
        this.instantiateFunc(this.origFSpec);
        if (this.func instanceof Algebraic) {
            return ((Algebraic)((Object)this.func)).getInitial();
        }
        int errCode = 2072;
        String msg = "Attempt to run a non-algebraic function as an algebraic function";
        throw new ExecException(msg, errCode, 4);
    }

    public String getIntermed() throws ExecException {
        this.instantiateFunc(this.origFSpec);
        if (this.func instanceof Algebraic) {
            return ((Algebraic)((Object)this.func)).getIntermed();
        }
        int errCode = 2072;
        String msg = "Attempt to run a non-algebraic function as an algebraic function";
        throw new ExecException(msg, errCode, 4);
    }

    public String getFinal() throws ExecException {
        this.instantiateFunc(this.origFSpec);
        if (this.func instanceof Algebraic) {
            return ((Algebraic)((Object)this.func)).getFinal();
        }
        int errCode = 2072;
        String msg = "Attempt to run a non-algebraic function as an algebraic function";
        throw new ExecException(msg, errCode, 4);
    }

    public Type getReturnType() {
        return this.func.getReturnType();
    }

    public void finish() {
        this.func.finish();
        if (this.executor != null) {
            this.executor.terminate();
        }
    }

    public Schema outputSchema(Schema input) {
        return this.func.outputSchema(input);
    }

    public Boolean isAsynchronous() {
        return this.func.isAsynchronous();
    }

    @Override
    public String name() {
        return "POUserFunc(" + this.func.getClass().getName() + ")" + "[" + DataType.findTypeName(this.resultType) + "]" + " - " + this.mKey.toString();
    }

    @Override
    public boolean supportsMultipleInputs() {
        return true;
    }

    @Override
    public boolean supportsMultipleOutputs() {
        return false;
    }

    @Override
    public void visit(PhyPlanVisitor v) throws VisitorException {
        v.visitUserFunc(this);
    }

    public FuncSpec getFuncSpec() {
        return this.funcSpec;
    }

    public String[] getCacheFiles() {
        return this.cacheFiles;
    }

    public void setCacheFiles(String[] cf) {
        this.cacheFiles = cf;
    }

    public boolean combinable() {
        return this.func instanceof Algebraic;
    }

    @Override
    public POUserFunc clone() throws CloneNotSupportedException {
        POUserFunc clone = new POUserFunc(new OperatorKey(this.mKey.scope, NodeIdGenerator.getGenerator().getNextNodeId(this.mKey.scope)), this.requestedParallelism, null, this.funcSpec.clone());
        clone.setResultType(this.resultType);
        return clone;
    }

    private void readObject(ObjectInputStream is) throws IOException, ClassNotFoundException {
        is.defaultReadObject();
        this.instantiateFunc(this.funcSpec);
    }

    @Override
    public List<ExpressionOperator> getChildExpressions() {
        return null;
    }

    @Override
    public void setAccumStart() {
        if (this.isAccumulative() && !this.isAccumStarted()) {
            super.setAccumStart();
            ((Accumulator)((Object)this.func)).cleanup();
        }
    }

    @Override
    public void setResultType(byte resultType) {
        this.resultType = resultType;
    }

    @Override
    public Tuple illustratorMarkup(Object in, Object out, int eqClassIndex) {
        return (Tuple)out;
    }

    public EvalFunc getFunc() {
        return this.func;
    }
}

