/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pig.ExecType;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.datastorage.ConfigurationUtil;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.PhysicalOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.Result;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.ConstantExpression;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhyPlanVisitor;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhysicalPlan;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POForEach;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POLoad;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POLocalRearrange;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataType;
import org.apache.pig.data.NonSpillableDataBag;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.PigContext;
import org.apache.pig.impl.io.FileSpec;
import org.apache.pig.impl.plan.NodeIdGenerator;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.plan.PlanException;
import org.apache.pig.impl.plan.VisitorException;

public class POFRJoin
extends PhysicalOperator {
    private static final Log log = LogFactory.getLog(POFRJoin.class);
    private static final long serialVersionUID = 1L;
    private int fragment;
    private List<List<PhysicalPlan>> phyPlanLists;
    private List<List<Byte>> keyTypes;
    private POLocalRearrange[] LRs;
    private FileSpec[] replFiles;
    private ConstantExpression[] constExps;
    private POForEach fe;
    private Map<Tuple, List<Tuple>>[] replicates;
    private boolean processingPlan;
    private Tuple dumTup = TupleFactory.getInstance().newTuple(1);
    private transient TupleFactory mTupleFactory;
    private boolean setUp;
    private boolean isLeftOuterJoin;
    private DataBag nullBag;

    public POFRJoin(OperatorKey k, int rp, List<PhysicalOperator> inp, List<List<PhysicalPlan>> ppLists, List<List<Byte>> keyTypes, FileSpec[] replFiles, int fragment, boolean isLeftOuter, Tuple nullTuple) throws ExecException {
        super(k, rp, inp);
        this.phyPlanLists = ppLists;
        this.fragment = fragment;
        this.keyTypes = keyTypes;
        this.replFiles = replFiles;
        this.replicates = new Map[ppLists.size()];
        this.LRs = new POLocalRearrange[ppLists.size()];
        this.constExps = new ConstantExpression[ppLists.size()];
        this.createJoinPlans(k);
        this.processingPlan = false;
        this.mTupleFactory = TupleFactory.getInstance();
        ArrayList<Tuple> tupList = new ArrayList<Tuple>();
        tupList.add(nullTuple);
        this.nullBag = new NonSpillableDataBag(tupList);
        this.isLeftOuterJoin = isLeftOuter;
    }

    public List<List<PhysicalPlan>> getJoinPlans() {
        return this.phyPlanLists;
    }

    private OperatorKey genKey(OperatorKey old) {
        return new OperatorKey(old.scope, NodeIdGenerator.getGenerator().getNextNodeId(old.scope));
    }

    private void createJoinPlans(OperatorKey old) throws ExecException {
        ArrayList<PhysicalPlan> fePlans = new ArrayList<PhysicalPlan>();
        ArrayList<Boolean> flatList = new ArrayList<Boolean>();
        int i = -1;
        for (List<PhysicalPlan> ppLst : this.phyPlanLists) {
            POLocalRearrange lr = new POLocalRearrange(this.genKey(old));
            lr.setIndex(++i);
            lr.setResultType((byte)110);
            lr.setKeyType(this.keyTypes.get(i).size() > 1 ? (byte)110 : this.keyTypes.get(i).get(0));
            try {
                lr.setPlans(ppLst);
            }
            catch (PlanException pe) {
                int errCode = 2071;
                String msg = "Problem with setting up local rearrange's plans.";
                throw new ExecException(msg, errCode, 4, pe);
            }
            this.LRs[i] = lr;
            ConstantExpression ce = new ConstantExpression(this.genKey(old));
            ce.setResultType(i == this.fragment ? (byte)110 : 120);
            this.constExps[i] = ce;
            PhysicalPlan pp = new PhysicalPlan();
            pp.add(ce);
            fePlans.add(pp);
            flatList.add(true);
        }
        this.fe = new POForEach(this.genKey(old), -1, fePlans, flatList);
    }

    @Override
    public void visit(PhyPlanVisitor v) throws VisitorException {
        v.visitFRJoin(this);
    }

    @Override
    public String name() {
        return this.getAliasString() + "FRJoin[" + DataType.findTypeName(this.resultType) + "]" + " - " + this.mKey.toString();
    }

    @Override
    public boolean supportsMultipleInputs() {
        return true;
    }

    @Override
    public boolean supportsMultipleOutputs() {
        return false;
    }

    @Override
    public Result getNext(Tuple t) throws ExecException {
        Result res = null;
        Result inp = null;
        if (!this.setUp) {
            this.setUpHashMap();
            this.setUp = true;
        }
        if (this.processingPlan) {
            while (true) {
                res = this.fe.getNext(dummyTuple);
                if (res.returnStatus == 0) {
                    return res;
                }
                if (res.returnStatus == 3) {
                    this.processingPlan = false;
                    break;
                }
                if (res.returnStatus == 2) {
                    return res;
                }
                if (res.returnStatus != 1) continue;
            }
        }
        while (true) {
            inp = this.processInput();
            if (inp.returnStatus == 3 || inp.returnStatus == 2) {
                return inp;
            }
            if (inp.returnStatus == 1) continue;
            POLocalRearrange lr = this.LRs[this.fragment];
            lr.attachInput((Tuple)inp.result);
            Result lrOut = lr.getNext(dummyTuple);
            if (lrOut.returnStatus != 0) {
                log.error((Object)"LocalRearrange isn't configured right or is not working");
                return new Result();
            }
            Tuple lrOutTuple = (Tuple)lrOut.result;
            Tuple key = TupleFactory.getInstance().newTuple(1);
            key.set(0, lrOutTuple.get(1));
            Tuple value = this.getValueTuple(lr, lrOutTuple);
            lr.detachInput();
            int i = -1;
            boolean noMatch = false;
            for (ConstantExpression ce : this.constExps) {
                if (++i == this.fragment) {
                    ce.setValue(value);
                    continue;
                }
                Map<Tuple, List<Tuple>> replicate = this.replicates[i];
                if (!replicate.containsKey(key)) {
                    if (this.isLeftOuterJoin) {
                        ce.setValue(this.nullBag);
                    }
                    noMatch = true;
                    break;
                }
                ce.setValue(new NonSpillableDataBag(replicate.get(key)));
            }
            if (this.isLeftOuterJoin || !noMatch) break;
        }
        this.fe.attachInput(this.dumTup);
        this.processingPlan = true;
        Result gn = this.getNext(dummyTuple);
        return gn;
    }

    private void setUpHashMap() throws ExecException {
        int i = -1;
        long time1 = System.currentTimeMillis();
        for (FileSpec replFile : this.replFiles) {
            if (++i == this.fragment) {
                this.replicates[i] = null;
                continue;
            }
            POLoad ld = new POLoad(new OperatorKey("Repl File Loader", 1L), replFile);
            Properties props = ConfigurationUtil.getLocalFSProperties();
            PigContext pc = new PigContext(ExecType.LOCAL, props);
            ld.setPc(pc);
            POLocalRearrange lr = this.LRs[i];
            lr.setInputs(Arrays.asList(ld));
            HashMap<Tuple, List<Tuple>> replicate = new HashMap<Tuple, List<Tuple>>(1000);
            log.debug((Object)"Completed setup. Trying to build replication hash table");
            int cnt = 0;
            Result res = lr.getNext(dummyTuple);
            while (res.returnStatus != 3) {
                Tuple tuple;
                ++cnt;
                if (reporter != null) {
                    reporter.progress();
                }
                if (!this.isKeyNull((tuple = (Tuple)res.result).get(1))) {
                    Tuple key = this.mTupleFactory.newTuple(1);
                    key.set(0, tuple.get(1));
                    Tuple value = this.getValueTuple(lr, tuple);
                    if (!replicate.containsKey(key)) {
                        replicate.put(key, new ArrayList(1));
                    }
                    ((List)replicate.get(key)).add(value);
                }
                res = lr.getNext(dummyTuple);
            }
            this.replicates[i] = replicate;
        }
        long time2 = System.currentTimeMillis();
        log.debug((Object)("Hash Table built. Time taken: " + (time2 - time1)));
    }

    private boolean isKeyNull(Object key) throws ExecException {
        if (key == null) {
            return true;
        }
        if (key instanceof Tuple) {
            Tuple t = (Tuple)key;
            for (int i = 0; i < t.size(); ++i) {
                if (!t.isNull(i)) continue;
                return true;
            }
        }
        return false;
    }

    private void readObject(ObjectInputStream is) throws IOException, ClassNotFoundException, ExecException {
        is.defaultReadObject();
        this.mTupleFactory = TupleFactory.getInstance();
    }

    private Tuple getValueTuple(POLocalRearrange lr, Tuple tuple) throws ExecException {
        Tuple keyAsTuple;
        Tuple val = (Tuple)tuple.get(2);
        Tuple retTup = null;
        boolean isProjectStar = lr.isProjectStar();
        Map<Integer, Integer> keyLookup = lr.getProjectedColsMap();
        int keyLookupSize = keyLookup.size();
        Object key = tuple.get(1);
        boolean isKeyTuple = lr.isKeyTuple();
        Tuple tuple2 = keyAsTuple = isKeyTuple ? (Tuple)tuple.get(1) : null;
        if (keyLookupSize > 0) {
            int finalValueSize = keyLookupSize + val.size();
            retTup = this.mTupleFactory.newTuple(finalValueSize);
            int valIndex = 0;
            for (int i = 0; i < finalValueSize; ++i) {
                Integer keyIndex = keyLookup.get(i);
                if (keyIndex == null) {
                    retTup.set(i, val.get(valIndex));
                    ++valIndex;
                    continue;
                }
                if (isKeyTuple) {
                    retTup.set(i, keyAsTuple.get(keyIndex));
                    continue;
                }
                retTup.set(i, key);
            }
        } else {
            retTup = isProjectStar ? this.mTupleFactory.newTuple(keyAsTuple.getAll()) : this.mTupleFactory.newTuple(val.getAll());
        }
        return retTup;
    }

    public int getFragment() {
        return this.fragment;
    }

    public void setFragment(int fragment) {
        this.fragment = fragment;
    }

    public FileSpec[] getReplFiles() {
        return this.replFiles;
    }

    public void setReplFiles(FileSpec[] replFiles) {
        this.replFiles = replFiles;
    }

    @Override
    public Tuple illustratorMarkup(Object in, Object out, int eqClassIndex) {
        return null;
    }
}

