/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators;

import java.util.List;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.PhysicalOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.Result;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhyPlanVisitor;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.plan.NodeIdGenerator;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.plan.VisitorException;
import org.apache.pig.pen.util.ExampleTuple;

public class POLimit
extends PhysicalOperator {
    private static final long serialVersionUID = 1L;
    private long soFar = 0L;
    long mLimit;

    public POLimit(OperatorKey k) {
        this(k, -1, null);
    }

    public POLimit(OperatorKey k, int rp) {
        this(k, rp, null);
    }

    public POLimit(OperatorKey k, List<PhysicalOperator> inputs) {
        this(k, -1, inputs);
    }

    public POLimit(OperatorKey k, int rp, List<PhysicalOperator> inputs) {
        super(k, rp, inputs);
    }

    public void setLimit(long limit) {
        this.mLimit = limit;
    }

    public long getLimit() {
        return this.mLimit;
    }

    @Override
    public Result getNext(Tuple t) throws ExecException {
        Object res = null;
        Result inp = null;
        inp = this.processInput();
        if (inp.returnStatus != 3 && inp.returnStatus != 2) {
            this.illustratorMarkup(inp.result, null, 0);
            if ((this.illustrator == null || this.illustrator.getOriginalLimit() != -1L) && this.soFar >= this.mLimit) {
                inp.returnStatus = (byte)3;
            }
            ++this.soFar;
        }
        return inp;
    }

    @Override
    public String name() {
        return this.getAliasString() + "Limit - " + this.mKey.toString();
    }

    @Override
    public boolean supportsMultipleInputs() {
        return false;
    }

    @Override
    public boolean supportsMultipleOutputs() {
        return false;
    }

    @Override
    public void visit(PhyPlanVisitor v) throws VisitorException {
        v.visitLimit(this);
    }

    @Override
    public void reset() {
        this.soFar = 0L;
    }

    @Override
    public POLimit clone() throws CloneNotSupportedException {
        POLimit newLimit = new POLimit(new OperatorKey(this.mKey.scope, NodeIdGenerator.getGenerator().getNextNodeId(this.mKey.scope)), this.requestedParallelism, this.inputs);
        newLimit.mLimit = this.mLimit;
        newLimit.setAlias(this.alias);
        return newLimit;
    }

    @Override
    public Tuple illustratorMarkup(Object in, Object out, int eqClassIndex) {
        if (this.illustrator != null) {
            ExampleTuple tIn = (ExampleTuple)in;
            this.illustrator.getEquivalenceClasses().get(eqClassIndex).add(tIn);
            this.illustrator.addData((Tuple)in);
        }
        return (Tuple)in;
    }
}

