/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.builtin;

import java.io.IOException;
import org.apache.pig.Accumulator;
import org.apache.pig.Algebraic;
import org.apache.pig.EvalFunc;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.logicalLayer.schema.Schema;

public class FloatMin
extends EvalFunc<Float>
implements Algebraic,
Accumulator<Float> {
    private Float intermediateMin = null;

    @Override
    public Float exec(Tuple input) throws IOException {
        try {
            return FloatMin.min(input);
        }
        catch (ExecException ee) {
            throw ee;
        }
        catch (Exception e) {
            int errCode = 2106;
            String msg = "Error while computing min in " + this.getClass().getSimpleName();
            throw new ExecException(msg, errCode, 4, e);
        }
    }

    @Override
    public String getInitial() {
        return Initial.class.getName();
    }

    @Override
    public String getIntermed() {
        return Intermediate.class.getName();
    }

    @Override
    public String getFinal() {
        return Final.class.getName();
    }

    protected static Float min(Tuple input) throws ExecException {
        DataBag values = (DataBag)input.get(0);
        if (values.size() == 0L) {
            return null;
        }
        float curMin = Float.POSITIVE_INFINITY;
        boolean sawNonNull = false;
        for (Tuple t : values) {
            try {
                Float f = (Float)t.get(0);
                if (f == null) continue;
                sawNonNull = true;
                curMin = Math.min(curMin, f.floatValue());
            }
            catch (RuntimeException exp) {
                int errCode = 2103;
                String msg = "Problem while computing min of floats.";
                throw new ExecException(msg, errCode, 4, exp);
            }
        }
        if (sawNonNull) {
            return new Float(curMin);
        }
        return null;
    }

    @Override
    public Schema outputSchema(Schema input) {
        return new Schema(new Schema.FieldSchema(null, 20));
    }

    @Override
    public void accumulate(Tuple b) throws IOException {
        try {
            Float curMin = FloatMin.min(b);
            if (curMin == null) {
                return;
            }
            if (this.intermediateMin == null) {
                this.intermediateMin = Float.valueOf(Float.POSITIVE_INFINITY);
            }
            this.intermediateMin = Float.valueOf(Math.min(this.intermediateMin.floatValue(), curMin.floatValue()));
        }
        catch (ExecException ee) {
            throw ee;
        }
        catch (Exception e) {
            int errCode = 2106;
            String msg = "Error while computing min in " + this.getClass().getSimpleName();
            throw new ExecException(msg, errCode, 4, e);
        }
    }

    @Override
    public void cleanup() {
        this.intermediateMin = null;
    }

    @Override
    public Float getValue() {
        return this.intermediateMin;
    }

    public static class Final
    extends EvalFunc<Float> {
        @Override
        public Float exec(Tuple input) throws IOException {
            try {
                return FloatMin.min(input);
            }
            catch (ExecException ee) {
                throw ee;
            }
            catch (Exception e) {
                int errCode = 2106;
                String msg = "Error while computing min in " + this.getClass().getSimpleName();
                throw new ExecException(msg, errCode, 4, e);
            }
        }
    }

    public static class Intermediate
    extends EvalFunc<Tuple> {
        private static TupleFactory tfact = TupleFactory.getInstance();

        @Override
        public Tuple exec(Tuple input) throws IOException {
            try {
                return tfact.newTuple(FloatMin.min(input));
            }
            catch (ExecException ee) {
                throw ee;
            }
            catch (Exception e) {
                int errCode = 2106;
                String msg = "Error while computing min in " + this.getClass().getSimpleName();
                throw new ExecException(msg, errCode, 4, e);
            }
        }
    }

    public static class Initial
    extends EvalFunc<Tuple> {
        private static TupleFactory tfact = TupleFactory.getInstance();

        @Override
        public Tuple exec(Tuple input) throws IOException {
            try {
                DataBag bg = (DataBag)input.get(0);
                Float f = null;
                if (bg.iterator().hasNext()) {
                    Tuple tp = bg.iterator().next();
                    f = (Float)tp.get(0);
                }
                return tfact.newTuple(f);
            }
            catch (ExecException ee) {
                throw ee;
            }
            catch (Exception e) {
                int errCode = 2106;
                String msg = "Error while computing min in " + this.getClass().getSimpleName();
                throw new ExecException(msg, errCode, 4, e);
            }
        }
    }
}

