/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.builtin;

import java.io.IOException;
import org.apache.pig.Accumulator;
import org.apache.pig.Algebraic;
import org.apache.pig.EvalFunc;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.logicalLayer.schema.Schema;

public class FloatSum
extends EvalFunc<Double>
implements Algebraic,
Accumulator<Double> {
    private Double intermediateSum = null;

    @Override
    public Double exec(Tuple input) throws IOException {
        try {
            return FloatSum.sum(input);
        }
        catch (ExecException ee) {
            throw ee;
        }
        catch (Exception e) {
            int errCode = 2106;
            String msg = "Error while computing sum in " + this.getClass().getSimpleName();
            throw new ExecException(msg, errCode, 4, e);
        }
    }

    @Override
    public String getInitial() {
        return Initial.class.getName();
    }

    @Override
    public String getIntermed() {
        return Intermediate.class.getName();
    }

    @Override
    public String getFinal() {
        return Final.class.getName();
    }

    protected static Double sumDoubles(Tuple input) throws ExecException {
        DataBag values = (DataBag)input.get(0);
        if (values.size() == 0L) {
            return null;
        }
        double sum = 0.0;
        boolean sawNonNull = false;
        for (Tuple t : values) {
            try {
                Double d = (Double)t.get(0);
                if (d == null) continue;
                sawNonNull = true;
                sum += d.doubleValue();
            }
            catch (RuntimeException exp) {
                ExecException newE = new ExecException("Error processing: " + t.toString() + exp.getMessage(), exp);
                throw newE;
            }
        }
        if (sawNonNull) {
            return new Double(sum);
        }
        return null;
    }

    protected static Double sum(Tuple input) throws ExecException {
        DataBag values = (DataBag)input.get(0);
        if (values.size() == 0L) {
            return null;
        }
        double sum = 0.0;
        boolean sawNonNull = false;
        for (Tuple t : values) {
            try {
                Float f = (Float)t.get(0);
                if (f == null) continue;
                sawNonNull = true;
                sum += (double)f.floatValue();
            }
            catch (RuntimeException exp) {
                int errCode = 2103;
                String msg = "Problem while computing sum of floats.";
                throw new ExecException(msg, errCode, 4, exp);
            }
        }
        if (sawNonNull) {
            return new Double(sum);
        }
        return null;
    }

    @Override
    public Schema outputSchema(Schema input) {
        return new Schema(new Schema.FieldSchema(null, 25));
    }

    @Override
    public void accumulate(Tuple b) throws IOException {
        try {
            Double curSum = FloatSum.sum(b);
            if (curSum == null) {
                return;
            }
            this.intermediateSum = (this.intermediateSum == null ? 0.0 : this.intermediateSum) + curSum;
        }
        catch (ExecException ee) {
            throw ee;
        }
        catch (Exception e) {
            int errCode = 2106;
            String msg = "Error while computing min in " + this.getClass().getSimpleName();
            throw new ExecException(msg, errCode, 4, e);
        }
    }

    @Override
    public void cleanup() {
        this.intermediateSum = null;
    }

    @Override
    public Double getValue() {
        return this.intermediateSum;
    }

    public static class Final
    extends EvalFunc<Double> {
        @Override
        public Double exec(Tuple input) throws IOException {
            try {
                return FloatSum.sumDoubles(input);
            }
            catch (ExecException ee) {
                throw ee;
            }
            catch (Exception e) {
                int errCode = 2106;
                String msg = "Error while computing sum in " + this.getClass().getSimpleName();
                throw new ExecException(msg, errCode, 4, e);
            }
        }
    }

    public static class Intermediate
    extends EvalFunc<Tuple> {
        private static TupleFactory tfact = TupleFactory.getInstance();

        @Override
        public Tuple exec(Tuple input) throws IOException {
            try {
                return tfact.newTuple(FloatSum.sumDoubles(input));
            }
            catch (ExecException ee) {
                throw ee;
            }
            catch (Exception e) {
                int errCode = 2106;
                String msg = "Error while computing sum in " + this.getClass().getSimpleName();
                throw new ExecException(msg, errCode, 4, e);
            }
        }
    }

    public static class Initial
    extends EvalFunc<Tuple> {
        private static TupleFactory tfact = TupleFactory.getInstance();

        @Override
        public Tuple exec(Tuple input) throws IOException {
            try {
                DataBag bg = (DataBag)input.get(0);
                Float f = null;
                if (bg.iterator().hasNext()) {
                    Tuple tp = bg.iterator().next();
                    f = (Float)tp.get(0);
                }
                return tfact.newTuple(f != null ? new Double(f.floatValue()) : null);
            }
            catch (ExecException e) {
                throw e;
            }
            catch (Exception e) {
                int errCode = 2106;
                String msg = "Error while computing sum in " + this.getClass().getSimpleName();
                throw new ExecException(msg, errCode, 4, e);
            }
        }
    }
}

