/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.builtin;

import java.io.IOException;
import org.apache.pig.Accumulator;
import org.apache.pig.Algebraic;
import org.apache.pig.EvalFunc;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.logicalLayer.schema.Schema;

public class IntMax
extends EvalFunc<Integer>
implements Algebraic,
Accumulator<Integer> {
    private Integer intermediateMax = null;

    @Override
    public Integer exec(Tuple input) throws IOException {
        try {
            return IntMax.max(input);
        }
        catch (ExecException ee) {
            throw ee;
        }
        catch (Exception e) {
            int errCode = 2106;
            String msg = "Error while computing max in " + this.getClass().getSimpleName();
            throw new ExecException(msg, errCode, 4, e);
        }
    }

    @Override
    public String getInitial() {
        return Initial.class.getName();
    }

    @Override
    public String getIntermed() {
        return Intermediate.class.getName();
    }

    @Override
    public String getFinal() {
        return Final.class.getName();
    }

    protected static Integer max(Tuple input) throws ExecException {
        DataBag values = (DataBag)input.get(0);
        if (values.size() == 0L) {
            return null;
        }
        int curMax = Integer.MIN_VALUE;
        boolean sawNonNull = false;
        for (Tuple t : values) {
            try {
                Integer i = (Integer)t.get(0);
                if (i == null) continue;
                sawNonNull = true;
                curMax = Math.max(curMax, i);
            }
            catch (RuntimeException exp) {
                int errCode = 2103;
                String msg = "Problem while computing max of ints.";
                throw new ExecException(msg, errCode, 4, exp);
            }
        }
        if (sawNonNull) {
            return curMax;
        }
        return null;
    }

    @Override
    public Schema outputSchema(Schema input) {
        return new Schema(new Schema.FieldSchema(null, 10));
    }

    @Override
    public void accumulate(Tuple b) throws IOException {
        try {
            Integer curMax = IntMax.max(b);
            if (curMax == null) {
                return;
            }
            if (this.intermediateMax == null) {
                this.intermediateMax = Integer.MIN_VALUE;
            }
            this.intermediateMax = Math.max(this.intermediateMax, curMax);
        }
        catch (ExecException ee) {
            throw ee;
        }
        catch (Exception e) {
            int errCode = 2106;
            String msg = "Error while computing max in " + this.getClass().getSimpleName();
            throw new ExecException(msg, errCode, 4, e);
        }
    }

    @Override
    public void cleanup() {
        this.intermediateMax = null;
    }

    @Override
    public Integer getValue() {
        return this.intermediateMax;
    }

    public static class Final
    extends EvalFunc<Integer> {
        @Override
        public Integer exec(Tuple input) throws IOException {
            try {
                return IntMax.max(input);
            }
            catch (ExecException ee) {
                throw ee;
            }
            catch (Exception e) {
                int errCode = 2106;
                String msg = "Error while computing max in " + this.getClass().getSimpleName();
                throw new ExecException(msg, errCode, 4, e);
            }
        }
    }

    public static class Intermediate
    extends EvalFunc<Tuple> {
        private static TupleFactory tfact = TupleFactory.getInstance();

        @Override
        public Tuple exec(Tuple input) throws IOException {
            try {
                return tfact.newTuple(IntMax.max(input));
            }
            catch (ExecException ee) {
                throw ee;
            }
            catch (Exception e) {
                int errCode = 2106;
                String msg = "Error while computing max in " + this.getClass().getSimpleName();
                throw new ExecException(msg, errCode, 4, e);
            }
        }
    }

    public static class Initial
    extends EvalFunc<Tuple> {
        private static TupleFactory tfact = TupleFactory.getInstance();

        @Override
        public Tuple exec(Tuple input) throws IOException {
            try {
                DataBag bg = (DataBag)input.get(0);
                Integer i = null;
                if (bg.iterator().hasNext()) {
                    Tuple tp = bg.iterator().next();
                    i = (Integer)tp.get(0);
                }
                return tfact.newTuple(i);
            }
            catch (ExecException ee) {
                throw ee;
            }
            catch (Exception e) {
                int errCode = 2106;
                String msg = "Error while computing max in " + this.getClass().getSimpleName();
                throw new ExecException(msg, errCode, 4, e);
            }
        }
    }
}

