/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.builtin;

import java.io.IOException;
import org.apache.pig.Accumulator;
import org.apache.pig.Algebraic;
import org.apache.pig.EvalFunc;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.logicalLayer.schema.Schema;

public class LongSum
extends EvalFunc<Long>
implements Algebraic,
Accumulator<Long> {
    private Long intermediateSum = null;

    @Override
    public Long exec(Tuple input) throws IOException {
        try {
            return LongSum.sum(input);
        }
        catch (ExecException ee) {
            throw ee;
        }
        catch (Exception e) {
            int errCode = 2106;
            String msg = "Error while computing sum in " + this.getClass().getSimpleName();
            throw new ExecException(msg, errCode, 4, e);
        }
    }

    @Override
    public String getInitial() {
        return Initial.class.getName();
    }

    @Override
    public String getIntermed() {
        return Intermediate.class.getName();
    }

    @Override
    public String getFinal() {
        return Final.class.getName();
    }

    protected static Long sum(Tuple input) throws ExecException {
        DataBag values = (DataBag)input.get(0);
        if (values.size() == 0L) {
            return null;
        }
        long sum = 0L;
        boolean sawNonNull = false;
        for (Tuple t : values) {
            try {
                Long l = (Long)t.get(0);
                if (l == null) continue;
                sawNonNull = true;
                sum += l.longValue();
            }
            catch (RuntimeException exp) {
                int errCode = 2103;
                String msg = "Problem while computing sum of longs.";
                throw new ExecException(msg, errCode, 4, exp);
            }
        }
        if (sawNonNull) {
            return sum;
        }
        return null;
    }

    @Override
    public Schema outputSchema(Schema input) {
        return new Schema(new Schema.FieldSchema(null, 15));
    }

    @Override
    public void accumulate(Tuple b) throws IOException {
        try {
            Long curSum = LongSum.sum(b);
            if (curSum == null) {
                return;
            }
            this.intermediateSum = (this.intermediateSum == null ? 0L : this.intermediateSum) + curSum;
        }
        catch (ExecException ee) {
            throw ee;
        }
        catch (Exception e) {
            int errCode = 2106;
            String msg = "Error while computing min in " + this.getClass().getSimpleName();
            throw new ExecException(msg, errCode, 4, e);
        }
    }

    @Override
    public void cleanup() {
        this.intermediateSum = null;
    }

    @Override
    public Long getValue() {
        return this.intermediateSum;
    }

    public static class Final
    extends EvalFunc<Long> {
        @Override
        public Long exec(Tuple input) throws IOException {
            try {
                return LongSum.sum(input);
            }
            catch (ExecException ee) {
                throw ee;
            }
            catch (Exception e) {
                int errCode = 2106;
                String msg = "Error while computing sum in " + this.getClass().getSimpleName();
                throw new ExecException(msg, errCode, 4, e);
            }
        }
    }

    public static class Intermediate
    extends EvalFunc<Tuple> {
        private static TupleFactory tfact = TupleFactory.getInstance();

        @Override
        public Tuple exec(Tuple input) throws IOException {
            try {
                return tfact.newTuple(LongSum.sum(input));
            }
            catch (ExecException ee) {
                throw ee;
            }
            catch (Exception e) {
                int errCode = 2106;
                String msg = "Error while computing sum in " + this.getClass().getSimpleName();
                throw new ExecException(msg, errCode, 4, e);
            }
        }
    }

    public static class Initial
    extends EvalFunc<Tuple> {
        private static TupleFactory tfact = TupleFactory.getInstance();

        @Override
        public Tuple exec(Tuple input) throws IOException {
            try {
                DataBag bg = (DataBag)input.get(0);
                Long l = null;
                if (bg.iterator().hasNext()) {
                    Tuple tp = bg.iterator().next();
                    l = (Long)tp.get(0);
                }
                return tfact.newTuple(l);
            }
            catch (ExecException e) {
                throw e;
            }
            catch (Exception e) {
                int errCode = 2106;
                String msg = "Error while computing sum in " + this.getClass().getSimpleName();
                throw new ExecException(msg, errCode, 4, e);
            }
        }
    }
}

