/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.builtin;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.compress.BZip2Codec;
import org.apache.hadoop.io.compress.GzipCodec;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.pig.FileInputLoadFunc;
import org.apache.pig.LoadFunc;
import org.apache.pig.LoadPushDown;
import org.apache.pig.ResourceSchema;
import org.apache.pig.StoreFunc;
import org.apache.pig.StoreFuncInterface;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigSplit;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigTextInputFormat;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigTextOutputFormat;
import org.apache.pig.bzip2r.Bzip2TextInputFormat;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.util.ObjectSerializer;
import org.apache.pig.impl.util.StorageUtil;
import org.apache.pig.impl.util.UDFContext;

public class PigStorage
extends FileInputLoadFunc
implements StoreFuncInterface,
LoadPushDown {
    protected RecordReader in = null;
    protected RecordWriter writer = null;
    protected final Log mLog = LogFactory.getLog(this.getClass());
    protected String signature;
    private byte fieldDel = (byte)9;
    private ArrayList<Object> mProtoTuple = null;
    private TupleFactory mTupleFactory = TupleFactory.getInstance();
    private String loadLocation;
    protected boolean[] mRequiredColumns = null;
    private boolean mRequiredColumnsInitialized = false;

    public PigStorage() {
    }

    public PigStorage(String delimiter) {
        this();
        this.fieldDel = StorageUtil.parseFieldDel(delimiter);
    }

    @Override
    public Tuple getNext() throws IOException {
        this.mProtoTuple = new ArrayList();
        if (!this.mRequiredColumnsInitialized) {
            if (this.signature != null) {
                Properties p = UDFContext.getUDFContext().getUDFProperties(this.getClass());
                this.mRequiredColumns = (boolean[])ObjectSerializer.deserialize(p.getProperty(this.signature));
            }
            this.mRequiredColumnsInitialized = true;
        }
        try {
            boolean notDone = this.in.nextKeyValue();
            if (!notDone) {
                return null;
            }
            Text value = (Text)this.in.getCurrentValue();
            byte[] buf = value.getBytes();
            int len = value.getLength();
            int start = 0;
            int fieldID = 0;
            for (int i = 0; i < len; ++i) {
                if (buf[i] != this.fieldDel) continue;
                if (this.mRequiredColumns == null || this.mRequiredColumns.length > fieldID && this.mRequiredColumns[fieldID]) {
                    this.readField(buf, start, i);
                }
                start = i + 1;
                ++fieldID;
            }
            if (start <= len && (this.mRequiredColumns == null || this.mRequiredColumns.length > fieldID && this.mRequiredColumns[fieldID])) {
                this.readField(buf, start, len);
            }
            Tuple t = this.mTupleFactory.newTupleNoCopy(this.mProtoTuple);
            return t;
        }
        catch (InterruptedException e) {
            int errCode = 6018;
            String errMsg = "Error while reading input";
            throw new ExecException(errMsg, errCode, 16, e);
        }
    }

    @Override
    public void putNext(Tuple f) throws IOException {
        try {
            this.writer.write(null, (Object)f);
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    private void readField(byte[] buf, int start, int end) {
        if (start == end) {
            this.mProtoTuple.add(null);
        } else {
            this.mProtoTuple.add(new DataByteArray(buf, start, end));
        }
    }

    @Override
    public LoadPushDown.RequiredFieldResponse pushProjection(LoadPushDown.RequiredFieldList requiredFieldList) throws FrontendException {
        if (requiredFieldList == null) {
            return null;
        }
        if (requiredFieldList.getFields() != null) {
            int lastColumn = -1;
            for (LoadPushDown.RequiredField rf : requiredFieldList.getFields()) {
                if (rf.getIndex() <= lastColumn) continue;
                lastColumn = rf.getIndex();
            }
            this.mRequiredColumns = new boolean[lastColumn + 1];
            for (LoadPushDown.RequiredField rf : requiredFieldList.getFields()) {
                if (rf.getIndex() == -1) continue;
                this.mRequiredColumns[rf.getIndex()] = true;
            }
            Properties p = UDFContext.getUDFContext().getUDFProperties(this.getClass());
            try {
                p.setProperty(this.signature, ObjectSerializer.serialize((Serializable)this.mRequiredColumns));
            }
            catch (Exception e) {
                throw new RuntimeException("Cannot serialize mRequiredColumns");
            }
        }
        return new LoadPushDown.RequiredFieldResponse(true);
    }

    public boolean equals(Object obj) {
        if (obj instanceof PigStorage) {
            return this.equals((PigStorage)obj);
        }
        return false;
    }

    public boolean equals(PigStorage other) {
        return this.fieldDel == other.fieldDel;
    }

    @Override
    public InputFormat getInputFormat() {
        if (this.loadLocation.endsWith(".bz2") || this.loadLocation.endsWith(".bz")) {
            return new Bzip2TextInputFormat();
        }
        return new PigTextInputFormat();
    }

    @Override
    public void prepareToRead(RecordReader reader, PigSplit split) {
        this.in = reader;
    }

    @Override
    public void setLocation(String location, Job job) throws IOException {
        this.loadLocation = location;
        FileInputFormat.setInputPaths((Job)job, (String)location);
    }

    @Override
    public OutputFormat getOutputFormat() {
        return new PigTextOutputFormat(this.fieldDel);
    }

    @Override
    public void prepareToWrite(RecordWriter writer) {
        this.writer = writer;
    }

    @Override
    public void setStoreLocation(String location, Job job) throws IOException {
        job.getConfiguration().set("mapred.textoutputformat.separator", "");
        FileOutputFormat.setOutputPath((Job)job, (Path)new Path(location));
        if ("true".equals(job.getConfiguration().get("output.compression.enabled"))) {
            FileOutputFormat.setCompressOutput((Job)job, (boolean)true);
            String codec = job.getConfiguration().get("output.compression.codec");
            try {
                FileOutputFormat.setOutputCompressorClass((Job)job, Class.forName(codec));
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Class not found: " + codec);
            }
        } else if (location.endsWith(".bz2") || location.endsWith(".bz")) {
            FileOutputFormat.setCompressOutput((Job)job, (boolean)true);
            FileOutputFormat.setOutputCompressorClass((Job)job, BZip2Codec.class);
        } else if (location.endsWith(".gz")) {
            FileOutputFormat.setCompressOutput((Job)job, (boolean)true);
            FileOutputFormat.setOutputCompressorClass((Job)job, GzipCodec.class);
        } else {
            FileOutputFormat.setCompressOutput((Job)job, (boolean)false);
        }
    }

    @Override
    public void checkSchema(ResourceSchema s) throws IOException {
    }

    @Override
    public String relToAbsPathForStoreLocation(String location, Path curDir) throws IOException {
        return LoadFunc.getAbsolutePath(location, curDir);
    }

    public int hashCode() {
        return this.fieldDel;
    }

    @Override
    public void setUDFContextSignature(String signature) {
        this.signature = signature;
    }

    @Override
    public List<LoadPushDown.OperatorSet> getFeatures() {
        return Arrays.asList(LoadPushDown.OperatorSet.PROJECTION);
    }

    @Override
    public void setStoreFuncUDFContextSignature(String signature) {
    }

    @Override
    public void cleanupOnFailure(String location, Job job) throws IOException {
        StoreFunc.cleanupOnFailureImpl(location, job);
    }
}

