/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.builtin;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.pig.Accumulator;
import org.apache.pig.Algebraic;
import org.apache.pig.EvalFunc;
import org.apache.pig.FuncSpec;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.builtin.DoubleSum;
import org.apache.pig.builtin.FloatSum;
import org.apache.pig.builtin.IntSum;
import org.apache.pig.builtin.LongSum;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.schema.Schema;

public class SUM
extends EvalFunc<Double>
implements Algebraic,
Accumulator<Double> {
    private Double intermediateSum = null;

    @Override
    public Double exec(Tuple input) throws IOException {
        try {
            return SUM.sum(input);
        }
        catch (ExecException ee) {
            throw ee;
        }
        catch (Exception e) {
            int errCode = 2106;
            String msg = "Error while computing sum in " + this.getClass().getSimpleName();
            throw new ExecException(msg, errCode, 4, e);
        }
    }

    @Override
    public String getInitial() {
        return Initial.class.getName();
    }

    @Override
    public String getIntermed() {
        return Intermediate.class.getName();
    }

    @Override
    public String getFinal() {
        return Final.class.getName();
    }

    protected static Double sum(Tuple input) throws ExecException {
        DataBag values = (DataBag)input.get(0);
        if (values.size() == 0L) {
            return null;
        }
        double sum = 0.0;
        boolean sawNonNull = false;
        for (Tuple t : values) {
            try {
                Double d;
                DataByteArray dba = (DataByteArray)t.get(0);
                Double d2 = d = dba != null ? Double.valueOf(dba.toString()) : null;
                if (d == null) continue;
                sawNonNull = true;
                sum += d.doubleValue();
            }
            catch (RuntimeException exp) {
                int errCode = 2103;
                String msg = "Problem while computing sum of doubles.";
                throw new ExecException(msg, errCode, 4, exp);
            }
        }
        if (sawNonNull) {
            return new Double(sum);
        }
        return null;
    }

    protected static Double sumDoubles(Tuple input) throws ExecException {
        DataBag values = (DataBag)input.get(0);
        if (values.size() == 0L) {
            return null;
        }
        double sum = 0.0;
        boolean sawNonNull = false;
        for (Tuple t : values) {
            try {
                Double d = (Double)t.get(0);
                if (d == null) continue;
                sawNonNull = true;
                sum += d.doubleValue();
            }
            catch (RuntimeException exp) {
                int errCode = 2103;
                String msg = "Problem while computing sum of doubles.";
                throw new ExecException(msg, errCode, 4, exp);
            }
        }
        if (sawNonNull) {
            return new Double(sum);
        }
        return null;
    }

    @Override
    public Schema outputSchema(Schema input) {
        return new Schema(new Schema.FieldSchema(null, 25));
    }

    @Override
    public List<FuncSpec> getArgToFuncMapping() throws FrontendException {
        ArrayList<FuncSpec> funcList = new ArrayList<FuncSpec>();
        funcList.add(new FuncSpec(this.getClass().getName(), Schema.generateNestedSchema((byte)120, 50)));
        funcList.add(new FuncSpec(DoubleSum.class.getName(), Schema.generateNestedSchema((byte)120, 25)));
        funcList.add(new FuncSpec(FloatSum.class.getName(), Schema.generateNestedSchema((byte)120, 20)));
        funcList.add(new FuncSpec(IntSum.class.getName(), Schema.generateNestedSchema((byte)120, 10)));
        funcList.add(new FuncSpec(LongSum.class.getName(), Schema.generateNestedSchema((byte)120, 15)));
        return funcList;
    }

    @Override
    public void accumulate(Tuple b) throws IOException {
        try {
            Double curSum = SUM.sum(b);
            if (curSum == null) {
                return;
            }
            this.intermediateSum = (this.intermediateSum == null ? 0.0 : this.intermediateSum) + curSum;
        }
        catch (ExecException ee) {
            throw ee;
        }
        catch (Exception e) {
            int errCode = 2106;
            String msg = "Error while computing sum in " + this.getClass().getSimpleName();
            throw new ExecException(msg, errCode, 4, e);
        }
    }

    @Override
    public void cleanup() {
        this.intermediateSum = null;
    }

    @Override
    public Double getValue() {
        return this.intermediateSum;
    }

    public static class Final
    extends EvalFunc<Double> {
        @Override
        public Double exec(Tuple input) throws IOException {
            try {
                return SUM.sumDoubles(input);
            }
            catch (ExecException ee) {
                throw ee;
            }
            catch (Exception e) {
                int errCode = 2106;
                String msg = "Error while computing sum in " + this.getClass().getSimpleName();
                throw new ExecException(msg, errCode, 4, e);
            }
        }
    }

    public static class Intermediate
    extends EvalFunc<Tuple> {
        private static TupleFactory tfact = TupleFactory.getInstance();

        @Override
        public Tuple exec(Tuple input) throws IOException {
            try {
                return tfact.newTuple(SUM.sumDoubles(input));
            }
            catch (ExecException ee) {
                throw ee;
            }
            catch (Exception e) {
                int errCode = 2106;
                String msg = "Error while computing sum in " + this.getClass().getSimpleName();
                throw new ExecException(msg, errCode, 4, e);
            }
        }
    }

    public static class Initial
    extends EvalFunc<Tuple> {
        private static TupleFactory tfact = TupleFactory.getInstance();

        @Override
        public Tuple exec(Tuple input) throws IOException {
            try {
                DataBag bg = (DataBag)input.get(0);
                DataByteArray dba = null;
                if (bg.iterator().hasNext()) {
                    Tuple tp = bg.iterator().next();
                    dba = (DataByteArray)tp.get(0);
                }
                return tfact.newTuple(dba != null ? Double.valueOf(dba.toString()) : null);
            }
            catch (NumberFormatException nfe) {
                Tuple t = tfact.newTuple(1);
                t.set(0, null);
                return t;
            }
            catch (ExecException e) {
                throw e;
            }
            catch (Exception e) {
                int errCode = 2106;
                String msg = "Error while computing sum in " + this.getClass().getSimpleName();
                throw new ExecException(msg, errCode, 4, e);
            }
        }
    }
}

