/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.builtin;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PushbackInputStream;
import java.util.Arrays;
import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pig.LoadStoreCaster;
import org.apache.pig.PigWarning;
import org.apache.pig.ResourceSchema;
import org.apache.pig.data.BagFactory;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.DataType;
import org.apache.pig.data.DefaultBagFactory;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.util.LogUtils;

public class Utf8StorageConverter
implements LoadStoreCaster {
    protected BagFactory mBagFactory = BagFactory.getInstance();
    protected TupleFactory mTupleFactory = TupleFactory.getInstance();
    protected final Log mLog = LogFactory.getLog(this.getClass());
    private static final Integer mMaxInt = Integer.MAX_VALUE;
    private static final Integer mMinInt = Integer.MIN_VALUE;
    private static final Long mMaxLong = Long.MAX_VALUE;
    private static final Long mMinLong = Long.MIN_VALUE;
    private static final int BUFFER_SIZE = 1024;

    private char findStartChar(char start) throws IOException {
        switch (start) {
            case ')': {
                return '(';
            }
            case ']': {
                return '[';
            }
            case '}': {
                return '{';
            }
        }
        throw new IOException("Unknown start character");
    }

    private DataBag consumeBag(PushbackInputStream in, ResourceSchema.ResourceFieldSchema fieldSchema) throws IOException {
        int buf;
        if (fieldSchema == null) {
            throw new IOException("Schema is null");
        }
        ResourceSchema.ResourceFieldSchema[] fss = fieldSchema.getSchema().getFields();
        while ((buf = in.read()) != 123) {
            if (buf != -1) continue;
            throw new IOException("Unexpect end of bag");
        }
        if (fss.length != 1) {
            throw new IOException("Only tuple is allowed inside bag schema");
        }
        ResourceSchema.ResourceFieldSchema fs = fss[0];
        DataBag db = DefaultBagFactory.getInstance().newDefaultBag();
        do {
            Tuple t;
            if ((t = this.consumeTuple(in, fs)) != null) {
                db.add(t);
            }
            while ((buf = in.read()) != 125 && buf != 44) {
                if (buf != -1) continue;
                throw new IOException("Unexpect end of bag");
            }
        } while (buf != 125);
        return db;
    }

    private Tuple consumeTuple(PushbackInputStream in, ResourceSchema.ResourceFieldSchema fieldSchema) throws IOException {
        int buf;
        if (fieldSchema == null) {
            throw new IOException("Schema is null");
        }
        while ((buf = in.read()) != 40 || buf == 125) {
            if (buf == -1) {
                throw new IOException("Unexpect end of tuple");
            }
            if (buf != 125) continue;
            in.unread(buf);
            return null;
        }
        Tuple t = TupleFactory.getInstance().newTuple();
        if (fieldSchema.getSchema() != null && fieldSchema.getSchema().getFields().length != 0) {
            ResourceSchema.ResourceFieldSchema[] fss = fieldSchema.getSchema().getFields();
            for (int i = 0; i < fss.length; ++i) {
                Object field;
                ResourceSchema.ResourceFieldSchema fs = fss[i];
                int delimit = 44;
                if (i == fss.length - 1) {
                    delimit = 41;
                }
                if (DataType.isComplex(fs.getType())) {
                    field = this.consumeComplexType(in, fs);
                    while ((buf = in.read()) != delimit) {
                        if (buf != -1) continue;
                        throw new IOException("Unexpect end of tuple");
                    }
                } else {
                    ByteArrayOutputStream mOut = new ByteArrayOutputStream(1024);
                    while ((buf = in.read()) != delimit) {
                        if (buf == -1) {
                            throw new IOException("Unexpect end of tuple");
                        }
                        if (buf == delimit) break;
                        mOut.write(buf);
                    }
                    field = this.parseSimpleType(mOut.toByteArray(), fs);
                }
                t.append(field);
            }
        } else {
            Stack<Character> level = new Stack<Character>();
            ByteArrayOutputStream mOut = new ByteArrayOutputStream(1024);
            while (true) {
                DataByteArray value;
                if ((buf = in.read()) == -1) {
                    throw new IOException("Unexpect end of tuple");
                }
                if (buf == 91 || buf == 123 || buf == 40) {
                    level.push(Character.valueOf((char)buf));
                    mOut.write(buf);
                    continue;
                }
                if (buf == 41 && level.isEmpty()) {
                    value = new DataByteArray(mOut.toByteArray());
                    t.append(value);
                    break;
                }
                if (buf == 44 && level.isEmpty()) {
                    value = new DataByteArray(mOut.toByteArray());
                    t.append(value);
                    mOut.reset();
                    continue;
                }
                if (buf == 93 || buf == 125 || buf == 41) {
                    if (((Character)level.peek()).charValue() != this.findStartChar((char)buf)) {
                        throw new IOException("Malformed tuple");
                    }
                    level.pop();
                    mOut.write(buf);
                    continue;
                }
                mOut.write(buf);
            }
        }
        return t;
    }

    /*
     * Unable to fully structure code
     */
    private Map<String, Object> consumeMap(PushbackInputStream in, ResourceSchema.ResourceFieldSchema fieldSchema) throws IOException {
        while ((buf = in.read()) != 91) {
            if (buf != -1) continue;
            throw new IOException("Unexpect end of map");
        }
        m = new HashMap<String, Object>();
        mOut = new ByteArrayOutputStream(1024);
        while (true) {
            if ((buf = in.read()) != 35) {
                if (buf == -1) {
                    throw new IOException("Unexpect end of map");
                }
                mOut.write(buf);
                continue;
            }
            key = this.bytesToCharArray(mOut.toByteArray());
            if (key.length() == 0) {
                throw new IOException("Map key can not be null");
            }
            mOut.reset();
            level = new Stack<Character>();
            while (true) {
                if ((buf = in.read()) == -1) {
                    throw new IOException("Unexpect end of map");
                }
                if (buf == 91 || buf == 123 || buf == 40) {
                    level.push(Character.valueOf((char)buf));
                } else {
                    if (buf == 93 && level.isEmpty()) break;
                    if (buf == 93 || buf == 125 || buf == 41) {
                        try {
                            if (((Character)level.peek()).charValue() != this.findStartChar((char)buf)) ** GOTO lbl34
                            level.pop();
                        }
                        catch (EmptyStackException e) {
                            throw new IOException("Malformed map");
                        }
                    } else if (buf == 44 && level.isEmpty()) break;
                }
lbl34:
                // 4 sources

                mOut.write(buf);
            }
            value = null;
            if (fieldSchema != null && fieldSchema.getSchema() != null && mOut.size() > 0) {
                value = this.bytesToObject(mOut.toByteArray(), fieldSchema.getSchema().getFields()[0]);
            } else if (mOut.size() > 0) {
                value = new DataByteArray(mOut.toByteArray());
            }
            m.put(key, value);
            mOut.reset();
            if (buf == 93) break;
        }
        return m;
    }

    private Object bytesToObject(byte[] b, ResourceSchema.ResourceFieldSchema fs) throws IOException {
        Object field;
        if (DataType.isComplex(fs.getType())) {
            ByteArrayInputStream bis = new ByteArrayInputStream(b);
            PushbackInputStream in = new PushbackInputStream(bis);
            field = this.consumeComplexType(in, fs);
        } else {
            field = this.parseSimpleType(b, fs);
        }
        return field;
    }

    private Object consumeComplexType(PushbackInputStream in, ResourceSchema.ResourceFieldSchema complexFieldSchema) throws IOException {
        Object field;
        switch (complexFieldSchema.getType()) {
            case 120: {
                field = this.consumeBag(in, complexFieldSchema);
                break;
            }
            case 110: {
                field = this.consumeTuple(in, complexFieldSchema);
                break;
            }
            case 100: {
                field = this.consumeMap(in, complexFieldSchema);
                break;
            }
            default: {
                throw new IOException("Unknown complex data type");
            }
        }
        return field;
    }

    private Object parseSimpleType(byte[] b, ResourceSchema.ResourceFieldSchema simpleFieldSchema) throws IOException {
        Object field;
        switch (simpleFieldSchema.getType()) {
            case 10: {
                field = this.bytesToInteger(b);
                break;
            }
            case 15: {
                field = this.bytesToLong(b);
                break;
            }
            case 20: {
                field = this.bytesToFloat(b);
                break;
            }
            case 25: {
                field = this.bytesToDouble(b);
                break;
            }
            case 55: {
                field = this.bytesToCharArray(b);
                break;
            }
            case 50: {
                field = new DataByteArray(b);
                break;
            }
            case 5: {
                field = this.bytesToBoolean(b);
                break;
            }
            default: {
                throw new IOException("Unknown simple data type");
            }
        }
        return field;
    }

    @Override
    public DataBag bytesToBag(byte[] b, ResourceSchema.ResourceFieldSchema schema) throws IOException {
        DataBag db;
        if (b == null) {
            return null;
        }
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(b);
            PushbackInputStream in = new PushbackInputStream(bis);
            db = this.consumeBag(in, schema);
        }
        catch (IOException e) {
            LogUtils.warn(this, "Unable to interpret value " + Arrays.toString(b) + " in field being " + "converted to type bag, caught ParseException <" + e.getMessage() + "> field discarded", PigWarning.FIELD_DISCARDED_TYPE_CONVERSION_FAILED, this.mLog);
            return null;
        }
        return db;
    }

    @Override
    public String bytesToCharArray(byte[] b) throws IOException {
        if (b == null) {
            return null;
        }
        return new String(b, "UTF-8");
    }

    @Override
    public Double bytesToDouble(byte[] b) {
        if (b == null) {
            return null;
        }
        try {
            return Double.valueOf(new String(b));
        }
        catch (NumberFormatException nfe) {
            LogUtils.warn(this, "Unable to interpret value " + Arrays.toString(b) + " in field being " + "converted to double, caught NumberFormatException <" + nfe.getMessage() + "> field discarded", PigWarning.FIELD_DISCARDED_TYPE_CONVERSION_FAILED, this.mLog);
            return null;
        }
    }

    @Override
    public Float bytesToFloat(byte[] b) throws IOException {
        if (b == null) {
            return null;
        }
        String s = b.length > 0 && (b[b.length - 1] == 70 || b[b.length - 1] == 102) ? new String(b, 0, b.length - 1) : new String(b);
        try {
            return Float.valueOf(s);
        }
        catch (NumberFormatException nfe) {
            LogUtils.warn(this, "Unable to interpret value " + Arrays.toString(b) + " in field being " + "converted to float, caught NumberFormatException <" + nfe.getMessage() + "> field discarded", PigWarning.FIELD_DISCARDED_TYPE_CONVERSION_FAILED, this.mLog);
            return null;
        }
    }

    public Boolean bytesToBoolean(byte[] b) throws IOException {
        if (b == null) {
            return null;
        }
        String s = new String(b);
        return Boolean.valueOf(s);
    }

    @Override
    public Integer bytesToInteger(byte[] b) throws IOException {
        if (b == null) {
            return null;
        }
        String s = new String(b);
        try {
            return Integer.valueOf(s);
        }
        catch (NumberFormatException nfe) {
            try {
                Double d = Double.valueOf(s);
                if (Double.compare(d, mMaxInt.doubleValue() + 1.0) >= 0 || Double.compare(d, mMinInt.doubleValue() - 1.0) <= 0) {
                    LogUtils.warn(this, "Value " + d + " too large for integer", PigWarning.TOO_LARGE_FOR_INT, this.mLog);
                    return null;
                }
                return d.intValue();
            }
            catch (NumberFormatException nfe2) {
                LogUtils.warn(this, "Unable to interpret value " + Arrays.toString(b) + " in field being " + "converted to int, caught NumberFormatException <" + nfe.getMessage() + "> field discarded", PigWarning.FIELD_DISCARDED_TYPE_CONVERSION_FAILED, this.mLog);
                return null;
            }
        }
    }

    @Override
    public Long bytesToLong(byte[] b) throws IOException {
        if (b == null) {
            return null;
        }
        String s = b.length > 0 && (b[b.length - 1] == 76 || b[b.length - 1] == 108) ? new String(b, 0, b.length - 1) : new String(b);
        try {
            return Long.valueOf(s);
        }
        catch (NumberFormatException nfe) {
            try {
                Double d = Double.valueOf(s);
                if (Double.compare(d, mMaxLong.doubleValue() + 1.0) > 0 || Double.compare(d, mMinLong.doubleValue() - 1.0) < 0) {
                    LogUtils.warn(this, "Value " + d + " too large for long", PigWarning.TOO_LARGE_FOR_INT, this.mLog);
                    return null;
                }
                return d.longValue();
            }
            catch (NumberFormatException nfe2) {
                LogUtils.warn(this, "Unable to interpret value " + Arrays.toString(b) + " in field being " + "converted to long, caught NumberFormatException <" + nfe.getMessage() + "> field discarded", PigWarning.FIELD_DISCARDED_TYPE_CONVERSION_FAILED, this.mLog);
                return null;
            }
        }
    }

    @Override
    public Map<String, Object> bytesToMap(byte[] b, ResourceSchema.ResourceFieldSchema fieldSchema) throws IOException {
        Map<String, Object> map;
        if (b == null) {
            return null;
        }
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(b);
            PushbackInputStream in = new PushbackInputStream(bis);
            map = this.consumeMap(in, fieldSchema);
        }
        catch (IOException e) {
            LogUtils.warn(this, "Unable to interpret value " + Arrays.toString(b) + " in field being " + "converted to type map, caught ParseException <" + e.getMessage() + "> field discarded", PigWarning.FIELD_DISCARDED_TYPE_CONVERSION_FAILED, this.mLog);
            return null;
        }
        return map;
    }

    @Override
    public Map<String, Object> bytesToMap(byte[] b) throws IOException {
        return this.bytesToMap(b, null);
    }

    @Override
    public Tuple bytesToTuple(byte[] b, ResourceSchema.ResourceFieldSchema fieldSchema) throws IOException {
        Tuple t;
        if (b == null) {
            return null;
        }
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(b);
            PushbackInputStream in = new PushbackInputStream(bis);
            t = this.consumeTuple(in, fieldSchema);
        }
        catch (IOException e) {
            LogUtils.warn(this, "Unable to interpret value " + Arrays.toString(b) + " in field being " + "converted to type tuple, caught ParseException <" + e.getMessage() + "> field discarded", PigWarning.FIELD_DISCARDED_TYPE_CONVERSION_FAILED, this.mLog);
            return null;
        }
        return t;
    }

    @Override
    public byte[] toBytes(DataBag bag) throws IOException {
        return bag.toString().getBytes();
    }

    @Override
    public byte[] toBytes(String s) throws IOException {
        return s.getBytes();
    }

    @Override
    public byte[] toBytes(Double d) throws IOException {
        return d.toString().getBytes();
    }

    @Override
    public byte[] toBytes(Float f) throws IOException {
        return f.toString().getBytes();
    }

    @Override
    public byte[] toBytes(Integer i) throws IOException {
        return i.toString().getBytes();
    }

    @Override
    public byte[] toBytes(Long l) throws IOException {
        return l.toString().getBytes();
    }

    @Override
    public byte[] toBytes(Map<String, Object> m) throws IOException {
        return DataType.mapToString(m).getBytes();
    }

    @Override
    public byte[] toBytes(Tuple t) throws IOException {
        return t.toString().getBytes();
    }

    @Override
    public byte[] toBytes(DataByteArray a) throws IOException {
        return a.get();
    }
}

