/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.data;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.WritableComparator;
import org.apache.hadoop.mapred.JobConf;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.classification.InterfaceAudience;
import org.apache.pig.classification.InterfaceStability;
import org.apache.pig.data.BagFactory;
import org.apache.pig.data.BinSedesTuple;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.DataType;
import org.apache.pig.data.InterSedes;
import org.apache.pig.data.InterSedesFactory;
import org.apache.pig.data.InternalMap;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.data.TupleRawComparator;
import org.apache.pig.impl.util.ObjectSerializer;

@InterfaceAudience.Private
@InterfaceStability.Stable
public class BinInterSedes
implements InterSedes {
    public static final byte BOOLEAN_TRUE = 0;
    public static final byte BOOLEAN_FALSE = 1;
    public static final byte BYTE = 2;
    public static final byte INTEGER = 3;
    public static final byte INTEGER_0 = 4;
    public static final byte INTEGER_1 = 5;
    public static final byte INTEGER_INSHORT = 6;
    public static final byte INTEGER_INBYTE = 7;
    public static final byte LONG = 8;
    public static final byte FLOAT = 9;
    public static final byte DOUBLE = 10;
    public static final byte BYTEARRAY = 11;
    public static final byte SMALLBYTEARRAY = 12;
    public static final byte TINYBYTEARRAY = 13;
    public static final byte CHARARRAY = 14;
    public static final byte SMALLCHARARRAY = 15;
    public static final byte MAP = 16;
    public static final byte SMALLMAP = 17;
    public static final byte TINYMAP = 18;
    public static final byte TUPLE = 19;
    public static final byte SMALLTUPLE = 20;
    public static final byte TINYTUPLE = 21;
    public static final byte BAG = 22;
    public static final byte SMALLBAG = 23;
    public static final byte TINYBAG = 24;
    public static final byte GENERIC_WRITABLECOMPARABLE = 25;
    public static final byte INTERNALMAP = 26;
    public static final byte NULL = 27;
    private static TupleFactory mTupleFactory = TupleFactory.getInstance();
    private static BagFactory mBagFactory = BagFactory.getInstance();
    static final int UNSIGNED_SHORT_MAX = 65535;
    static final int UNSIGNED_BYTE_MAX = 255;
    public static final String UTF8 = "UTF-8";

    private Tuple readTuple(DataInput in, byte type) throws IOException {
        int sz = this.getTupleSize(in, type);
        Tuple t = mTupleFactory.newTuple(sz);
        for (int i = 0; i < sz; ++i) {
            t.set(i, this.readDatum(in));
        }
        return t;
    }

    private int getTupleSize(DataInput in, byte type) throws IOException {
        int sz;
        switch (type) {
            case 21: {
                sz = in.readUnsignedByte();
                break;
            }
            case 20: {
                sz = in.readUnsignedShort();
                break;
            }
            case 19: {
                sz = in.readInt();
                break;
            }
            default: {
                int errCode = 2112;
                String msg = "Unexpected datatype " + type + " while reading tuple" + "from binary file.";
                throw new ExecException(msg, errCode, 4);
            }
        }
        if (sz < 0) {
            throw new IOException("Invalid size " + sz + " for a tuple");
        }
        return sz;
    }

    private DataBag readBag(DataInput in, byte type) throws IOException {
        long size;
        DataBag bag = mBagFactory.newDefaultBag();
        switch (type) {
            case 24: {
                size = in.readUnsignedByte();
                break;
            }
            case 23: {
                size = in.readUnsignedShort();
                break;
            }
            case 22: {
                size = in.readLong();
                break;
            }
            default: {
                int errCode = 2219;
                String msg = "Unexpected data while reading bag from binary file.";
                throw new ExecException(msg, errCode, 4);
            }
        }
        for (long i = 0L; i < size; ++i) {
            Object o = this.readDatum(in);
            bag.add((Tuple)o);
            continue;
        }
        return bag;
    }

    private Map<String, Object> readMap(DataInput in, byte type) throws IOException {
        int size;
        switch (type) {
            case 18: {
                size = in.readUnsignedByte();
                break;
            }
            case 17: {
                size = in.readUnsignedShort();
                break;
            }
            case 16: {
                size = in.readInt();
                break;
            }
            default: {
                int errCode = 2220;
                String msg = "Unexpected data while reading mapfrom binary file.";
                throw new ExecException(msg, errCode, 4);
            }
        }
        HashMap<String, Object> m = new HashMap<String, Object>(size);
        for (int i = 0; i < size; ++i) {
            String key = (String)this.readDatum(in);
            m.put(key, this.readDatum(in));
        }
        return m;
    }

    private InternalMap readInternalMap(DataInput in) throws IOException {
        int size = in.readInt();
        InternalMap m = new InternalMap(size);
        for (int i = 0; i < size; ++i) {
            Object key = this.readDatum(in);
            m.put(key, this.readDatum(in));
        }
        return m;
    }

    private static String readCharArray(DataInput in) throws IOException {
        return in.readUTF();
    }

    private static String readBigCharArray(DataInput in) throws IOException {
        int size = in.readInt();
        byte[] ba = new byte[size];
        in.readFully(ba);
        return new String(ba, UTF8);
    }

    private WritableComparable readWritable(DataInput in) throws IOException {
        String className = (String)this.readDatum(in);
        Class<?> objClass = null;
        try {
            objClass = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new IOException("Could not find class " + className + ", while attempting to de-serialize it ", e);
        }
        WritableComparable writable = null;
        try {
            writable = (WritableComparable)objClass.newInstance();
        }
        catch (Exception e) {
            String msg = "Could create instance of class " + className + ", while attempting to de-serialize it. (no default constructor ?)";
            throw new IOException(msg, e);
        }
        writable.readFields(in);
        return writable;
    }

    @Override
    public Object readDatum(DataInput in) throws IOException, ExecException {
        byte b = in.readByte();
        return this.readDatum(in, b);
    }

    private static Object readBytes(DataInput in, int size) throws IOException {
        byte[] ba = new byte[size];
        in.readFully(ba);
        return new DataByteArray(ba);
    }

    @Override
    public Object readDatum(DataInput in, byte type) throws IOException, ExecException {
        switch (type) {
            case 19: 
            case 20: 
            case 21: {
                return this.readTuple(in, type);
            }
            case 22: 
            case 23: 
            case 24: {
                return this.readBag(in, type);
            }
            case 16: 
            case 17: 
            case 18: {
                return this.readMap(in, type);
            }
            case 26: {
                return this.readInternalMap(in);
            }
            case 4: {
                return 0;
            }
            case 5: {
                return 1;
            }
            case 7: {
                return (int)in.readByte();
            }
            case 6: {
                return (int)in.readShort();
            }
            case 3: {
                return in.readInt();
            }
            case 8: {
                return in.readLong();
            }
            case 9: {
                return Float.valueOf(in.readFloat());
            }
            case 10: {
                return in.readDouble();
            }
            case 0: {
                return true;
            }
            case 1: {
                return false;
            }
            case 2: {
                return in.readByte();
            }
            case 13: {
                int size = in.readUnsignedByte();
                return BinInterSedes.readBytes(in, size);
            }
            case 12: {
                int size = in.readUnsignedShort();
                return BinInterSedes.readBytes(in, size);
            }
            case 11: {
                int size = in.readInt();
                return BinInterSedes.readBytes(in, size);
            }
            case 14: {
                return BinInterSedes.readBigCharArray(in);
            }
            case 15: {
                return BinInterSedes.readCharArray(in);
            }
            case 25: {
                return this.readWritable(in);
            }
            case 27: {
                return null;
            }
        }
        throw new RuntimeException("Unexpected data type " + type + " found in stream.");
    }

    @Override
    public void writeDatum(DataOutput out, Object val) throws IOException {
        byte type = DataType.findType(val);
        switch (type) {
            case 110: {
                this.writeTuple(out, (Tuple)val);
                break;
            }
            case 120: {
                this.writeBag(out, (DataBag)val);
                break;
            }
            case 100: {
                this.writeMap(out, (Map)val);
                break;
            }
            case 127: {
                out.writeByte(26);
                Map m = (Map)val;
                out.writeInt(m.size());
                for (Map.Entry entry : m.entrySet()) {
                    this.writeDatum(out, entry.getKey());
                    this.writeDatum(out, entry.getValue());
                }
                break;
            }
            case 10: {
                int i = (Integer)val;
                if (i == 0) {
                    out.writeByte(4);
                    break;
                }
                if (i == 1) {
                    out.writeByte(5);
                    break;
                }
                if (-128 <= i && i <= 127) {
                    out.writeByte(7);
                    out.writeByte(i);
                    break;
                }
                if (Short.MIN_VALUE <= i && i <= Short.MAX_VALUE) {
                    out.writeByte(6);
                    out.writeShort(i);
                    break;
                }
                out.writeByte(3);
                out.writeInt(i);
                break;
            }
            case 15: {
                out.writeByte(8);
                out.writeLong((Long)val);
                break;
            }
            case 20: {
                out.writeByte(9);
                out.writeFloat(((Float)val).floatValue());
                break;
            }
            case 25: {
                out.writeByte(10);
                out.writeDouble((Double)val);
                break;
            }
            case 5: {
                if (((Boolean)val).booleanValue()) {
                    out.writeByte(0);
                    break;
                }
                out.writeByte(1);
                break;
            }
            case 6: {
                out.writeByte(2);
                out.writeByte(((Byte)val).byteValue());
                break;
            }
            case 50: {
                DataByteArray bytes = (DataByteArray)val;
                int sz = bytes.size();
                if (sz < 255) {
                    out.writeByte(13);
                    out.writeByte(sz);
                } else if (sz < 65535) {
                    out.writeByte(12);
                    out.writeShort(sz);
                } else {
                    out.writeByte(11);
                    out.writeInt(sz);
                }
                out.write(bytes.mData);
                break;
            }
            case 55: {
                String s = (String)val;
                if (s.length() < 21845) {
                    out.writeByte(15);
                    out.writeUTF(s);
                    break;
                }
                byte[] utfBytes = s.getBytes(UTF8);
                int length = utfBytes.length;
                out.writeByte(14);
                out.writeInt(length);
                out.write(utfBytes);
                break;
            }
            case 123: {
                out.writeByte(25);
                this.writeDatum(out, val.getClass().getName());
                Writable writable = (Writable)val;
                writable.write(out);
                break;
            }
            case 1: {
                out.writeByte(27);
                break;
            }
            default: {
                throw new RuntimeException("Unexpected data type " + val.getClass().getName() + " found in stream. " + "Note only standard Pig type is supported when you output from UDF/LoadFunc");
            }
        }
    }

    private void writeMap(DataOutput out, Map<String, Object> m) throws IOException {
        int sz = m.size();
        if (sz < 255) {
            out.writeByte(18);
            out.writeByte(sz);
        } else if (sz < 65535) {
            out.writeByte(17);
            out.writeShort(sz);
        } else {
            out.writeByte(16);
            out.writeInt(sz);
        }
        for (Map.Entry<String, Object> entry : m.entrySet()) {
            this.writeDatum(out, entry.getKey());
            this.writeDatum(out, entry.getValue());
        }
    }

    private void writeBag(DataOutput out, DataBag bag) throws IOException {
        long sz = bag.size();
        if (sz < 255L) {
            out.writeByte(24);
            out.writeByte((int)sz);
        } else if (sz < 65535L) {
            out.writeByte(23);
            out.writeShort((int)sz);
        } else {
            out.writeByte(22);
            out.writeLong(sz);
        }
        Iterator<Tuple> it = bag.iterator();
        while (it.hasNext()) {
            this.writeTuple(out, it.next());
        }
    }

    private void writeTuple(DataOutput out, Tuple t) throws IOException {
        int sz = t.size();
        if (sz < 255) {
            out.writeByte(21);
            out.writeByte(sz);
        } else if (sz < 65535) {
            out.writeByte(20);
            out.writeShort(sz);
        } else {
            out.writeByte(19);
            out.writeInt(sz);
        }
        for (int i = 0; i < sz; ++i) {
            this.writeDatum(out, t.get(i));
        }
    }

    @Override
    public void addColsToTuple(DataInput in, Tuple t) throws IOException {
        byte type = in.readByte();
        int sz = this.getTupleSize(in, type);
        for (int i = 0; i < sz; ++i) {
            t.append(this.readDatum(in));
        }
    }

    @Override
    public Class<? extends TupleRawComparator> getTupleRawComparatorClass() {
        return BinInterSedesTupleRawComparator.class;
    }

    public static class BinInterSedesTupleRawComparator
    extends WritableComparator
    implements TupleRawComparator {
        private final Log mLog = LogFactory.getLog(this.getClass());
        private boolean[] mAsc;
        private boolean[] mSecondaryAsc;
        private static final boolean[] EMPTY_ASC = new boolean[0];
        private boolean mWholeTuple;
        private boolean mIsSecondarySort;
        private boolean mHasNullField;
        private TupleFactory mFact;
        private InterSedes mSedes;

        public BinInterSedesTupleRawComparator() {
            super(BinSedesTuple.class);
        }

        public Configuration getConf() {
            return null;
        }

        public void setConf(Configuration conf) {
            if (!(conf instanceof JobConf)) {
                this.mLog.warn((Object)("Expected jobconf in setConf, got " + conf.getClass().getName()));
                return;
            }
            try {
                this.mAsc = (boolean[])ObjectSerializer.deserialize(conf.get("pig.sortOrder"));
                this.mSecondaryAsc = (boolean[])ObjectSerializer.deserialize(conf.get("pig.secondarySortOrder"));
                this.mIsSecondarySort = true;
            }
            catch (IOException ioe) {
                this.mLog.error((Object)("Unable to deserialize sort order object" + ioe.getMessage()));
                throw new RuntimeException(ioe);
            }
            if (this.mAsc == null) {
                this.mAsc = new boolean[1];
                this.mAsc[0] = true;
            }
            if (this.mSecondaryAsc == null) {
                this.mIsSecondarySort = false;
            }
            this.mWholeTuple = this.mAsc.length == 1;
            this.mFact = TupleFactory.getInstance();
            this.mSedes = InterSedesFactory.getInterSedesInstance();
        }

        @Override
        public boolean hasComparedTupleNull() {
            return this.mHasNullField;
        }

        public int compare(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) {
            int rc = 0;
            ByteBuffer bb1 = ByteBuffer.wrap(b1, s1, l1);
            ByteBuffer bb2 = ByteBuffer.wrap(b2, s2, l2);
            try {
                rc = this.compareBinSedesTuple(bb1, bb2);
            }
            catch (IOException ioe) {
                this.mLog.error((Object)("I/O error during tuple comparison: " + ioe.getMessage()));
                throw new RuntimeException(ioe.getMessage(), ioe);
            }
            return rc;
        }

        private int compareBinSedesTuple(ByteBuffer bb1, ByteBuffer bb2) throws IOException {
            this.mHasNullField = false;
            int s1 = bb1.position();
            int s2 = bb2.position();
            int result = 0;
            try {
                int tsz1 = BinInterSedesTupleRawComparator.readSize(bb1);
                int tsz2 = BinInterSedesTupleRawComparator.readSize(bb2);
                if (tsz1 > tsz2) {
                    return 1;
                }
                if (tsz1 < tsz2) {
                    return -1;
                }
                if (this.mIsSecondarySort) {
                    assert (tsz1 == 2);
                    result = this.compareBinInterSedesDatum(bb1, bb2, this.mAsc);
                    if (result == 0) {
                        result = this.compareBinInterSedesDatum(bb1, bb2, this.mSecondaryAsc);
                    }
                } else {
                    for (int i = 0; i < tsz1 && result == 0; ++i) {
                        result = this.compareBinInterSedesDatum(bb1, bb2, EMPTY_ASC);
                        if (result == 0) continue;
                        if (!this.mWholeTuple && !this.mAsc[i]) {
                            result *= -1;
                            continue;
                        }
                        if (!this.mWholeTuple || this.mAsc[0]) continue;
                        result *= -1;
                    }
                }
            }
            catch (UnsupportedEncodingException uee) {
                Tuple t1 = this.mFact.newTuple();
                Tuple t2 = this.mFact.newTuple();
                t1.readFields(new DataInputStream(new ByteArrayInputStream(bb1.array(), s1, bb1.limit())));
                t2.readFields(new DataInputStream(new ByteArrayInputStream(bb2.array(), s2, bb2.limit())));
                result = this.compare(t1, t2);
            }
            return result;
        }

        private int compareBinInterSedesDatum(ByteBuffer bb1, ByteBuffer bb2, boolean[] asc) throws IOException {
            byte type2;
            byte type1;
            int rc = 0;
            byte dt1 = bb1.get();
            byte dt2 = bb2.get();
            switch (dt1) {
                case 27: {
                    type1 = 1;
                    type2 = BinInterSedesTupleRawComparator.getGeneralizedDataType(dt2);
                    if (asc != null) {
                        this.mHasNullField = true;
                    }
                    if (type1 != type2) break;
                    rc = 0;
                    break;
                }
                case 0: 
                case 1: {
                    type1 = 5;
                    type2 = BinInterSedesTupleRawComparator.getGeneralizedDataType(dt2);
                    if (type1 != type2) break;
                    int bv1 = dt1 == 0 ? 1 : 0;
                    int bv2 = dt2 == 0 ? 1 : 0;
                    rc = bv1 - bv2;
                    break;
                }
                case 2: {
                    byte bv2;
                    type1 = 6;
                    type2 = BinInterSedesTupleRawComparator.getGeneralizedDataType(dt2);
                    if (type1 != type2) break;
                    byte bv1 = bb1.get();
                    rc = bv1 < (bv2 = bb2.get()) ? -1 : (bv1 == bv2 ? 0 : 1);
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    int iv2;
                    type1 = 10;
                    type2 = BinInterSedesTupleRawComparator.getGeneralizedDataType(dt2);
                    if (type1 != type2) break;
                    int iv1 = BinInterSedesTupleRawComparator.readInt(bb1, dt1);
                    rc = iv1 < (iv2 = BinInterSedesTupleRawComparator.readInt(bb2, dt2)) ? -1 : (iv1 == iv2 ? 0 : 1);
                    break;
                }
                case 8: {
                    long lv2;
                    type1 = 15;
                    type2 = BinInterSedesTupleRawComparator.getGeneralizedDataType(dt2);
                    if (type1 != type2) break;
                    long lv1 = bb1.getLong();
                    rc = lv1 < (lv2 = bb2.getLong()) ? -1 : (lv1 == lv2 ? 0 : 1);
                    break;
                }
                case 9: {
                    type1 = 20;
                    type2 = BinInterSedesTupleRawComparator.getGeneralizedDataType(dt2);
                    if (type1 != type2) break;
                    float fv1 = bb1.getFloat();
                    float fv2 = bb2.getFloat();
                    rc = Float.compare(fv1, fv2);
                    break;
                }
                case 10: {
                    type1 = 25;
                    type2 = BinInterSedesTupleRawComparator.getGeneralizedDataType(dt2);
                    if (type1 != type2) break;
                    double dv1 = bb1.getDouble();
                    double dv2 = bb2.getDouble();
                    rc = Double.compare(dv1, dv2);
                    break;
                }
                case 11: 
                case 12: 
                case 13: {
                    type1 = 50;
                    type2 = BinInterSedesTupleRawComparator.getGeneralizedDataType(dt2);
                    if (type1 != type2) break;
                    int basz1 = BinInterSedesTupleRawComparator.readSize(bb1, dt1);
                    int basz2 = BinInterSedesTupleRawComparator.readSize(bb2, dt2);
                    byte[] ba1 = new byte[basz1];
                    byte[] ba2 = new byte[basz2];
                    bb1.get(ba1);
                    bb2.get(ba2);
                    rc = DataByteArray.compare(ba1, ba2);
                    break;
                }
                case 14: 
                case 15: {
                    type1 = 55;
                    type2 = BinInterSedesTupleRawComparator.getGeneralizedDataType(dt2);
                    if (type1 != type2) break;
                    int casz1 = BinInterSedesTupleRawComparator.readSize(bb1, dt1);
                    int casz2 = BinInterSedesTupleRawComparator.readSize(bb2, dt2);
                    byte[] ca1 = new byte[casz1];
                    byte[] ca2 = new byte[casz2];
                    bb1.get(ca1);
                    bb2.get(ca2);
                    String str1 = null;
                    String str2 = null;
                    try {
                        str1 = new String(ca1, BinInterSedes.UTF8);
                        str2 = new String(ca2, BinInterSedes.UTF8);
                    }
                    catch (UnsupportedEncodingException uee) {
                        this.mLog.warn((Object)"Unsupported string encoding", (Throwable)uee);
                        uee.printStackTrace();
                    }
                    if (str1 == null || str2 == null) break;
                    rc = str1.compareTo(str2);
                    break;
                }
                case 19: 
                case 20: 
                case 21: {
                    int tsz2;
                    type1 = 110;
                    type2 = BinInterSedesTupleRawComparator.getGeneralizedDataType(dt2);
                    if (type1 != type2) break;
                    int tsz1 = BinInterSedesTupleRawComparator.readSize(bb1, dt1);
                    if (tsz1 > (tsz2 = BinInterSedesTupleRawComparator.readSize(bb2, dt2))) {
                        return 1;
                    }
                    if (tsz1 < tsz2) {
                        return -1;
                    }
                    for (int i = 0; i < tsz1 && rc == 0; ++i) {
                        rc = this.compareBinInterSedesDatum(bb1, bb2, null);
                        if (rc == 0 || asc == null || asc.length <= 1 || asc[i]) continue;
                        rc *= -1;
                    }
                    break;
                }
                case 22: 
                case 23: 
                case 24: {
                    type1 = 120;
                    type2 = BinInterSedesTupleRawComparator.getGeneralizedDataType(dt2);
                    if (type1 != type2) break;
                    rc = this.compareBinInterSedesBag(bb1, bb2, dt1, dt2);
                    break;
                }
                case 16: 
                case 17: 
                case 18: {
                    type1 = 100;
                    type2 = BinInterSedesTupleRawComparator.getGeneralizedDataType(dt2);
                    if (type1 != type2) break;
                    rc = this.compareBinInterSedesMap(bb1, bb2, dt1, dt2);
                    break;
                }
                case 25: {
                    type1 = 123;
                    type2 = BinInterSedesTupleRawComparator.getGeneralizedDataType(dt2);
                    if (type1 != type2) break;
                    rc = this.compareBinInterSedesGenericWritableComparable(bb1, bb2);
                    break;
                }
                default: {
                    this.mLog.info((Object)("Unsupported DataType for binary comparison, switching to object deserialization: " + DataType.genTypeToNameMap().get(dt1) + "(" + dt1 + ")"));
                    throw new UnsupportedEncodingException();
                }
            }
            if (type1 != type2) {
                int n = rc = type1 < type2 ? -1 : 1;
            }
            if (asc != null && asc.length == 1 && !asc[0]) {
                rc *= -1;
            }
            return rc;
        }

        public int compare(WritableComparable o1, WritableComparable o2) {
            int tsz2;
            Tuple t1 = (Tuple)o1;
            Tuple t2 = (Tuple)o2;
            this.mHasNullField = false;
            int result = 0;
            int tsz1 = t1.size();
            if (tsz1 > (tsz2 = t2.size())) {
                return 1;
            }
            if (tsz1 < tsz2) {
                return -1;
            }
            try {
                if (this.mIsSecondarySort) {
                    assert (tsz1 == 3);
                    result = this.compareDatum(t1.get(0), t2.get(0), this.mAsc);
                    if (result == 0) {
                        result = this.compareDatum(t1.get(1), t2.get(1), this.mSecondaryAsc);
                    }
                } else {
                    result = this.compareDatum(t1, t2, this.mAsc);
                }
            }
            catch (ExecException e) {
                throw new RuntimeException("Unable to compare tuples", e);
            }
            return result;
        }

        private int compareDatum(Object o1, Object o2, boolean[] asc) {
            int rc = 0;
            if (o1 != null && o2 != null && o1 instanceof Tuple && o2 instanceof Tuple) {
                Tuple t1 = (Tuple)o1;
                Tuple t2 = (Tuple)o2;
                int sz1 = t1.size();
                int sz2 = t2.size();
                if (sz2 < sz1) {
                    return 1;
                }
                if (sz2 > sz1) {
                    return -1;
                }
                for (int i = 0; i < sz1; ++i) {
                    try {
                        rc = DataType.compare(t1.get(i), t2.get(i));
                        if (rc != 0 && asc != null && asc.length > 1 && !asc[i]) {
                            rc *= -1;
                        }
                        if (t1.get(i) == null) {
                            this.mHasNullField = true;
                        }
                        if (rc == 0) continue;
                        break;
                    }
                    catch (ExecException e) {
                        throw new RuntimeException("Unable to compare tuples", e);
                    }
                }
            } else {
                rc = DataType.compare(o1, o2);
            }
            if (asc != null && asc.length == 1 && !asc[0]) {
                rc *= -1;
            }
            return rc;
        }

        private int compareBinInterSedesGenericWritableComparable(ByteBuffer bb1, ByteBuffer bb2) throws ExecException, IOException {
            DataInputBuffer buffer1 = new DataInputBuffer();
            DataInputBuffer buffer2 = new DataInputBuffer();
            buffer1.reset(bb1.array(), bb1.position(), bb1.remaining());
            buffer2.reset(bb2.array(), bb2.position(), bb2.remaining());
            Comparable writable1 = (Comparable)this.mSedes.readDatum((DataInput)buffer1);
            Comparable writable2 = (Comparable)this.mSedes.readDatum((DataInput)buffer2);
            bb1.position(buffer1.getPosition());
            bb2.position(buffer2.getPosition());
            return writable1.compareTo(writable2);
        }

        private int compareBinInterSedesBag(ByteBuffer bb1, ByteBuffer bb2, byte dt1, byte dt2) throws IOException {
            int bsz2;
            int s1 = bb1.position();
            int s2 = bb2.position();
            int l1 = bb1.remaining();
            int l2 = bb2.remaining();
            int bsz1 = BinInterSedesTupleRawComparator.readSize(bb1, dt1);
            if (bsz1 > (bsz2 = BinInterSedesTupleRawComparator.readSize(bb2, dt2))) {
                return 1;
            }
            if (bsz1 < bsz2) {
                return -1;
            }
            DataInputBuffer buffer1 = new DataInputBuffer();
            DataInputBuffer buffer2 = new DataInputBuffer();
            buffer1.reset(bb1.array(), s1, l1);
            buffer2.reset(bb2.array(), s2, l2);
            DataBag bag1 = (DataBag)this.mSedes.readDatum((DataInput)buffer1, dt1);
            DataBag bag2 = (DataBag)this.mSedes.readDatum((DataInput)buffer2, dt2);
            bb1.position(buffer1.getPosition());
            bb2.position(buffer2.getPosition());
            return bag1.compareTo(bag2);
        }

        private int compareBinInterSedesMap(ByteBuffer bb1, ByteBuffer bb2, byte dt1, byte dt2) throws ExecException, IOException {
            int bsz2;
            int s1 = bb1.position();
            int s2 = bb2.position();
            int l1 = bb1.remaining();
            int l2 = bb2.remaining();
            int bsz1 = BinInterSedesTupleRawComparator.readSize(bb1, dt1);
            if (bsz1 > (bsz2 = BinInterSedesTupleRawComparator.readSize(bb2, dt2))) {
                return 1;
            }
            if (bsz1 < bsz2) {
                return -1;
            }
            DataInputBuffer buffer1 = new DataInputBuffer();
            DataInputBuffer buffer2 = new DataInputBuffer();
            buffer1.reset(bb1.array(), s1, l1);
            buffer2.reset(bb2.array(), s2, l2);
            Map map1 = (Map)this.mSedes.readDatum((DataInput)buffer1, dt1);
            Map map2 = (Map)this.mSedes.readDatum((DataInput)buffer2, dt2);
            bb1.position(buffer1.getPosition());
            bb2.position(buffer2.getPosition());
            return DataType.compare(map1, map2, (byte)100, (byte)100);
        }

        private static byte getGeneralizedDataType(byte type) {
            switch (type) {
                case 27: {
                    return 1;
                }
                case 0: 
                case 1: {
                    return 5;
                }
                case 2: {
                    return 6;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    return 10;
                }
                case 8: {
                    return 15;
                }
                case 9: {
                    return 20;
                }
                case 10: {
                    return 25;
                }
                case 11: 
                case 12: 
                case 13: {
                    return 50;
                }
                case 14: 
                case 15: {
                    return 55;
                }
                case 19: 
                case 20: 
                case 21: {
                    return 110;
                }
                case 22: 
                case 23: 
                case 24: {
                    return 120;
                }
                case 16: 
                case 17: 
                case 18: {
                    return 100;
                }
                case 26: {
                    return 127;
                }
                case 25: {
                    return 123;
                }
            }
            throw new RuntimeException("Unexpected data type " + type + " found in stream.");
        }

        private static int readInt(ByteBuffer bb, byte type) {
            switch (type) {
                case 4: {
                    return 0;
                }
                case 5: {
                    return 1;
                }
                case 7: {
                    return bb.get();
                }
                case 6: {
                    return bb.getShort();
                }
                case 3: {
                    return bb.getInt();
                }
            }
            throw new RuntimeException("Unexpected data type " + type + " found in stream.");
        }

        private static int readSize(ByteBuffer bb) {
            return BinInterSedesTupleRawComparator.readSize(bb, bb.get());
        }

        private static int readSize(ByteBuffer bb, byte type) {
            switch (type) {
                case 13: 
                case 18: 
                case 21: 
                case 24: {
                    return BinInterSedesTupleRawComparator.getUnsignedByte(bb);
                }
                case 12: 
                case 15: 
                case 17: 
                case 20: 
                case 23: {
                    return BinInterSedesTupleRawComparator.getUnsignedShort(bb);
                }
                case 11: 
                case 14: 
                case 16: 
                case 19: 
                case 22: {
                    return bb.getInt();
                }
            }
            throw new RuntimeException("Unexpected data type " + type + " found in stream.");
        }

        private static int getUnsignedShort(ByteBuffer bb) {
            return (bb.get() & 0xFF) << 8 | bb.get() & 0xFF;
        }

        private static int getUnsignedByte(ByteBuffer bb) {
            return bb.get() & 0xFF;
        }
    }
}

