/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.data;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.hadoop.io.Writable;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.classification.InterfaceAudience;
import org.apache.pig.classification.InterfaceStability;
import org.apache.pig.data.BagFactory;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.DataType;
import org.apache.pig.data.InternalMap;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;

@InterfaceAudience.Private
@InterfaceStability.Stable
public class DataReaderWriter {
    private static TupleFactory mTupleFactory = TupleFactory.getInstance();
    private static BagFactory mBagFactory = BagFactory.getInstance();
    static final int UNSIGNED_SHORT_MAX = 65535;
    public static final String UTF8 = "UTF-8";

    public static Tuple bytesToTuple(DataInput in) throws IOException {
        int sz = in.readInt();
        if (sz < 0) {
            throw new IOException("Invalid size " + sz + " for a tuple");
        }
        Tuple t = mTupleFactory.newTuple(sz);
        for (int i = 0; i < sz; ++i) {
            t.set(i, DataReaderWriter.readDatum(in));
        }
        return t;
    }

    public static DataBag bytesToBag(DataInput in) throws IOException {
        DataBag bag = mBagFactory.newDefaultBag();
        long size = in.readLong();
        for (long i = 0L; i < size; ++i) {
            Object o = DataReaderWriter.readDatum(in);
            bag.add((Tuple)o);
            continue;
        }
        return bag;
    }

    public static Map<String, Object> bytesToMap(DataInput in) throws IOException {
        int size = in.readInt();
        HashMap<String, Object> m = new HashMap<String, Object>(size);
        for (int i = 0; i < size; ++i) {
            String key = (String)DataReaderWriter.readDatum(in);
            m.put(key, DataReaderWriter.readDatum(in));
        }
        return m;
    }

    public static InternalMap bytesToInternalMap(DataInput in) throws IOException {
        int size = in.readInt();
        InternalMap m = new InternalMap(size);
        for (int i = 0; i < size; ++i) {
            Object key = DataReaderWriter.readDatum(in);
            m.put(key, DataReaderWriter.readDatum(in));
        }
        return m;
    }

    public static String bytesToCharArray(DataInput in) throws IOException {
        int size = in.readUnsignedShort();
        byte[] ba = new byte[size];
        in.readFully(ba);
        return new String(ba, UTF8);
    }

    public static String bytesToBigCharArray(DataInput in) throws IOException {
        int size = in.readInt();
        byte[] ba = new byte[size];
        in.readFully(ba);
        return new String(ba, UTF8);
    }

    public static Writable bytesToWritable(DataInput in) throws IOException {
        String className = (String)DataReaderWriter.readDatum(in);
        Class<?> objClass = null;
        try {
            objClass = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new IOException("Could not find class " + className + ", while attempting to de-serialize it ", e);
        }
        Writable writable = null;
        try {
            writable = (Writable)objClass.newInstance();
        }
        catch (Exception e) {
            String msg = "Could create instance of class " + className + ", while attempting to de-serialize it. (no default constructor ?)";
            throw new IOException(msg, e);
        }
        writable.readFields(in);
        return writable;
    }

    public static Object readDatum(DataInput in) throws IOException, ExecException {
        byte b = in.readByte();
        return DataReaderWriter.readDatum(in, b);
    }

    public static Object readDatum(DataInput in, byte type) throws IOException, ExecException {
        switch (type) {
            case 110: {
                return DataReaderWriter.bytesToTuple(in);
            }
            case 120: {
                return DataReaderWriter.bytesToBag(in);
            }
            case 100: {
                return DataReaderWriter.bytesToMap(in);
            }
            case 127: {
                return DataReaderWriter.bytesToInternalMap(in);
            }
            case 10: {
                return in.readInt();
            }
            case 15: {
                return in.readLong();
            }
            case 20: {
                return Float.valueOf(in.readFloat());
            }
            case 25: {
                return in.readDouble();
            }
            case 5: {
                return in.readBoolean();
            }
            case 6: {
                return in.readByte();
            }
            case 50: {
                int size = in.readInt();
                byte[] ba = new byte[size];
                in.readFully(ba);
                return new DataByteArray(ba);
            }
            case 60: {
                return DataReaderWriter.bytesToBigCharArray(in);
            }
            case 55: {
                return DataReaderWriter.bytesToCharArray(in);
            }
            case 123: {
                return DataReaderWriter.bytesToWritable(in);
            }
            case 1: {
                return null;
            }
        }
        throw new RuntimeException("Unexpected data type " + type + " found in stream.");
    }

    public static void writeDatum(DataOutput out, Object val) throws IOException {
        byte type = DataType.findType(val);
        switch (type) {
            case 110: {
                Tuple t = (Tuple)val;
                out.writeByte(110);
                int sz = t.size();
                out.writeInt(sz);
                for (int i = 0; i < sz; ++i) {
                    DataReaderWriter.writeDatum(out, t.get(i));
                }
                break;
            }
            case 120: {
                DataBag bag = (DataBag)val;
                out.writeByte(120);
                out.writeLong(bag.size());
                Iterator<Tuple> it = bag.iterator();
                while (it.hasNext()) {
                    DataReaderWriter.writeDatum(out, it.next());
                }
                break;
            }
            case 100: {
                out.writeByte(100);
                Map m = (Map)val;
                out.writeInt(m.size());
                for (Map.Entry entry : m.entrySet()) {
                    DataReaderWriter.writeDatum(out, entry.getKey());
                    DataReaderWriter.writeDatum(out, entry.getValue());
                }
                break;
            }
            case 127: {
                out.writeByte(127);
                Map m = (Map)val;
                out.writeInt(m.size());
                for (Map.Entry entry : m.entrySet()) {
                    DataReaderWriter.writeDatum(out, entry.getKey());
                    DataReaderWriter.writeDatum(out, entry.getValue());
                }
                break;
            }
            case 10: {
                out.writeByte(10);
                out.writeInt((Integer)val);
                break;
            }
            case 15: {
                out.writeByte(15);
                out.writeLong((Long)val);
                break;
            }
            case 20: {
                out.writeByte(20);
                out.writeFloat(((Float)val).floatValue());
                break;
            }
            case 25: {
                out.writeByte(25);
                out.writeDouble((Double)val);
                break;
            }
            case 5: {
                out.writeByte(5);
                out.writeBoolean((Boolean)val);
                break;
            }
            case 6: {
                out.writeByte(6);
                out.writeByte(((Byte)val).byteValue());
                break;
            }
            case 50: {
                out.writeByte(50);
                DataByteArray bytes = (DataByteArray)val;
                out.writeInt(bytes.size());
                out.write(bytes.mData);
                break;
            }
            case 55: {
                String s = (String)val;
                byte[] utfBytes = s.getBytes(UTF8);
                int length = utfBytes.length;
                if (length < 65535) {
                    out.writeByte(55);
                    out.writeShort(length);
                    out.write(utfBytes);
                    break;
                }
                out.writeByte(60);
                out.writeInt(length);
                out.write(utfBytes);
                break;
            }
            case 123: {
                out.writeByte(123);
                DataReaderWriter.writeDatum(out, val.getClass().getName());
                Writable writable = (Writable)val;
                writable.write(out);
                break;
            }
            case 1: {
                out.writeByte(1);
                break;
            }
            default: {
                throw new RuntimeException("Unexpected data type " + type + " found in stream.");
            }
        }
    }
}

