/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.data;

import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import org.apache.pig.PigCounters;
import org.apache.pig.PigWarning;
import org.apache.pig.data.DefaultAbstractBag;
import org.apache.pig.data.Tuple;

public abstract class SortedSpillBag
extends DefaultAbstractBag {
    private static final long serialVersionUID = 1L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long proactive_spill(Comparator<Tuple> comp) {
        if (this.mContents.size() == 0) {
            return 0L;
        }
        if (this.mSpillFiles == null) {
            this.incSpillCount(PigCounters.PROACTIVE_SPILL_COUNT_BAGS);
        }
        long spilled = 0L;
        DataOutputStream out = null;
        try {
            out = this.getSpillFile();
        }
        catch (IOException ioe) {
            this.warn("Unable to create tmp file to spill to disk", PigWarning.UNABLE_TO_CREATE_FILE_TO_SPILL, ioe);
            return 0L;
        }
        try {
            Object[] array = new Tuple[this.mContents.size()];
            this.mContents.toArray(array);
            if (comp == null) {
                Arrays.sort(array);
            } else {
                Arrays.sort(array, comp);
            }
            for (Object t : array) {
                t.write((DataOutput)out);
                if ((++spilled & 0x3FFFL) != 0L) continue;
                this.reportProgress();
            }
            out.flush();
        }
        catch (IOException ioe) {
            this.mSpillFiles.remove(this.mSpillFiles.size() - 1);
            this.warn("Unable to spill contents to disk", PigWarning.UNABLE_TO_SPILL, ioe);
            long l = 0L;
            return l;
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    this.warn("Error closing spill", PigWarning.UNABLE_TO_CLOSE_SPILL_FILE, e);
                }
            }
        }
        this.mContents.clear();
        this.incSpillCount(PigCounters.PROACTIVE_SPILL_COUNT_RECS, spilled);
        return spilled;
    }
}

