/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.impl;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.FileSystem;
import org.apache.log4j.Level;
import org.apache.pig.ExecType;
import org.apache.pig.FuncSpec;
import org.apache.pig.Main;
import org.apache.pig.backend.datastorage.DataStorage;
import org.apache.pig.backend.datastorage.DataStorageException;
import org.apache.pig.backend.datastorage.ElementDescriptor;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.datastorage.HDataStorage;
import org.apache.pig.backend.hadoop.executionengine.HExecutionEngine;
import org.apache.pig.backend.hadoop.streaming.HadoopExecutableManager;
import org.apache.pig.impl.streaming.ExecutableManager;
import org.apache.pig.impl.streaming.StreamingCommand;
import org.apache.pig.impl.util.JarManager;

public class PigContext
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final transient Log log = LogFactory.getLog(this.getClass());
    public static final String JOB_NAME = "jobName";
    public static final String JOB_NAME_PREFIX = "PigLatin";
    public static final String JOB_PRIORITY = "jobPriority";
    private ExecType execType;
    public transient List<URL> extraJars = new LinkedList<URL>();
    public transient Vector<String> skipJars = new Vector(2);
    private transient DataStorage dfs;
    private transient DataStorage lfs;
    private transient HExecutionEngine executionEngine;
    private Properties properties;
    public List<String> scriptFiles = new ArrayList<String>();
    public List<String> scriptJars = new ArrayList<String>(2);
    private Map<String, FuncSpec> definedFunctions = new HashMap<String, FuncSpec>();
    private Map<String, StreamingCommand> definedCommands = new HashMap<String, StreamingCommand>();
    private static ThreadLocal<ArrayList<String>> packageImportList = new ThreadLocal();
    private Properties log4jProperties = new Properties();
    private Level defaultLogLevel;
    public int defaultParallel = -1;
    public boolean inExplain = false;
    public boolean inIllustrator = false;
    private String last_alias = null;
    List<String> skippedShipPaths = new ArrayList<String>();
    private static ClassLoader classloader = PigContext.class.getClassLoader();

    public PigContext() {
        this(ExecType.MAPREDUCE, new Properties());
    }

    public PigContext(ExecType execType, Properties properties) {
        this.execType = execType;
        this.properties = properties;
        this.properties.setProperty("exectype", this.execType.name());
        String pigJar = JarManager.findContainingJar(Main.class);
        String hadoopJar = JarManager.findContainingJar(FileSystem.class);
        if (pigJar != null) {
            this.skipJars.add(pigJar);
            if (!pigJar.equals(hadoopJar)) {
                this.skipJars.add(hadoopJar);
            }
        }
        this.executionEngine = null;
        this.skippedShipPaths.add("/bin");
        this.skippedShipPaths.add("/usr/bin");
        this.skippedShipPaths.add("/usr/local/bin");
        this.skippedShipPaths.add("/sbin");
        this.skippedShipPaths.add("/usr/sbin");
        this.skippedShipPaths.add("/usr/local/sbin");
    }

    public static void initializeImportList(String importListCommandLineProperties) {
        StringTokenizer tokenizer = new StringTokenizer(importListCommandLineProperties, ":");
        int pos = 0;
        ArrayList<String> importList = PigContext.getPackageImportList();
        while (tokenizer.hasMoreTokens()) {
            String importItem = tokenizer.nextToken();
            if (!importItem.endsWith(".")) {
                importItem = importItem + ".";
            }
            importList.add(pos, importItem);
            ++pos;
        }
    }

    public void connect() throws ExecException {
        switch (this.execType) {
            case LOCAL: 
            case MAPREDUCE: {
                this.executionEngine = new HExecutionEngine(this);
                this.executionEngine.init();
                this.dfs = this.executionEngine.getDataStorage();
                this.lfs = new HDataStorage(URI.create("file:///"), this.properties);
                break;
            }
            default: {
                int errCode = 2040;
                String msg = "Unkown exec type: " + this.execType;
                throw new ExecException(msg, errCode, 4);
            }
        }
    }

    public void setJobtrackerLocation(String newLocation) {
        Properties trackerLocation = new Properties();
        trackerLocation.setProperty("mapred.job.tracker", newLocation);
        try {
            this.executionEngine.updateConfiguration(trackerLocation);
        }
        catch (ExecException e) {
            this.log.error((Object)("Failed to set tracker at: " + newLocation));
        }
    }

    public void addScriptFile(String path) throws MalformedURLException {
        if (path != null) {
            this.scriptFiles.add(path);
        }
    }

    public void addJar(String path) throws MalformedURLException {
        if (path != null) {
            URL resource = new File(path).toURI().toURL();
            this.addJar(resource);
        }
    }

    public void addJar(URL resource) throws MalformedURLException {
        if (resource != null) {
            this.extraJars.add(resource);
            classloader = this.createCl(null);
        }
    }

    public void rename(String oldName, String newName) throws IOException {
        if (oldName.equals(newName)) {
            return;
        }
        System.out.println("Renaming " + oldName + " to " + newName);
        ElementDescriptor dst = null;
        ElementDescriptor src = null;
        try {
            dst = this.dfs.asElement(newName);
            src = this.dfs.asElement(oldName);
        }
        catch (DataStorageException e) {
            byte errSrc = this.getErrorSource();
            int errCode = 0;
            switch (errSrc) {
                case 16: {
                    errCode = 6005;
                    break;
                }
                case 8: {
                    errCode = 4005;
                    break;
                }
                default: {
                    errCode = 2038;
                }
            }
            String msg = "Unable to rename " + oldName + " to " + newName;
            throw new ExecException(msg, errCode, errSrc, e);
        }
        if (dst.exists()) {
            dst.delete();
        }
        src.rename(dst);
    }

    public void copy(String src, String dst, boolean localDst) throws IOException {
        DataStorage dstStorage = this.dfs;
        if (localDst) {
            dstStorage = this.lfs;
        }
        ElementDescriptor srcElement = null;
        ElementDescriptor dstElement = null;
        try {
            srcElement = this.dfs.asElement(src);
            dstElement = dstStorage.asElement(dst);
        }
        catch (DataStorageException e) {
            byte errSrc = this.getErrorSource();
            int errCode = 0;
            switch (errSrc) {
                case 16: {
                    errCode = 6006;
                    break;
                }
                case 8: {
                    errCode = 4006;
                    break;
                }
                default: {
                    errCode = 2039;
                }
            }
            String msg = "Unable to copy " + src + " to " + dst;
            throw new ExecException(msg, errCode, errSrc, e);
        }
        srcElement.copy(dstElement, this.properties, false);
    }

    public HExecutionEngine getExecutionEngine() {
        return this.executionEngine;
    }

    public DataStorage getDfs() {
        return this.dfs;
    }

    public DataStorage getLfs() {
        return this.lfs;
    }

    public DataStorage getFs() {
        return this.dfs;
    }

    public Properties getProperties() {
        return this.properties;
    }

    @Deprecated
    public Properties getConf() {
        return this.getProperties();
    }

    public String getLastAlias() {
        return this.last_alias;
    }

    public void setLastAlias(String value) {
        this.last_alias = value;
    }

    public void registerFunction(String function, FuncSpec functionSpec) {
        if (functionSpec == null) {
            this.definedFunctions.remove(function);
        } else {
            this.definedFunctions.put(function, functionSpec);
        }
    }

    public void registerStreamCmd(String alias, StreamingCommand command) {
        if (command == null) {
            this.definedCommands.remove(alias);
        } else {
            this.definedCommands.put(alias, command);
        }
    }

    public ExecType getExecType() {
        return this.execType;
    }

    public ClassLoader createCl(String jarFile) throws MalformedURLException {
        int len = this.extraJars.size();
        int passedJar = jarFile == null ? 0 : 1;
        URL[] urls = new URL[len + passedJar];
        if (jarFile != null) {
            urls[0] = new URL("file:" + jarFile);
        }
        for (int i = 0; i < this.extraJars.size(); ++i) {
            urls[i + passedJar] = this.extraJars.get(i);
        }
        return new URLClassLoader(urls, PigContext.class.getClassLoader());
    }

    public static Class resolveClassName(String name) throws IOException {
        for (String prefix : PigContext.getPackageImportList()) {
            try {
                Class<?> c = Class.forName(prefix + name, true, classloader);
                return c;
            }
            catch (ClassNotFoundException e) {
            }
            catch (UnsupportedClassVersionError e) {
                int errCode = 1069;
                String msg = "Problem resolving class version numbers for class " + name;
                throw new ExecException(msg, errCode, 2, e);
            }
        }
        int errCode = 1070;
        String msg = "Could not resolve " + name + " using imports: " + packageImportList.get();
        throw new ExecException(msg, errCode, 2);
    }

    public static Object instantiateFuncFromSpec(FuncSpec funcSpec) {
        Object ret;
        String className = funcSpec.getClassName();
        Object[] args = funcSpec.getCtorArgs();
        Class objClass = null;
        try {
            objClass = PigContext.resolveClassName(className);
        }
        catch (IOException ioe) {
            throw new RuntimeException("Cannot instantiate: " + className, ioe);
        }
        try {
            if (args != null && args.length > 0) {
                Class[] paramTypes = new Class[args.length];
                for (int i = 0; i < paramTypes.length; ++i) {
                    paramTypes[i] = String.class;
                }
                Constructor c = objClass.getConstructor(paramTypes);
                ret = c.newInstance(args);
            } else {
                ret = objClass.newInstance();
            }
        }
        catch (NoSuchMethodException nme) {
            try {
                Constructor c = objClass.getConstructor(String[].class);
                Object[] wrappedArgs = new Object[]{args};
                ret = c.newInstance(wrappedArgs);
            }
            catch (Throwable e) {
                StringBuilder sb = new StringBuilder();
                sb.append("could not instantiate '");
                sb.append(className);
                sb.append("' with arguments '");
                sb.append(Arrays.toString(args));
                sb.append("'");
                throw new RuntimeException(sb.toString(), e);
            }
        }
        catch (Throwable e) {
            StringBuilder sb = new StringBuilder();
            sb.append("could not instantiate '");
            sb.append(className);
            sb.append("' with arguments '");
            sb.append(Arrays.toString(args));
            sb.append("'");
            throw new RuntimeException(sb.toString(), e);
        }
        return ret;
    }

    public static Object instantiateFuncFromSpec(String funcSpec) {
        return PigContext.instantiateFuncFromSpec(new FuncSpec(funcSpec));
    }

    public Class getClassForAlias(String alias) throws IOException {
        String className = null;
        FuncSpec funcSpec = null;
        if (this.definedFunctions != null) {
            funcSpec = this.definedFunctions.get(alias);
        }
        className = funcSpec != null ? funcSpec.getClassName() : FuncSpec.getClassNameFromSpec(alias);
        return PigContext.resolveClassName(className);
    }

    public Object instantiateFuncFromAlias(String alias) throws IOException {
        FuncSpec funcSpec;
        if (this.definedFunctions != null && (funcSpec = this.definedFunctions.get(alias)) != null) {
            return PigContext.instantiateFuncFromSpec(funcSpec);
        }
        return PigContext.instantiateFuncFromSpec(alias);
    }

    public StreamingCommand getCommandForAlias(String alias) {
        return this.definedCommands.get(alias);
    }

    public void setExecType(ExecType execType) {
        this.execType = execType;
    }

    public ExecutableManager createExecutableManager() throws ExecException {
        HadoopExecutableManager executableManager = null;
        switch (this.execType) {
            case LOCAL: 
            case MAPREDUCE: {
                executableManager = new HadoopExecutableManager();
                break;
            }
            default: {
                int errCode = 2040;
                String msg = "Unkown exec type: " + this.execType;
                throw new ExecException(msg, errCode, 4);
            }
        }
        return executableManager;
    }

    public FuncSpec getFuncSpecFromAlias(String alias) {
        FuncSpec funcSpec;
        if (this.definedFunctions != null && (funcSpec = this.definedFunctions.get(alias)) != null) {
            return funcSpec;
        }
        return null;
    }

    public void addPathToSkip(String path) {
        this.skippedShipPaths.add(path);
    }

    public List<String> getPathsToSkip() {
        return this.skippedShipPaths;
    }

    public byte getErrorSource() {
        if (this.execType == ExecType.LOCAL || this.execType == ExecType.MAPREDUCE) {
            return 16;
        }
        return 4;
    }

    public static ArrayList<String> getPackageImportList() {
        if (packageImportList.get() == null) {
            ArrayList<String> importlist = new ArrayList<String>();
            importlist.add("");
            importlist.add("org.apache.pig.builtin.");
            importlist.add("org.apache.pig.impl.builtin.");
            packageImportList.set(importlist);
        }
        return packageImportList.get();
    }

    public static void setPackageImportList(ArrayList<String> list) {
        packageImportList.set(list);
    }

    public void setLog4jProperties(Properties p) {
        this.log4jProperties = p;
    }

    public Properties getLog4jProperties() {
        return this.log4jProperties;
    }

    public Level getDefaultLogLevel() {
        return this.defaultLogLevel;
    }

    public void setDefaultLogLevel(Level l) {
        this.defaultLogLevel = l;
    }

    public static ClassLoader getClassLoader() {
        return classloader;
    }

    public static void setClassLoader(ClassLoader cl) {
        classloader = cl;
    }
}

