/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.impl.io;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.pig.data.InterSedes;
import org.apache.pig.data.InterSedesFactory;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.io.BufferedPositionedInputStream;

public class InterRecordReader
extends RecordReader<Text, Tuple> {
    private long start;
    private long pos;
    private long end;
    private BufferedPositionedInputStream in;
    private Tuple value = null;
    public static final int RECORD_1 = 1;
    public static final int RECORD_2 = 2;
    public static final int RECORD_3 = 3;
    private DataInputStream inData = null;
    private static InterSedes sedes = InterSedesFactory.getInterSedesInstance();

    public void initialize(InputSplit genericSplit, TaskAttemptContext context) throws IOException {
        FileSplit split = (FileSplit)genericSplit;
        Configuration job = context.getConfiguration();
        this.start = split.getStart();
        this.end = this.start + split.getLength();
        Path file = split.getPath();
        FileSystem fs = file.getFileSystem(job);
        FSDataInputStream fileIn = fs.open(split.getPath());
        if (this.start != 0L) {
            fileIn.seek(this.start);
        }
        this.in = new BufferedPositionedInputStream((InputStream)fileIn, this.start);
        this.inData = new DataInputStream(this.in);
    }

    public boolean nextKeyValue() throws IOException {
        int b = 0;
        while (true) {
            if (this.in == null || this.in.getPosition() >= this.end) {
                return false;
            }
            if (b != 1) {
                b = this.in.read();
                if (b != 1 && b != -1) continue;
                if (b == -1) {
                    return false;
                }
            }
            if ((b = this.in.read()) != 2 && b != -1) continue;
            if (b == -1) {
                return false;
            }
            b = this.in.read();
            if (b != 3 && b != -1) continue;
            if (b == -1) {
                return false;
            }
            b = this.in.read();
            if (b == 21 || b == 20 || b == 19 || b == -1) break;
        }
        if (b == -1) {
            return false;
        }
        this.value = (Tuple)sedes.readDatum(this.inData, (byte)b);
        this.pos = this.in.getPosition();
        return true;
    }

    public Text getCurrentKey() {
        return null;
    }

    public Tuple getCurrentValue() {
        return this.value;
    }

    public float getProgress() {
        if (this.start == this.end) {
            return 0.0f;
        }
        return Math.min(1.0f, (float)(this.pos - this.start) / (float)(this.end - this.start));
    }

    public synchronized void close() throws IOException {
        if (this.in != null) {
            this.in.close();
        }
    }
}

