/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.impl.io;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.pig.LoadCaster;
import org.apache.pig.LoadFunc;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigSplit;
import org.apache.pig.backend.hadoop.executionengine.shims.HadoopShims;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.plan.OperatorKey;

public class ReadToEndLoader
extends LoadFunc {
    private LoadFunc wrappedLoadFunc;
    private Configuration conf;
    private String inputLocation;
    private int[] toReadSplits = null;
    private int toReadSplitsIdx = 0;
    private int curSplitIndex;
    private List<InputSplit> inpSplits = null;
    private RecordReader reader = null;
    private InputFormat inputFormat = null;

    public ReadToEndLoader(LoadFunc wrappedLoadFunc, Configuration conf, String inputLocation, int splitIndex) throws IOException {
        this.wrappedLoadFunc = wrappedLoadFunc;
        this.inputLocation = inputLocation;
        this.conf = conf;
        this.curSplitIndex = splitIndex;
        this.init();
    }

    public ReadToEndLoader(LoadFunc wrappedLoadFunc, Configuration conf, String inputLocation, int[] toReadSplitIdxs) throws IOException {
        this.wrappedLoadFunc = wrappedLoadFunc;
        this.inputLocation = inputLocation;
        this.toReadSplits = toReadSplitIdxs;
        this.conf = conf;
        this.curSplitIndex = toReadSplitIdxs.length > 0 ? toReadSplitIdxs[0] : Integer.MAX_VALUE;
        this.init();
    }

    private void init() throws IOException {
        this.conf = new Configuration(this.conf);
        Job job = new Job(this.conf);
        this.wrappedLoadFunc.setLocation(this.inputLocation, job);
        this.conf = job.getConfiguration();
        this.inputFormat = this.wrappedLoadFunc.getInputFormat();
        try {
            this.inpSplits = this.inputFormat.getSplits(HadoopShims.createJobContext(this.conf, new JobID()));
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    private boolean initializeReader() throws IOException, InterruptedException {
        if (this.curSplitIndex > this.inpSplits.size() - 1) {
            return false;
        }
        if (this.reader != null) {
            this.reader.close();
        }
        InputSplit curSplit = this.inpSplits.get(this.curSplitIndex);
        TaskAttemptContext tAContext = HadoopShims.createTaskAttemptContext(this.conf, new TaskAttemptID());
        this.reader = this.inputFormat.createRecordReader(curSplit, tAContext);
        this.reader.initialize(curSplit, tAContext);
        PigSplit pigSplit = new PigSplit(new InputSplit[]{curSplit}, -1, new ArrayList<OperatorKey>(), -1);
        this.wrappedLoadFunc.prepareToRead(this.reader, pigSplit);
        return true;
    }

    @Override
    public Tuple getNext() throws IOException {
        try {
            Tuple t = null;
            if (this.reader == null) {
                return this.getNextHelper();
            }
            t = this.wrappedLoadFunc.getNext();
            if (t != null) {
                return t;
            }
            this.updateCurSplitIndex();
            return this.getNextHelper();
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    private Tuple getNextHelper() throws IOException, InterruptedException {
        Tuple t = null;
        while (this.initializeReader()) {
            t = this.wrappedLoadFunc.getNext();
            if (t == null) {
                this.updateCurSplitIndex();
                continue;
            }
            return t;
        }
        return null;
    }

    private void updateCurSplitIndex() {
        if (this.toReadSplits == null) {
            ++this.curSplitIndex;
        } else {
            ++this.toReadSplitsIdx;
            this.curSplitIndex = this.toReadSplitsIdx >= this.toReadSplits.length ? Integer.MAX_VALUE : this.toReadSplits[this.toReadSplitsIdx];
        }
    }

    @Override
    public InputFormat getInputFormat() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public LoadCaster getLoadCaster() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void prepareToRead(RecordReader reader, PigSplit split) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setLocation(String location, Job job) throws IOException {
    }
}

