/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.impl.util;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Job;
import org.apache.pig.FileInputLoadFunc;
import org.apache.pig.FuncSpec;
import org.apache.pig.LoadFunc;
import org.apache.pig.ResourceSchema;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.data.DataType;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.PigContext;
import org.apache.pig.impl.io.InterStorage;
import org.apache.pig.impl.io.ReadToEndLoader;
import org.apache.pig.impl.io.TFileStorage;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import org.apache.pig.impl.util.ObjectSerializer;
import org.apache.pig.newplan.logical.Util;
import org.apache.pig.newplan.logical.relational.LogicalSchema;
import org.apache.pig.parser.ParserException;
import org.apache.pig.parser.QueryParserDriver;

public class Utils {
    public static boolean checkNullEquals(Object obj1, Object obj2, boolean checkEquality) {
        if (obj1 == null || obj2 == null) {
            return obj1 == obj2;
        }
        return !checkEquality || obj1.equals(obj2);
    }

    public static boolean checkNullAndClass(Object obj1, Object obj2) {
        if (Utils.checkNullEquals(obj1, obj2, false)) {
            if (obj1 != null) {
                return obj1.getClass() == obj2.getClass();
            }
            return true;
        }
        return false;
    }

    public static Schema getScriptSchema(String loadFuncSignature, Configuration conf) throws IOException {
        Schema scriptSchema = null;
        String scriptField = conf.get(loadFuncSignature + ".scriptSchema");
        if (scriptField != null) {
            scriptSchema = (Schema)ObjectSerializer.deserialize(scriptField);
        }
        return scriptSchema;
    }

    public static ResourceSchema getSchema(LoadFunc wrappedLoadFunc, String location, boolean checkExistence, Job job) throws IOException {
        ReadToEndLoader loader;
        Tuple t;
        Configuration conf = job.getConfiguration();
        if (checkExistence) {
            Path path = new Path(location);
            if (!FileSystem.get((Configuration)conf).exists(path)) {
                return null;
            }
        }
        if ((t = (loader = new ReadToEndLoader(wrappedLoadFunc, conf, location, 0)).getNext()) == null) {
            return null;
        }
        int numFields = t.size();
        Schema s = new Schema();
        for (int i = 0; i < numFields; ++i) {
            try {
                s.add(DataType.determineFieldSchema(t.get(i)));
                continue;
            }
            catch (Exception e) {
                int errCode = 2104;
                String msg = "Error while determining schema of SequenceFileStorage data.";
                throw new ExecException(msg, errCode, 4, e);
            }
        }
        return new ResourceSchema(s);
    }

    public static Schema getSchemaFromString(String schemaString) throws ParserException {
        LogicalSchema schema = Utils.parseSchema(schemaString);
        Schema result = Util.translateSchema(schema);
        Schema.setSchemaDefaultType(result, (byte)50);
        return result;
    }

    public static LogicalSchema parseSchema(String schemaString) throws ParserException {
        QueryParserDriver queryParser = new QueryParserDriver(new PigContext(), "util", new HashMap<String, String>());
        LogicalSchema schema = queryParser.parseSchema(schemaString);
        return schema;
    }

    public static String getTmpFileCompressorName(PigContext pigContext) {
        if (pigContext == null) {
            return InterStorage.class.getName();
        }
        boolean tmpFileCompression = pigContext.getProperties().getProperty("pig.tmpfilecompression", "false").equals("true");
        String codec = pigContext.getProperties().getProperty("pig.tmpfilecompression.codec", "");
        if (tmpFileCompression) {
            if (codec.equals("lzo")) {
                pigContext.getProperties().setProperty("io.compression.codec.lzo.class", "com.hadoop.compression.lzo.LzoCodec");
            }
            return TFileStorage.class.getName();
        }
        return InterStorage.class.getName();
    }

    public static FileInputLoadFunc getTmpFileStorageObject(Configuration conf) throws IOException {
        boolean tmpFileCompression = conf.getBoolean("pig.tmpfilecompression", false);
        return tmpFileCompression ? new TFileStorage() : new InterStorage();
    }

    public static boolean tmpFileCompression(PigContext pigContext) {
        if (pigContext == null) {
            return false;
        }
        return pigContext.getProperties().getProperty("pig.tmpfilecompression", "false").equals("true");
    }

    public static String tmpFileCompressionCodec(PigContext pigContext) throws IOException {
        if (pigContext == null) {
            return "";
        }
        String codec = pigContext.getProperties().getProperty("pig.tmpfilecompression.codec", "");
        if (codec.equals("gz") || codec.equals("lzo")) {
            return codec;
        }
        throw new IOException("Invalid temporary file compression codec [" + codec + "]. Expected compression codecs are gz and lzo");
    }

    public static String getStringFromArray(String[] arr) {
        StringBuilder str = new StringBuilder();
        for (String s : arr) {
            str.append(s);
            str.append(" ");
        }
        return str.toString();
    }

    public static FuncSpec buildSimpleFuncSpec(String className, byte ... types) {
        ArrayList fieldSchemas = Lists.newArrayListWithExpectedSize((int)types.length);
        for (byte type : types) {
            fieldSchemas.add(new Schema.FieldSchema(null, type));
        }
        return new FuncSpec(className, new Schema(fieldSchemas));
    }

    public static String slashisize(String str) {
        return str.replace("\\\\", "\\");
    }

    public static <O> Collection<O> mergeCollection(Collection<O> a, Collection<O> b) {
        if (a == null && b == null) {
            return null;
        }
        Collection result = null;
        try {
            result = a != null ? (Collection)a.getClass().newInstance() : (Collection)b.getClass().newInstance();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (a == null) {
            result.addAll(b);
        } else if (b == null) {
            result.addAll(a);
        } else {
            result.addAll(a);
            for (O o : b) {
                if (result.contains(o)) continue;
                result.add(o);
            }
        }
        return result;
    }
}

