/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.newplan.logical.relational;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.apache.pig.FuncSpec;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.LogicalToPhysicalTranslatorException;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.PhysicalOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.ConstantExpression;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.POProject;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.POUserComparisonFunc;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.POUserFunc;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhysicalPlan;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POCollectedGroup;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.PODistinct;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POFRJoin;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POFilter;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POForEach;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POGlobalRearrange;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POLimit;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POLoad;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POLocalRearrange;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POMergeCogroup;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POMergeJoin;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.PONative;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POPackage;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POSkewedJoin;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POSort;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POSplit;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POStore;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POStream;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POUnion;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.PigContext;
import org.apache.pig.impl.builtin.GFCross;
import org.apache.pig.impl.io.FileLocalizer;
import org.apache.pig.impl.io.FileSpec;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.plan.NodeIdGenerator;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.plan.PlanException;
import org.apache.pig.impl.plan.VisitorException;
import org.apache.pig.impl.util.CompilerUtils;
import org.apache.pig.impl.util.LinkedMultiMap;
import org.apache.pig.impl.util.MultiMap;
import org.apache.pig.impl.util.Utils;
import org.apache.pig.newplan.DependencyOrderWalker;
import org.apache.pig.newplan.Operator;
import org.apache.pig.newplan.OperatorPlan;
import org.apache.pig.newplan.PlanWalker;
import org.apache.pig.newplan.ReverseDependencyOrderWalkerWOSeenChk;
import org.apache.pig.newplan.SubtreeDependencyOrderWalker;
import org.apache.pig.newplan.logical.Util;
import org.apache.pig.newplan.logical.expression.ExpToPhyTranslationVisitor;
import org.apache.pig.newplan.logical.expression.LogicalExpressionPlan;
import org.apache.pig.newplan.logical.expression.ProjectExpression;
import org.apache.pig.newplan.logical.relational.LOCogroup;
import org.apache.pig.newplan.logical.relational.LOCross;
import org.apache.pig.newplan.logical.relational.LODistinct;
import org.apache.pig.newplan.logical.relational.LOFilter;
import org.apache.pig.newplan.logical.relational.LOForEach;
import org.apache.pig.newplan.logical.relational.LOGenerate;
import org.apache.pig.newplan.logical.relational.LOInnerLoad;
import org.apache.pig.newplan.logical.relational.LOJoin;
import org.apache.pig.newplan.logical.relational.LOLimit;
import org.apache.pig.newplan.logical.relational.LOLoad;
import org.apache.pig.newplan.logical.relational.LONative;
import org.apache.pig.newplan.logical.relational.LOSort;
import org.apache.pig.newplan.logical.relational.LOSplit;
import org.apache.pig.newplan.logical.relational.LOSplitOutput;
import org.apache.pig.newplan.logical.relational.LOStore;
import org.apache.pig.newplan.logical.relational.LOStream;
import org.apache.pig.newplan.logical.relational.LOUnion;
import org.apache.pig.newplan.logical.relational.LogicalPlan;
import org.apache.pig.newplan.logical.relational.LogicalRelationalNodesVisitor;
import org.apache.pig.newplan.logical.relational.LogicalRelationalOperator;
import org.apache.pig.newplan.logical.relational.LogicalSchema;

public class LogToPhyTranslationVisitor
extends LogicalRelationalNodesVisitor {
    protected Map<Operator, PhysicalOperator> logToPhyMap;
    protected Stack<PhysicalPlan> currentPlans;
    protected PhysicalPlan currentPlan;
    protected NodeIdGenerator nodeGen = NodeIdGenerator.getGenerator();
    protected PigContext pc;

    public LogToPhyTranslationVisitor(OperatorPlan plan) throws FrontendException {
        super(plan, new DependencyOrderWalker(plan));
        this.currentPlan = new PhysicalPlan();
        this.logToPhyMap = new HashMap<Operator, PhysicalOperator>();
        this.currentPlans = new Stack();
    }

    public void setPigContext(PigContext pc) {
        this.pc = pc;
    }

    public Map<Operator, PhysicalOperator> getLogToPhyMap() {
        return this.logToPhyMap;
    }

    public PhysicalPlan getPhysicalPlan() {
        return this.currentPlan;
    }

    @Override
    public void visit(LOLoad loLoad) throws FrontendException {
        String scope = "scope";
        POLoad load = new POLoad(new OperatorKey(scope, this.nodeGen.getNextNodeId(scope)), loLoad.getLoadFunc());
        load.setAlias(loLoad.getAlias());
        load.setLFile(loLoad.getFileSpec());
        load.setPc(this.pc);
        load.setResultType((byte)120);
        load.setSignature(loLoad.getSignature());
        this.currentPlan.add(load);
        this.logToPhyMap.put(loLoad, load);
        List<Operator> op = loLoad.getPlan().getPredecessors(loLoad);
        if (op != null) {
            PhysicalOperator from = this.logToPhyMap.get(op.get(0));
            try {
                this.currentPlan.connect(from, load);
            }
            catch (PlanException e) {
                int errCode = 2015;
                String msg = "Invalid physical operators in the physical plan";
                throw new LogicalToPhysicalTranslatorException(msg, errCode, 4, (Throwable)e);
            }
        }
    }

    @Override
    public void visit(LONative loNative) throws FrontendException {
        String scope = "scope";
        PONative poNative = new PONative(new OperatorKey(scope, this.nodeGen.getNextNodeId(scope)));
        poNative.setAlias(loNative.getAlias());
        poNative.setNativeMRjar(loNative.getNativeMRJar());
        poNative.setParams(loNative.getParams());
        poNative.setResultType((byte)120);
        this.logToPhyMap.put(loNative, poNative);
        this.currentPlan.add(poNative);
        List<Operator> op = loNative.getPlan().getPredecessors(loNative);
        if (op == null) {
            int errCode = 2051;
            String msg = "Did not find a predecessor for Native.";
            throw new LogicalToPhysicalTranslatorException(msg, errCode, 4);
        }
        PhysicalOperator from = this.logToPhyMap.get(op.get(0));
        try {
            this.currentPlan.connect(from, poNative);
        }
        catch (PlanException e) {
            int errCode = 2015;
            String msg = "Invalid physical operators in the physical plan";
            throw new LogicalToPhysicalTranslatorException(msg, errCode, 4, (Throwable)e);
        }
    }

    @Override
    public void visit(LOFilter filter) throws FrontendException {
        String scope = "scope";
        POFilter poFilter = new POFilter(new OperatorKey(scope, this.nodeGen.getNextNodeId(scope)), filter.getRequestedParallelisam());
        poFilter.setAlias(filter.getAlias());
        poFilter.setResultType((byte)120);
        this.currentPlan.add(poFilter);
        this.logToPhyMap.put(filter, poFilter);
        this.currentPlans.push(this.currentPlan);
        this.currentPlan = new PhysicalPlan();
        ReverseDependencyOrderWalkerWOSeenChk childWalker = new ReverseDependencyOrderWalkerWOSeenChk(filter.getFilterPlan());
        this.pushWalker(childWalker);
        this.currentWalker.walk(new ExpToPhyTranslationVisitor(this.currentWalker.getPlan(), childWalker, filter, this.currentPlan, this.logToPhyMap));
        this.popWalker();
        poFilter.setPlan(this.currentPlan);
        this.currentPlan = this.currentPlans.pop();
        List<Operator> op = filter.getPlan().getPredecessors(filter);
        if (op == null) {
            int errCode = 2051;
            String msg = "Did not find a predecessor for Filter.";
            throw new LogicalToPhysicalTranslatorException(msg, errCode, 4);
        }
        PhysicalOperator from = this.logToPhyMap.get(op.get(0));
        try {
            this.currentPlan.connect(from, poFilter);
        }
        catch (PlanException e) {
            int errCode = 2015;
            String msg = "Invalid physical operators in the physical plan";
            throw new LogicalToPhysicalTranslatorException(msg, errCode, 4, (Throwable)e);
        }
        this.translateSoftLinks(filter);
    }

    @Override
    public void visit(LOSort sort) throws FrontendException {
        POSort poSort;
        String scope = "scope";
        List<LogicalExpressionPlan> logPlans = sort.getSortColPlans();
        ArrayList<PhysicalPlan> sortPlans = new ArrayList<PhysicalPlan>(logPlans.size());
        this.currentPlans.push(this.currentPlan);
        for (LogicalExpressionPlan plan : logPlans) {
            this.currentPlan = new PhysicalPlan();
            ReverseDependencyOrderWalkerWOSeenChk childWalker = new ReverseDependencyOrderWalkerWOSeenChk(plan);
            this.pushWalker(childWalker);
            ((PlanWalker)childWalker).walk(new ExpToPhyTranslationVisitor(this.currentWalker.getPlan(), childWalker, sort, this.currentPlan, this.logToPhyMap));
            sortPlans.add(this.currentPlan);
            this.popWalker();
        }
        this.currentPlan = this.currentPlans.pop();
        if (sort.getUserFunc() == null) {
            poSort = new POSort(new OperatorKey(scope, this.nodeGen.getNextNodeId(scope)), sort.getRequestedParallelisam(), null, sortPlans, sort.getAscendingCols(), null);
        } else {
            POUserComparisonFunc comparator = new POUserComparisonFunc(new OperatorKey(scope, this.nodeGen.getNextNodeId(scope)), sort.getRequestedParallelisam(), null, sort.getUserFunc());
            poSort = new POSort(new OperatorKey(scope, this.nodeGen.getNextNodeId(scope)), sort.getRequestedParallelisam(), null, sortPlans, sort.getAscendingCols(), comparator);
        }
        poSort.setAlias(sort.getAlias());
        poSort.setLimit(sort.getLimit());
        this.logToPhyMap.put(sort, poSort);
        this.currentPlan.add(poSort);
        List<Operator> op = sort.getPlan().getPredecessors(sort);
        if (op == null) {
            int errCode = 2051;
            String msg = "Did not find a predecessor for Sort.";
            throw new LogicalToPhysicalTranslatorException(msg, errCode, 4);
        }
        PhysicalOperator from = this.logToPhyMap.get(op.get(0));
        try {
            this.currentPlan.connect(from, poSort);
        }
        catch (PlanException e) {
            int errCode = 2015;
            String msg = "Invalid physical operators in the physical plan";
            throw new LogicalToPhysicalTranslatorException(msg, errCode, 4, (Throwable)e);
        }
        poSort.setResultType((byte)120);
    }

    @Override
    public void visit(LOCross cross) throws FrontendException {
        String scope = "scope";
        List<Operator> inputs = cross.getPlan().getPredecessors(cross);
        POGlobalRearrange poGlobal = new POGlobalRearrange(new OperatorKey(scope, this.nodeGen.getNextNodeId(scope)), cross.getRequestedParallelisam());
        poGlobal.setAlias(cross.getAlias());
        POPackage poPackage = new POPackage(new OperatorKey(scope, this.nodeGen.getNextNodeId(scope)), cross.getRequestedParallelisam());
        poGlobal.setAlias(cross.getAlias());
        this.currentPlan.add(poGlobal);
        this.currentPlan.add(poPackage);
        int count = 0;
        try {
            this.currentPlan.connect(poGlobal, poPackage);
            List<Boolean> flattenLst = Arrays.asList(true, true);
            for (Operator op : inputs) {
                PhysicalPlan fep1 = new PhysicalPlan();
                ConstantExpression ce1 = new ConstantExpression(new OperatorKey(scope, this.nodeGen.getNextNodeId(scope)), cross.getRequestedParallelisam());
                ce1.setValue(inputs.size());
                ce1.setResultType((byte)10);
                fep1.add(ce1);
                ConstantExpression ce2 = new ConstantExpression(new OperatorKey(scope, this.nodeGen.getNextNodeId(scope)), cross.getRequestedParallelisam());
                ce2.setValue(count);
                ce2.setResultType((byte)10);
                fep1.add(ce2);
                POUserFunc gfc = new POUserFunc(new OperatorKey(scope, this.nodeGen.getNextNodeId(scope)), cross.getRequestedParallelisam(), Arrays.asList(ce1, ce2), new FuncSpec(GFCross.class.getName()));
                gfc.setAlias(cross.getAlias());
                gfc.setResultType((byte)120);
                fep1.addAsLeaf(gfc);
                gfc.setInputs(Arrays.asList(ce1, ce2));
                PhysicalPlan fep2 = new PhysicalPlan();
                POProject feproj = new POProject(new OperatorKey(scope, this.nodeGen.getNextNodeId(scope)), cross.getRequestedParallelisam());
                feproj.setAlias(cross.getAlias());
                feproj.setResultType((byte)110);
                feproj.setStar(true);
                feproj.setOverloaded(false);
                fep2.add(feproj);
                List<PhysicalPlan> fePlans = Arrays.asList(fep1, fep2);
                POForEach fe = new POForEach(new OperatorKey(scope, this.nodeGen.getNextNodeId(scope)), cross.getRequestedParallelisam(), fePlans, flattenLst);
                fe.setAlias(cross.getAlias());
                this.currentPlan.add(fe);
                this.currentPlan.connect(this.logToPhyMap.get(op), fe);
                POLocalRearrange physOp = new POLocalRearrange(new OperatorKey(scope, this.nodeGen.getNextNodeId(scope)), cross.getRequestedParallelisam());
                physOp.setAlias(cross.getAlias());
                ArrayList<PhysicalPlan> lrPlans = new ArrayList<PhysicalPlan>();
                for (int i = 0; i < inputs.size(); ++i) {
                    PhysicalPlan lrp1 = new PhysicalPlan();
                    POProject lrproj1 = new POProject(new OperatorKey(scope, this.nodeGen.getNextNodeId(scope)), cross.getRequestedParallelisam(), i);
                    lrproj1.setAlias(cross.getAlias());
                    lrproj1.setOverloaded(false);
                    lrproj1.setResultType((byte)10);
                    lrp1.add(lrproj1);
                    lrPlans.add(lrp1);
                }
                physOp.setCross(true);
                physOp.setIndex(count++);
                physOp.setKeyType((byte)110);
                physOp.setPlans(lrPlans);
                physOp.setResultType((byte)110);
                this.currentPlan.add(physOp);
                this.currentPlan.connect(fe, physOp);
                this.currentPlan.connect(physOp, poGlobal);
            }
        }
        catch (PlanException e1) {
            int errCode = 2015;
            String msg = "Invalid physical operators in the physical plan";
            throw new LogicalToPhysicalTranslatorException(msg, errCode, 4, (Throwable)e1);
        }
        catch (ExecException e) {
            int errCode = 2058;
            String msg = "Unable to set index on newly create POLocalRearrange.";
            throw new VisitorException(msg, errCode, 4, (Throwable)e);
        }
        poPackage.setKeyType((byte)110);
        poPackage.setResultType((byte)110);
        poPackage.setNumInps(count);
        boolean[] inner = new boolean[count];
        for (int i = 0; i < count; ++i) {
            inner[i] = true;
        }
        poPackage.setInner(inner);
        ArrayList<PhysicalPlan> fePlans = new ArrayList<PhysicalPlan>();
        ArrayList<Boolean> flattenLst = new ArrayList<Boolean>();
        for (int i = 1; i <= count; ++i) {
            PhysicalPlan fep1 = new PhysicalPlan();
            POProject feproj1 = new POProject(new OperatorKey(scope, this.nodeGen.getNextNodeId(scope)), cross.getRequestedParallelisam(), i);
            feproj1.setAlias(cross.getAlias());
            feproj1.setResultType((byte)120);
            feproj1.setOverloaded(false);
            fep1.add(feproj1);
            fePlans.add(fep1);
            flattenLst.add(true);
        }
        POForEach fe = new POForEach(new OperatorKey(scope, this.nodeGen.getNextNodeId(scope)), cross.getRequestedParallelisam(), fePlans, flattenLst);
        fe.setAlias(cross.getAlias());
        this.currentPlan.add(fe);
        try {
            this.currentPlan.connect(poPackage, fe);
        }
        catch (PlanException e1) {
            int errCode = 2015;
            String msg = "Invalid physical operators in the physical plan";
            throw new LogicalToPhysicalTranslatorException(msg, errCode, 4, (Throwable)e1);
        }
        this.logToPhyMap.put(cross, fe);
    }

    @Override
    public void visit(LOStream stream) throws FrontendException {
        String scope = "scope";
        POStream poStream = new POStream(new OperatorKey(scope, this.nodeGen.getNextNodeId(scope)), stream.getExecutableManager(), stream.getStreamingCommand(), this.pc.getProperties());
        poStream.setAlias(stream.getAlias());
        this.currentPlan.add(poStream);
        this.logToPhyMap.put(stream, poStream);
        List<Operator> op = stream.getPlan().getPredecessors(stream);
        if (op == null) {
            int errCode = 2051;
            String msg = "Did not find a predecessor for Stream.";
            throw new LogicalToPhysicalTranslatorException(msg, errCode, 4);
        }
        PhysicalOperator from = this.logToPhyMap.get(op.get(0));
        try {
            this.currentPlan.connect(from, poStream);
        }
        catch (PlanException e) {
            int errCode = 2015;
            String msg = "Invalid physical operators in the physical plan";
            throw new LogicalToPhysicalTranslatorException(msg, errCode, 4, (Throwable)e);
        }
    }

    @Override
    public void visit(LOInnerLoad load) throws FrontendException {
        String scope = "scope";
        POProject exprOp = new POProject(new OperatorKey(scope, this.nodeGen.getNextNodeId(scope)));
        LogicalSchema s = load.getSchema();
        if (load.sourceIsBag()) {
            exprOp.setResultType((byte)120);
            exprOp.setOverloaded(true);
        } else if (s != null) {
            exprOp.setResultType(s.getField((int)0).type);
        } else {
            exprOp.setResultType((byte)50);
        }
        ProjectExpression proj = load.getProjection();
        if (proj.isProjectStar()) {
            exprOp.setStar(proj.isProjectStar());
        } else if (proj.isRangeProject()) {
            if (proj.getEndCol() != -1) {
                throw new AssertionError((Object)"project range that is not a project-to-end seen in translation to physical plan!");
            }
            exprOp.setProjectToEnd(proj.getStartCol());
        } else {
            exprOp.setColumn(load.getColNum());
        }
        this.logToPhyMap.put(load, exprOp);
        this.currentPlan.add(exprOp);
    }

    @Override
    public void visit(LOForEach foreach) throws FrontendException {
        String scope = "scope";
        ArrayList<PhysicalPlan> innerPlans = new ArrayList<PhysicalPlan>();
        LogicalPlan inner = foreach.getInnerPlan();
        LOGenerate gen = (LOGenerate)inner.getSinks().get(0);
        List<LogicalExpressionPlan> exps = gen.getOutputPlans();
        List<Operator> preds = inner.getPredecessors(gen);
        this.currentPlans.push(this.currentPlan);
        for (int i = 0; i < exps.size(); ++i) {
            this.currentPlan = new PhysicalPlan();
            PlanWalker childWalker = new ReverseDependencyOrderWalkerWOSeenChk(exps.get(i));
            this.pushWalker(childWalker);
            childWalker.walk(new ExpToPhyTranslationVisitor(exps.get(i), childWalker, gen, this.currentPlan, this.logToPhyMap));
            this.popWalker();
            List<Operator> leaves = exps.get(i).getSinks();
            for (Operator l : leaves) {
                PhysicalOperator op = this.logToPhyMap.get(l);
                if (!(l instanceof ProjectExpression)) continue;
                int input = ((ProjectExpression)l).getInputNum();
                Operator pred = preds.get(input);
                childWalker = new SubtreeDependencyOrderWalker(inner, pred);
                this.pushWalker(childWalker);
                childWalker.walk(this);
                this.popWalker();
                PhysicalOperator leaf = this.logToPhyMap.get(pred);
                if (pred instanceof LOInnerLoad) {
                    this.currentPlan.remove(leaf);
                    this.logToPhyMap.remove(pred);
                    POProject leafProj = (POProject)leaf;
                    try {
                        if (leafProj.isStar()) {
                            ((POProject)op).setStar(true);
                            continue;
                        }
                        if (leafProj.isProjectToEnd()) {
                            ((POProject)op).setProjectToEnd(leafProj.getStartCol());
                            continue;
                        }
                        ((POProject)op).setColumn(leafProj.getColumn());
                        continue;
                    }
                    catch (ExecException e) {
                        throw new FrontendException((Operator)foreach, "Cannot get column from " + leaf, 2230, (Throwable)e);
                    }
                }
                this.currentPlan.connect(leaf, op);
            }
            innerPlans.add(this.currentPlan);
        }
        this.currentPlan = this.currentPlans.pop();
        boolean[] flatten = gen.getFlattenFlags();
        ArrayList<Boolean> flattenList = new ArrayList<Boolean>();
        for (boolean fl : flatten) {
            flattenList.add(fl);
        }
        POForEach poFE = new POForEach(new OperatorKey(scope, this.nodeGen.getNextNodeId(scope)), foreach.getRequestedParallelisam(), innerPlans, flattenList);
        poFE.setAlias(foreach.getAlias());
        poFE.setResultType((byte)120);
        this.logToPhyMap.put(foreach, poFE);
        this.currentPlan.add(poFE);
        List<Operator> op = foreach.getPlan().getPredecessors(foreach);
        if (op == null) {
            return;
        }
        PhysicalOperator from = this.logToPhyMap.get(op.get(0));
        try {
            this.currentPlan.connect(from, poFE);
        }
        catch (Exception e) {
            int errCode = 2015;
            String msg = "Invalid physical operators in the physical plan";
            throw new LogicalToPhysicalTranslatorException(msg, errCode, 4, (Throwable)e);
        }
        this.translateSoftLinks(foreach);
    }

    private List<PhysicalPlan> translateExpressionPlans(LogicalRelationalOperator loj, List<LogicalExpressionPlan> plans) throws FrontendException {
        ArrayList<PhysicalPlan> exprPlans = new ArrayList<PhysicalPlan>();
        if (plans == null || plans.size() == 0) {
            return exprPlans;
        }
        this.currentPlans.push(this.currentPlan);
        for (LogicalExpressionPlan lp : plans) {
            this.currentPlan = new PhysicalPlan();
            ReverseDependencyOrderWalkerWOSeenChk childWalker = new ReverseDependencyOrderWalkerWOSeenChk(lp);
            this.pushWalker(childWalker);
            this.currentWalker.walk(new ExpToPhyTranslationVisitor(this.currentWalker.getPlan(), childWalker, loj, this.currentPlan, this.logToPhyMap));
            exprPlans.add(this.currentPlan);
            this.popWalker();
        }
        this.currentPlan = this.currentPlans.pop();
        return exprPlans;
    }

    @Override
    public void visit(LOStore loStore) throws FrontendException {
        String scope = "scope";
        POStore store = new POStore(new OperatorKey(scope, this.nodeGen.getNextNodeId(scope)));
        store.setAlias(loStore.getAlias());
        store.setSFile(loStore.getOutputSpec());
        store.setInputSpec(loStore.getInputSpec());
        store.setSignature(loStore.getSignature());
        store.setSortInfo(loStore.getSortInfo());
        store.setIsTmpStore(loStore.isTmpStore());
        store.setSchema(Util.translateSchema(loStore.getSchema()));
        this.currentPlan.add(store);
        List<Operator> op = loStore.getPlan().getPredecessors(loStore);
        PhysicalOperator from = null;
        if (op != null) {
            from = this.logToPhyMap.get(op.get(0));
        }
        try {
            this.currentPlan.connect(from, store);
        }
        catch (PlanException e) {
            int errCode = 2015;
            String msg = "Invalid physical operators in the physical plan";
            throw new LogicalToPhysicalTranslatorException(msg, errCode, 4, (Throwable)e);
        }
        this.logToPhyMap.put(loStore, store);
    }

    @Override
    public void visit(LOCogroup cg) throws FrontendException {
        switch (cg.getGroupType()) {
            case COLLECTED: {
                this.translateCollectedCogroup(cg);
                break;
            }
            case REGULAR: {
                POPackage poPackage = this.compileToLR_GR_PackTrio(cg, cg.getCustomPartitioner(), cg.getInner(), cg.getExpressionPlans());
                poPackage.setPackageType(POPackage.PackageType.GROUP);
                this.logToPhyMap.put(cg, poPackage);
                break;
            }
            case MERGE: {
                this.translateMergeCogroup(cg);
                break;
            }
            default: {
                throw new LogicalToPhysicalTranslatorException("Unknown CoGroup Modifier", 4);
            }
        }
        this.translateSoftLinks(cg);
    }

    private void translateCollectedCogroup(LOCogroup cg) throws FrontendException {
        LogicalRelationalOperator pred = (LogicalRelationalOperator)this.plan.getPredecessors(cg).get(0);
        List<LogicalExpressionPlan> exprPlans = cg.getExpressionPlans().get(0);
        POCollectedGroup physOp = new POCollectedGroup(new OperatorKey("scope", this.nodeGen.getNextNodeId("scope")));
        physOp.setAlias(cg.getAlias());
        List<PhysicalPlan> pExprPlans = this.translateExpressionPlans(cg, exprPlans);
        try {
            physOp.setPlans(pExprPlans);
        }
        catch (PlanException pe) {
            int errCode = 2071;
            String msg = "Problem with setting up map group's plans.";
            throw new LogicalToPhysicalTranslatorException(msg, errCode, 4, (Throwable)pe);
        }
        Byte type = null;
        if (exprPlans.size() > 1) {
            type = 110;
            physOp.setKeyType(type);
        } else {
            type = ((PhysicalOperator)pExprPlans.get(0).getLeaves().get(0)).getResultType();
            physOp.setKeyType(type);
        }
        physOp.setResultType((byte)110);
        this.currentPlan.add(physOp);
        try {
            this.currentPlan.connect(this.logToPhyMap.get(pred), physOp);
        }
        catch (PlanException e) {
            int errCode = 2015;
            String msg = "Invalid physical operators in the physical plan";
            throw new LogicalToPhysicalTranslatorException(msg, errCode, 4, (Throwable)e);
        }
        this.logToPhyMap.put(cg, physOp);
    }

    private POMergeCogroup compileToMergeCogrp(LogicalRelationalOperator relationalOp, MultiMap<Integer, LogicalExpressionPlan> innerPlans) throws FrontendException {
        List<Operator> inputs = relationalOp.getPlan().getPredecessors(relationalOp);
        POLocalRearrange[] innerLRs = new POLocalRearrange[inputs.size()];
        int count = 0;
        ArrayList<PhysicalOperator> inpPOs = new ArrayList<PhysicalOperator>(inputs.size());
        for (int i = 0; i < inputs.size(); ++i) {
            Operator op = inputs.get(i);
            PhysicalOperator physOp = this.logToPhyMap.get(op);
            inpPOs.add(physOp);
            List<LogicalExpressionPlan> plans = innerPlans.get(i);
            POLocalRearrange poInnerLR = new POLocalRearrange(new OperatorKey("scope", this.nodeGen.getNextNodeId("scope")));
            poInnerLR.setAlias(relationalOp.getAlias());
            List<PhysicalPlan> exprPlans = this.translateExpressionPlans(relationalOp, plans);
            try {
                poInnerLR.setPlans(exprPlans);
            }
            catch (PlanException pe) {
                int errCode = 2071;
                String msg = "Problem with setting up local rearrange's plans.";
                throw new LogicalToPhysicalTranslatorException(msg, errCode, 4, (Throwable)pe);
            }
            innerLRs[count] = poInnerLR;
            try {
                poInnerLR.setIndex(count++);
            }
            catch (ExecException e1) {
                int errCode = 2058;
                String msg = "Unable to set index on newly create POLocalRearrange.";
                throw new VisitorException(msg, errCode, 4, (Throwable)e1);
            }
            poInnerLR.setKeyType(plans.size() > 1 ? (byte)110 : ((PhysicalOperator)exprPlans.get(0).getLeaves().get(0)).getResultType());
            poInnerLR.setResultType((byte)110);
        }
        POMergeCogroup poCogrp = new POMergeCogroup(new OperatorKey("scope", this.nodeGen.getNextNodeId("scope")), inpPOs, innerLRs, relationalOp.getRequestedParallelisam());
        return poCogrp;
    }

    private void translateMergeCogroup(LOCogroup cg) throws FrontendException {
        if (!this.validateMergeCogrp(cg.getInner())) {
            throw new LogicalToPhysicalTranslatorException("Inner is not supported for any relation on Merge Cogroup.");
        }
        List<Operator> inputs = cg.getPlan().getPredecessors(cg);
        this.validateMapSideMerge(inputs, cg.getPlan());
        POMergeCogroup poCogrp = this.compileToMergeCogrp(cg, cg.getExpressionPlans());
        poCogrp.setResultType((byte)110);
        poCogrp.setAlias(cg.getAlias());
        this.currentPlan.add(poCogrp);
        for (Operator op : inputs) {
            try {
                this.currentPlan.connect(this.logToPhyMap.get(op), poCogrp);
            }
            catch (PlanException e) {
                int errCode = 2015;
                String msg = "Invalid physical operators in the physical plan";
                throw new LogicalToPhysicalTranslatorException(msg, errCode, 4, (Throwable)e);
            }
        }
        this.logToPhyMap.put(cg, poCogrp);
    }

    private boolean validateMergeCogrp(boolean[] innerFlags) {
        for (boolean flag : innerFlags) {
            if (!flag) continue;
            return false;
        }
        return true;
    }

    private boolean validateMapSideMerge(List<Operator> preds, OperatorPlan lp) throws LogicalToPhysicalTranslatorException {
        int errCode = 1103;
        String errMsg = "Merge join/Cogroup only supports Filter, Foreach, filter and Load as its predecessor. Found : ";
        if (preds != null && !preds.isEmpty()) {
            for (Operator lo : preds) {
                if (!(lo instanceof LOFilter || lo instanceof LOForEach || lo instanceof LOLoad)) {
                    throw new LogicalToPhysicalTranslatorException(errMsg, errCode);
                }
                this.validateMapSideMerge(lp.getPredecessors(lo), lp);
            }
        }
        return true;
    }

    @Override
    public void visit(LOJoin loj) throws FrontendException {
        String msg;
        String msg2;
        String scope = "scope";
        List<Operator> inputs = loj.getPlan().getPredecessors(loj);
        LinkedMultiMap<PhysicalOperator, PhysicalPlan> joinPlans = new LinkedMultiMap<PhysicalOperator, PhysicalPlan>();
        ArrayList<List<PhysicalPlan>> ppLists = new ArrayList<List<PhysicalPlan>>();
        ArrayList<PhysicalOperator> inp = new ArrayList<PhysicalOperator>();
        ArrayList<List<Byte>> keyTypes = new ArrayList<List<Byte>>();
        boolean[] innerFlags = loj.getInnerFlags();
        String alias = loj.getAlias();
        int parallel = loj.getRequestedParallelisam();
        for (int i = 0; i < inputs.size(); ++i) {
            Operator op = inputs.get(i);
            PhysicalOperator physOp = this.logToPhyMap.get(op);
            inp.add(physOp);
            List plans = (List)loj.getJoinPlan(i);
            List<PhysicalPlan> exprPlans = this.translateExpressionPlans(loj, plans);
            ppLists.add(exprPlans);
            joinPlans.put(physOp, exprPlans);
            ArrayList<Byte> tupleKeyMemberTypes = new ArrayList<Byte>();
            for (PhysicalPlan exprPlan : exprPlans) {
                tupleKeyMemberTypes.add(((PhysicalOperator)exprPlan.getLeaves().get(0)).getResultType());
            }
            keyTypes.add(tupleKeyMemberTypes);
        }
        if (loj.getJoinType() == LOJoin.JOINTYPE.SKEWED) {
            String msg3;
            POSkewedJoin skj;
            try {
                skj = new POSkewedJoin(new OperatorKey(scope, this.nodeGen.getNextNodeId(scope)), parallel, inp, innerFlags);
                skj.setAlias(alias);
                skj.setJoinPlans(joinPlans);
            }
            catch (Exception e) {
                int errCode = 2015;
                String msg4 = "Skewed Join creation failed";
                throw new LogicalToPhysicalTranslatorException(msg4, errCode, 4, (Throwable)e);
            }
            skj.setResultType((byte)110);
            for (int i = 0; i < inputs.size(); ++i) {
                Operator op = inputs.get(i);
                if (!innerFlags[i]) {
                    try {
                        LogicalSchema s = ((LogicalRelationalOperator)op).getSchema();
                        if (s == null) {
                            throw new FrontendException(loj, "Cannot determine skewed join schema", 2247);
                        }
                        skj.addSchema(Util.translateSchema(s));
                        continue;
                    }
                    catch (FrontendException e) {
                        int errCode = 2015;
                        msg3 = "Couldn't set the schema for outer join";
                        throw new LogicalToPhysicalTranslatorException(msg3, errCode, 4, (Throwable)e);
                    }
                }
                skj.addSchema(null);
            }
            this.currentPlan.add(skj);
            for (Operator op : inputs) {
                try {
                    this.currentPlan.connect(this.logToPhyMap.get(op), skj);
                }
                catch (PlanException e) {
                    int errCode = 2015;
                    msg3 = "Invalid physical operators in the physical plan";
                    throw new LogicalToPhysicalTranslatorException(msg3, errCode, 4, (Throwable)e);
                }
            }
            this.logToPhyMap.put(loj, skj);
        } else if (loj.getJoinType() == LOJoin.JOINTYPE.REPLICATED) {
            POFRJoin pfrj;
            int fragment = 0;
            try {
                boolean isLeftOuter = false;
                isLeftOuter = !innerFlags[1];
                Tuple nullTuple = null;
                if (isLeftOuter) {
                    try {
                        LogicalSchema inputSchema = ((LogicalRelationalOperator)inputs.get(1)).getSchema();
                        if (inputSchema == null) {
                            int errCode = 1109;
                            msg2 = "Input (" + ((LogicalRelationalOperator)inputs.get(1)).getAlias() + ") " + "on which outer join is desired should have a valid schema";
                            throw new LogicalToPhysicalTranslatorException(msg2, errCode, 2);
                        }
                        nullTuple = TupleFactory.getInstance().newTuple(inputSchema.size());
                        for (int j = 0; j < inputSchema.size(); ++j) {
                            nullTuple.set(j, null);
                        }
                    }
                    catch (FrontendException e) {
                        int errCode = 2104;
                        msg2 = "Error while determining the schema of input";
                        throw new LogicalToPhysicalTranslatorException(msg2, errCode, 4, (Throwable)e);
                    }
                }
                pfrj = new POFRJoin(new OperatorKey(scope, this.nodeGen.getNextNodeId(scope)), parallel, inp, ppLists, keyTypes, null, fragment, isLeftOuter, nullTuple);
                pfrj.setAlias(alias);
            }
            catch (ExecException e1) {
                int errCode = 2058;
                msg = "Unable to set index on newly create POLocalRearrange.";
                throw new VisitorException(msg, errCode, 4, (Throwable)e1);
            }
            pfrj.setResultType((byte)110);
            this.currentPlan.add(pfrj);
            for (Operator op : inputs) {
                try {
                    this.currentPlan.connect(this.logToPhyMap.get(op), pfrj);
                }
                catch (PlanException e) {
                    int errCode = 2015;
                    msg2 = "Invalid physical operators in the physical plan";
                    throw new LogicalToPhysicalTranslatorException(msg2, errCode, 4, (Throwable)e);
                }
            }
            this.logToPhyMap.put(loj, pfrj);
        } else {
            if (loj.getJoinType() == LOJoin.JOINTYPE.MERGE && this.validateMapSideMerge(inputs, loj.getPlan())) {
                PhysicalOperator smj;
                boolean usePOMergeJoin;
                boolean bl = usePOMergeJoin = inputs.size() == 2 && innerFlags[0] && innerFlags[1];
                if (usePOMergeJoin) {
                    try {
                        smj = new POMergeJoin(new OperatorKey(scope, this.nodeGen.getNextNodeId(scope)), parallel, inp, joinPlans, keyTypes);
                    }
                    catch (PlanException e) {
                        int errCode = 2042;
                        msg = "Merge Join creation failed";
                        throw new LogicalToPhysicalTranslatorException(msg, errCode, 4, (Throwable)e);
                    }
                    this.logToPhyMap.put(loj, smj);
                } else {
                    smj = this.compileToMergeCogrp(loj, loj.getExpressionPlans());
                }
                smj.setResultType((byte)110);
                this.currentPlan.add(smj);
                smj.setAlias(alias);
                for (Operator op : inputs) {
                    try {
                        this.currentPlan.connect(this.logToPhyMap.get(op), smj);
                    }
                    catch (PlanException e) {
                        int errCode = 2015;
                        msg2 = "Invalid physical operators in the physical plan";
                        throw new LogicalToPhysicalTranslatorException(msg2, errCode, 4, (Throwable)e);
                    }
                }
                if (!usePOMergeJoin) {
                    POForEach fe = this.compileFE4Flattening(innerFlags, scope, parallel, alias, inputs);
                    this.currentPlan.add(fe);
                    try {
                        this.currentPlan.connect(smj, fe);
                    }
                    catch (PlanException e) {
                        throw new LogicalToPhysicalTranslatorException(e.getMessage(), e.getErrorCode(), e.getErrorSource(), (Throwable)e);
                    }
                    this.logToPhyMap.put(loj, fe);
                }
                return;
            }
            if (loj.getJoinType() == LOJoin.JOINTYPE.HASH) {
                POPackage poPackage = this.compileToLR_GR_PackTrio(loj, loj.getCustomPartitioner(), innerFlags, loj.getExpressionPlans());
                POForEach fe = this.compileFE4Flattening(innerFlags, scope, parallel, alias, inputs);
                this.currentPlan.add(fe);
                try {
                    this.currentPlan.connect(poPackage, fe);
                }
                catch (PlanException e) {
                    throw new LogicalToPhysicalTranslatorException(e.getDetailedMessage(), e.getErrorCode(), e.getErrorSource(), (Throwable)e);
                }
                this.logToPhyMap.put(loj, fe);
                poPackage.setPackageType(POPackage.PackageType.JOIN);
            }
        }
        this.translateSoftLinks(loj);
    }

    private POPackage compileToLR_GR_PackTrio(LogicalRelationalOperator relationalOp, String customPartitioner, boolean[] innerFlags, MultiMap<Integer, LogicalExpressionPlan> innerPlans) throws FrontendException {
        POGlobalRearrange poGlobal = new POGlobalRearrange(new OperatorKey("scope", this.nodeGen.getNextNodeId("scope")), relationalOp.getRequestedParallelisam());
        poGlobal.setAlias(relationalOp.getAlias());
        poGlobal.setCustomPartitioner(customPartitioner);
        POPackage poPackage = new POPackage(new OperatorKey("scope", this.nodeGen.getNextNodeId("scope")), relationalOp.getRequestedParallelisam());
        poPackage.setAlias(relationalOp.getAlias());
        this.currentPlan.add(poGlobal);
        this.currentPlan.add(poPackage);
        try {
            this.currentPlan.connect(poGlobal, poPackage);
        }
        catch (PlanException e1) {
            int errCode = 2015;
            String msg = "Invalid physical operators in the physical plan";
            throw new LogicalToPhysicalTranslatorException(msg, errCode, 4, (Throwable)e1);
        }
        int count = 0;
        Byte type = null;
        List<Operator> inputs = relationalOp.getPlan().getPredecessors(relationalOp);
        for (int i = 0; i < inputs.size(); ++i) {
            Operator op = inputs.get(i);
            List<LogicalExpressionPlan> plans = innerPlans.get(i);
            POLocalRearrange physOp = new POLocalRearrange(new OperatorKey("scope", this.nodeGen.getNextNodeId("scope")), relationalOp.getRequestedParallelisam());
            physOp.setAlias(relationalOp.getAlias());
            List<PhysicalPlan> exprPlans = this.translateExpressionPlans(relationalOp, plans);
            try {
                physOp.setPlans(exprPlans);
            }
            catch (PlanException pe) {
                int errCode = 2071;
                String msg = "Problem with setting up local rearrange's plans.";
                throw new LogicalToPhysicalTranslatorException(msg, errCode, 4, (Throwable)pe);
            }
            try {
                physOp.setIndex(count++);
            }
            catch (ExecException e1) {
                int errCode = 2058;
                String msg = "Unable to set index on newly create POLocalRearrange.";
                throw new VisitorException(msg, errCode, 4, (Throwable)e1);
            }
            if (plans.size() > 1) {
                type = 110;
                physOp.setKeyType(type);
            } else {
                type = ((PhysicalOperator)exprPlans.get(0).getLeaves().get(0)).getResultType();
                physOp.setKeyType(type);
            }
            physOp.setResultType((byte)110);
            this.currentPlan.add(physOp);
            try {
                this.currentPlan.connect(this.logToPhyMap.get(op), physOp);
                this.currentPlan.connect(physOp, poGlobal);
                continue;
            }
            catch (PlanException e) {
                int errCode = 2015;
                String msg = "Invalid physical operators in the physical plan";
                throw new LogicalToPhysicalTranslatorException(msg, errCode, 4, (Throwable)e);
            }
        }
        poPackage.setKeyType(type);
        poPackage.setResultType((byte)110);
        poPackage.setNumInps(count);
        poPackage.setInner(innerFlags);
        return poPackage;
    }

    private POForEach compileFE4Flattening(boolean[] innerFlags, String scope, int parallel, String alias, List<Operator> inputs) throws FrontendException {
        POForEach fe;
        ArrayList<PhysicalPlan> fePlans = new ArrayList<PhysicalPlan>();
        ArrayList<Boolean> flattenLst = new ArrayList<Boolean>();
        try {
            for (int i = 0; i < inputs.size(); ++i) {
                PhysicalPlan fep1 = new PhysicalPlan();
                POProject feproj1 = new POProject(new OperatorKey(scope, this.nodeGen.getNextNodeId(scope)), parallel, i + 1);
                feproj1.setAlias(alias);
                feproj1.setResultType((byte)120);
                feproj1.setOverloaded(false);
                fep1.add(feproj1);
                fePlans.add(fep1);
                if (!innerFlags[i]) {
                    Operator joinInput = inputs.get(i);
                    LogToPhyTranslationVisitor.updateWithEmptyBagCheck(fep1, joinInput);
                }
                flattenLst.add(true);
            }
            fe = new POForEach(new OperatorKey(scope, this.nodeGen.getNextNodeId(scope)), parallel, fePlans, flattenLst);
            fe.setAlias(alias);
        }
        catch (PlanException e1) {
            int errCode = 2015;
            String msg = "Invalid physical operators in the physical plan";
            throw new LogicalToPhysicalTranslatorException(msg, errCode, 4, (Throwable)e1);
        }
        return fe;
    }

    @Override
    public void visit(LOUnion loUnion) throws FrontendException {
        String scope = "scope";
        POUnion physOp = new POUnion(new OperatorKey(scope, this.nodeGen.getNextNodeId(scope)), loUnion.getRequestedParallelisam());
        physOp.setAlias(loUnion.getAlias());
        this.currentPlan.add(physOp);
        physOp.setResultType((byte)120);
        this.logToPhyMap.put(loUnion, physOp);
        List<Operator> ops = loUnion.getPlan().getPredecessors(loUnion);
        for (Operator l : ops) {
            PhysicalOperator from = this.logToPhyMap.get(l);
            try {
                this.currentPlan.connect(from, physOp);
            }
            catch (PlanException e) {
                int errCode = 2015;
                String msg = "Invalid physical operators in the physical plan";
                throw new LogicalToPhysicalTranslatorException(msg, errCode, 4, (Throwable)e);
            }
        }
    }

    @Override
    public void visit(LODistinct loDistinct) throws FrontendException {
        String scope = "scope";
        PODistinct physOp = new PODistinct(new OperatorKey(scope, this.nodeGen.getNextNodeId(scope)), loDistinct.getRequestedParallelisam());
        physOp.setAlias(loDistinct.getAlias());
        this.currentPlan.add(physOp);
        physOp.setResultType((byte)120);
        this.logToPhyMap.put(loDistinct, physOp);
        Operator op = loDistinct.getPlan().getPredecessors(loDistinct).get(0);
        PhysicalOperator from = this.logToPhyMap.get(op);
        try {
            this.currentPlan.connect(from, physOp);
        }
        catch (PlanException e) {
            int errCode = 2015;
            String msg = "Invalid physical operators in the physical plan";
            throw new LogicalToPhysicalTranslatorException(msg, errCode, 4, (Throwable)e);
        }
    }

    @Override
    public void visit(LOLimit loLimit) throws FrontendException {
        String scope = "scope";
        POLimit physOp = new POLimit(new OperatorKey(scope, this.nodeGen.getNextNodeId(scope)), loLimit.getRequestedParallelisam());
        physOp.setLimit(loLimit.getLimit());
        physOp.setAlias(loLimit.getAlias());
        this.currentPlan.add(physOp);
        physOp.setResultType((byte)120);
        this.logToPhyMap.put(loLimit, physOp);
        Operator op = loLimit.getPlan().getPredecessors(loLimit).get(0);
        PhysicalOperator from = this.logToPhyMap.get(op);
        try {
            this.currentPlan.connect(from, physOp);
        }
        catch (PlanException e) {
            int errCode = 2015;
            String msg = "Invalid physical operators in the physical plan";
            throw new LogicalToPhysicalTranslatorException(msg, errCode, 4, (Throwable)e);
        }
    }

    @Override
    public void visit(LOSplit loSplit) throws FrontendException {
        FileSpec splStrFile;
        String scope = "scope";
        POSplit physOp = new POSplit(new OperatorKey(scope, this.nodeGen.getNextNodeId(scope)), loSplit.getRequestedParallelisam());
        physOp.setAlias(loSplit.getAlias());
        try {
            splStrFile = new FileSpec(FileLocalizer.getTemporaryPath(this.pc).toString(), new FuncSpec(Utils.getTmpFileCompressorName(this.pc)));
        }
        catch (IOException e1) {
            byte errSrc = this.pc.getErrorSource();
            int errCode = 0;
            switch (errSrc) {
                case 4: {
                    errCode = 2016;
                    break;
                }
                case 16: {
                    errCode = 6002;
                    break;
                }
                case 8: {
                    errCode = 4003;
                }
            }
            String msg = "Unable to obtain a temporary path.";
            throw new LogicalToPhysicalTranslatorException(msg, errCode, errSrc, (Throwable)e1);
        }
        physOp.setSplitStore(splStrFile);
        this.logToPhyMap.put(loSplit, physOp);
        this.currentPlan.add(physOp);
        List<Operator> op = loSplit.getPlan().getPredecessors(loSplit);
        if (op == null) {
            int errCode = 2051;
            String msg = "Did not find a predecessor for Split.";
            throw new LogicalToPhysicalTranslatorException(msg, errCode, 4);
        }
        PhysicalOperator from = this.logToPhyMap.get(op.get(0));
        try {
            this.currentPlan.connect(from, physOp);
        }
        catch (PlanException e) {
            int errCode = 2015;
            String msg = "Invalid physical operators in the physical plan";
            throw new LogicalToPhysicalTranslatorException(msg, errCode, 4, (Throwable)e);
        }
    }

    @Override
    public void visit(LOSplitOutput loSplitOutput) throws FrontendException {
        String scope = "scope";
        POFilter poFilter = new POFilter(new OperatorKey(scope, this.nodeGen.getNextNodeId(scope)), loSplitOutput.getRequestedParallelisam());
        poFilter.setAlias(loSplitOutput.getAlias());
        poFilter.setResultType((byte)120);
        this.currentPlan.add(poFilter);
        this.logToPhyMap.put(loSplitOutput, poFilter);
        this.currentPlans.push(this.currentPlan);
        this.currentPlan = new PhysicalPlan();
        ReverseDependencyOrderWalkerWOSeenChk childWalker = new ReverseDependencyOrderWalkerWOSeenChk(loSplitOutput.getFilterPlan());
        this.pushWalker(childWalker);
        this.currentWalker.walk(new ExpToPhyTranslationVisitor(this.currentWalker.getPlan(), childWalker, loSplitOutput, this.currentPlan, this.logToPhyMap));
        this.popWalker();
        poFilter.setPlan(this.currentPlan);
        this.currentPlan = this.currentPlans.pop();
        List<Operator> op = loSplitOutput.getPlan().getPredecessors(loSplitOutput);
        if (op == null) {
            int errCode = 2051;
            String msg = "Did not find a predecessor for Filter.";
            throw new LogicalToPhysicalTranslatorException(msg, errCode, 4);
        }
        PhysicalOperator from = this.logToPhyMap.get(op.get(0));
        try {
            this.currentPlan.connect(from, poFilter);
        }
        catch (PlanException e) {
            int errCode = 2015;
            String msg = "Invalid physical operators in the physical plan";
            throw new LogicalToPhysicalTranslatorException(msg, errCode, 4, (Throwable)e);
        }
        this.translateSoftLinks(loSplitOutput);
    }

    public static void updateWithEmptyBagCheck(PhysicalPlan fePlan, Operator joinInput) throws FrontendException {
        LogicalSchema inputSchema = null;
        try {
            inputSchema = ((LogicalRelationalOperator)joinInput).getSchema();
            if (inputSchema == null) {
                int errCode = 1109;
                String msg = "Input (" + ((LogicalRelationalOperator)joinInput).getAlias() + ") " + "on which outer join is desired should have a valid schema";
                throw new LogicalToPhysicalTranslatorException(msg, errCode, 2);
            }
        }
        catch (FrontendException e) {
            int errCode = 2104;
            String msg = "Error while determining the schema of input";
            throw new LogicalToPhysicalTranslatorException(msg, errCode, 4, (Throwable)e);
        }
        CompilerUtils.addEmptyBagOuterJoin(fePlan, Util.translateSchema(inputSchema));
    }

    private boolean validateMergeJoin(LOJoin loj) throws FrontendException {
        List<Operator> preds = this.plan.getPredecessors(loj);
        int errCode = 1101;
        String errMsg = "Merge Join must have exactly two inputs.";
        if (preds.size() != 2) {
            throw new LogicalToPhysicalTranslatorException(errMsg + " Found: " + preds.size(), errCode);
        }
        return this.mergeJoinValidator(preds, loj.getPlan());
    }

    private boolean mergeJoinValidator(List<Operator> preds, OperatorPlan lp) throws FrontendException {
        int errCode = 1103;
        String errMsg = "Merge join only supports Filter, Foreach, filter and Load as its predecessor. Found : ";
        if (preds != null && !preds.isEmpty()) {
            for (Operator lo : preds) {
                if (!(lo instanceof LOFilter || lo instanceof LOLoad || lo instanceof LOForEach)) {
                    throw new LogicalToPhysicalTranslatorException(errMsg, errCode);
                }
                this.mergeJoinValidator(lp.getPredecessors(lo), lp);
            }
        }
        return true;
    }

    private void translateSoftLinks(Operator op) throws FrontendException {
        List<Operator> preds = op.getPlan().getSoftLinkPredecessors(op);
        if (preds == null) {
            return;
        }
        for (Operator pred : preds) {
            PhysicalOperator from = this.logToPhyMap.get(pred);
            this.currentPlan.createSoftLink(from, (org.apache.pig.impl.plan.Operator)this.logToPhyMap.get(op));
        }
    }
}

