/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.newplan.logical.rules;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.newplan.DepthFirstWalker;
import org.apache.pig.newplan.OperatorPlan;
import org.apache.pig.newplan.logical.relational.LOLoad;
import org.apache.pig.newplan.logical.relational.LOStore;
import org.apache.pig.newplan.logical.relational.LogicalRelationalNodesVisitor;
import org.apache.pig.newplan.logical.relational.LogicalRelationalOperator;

public class LoadStoreFuncDupSignatureValidator {
    OperatorPlan plan;

    public LoadStoreFuncDupSignatureValidator(OperatorPlan plan) {
        this.plan = plan;
    }

    public void validate() throws FrontendException {
        LoadStoreFuncDupSignatureVisitor visitor = new LoadStoreFuncDupSignatureVisitor(this.plan);
        visitor.visit();
        visitor.finish();
    }

    static class LoadStoreFuncDupSignatureVisitor
    extends LogicalRelationalNodesVisitor {
        Map<String, List<LOLoad>> loadSignatures = new HashMap<String, List<LOLoad>>();
        Map<String, List<LOStore>> storeSignatures = new HashMap<String, List<LOStore>>();

        protected LoadStoreFuncDupSignatureVisitor(OperatorPlan plan) throws FrontendException {
            super(plan, new DepthFirstWalker(plan));
        }

        @Override
        public void visit(LOLoad load) throws FrontendException {
            if (this.loadSignatures.containsKey(load.getSignature())) {
                List<LOLoad> loads = this.loadSignatures.get(load.getSignature());
                loads.add(load);
            } else {
                ArrayList<LOLoad> loads = new ArrayList<LOLoad>();
                loads.add(load);
                this.loadSignatures.put(load.getSignature(), loads);
            }
        }

        @Override
        public void visit(LOStore store) throws FrontendException {
            if (this.storeSignatures.containsKey(store.getSignature())) {
                List<LOStore> stores = this.storeSignatures.get(store.getSignature());
                stores.add(store);
            } else {
                ArrayList<LOStore> stores = new ArrayList<LOStore>();
                stores.add(store);
                this.storeSignatures.put(store.getSignature(), stores);
            }
        }

        public void finish() {
            int i;
            String key;
            for (Map.Entry<String, List<LOLoad>> entry : this.loadSignatures.entrySet()) {
                key = entry.getKey();
                List<LOLoad> loads = entry.getValue();
                if (loads.size() <= 1) continue;
                for (i = 0; i < loads.size(); ++i) {
                    loads.get(i).setSignature(key + "$" + i);
                }
            }
            for (Map.Entry<String, List<LogicalRelationalOperator>> entry : this.storeSignatures.entrySet()) {
                key = entry.getKey();
                List<LogicalRelationalOperator> stores = entry.getValue();
                if (stores.size() <= 1) continue;
                for (i = 0; i < stores.size(); ++i) {
                    ((LOStore)stores.get(i)).setSignature(key + "$" + i);
                }
            }
        }
    }
}

