/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.hbase.shim.api;

import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.w3c.dom.Node;

public class ColumnFilter {
    protected String m_fieldAlias;
    protected ComparisonType m_comparison;
    protected boolean m_signedComparison;
    protected String m_constant;
    protected String m_format;
    protected String m_fieldType;

    public ColumnFilter(String alias) {
        this.setFieldAlias(alias);
    }

    public void setFieldAlias(String alias) {
        this.m_fieldAlias = alias;
    }

    public String getFieldAlias() {
        return this.m_fieldAlias;
    }

    public void setFieldType(String type) {
        this.m_fieldType = type;
    }

    public String getFieldType() {
        return this.m_fieldType;
    }

    public void setComparisonOperator(ComparisonType c) {
        this.m_comparison = c;
    }

    public ComparisonType getComparisonOperator() {
        return this.m_comparison;
    }

    public void setSignedComparison(boolean signed) {
        this.m_signedComparison = signed;
    }

    public boolean getSignedComparison() {
        return this.m_signedComparison;
    }

    public void setConstant(String constant) {
        this.m_constant = constant;
    }

    public String getConstant() {
        return this.m_constant;
    }

    public void setFormat(String format) {
        this.m_format = format;
    }

    public String getFormat() {
        return this.m_format;
    }

    public void appendXML(StringBuffer buff) {
        if (Const.isEmpty((String)this.m_fieldAlias) || Const.isEmpty((String)this.m_constant) || this.m_comparison == null) {
            return;
        }
        buff.append("\n        ").append(XMLHandler.openTag((String)"filter"));
        buff.append("\n            ").append(XMLHandler.addTagValue((String)"alias", (String)this.m_fieldAlias));
        buff.append("\n            ").append(XMLHandler.addTagValue((String)"type", (String)this.m_fieldType));
        buff.append("\n            ").append(XMLHandler.addTagValue((String)"comparison_opp", (String)this.m_comparison.toString()));
        buff.append("\n            ").append(XMLHandler.addTagValue((String)"signed_comp", (boolean)this.m_signedComparison));
        buff.append("\n            ").append(XMLHandler.addTagValue((String)"constant", (String)this.m_constant));
        if (!Const.isEmpty((String)this.m_format)) {
            buff.append("\n            ").append(XMLHandler.addTagValue((String)"format", (String)this.m_format.trim()));
        }
        buff.append("\n        ").append(XMLHandler.closeTag((String)"filter"));
    }

    public static ColumnFilter getFilter(Node filterNode) {
        String alias = XMLHandler.getTagValue((Node)filterNode, (String)"alias");
        ColumnFilter returnVal = new ColumnFilter(alias);
        String type = XMLHandler.getTagValue((Node)filterNode, (String)"type");
        returnVal.setFieldType(type);
        String comp = XMLHandler.getTagValue((Node)filterNode, (String)"comparison_opp");
        returnVal.setComparisonOperator(ColumnFilter.stringToOpp(comp));
        String signed = XMLHandler.getTagValue((Node)filterNode, (String)"signed_comp");
        returnVal.setSignedComparison(signed.equalsIgnoreCase("Y"));
        String constant = XMLHandler.getTagValue((Node)filterNode, (String)"constant");
        returnVal.setConstant(constant);
        String format = XMLHandler.getTagValue((Node)filterNode, (String)"format");
        returnVal.setFormat(format);
        return returnVal;
    }

    public void saveRep(Repository rep, ObjectId id_transformation, ObjectId id_step, int filterNum) throws KettleException {
        if (Const.isEmpty((String)this.m_fieldAlias) || Const.isEmpty((String)this.m_constant) || this.m_comparison == null) {
            return;
        }
        rep.saveStepAttribute(id_transformation, id_step, filterNum, "cf_alias", this.m_fieldAlias);
        rep.saveStepAttribute(id_transformation, id_step, filterNum, "cf_type", this.m_fieldType);
        rep.saveStepAttribute(id_transformation, id_step, filterNum, "cf_comparison_opp", this.m_comparison.toString());
        rep.saveStepAttribute(id_transformation, id_step, filterNum, "cf_signed_comp", this.m_signedComparison);
        rep.saveStepAttribute(id_transformation, id_step, filterNum, "cf_constant", this.m_constant);
        if (!Const.isEmpty((String)this.m_format)) {
            rep.saveStepAttribute(id_transformation, id_step, filterNum, "cf_format", this.m_format.trim());
        }
    }

    public static ColumnFilter getFilter(Repository rep, int nodeNum, ObjectId id_step) throws KettleException {
        String alias = rep.getStepAttributeString(id_step, nodeNum, "cf_alias");
        ColumnFilter returnVal = new ColumnFilter(alias);
        String type = rep.getStepAttributeString(id_step, nodeNum, "cf_type");
        returnVal.setFieldType(type);
        String comp = rep.getStepAttributeString(id_step, nodeNum, "cf_comparison_opp");
        returnVal.setComparisonOperator(ColumnFilter.stringToOpp(comp));
        returnVal.setSignedComparison(rep.getStepAttributeBoolean(id_step, nodeNum, "cf_signed_comp"));
        String constant = rep.getStepAttributeString(id_step, nodeNum, "cf_constant");
        returnVal.setConstant(constant);
        String format = rep.getStepAttributeString(id_step, nodeNum, "cf_format");
        returnVal.setFormat(format);
        return returnVal;
    }

    public static ComparisonType stringToOpp(String opp) {
        ComparisonType c = null;
        for (ComparisonType t : ComparisonType.values()) {
            if (!t.toString().equals(opp)) continue;
            c = t;
            break;
        }
        return c;
    }

    public static String[] getAllOperators() {
        String[] ops = new String[]{ComparisonType.EQUAL.toString(), ComparisonType.NOT_EQUAL.toString(), ComparisonType.GREATER_THAN.toString(), ComparisonType.GREATER_THAN_OR_EQUAL.toString(), ComparisonType.LESS_THAN.toString(), ComparisonType.LESS_THAN_OR_EQUAL.toString(), ComparisonType.SUBSTRING.toString(), ComparisonType.REGEX.toString()};
        return ops;
    }

    public static String[] getStringOperators() {
        String[] ops = new String[]{ComparisonType.SUBSTRING.toString(), ComparisonType.REGEX.toString()};
        return ops;
    }

    public static String[] getNumericOperators() {
        String[] ops = new String[]{ComparisonType.EQUAL.toString(), ComparisonType.NOT_EQUAL.toString(), ComparisonType.GREATER_THAN.toString(), ComparisonType.GREATER_THAN_OR_EQUAL.toString(), ComparisonType.LESS_THAN.toString(), ComparisonType.LESS_THAN_OR_EQUAL.toString()};
        return ops;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ComparisonType {
        EQUAL("="),
        GREATER_THAN(">"),
        GREATER_THAN_OR_EQUAL(">="),
        LESS_THAN("<"),
        LESS_THAN_OR_EQUAL("<="),
        NOT_EQUAL("!="),
        SUBSTRING("Substring"),
        REGEX("Regular expression");

        private final String m_stringVal;

        private ComparisonType(String name) {
            this.m_stringVal = name;
        }

        public String toString() {
            return this.m_stringVal;
        }
    }
}

