/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.ui.xul.binding;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BindingConvertor<V, R> {
    private static final long serialVersionUID = 1L;
    private static BindingConvertor<Integer, String> integer2String = new Integer2String();
    private static BindingConvertor<String, Integer> string2Integer = new String2Integer();
    private static BindingConvertor<Long, String> long2String = new Long2String();
    private static BindingConvertor<String, String> string2String = new String2String();
    private static BindingConvertor<Boolean, String> boolean2String = new Boolean2String();
    private static BindingConvertor<Double, String> double2String = new Double2String();
    private static BindingConvertor<String, Double> string2Double = new String2Double();
    private static BindingConvertor<Integer, Boolean> integer2Boolean = new Integer2Boolean();
    private static BindingConvertor<Object, Boolean> object2Boolean = new Object2Boolean();
    private static BindingConvertor<Collection, Object[]> collection2ObjectArray = new Collection2ObjectArray();

    public abstract R sourceToTarget(V var1);

    public abstract V targetToSource(R var1);

    public static BindingConvertor<Collection, Object[]> collection2ObjectArray() {
        return collection2ObjectArray;
    }

    public static BindingConvertor<Integer, String> integer2String() {
        return integer2String;
    }

    public static BindingConvertor<Integer, Boolean> integer2Boolean() {
        return integer2Boolean;
    }

    public static BindingConvertor<String, Integer> string2Integer() {
        return string2Integer;
    }

    public static BindingConvertor<Long, String> long2String() {
        return long2String;
    }

    public static BindingConvertor<Date, String> date2String() {
        return BindingConvertor.date2String(new SimpleDateFormat("MM-dd-yyyy"));
    }

    public static BindingConvertor<Date, String> date2String(DateFormat format) {
        return new Date2String(format);
    }

    public static BindingConvertor<String, String> string2String() {
        return string2String;
    }

    public static BindingConvertor<Boolean, String> boolean2String() {
        return boolean2String;
    }

    public static BindingConvertor<Double, String> double2String() {
        return double2String;
    }

    public static BindingConvertor<String, Double> string2Double() {
        return string2Double;
    }

    public static BindingConvertor<Object, Boolean> object2Boolean() {
        return object2Boolean;
    }

    public static BindingConvertor<String, String> truncatedString(int length) {
        return new TruncatedStringBindingConvertor(length);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class TruncatedStringBindingConvertor
    extends BindingConvertor<String, String> {
        private int length = 100;

        public TruncatedStringBindingConvertor(int length) {
            this.length = length;
        }

        @Override
        public String sourceToTarget(String value) {
            if (value.length() > this.length) {
                return value.substring(0, this.length) + "...";
            }
            return value;
        }

        @Override
        public String targetToSource(String value) {
            return value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Object2Boolean
    extends BindingConvertor<Object, Boolean> {
        Object2Boolean() {
        }

        @Override
        public Boolean sourceToTarget(Object value) {
            return value != null;
        }

        @Override
        public Object targetToSource(Boolean value) {
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Integer2Boolean
    extends BindingConvertor<Integer, Boolean> {
        Integer2Boolean() {
        }

        @Override
        public Boolean sourceToTarget(Integer value) {
            if (value == null) {
                return false;
            }
            return value > 0;
        }

        @Override
        public Integer targetToSource(Boolean value) {
            if (value == null) {
                return 0;
            }
            return value != false ? 1 : 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Double2String
    extends BindingConvertor<Double, String> {
        Double2String() {
        }

        @Override
        public String sourceToTarget(Double toString) {
            if (toString != null) {
                return toString.toString();
            }
            return "";
        }

        @Override
        public Double targetToSource(String toDouble) {
            try {
                return Double.valueOf(toDouble);
            }
            catch (Exception e) {
                return new Double(0.0);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class String2Double
    extends BindingConvertor<String, Double> {
        String2Double() {
        }

        @Override
        public Double sourceToTarget(String toDouble) {
            try {
                return Double.valueOf(toDouble);
            }
            catch (Exception e) {
                return new Double(0.0);
            }
        }

        @Override
        public String targetToSource(Double toString) {
            if (toString != null) {
                return toString.toString();
            }
            return "";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Boolean2String
    extends BindingConvertor<Boolean, String> {
        Boolean2String() {
        }

        @Override
        public String sourceToTarget(Boolean value) {
            return value.toString();
        }

        @Override
        public Boolean targetToSource(String value) {
            return Boolean.parseBoolean(value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class String2String
    extends BindingConvertor<String, String> {
        String2String() {
        }

        @Override
        public String sourceToTarget(String value) {
            return value;
        }

        @Override
        public String targetToSource(String value) {
            return value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Date2String
    extends BindingConvertor<Date, String> {
        DateFormat format = null;

        public Date2String() {
            this.format = new SimpleDateFormat("MM-dd-yyyy");
        }

        public Date2String(DateFormat format) {
            this.format = format;
        }

        @Override
        public String sourceToTarget(Date value) {
            if (value == null) {
                return "";
            }
            return this.format.format(value);
        }

        @Override
        public Date targetToSource(String value) {
            try {
                return this.format.parse(value);
            }
            catch (Exception e) {
                return null;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Long2String
    extends BindingConvertor<Long, String> {
        Long2String() {
        }

        @Override
        public String sourceToTarget(Long value) {
            if (value != null) {
                return value.toString();
            }
            return "";
        }

        @Override
        public Long targetToSource(String value) {
            if (value != null) {
                try {
                    return Long.valueOf(value);
                }
                catch (NumberFormatException e) {
                    return new Long(0L);
                }
            }
            return new Long(0L);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class String2Integer
    extends BindingConvertor<String, Integer> {
        String2Integer() {
        }

        @Override
        public Integer sourceToTarget(String value) {
            if (value != null) {
                try {
                    return Integer.valueOf(value);
                }
                catch (NumberFormatException e) {
                    return new Integer(0);
                }
            }
            return new Integer(0);
        }

        @Override
        public String targetToSource(Integer value) {
            if (value != null) {
                return value.toString();
            }
            return "";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Integer2String
    extends BindingConvertor<Integer, String> {
        Integer2String() {
        }

        @Override
        public String sourceToTarget(Integer value) {
            if (value != null) {
                return value.toString();
            }
            return "";
        }

        @Override
        public Integer targetToSource(String value) {
            if (value != null) {
                try {
                    return Integer.valueOf(value);
                }
                catch (NumberFormatException e) {
                    return new Integer(0);
                }
            }
            return new Integer(0);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Collection2ObjectArray
    extends BindingConvertor<Collection, Object[]> {
        Collection2ObjectArray() {
        }

        @Override
        public Object[] sourceToTarget(Collection value) {
            return value.toArray();
        }

        @Override
        public Collection targetToSource(Object[] value) {
            return Arrays.asList(value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Direction {
        FORWARD,
        BACK;

    }
}

