/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.ui.xul.binding;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.ui.xul.binding.BindingException;
import org.pentaho.ui.xul.binding.InlineBindingExpression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BindingUtil {
    private static final Log logger = LogFactory.getLog(BindingUtil.class);

    public static List<InlineBindingExpression> getBindingExpressions(String bindingText) {
        ArrayList<InlineBindingExpression> exps = new ArrayList<InlineBindingExpression>();
        for (String bindingExpText : bindingText.split(",")) {
            exps.add(new InlineBindingExpression(bindingExpText.trim()));
        }
        return exps;
    }

    public static Method findGetMethod(Object o, String property) {
        String methodName = null;
        try {
            methodName = "get" + String.valueOf(property.charAt(0)).toUpperCase() + property.substring(1);
            Method getMethod = o.getClass().getMethod(methodName, new Class[0]);
            return getMethod;
        }
        catch (NoSuchMethodException e) {
            logger.debug((Object)("could not resolve getter method [" + methodName + "] for property [" + property + "] on object [" + o.getClass().getName() + "].  Trying to resolve as boolean style getter..."));
            try {
                String isMethodName = "is" + String.valueOf(property.charAt(0)).toUpperCase() + property.substring(1);
                Method getMethod = o.getClass().getMethod(isMethodName, new Class[0]);
                return getMethod;
            }
            catch (NoSuchMethodException ex) {
                throw new BindingException("Could not resolve getter method for property [" + property + "] on object [" + o.getClass().getName() + "]", ex);
            }
        }
    }

    public static Method findSetMethod(Object o, String property, Class paramClass) {
        String methodName = "set" + String.valueOf(property.charAt(0)).toUpperCase() + property.substring(1);
        try {
            if (paramClass != null) {
                Method setMethod = o.getClass().getMethod(methodName, paramClass);
                logger.debug((Object)"Found set method by name and type");
                return setMethod;
            }
            return BindingUtil.getMethodNameByNameOnly(o, methodName);
        }
        catch (Exception e) {
            try {
                return BindingUtil.getMethodNameByNameOnly(o, methodName);
            }
            catch (BindingException ex) {
                throw new BindingException("Could not resolve setter method for property [" + property + "] on object [" + o.getClass().getName() + "] with paramClass: " + paramClass, e);
            }
        }
    }

    public static Class getMethodReturnType(Method method, Object o) {
        Class getClazz = null;
        Object getRetVal = null;
        try {
            getRetVal = method.invoke(o, new Object[0]);
            logger.debug((Object)("Found get Return Value: " + getRetVal));
        }
        catch (IllegalAccessException e) {
            throw new BindingException("Error invoking getter method [" + method.getName() + "]", e);
        }
        catch (InvocationTargetException e) {
            throw new BindingException("Error invoking getter method [" + method.getName() + "]", e);
        }
        if (getRetVal != null) {
            logger.debug((Object)"Get Return was not null, checking it's type");
            getClazz = BindingUtil.getObjectClassOrType(getRetVal);
            logger.debug((Object)("Get Return type is: " + getClazz));
        }
        return getClazz;
    }

    private static Class getObjectClassOrType(Object o) {
        if (o instanceof Boolean) {
            return Boolean.TYPE;
        }
        if (o instanceof Integer) {
            return Integer.TYPE;
        }
        if (o instanceof Float) {
            return Float.TYPE;
        }
        if (o instanceof Double) {
            return Double.TYPE;
        }
        if (o instanceof Short) {
            return Short.TYPE;
        }
        if (o instanceof Long) {
            return Long.TYPE;
        }
        return o.getClass();
    }

    private static Method getMethodNameByNameOnly(Object o, String methodName) throws BindingException {
        for (Method m : o.getClass().getMethods()) {
            if (!m.getName().equals(methodName)) continue;
            return m;
        }
        throw new BindingException("Could not resolve method by name either. You're really hosed, check property name");
    }
}

