/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.ui.xul.binding;

import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.ui.xul.XulComponent;
import org.pentaho.ui.xul.XulDomContainer;
import org.pentaho.ui.xul.binding.Binding;
import org.pentaho.ui.xul.binding.BindingContext;
import org.pentaho.ui.xul.binding.BindingException;
import org.pentaho.ui.xul.binding.BindingExpression;
import org.pentaho.ui.xul.binding.DefaultBinding;

public class DefaultBindingContext
implements BindingContext {
    private XulDomContainer container;
    private List<Binding> bindings = new ArrayList<Binding>();
    private static final Log logger = LogFactory.getLog(DefaultBindingContext.class);
    private Map<Binding, List<PropertyChangeListener>> bindingListeners = new HashMap<Binding, List<PropertyChangeListener>>();

    public DefaultBindingContext(XulDomContainer container) {
        this.container = container;
    }

    public void add(XulComponent source, String expr) {
        BindingExpression expression = BindingExpression.parse(expr);
        XulComponent target = this.container.getDocumentRoot().getElementById(expression.target);
        DefaultBinding newBinding = new DefaultBinding(source, expression.sourceAttr, target, expression.targetAttr);
        this.add(newBinding);
    }

    public void remove(Binding bind) {
        if (!this.bindingListeners.containsKey(bind) && !this.bindings.contains(bind)) {
            return;
        }
        bind.destroyBindings();
        this.bindingListeners.remove(bind);
        this.bindings.remove(bind);
    }

    public void add(Binding bind) {
        try {
            this.bindings.add(bind);
            bind.bindForward();
            if (!this.bindingListeners.containsKey(bind)) {
                this.bindingListeners.put(bind, new ArrayList());
            }
            this.bindingListeners.get(bind).add(bind.getForwardListener());
            if (bind.getBindingType() == Binding.Type.BI_DIRECTIONAL) {
                bind.bindReverse();
                this.bindingListeners.get(bind).add(bind.getReverseListener());
            }
            bind.setContext(this);
        }
        catch (Throwable t) {
            throw new BindingException("Binding failed: " + bind.getSource() + "." + bind.getSourceAttr() + " <==> " + bind.getTarget() + "." + bind.getTargetAttr(), t);
        }
    }

    public void addInitializedBinding(Binding binding) {
        try {
            this.bindings.add(binding);
            if (!this.bindingListeners.containsKey(binding)) {
                this.bindingListeners.put(binding, new ArrayList());
            }
            this.bindingListeners.get(binding).addAll(binding.getListeneners());
            binding.setContext(this);
        }
        catch (Throwable t) {
            throw new BindingException("Binding failed: " + binding.getSource() + "." + binding.getSourceAttr() + " <==> " + binding.getTarget() + "." + binding.getTargetAttr(), t);
        }
    }
}

