/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.ui.xul.impl;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.ui.xul.XulComponent;
import org.pentaho.ui.xul.XulDomContainer;
import org.pentaho.ui.xul.XulDomException;
import org.pentaho.ui.xul.XulException;
import org.pentaho.ui.xul.binding.BindingProvider;
import org.pentaho.ui.xul.containers.XulRoot;
import org.pentaho.ui.xul.dom.Attribute;
import org.pentaho.ui.xul.dom.Document;
import org.pentaho.ui.xul.dom.DocumentFactory;
import org.pentaho.ui.xul.dom.Element;
import org.pentaho.ui.xul.dom.Namespace;
import org.pentaho.ui.xul.util.Align;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractXulComponent
implements XulComponent {
    private static final long serialVersionUID = -3629792827245143824L;
    private static final Log logger = LogFactory.getLog(AbstractXulComponent.class);
    private Object managedObject;
    protected Element element;
    protected int flex = 0;
    protected String id;
    protected boolean flexLayout = false;
    protected int width;
    protected int height;
    public boolean initialized = false;
    protected String tooltip;
    protected String bgcolor = null;
    protected int padding = -1;
    protected int spacing = -1;
    protected String onblur;
    protected String insertbefore;
    protected String insertafter;
    protected boolean removeElement;
    protected int position = -1;
    protected boolean visible = true;
    protected Align alignment;
    protected String context;
    protected String popup;
    protected String menu;
    protected String ondrag;
    protected String drageffect;
    protected String ondrop;
    protected BindingProvider bindingProvider;
    private String dropVetoMethod;

    public AbstractXulComponent(Element element) {
        this.element = element;
    }

    public AbstractXulComponent(String name) {
        try {
            this.element = DocumentFactory.createElement(name, this);
        }
        catch (XulException e) {
            logger.error((Object)String.format("error creating XulElement (%s)", name), (Throwable)e);
            throw new IllegalArgumentException(String.format("error creating XulElement (%s)", name), e);
        }
    }

    @Override
    public Object getManagedObject() {
        return this.managedObject;
    }

    @Override
    public void setManagedObject(Object managed) {
        this.managedObject = managed;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.setAttribute("ID", id);
        this.id = id;
    }

    @Override
    public int getFlex() {
        return this.flex;
    }

    @Override
    public void setFlex(int flex) {
        this.flex = flex;
    }

    public void layout() {
        this.initialized = true;
    }

    protected void invoke(String method) {
        this.invoke(method, null);
    }

    protected void invoke(String method, Object[] args) {
        Document doc = this.getDocument();
        if (doc == null) {
            logger.error((Object)"Error invoking event: document is null");
            return;
        }
        XulRoot window = (XulRoot)doc.getRootElement();
        XulDomContainer con = window.getXulDomContainer();
        try {
            if (args == null) {
                args = new Object[]{};
            }
            con.invoke(method, args);
        }
        catch (XulException e) {
            logger.error((Object)"Error calling oncommand event", (Throwable)e);
        }
    }

    @Override
    public String getName() {
        return this.element.getName();
    }

    @Override
    public void addChild(Element ele) {
        this.element.addChild(ele);
    }

    @Override
    public void addChildAt(Element element, int idx) {
        this.element.addChildAt(element, idx);
    }

    @Override
    public void removeChild(Element ele) {
        this.element.removeChild(ele);
    }

    @Override
    public List<XulComponent> getChildNodes() {
        return this.element.getChildNodes();
    }

    @Override
    public Document getDocument() {
        return this.element.getDocument();
    }

    @Override
    public XulComponent getElementById(String elementId) {
        return this.element.getElementById(elementId);
    }

    @Override
    public XulComponent getElementByXPath(String path) {
        return this.element.getElementByXPath(path);
    }

    @Override
    public Object getElementObject() {
        return this.element.getElementObject();
    }

    @Override
    public List<XulComponent> getElementsByTagName(String tagName) {
        return this.element.getElementsByTagName(tagName);
    }

    @Override
    public XulComponent getFirstChild() {
        return this.element.getFirstChild();
    }

    @Override
    public Namespace getNamespace() {
        return this.element.getNamespace();
    }

    @Override
    public XulComponent getParent() {
        return this.element.getParent();
    }

    @Override
    public String getText() {
        return this.element.getText();
    }

    @Override
    public void setAttribute(Attribute attribute) {
        this.element.setAttribute(attribute);
    }

    @Override
    public void setNamespace(String prefix, String uri) {
        this.element.setNamespace(prefix, uri);
    }

    @Override
    public List<Attribute> getAttributes() {
        return this.element.getAttributes();
    }

    @Override
    public String getAttributeValue(String attributeName) {
        return this.element.getAttributeValue(attributeName);
    }

    @Override
    public void setAttributes(List<Attribute> attributes) {
        this.element.setAttributes(attributes);
    }

    @Override
    public void setAttribute(String name, String value) {
        this.element.setAttribute(name, value);
    }

    public AbstractXulComponent getXulElement() {
        return this;
    }

    @Override
    public void replaceChild(XulComponent oldElement, XulComponent newElement) throws XulDomException {
        this.element.replaceChild(oldElement, newElement);
    }

    @Override
    public void setHeight(int height) {
        this.height = height;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public void setWidth(int width) {
        this.width = width;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public void setOnblur(String method) {
        this.onblur = method;
    }

    @Override
    public String getOnblur() {
        return this.onblur;
    }

    @Override
    public String getTooltiptext() {
        return this.tooltip;
    }

    @Override
    public void setTooltiptext(String tooltip) {
        this.tooltip = tooltip;
    }

    @Override
    public void setBgcolor(String bgcolor) {
        this.bgcolor = bgcolor;
    }

    @Override
    public String getBgcolor() {
        return this.bgcolor;
    }

    @Override
    public int getPadding() {
        return this.padding;
    }

    @Override
    public void setPadding(int padding) {
        this.padding = padding;
    }

    @Override
    public int getSpacing() {
        return this.spacing;
    }

    @Override
    public void setSpacing(int spacing) {
        this.spacing = spacing;
    }

    @Override
    public String getInsertafter() {
        return this.insertafter;
    }

    @Override
    public String getInsertbefore() {
        return this.insertbefore;
    }

    @Override
    public int getPosition() {
        return this.position;
    }

    @Override
    public boolean getRemoveelement() {
        return this.removeElement;
    }

    @Override
    public void setInsertafter(String id) {
        this.insertafter = id;
    }

    @Override
    public void setInsertbefore(String id) {
        this.insertbefore = id;
    }

    @Override
    public void setPosition(int pos) {
        this.position = pos;
    }

    @Override
    public void setRemoveelement(boolean flag) {
        this.removeElement = flag;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public void setVisible(boolean visible) {
        this.visible = visible;
        if (this.initialized) {
            this.layout();
        }
    }

    @Override
    public void onDomReady() {
    }

    @Override
    public String getAlign() {
        return this.alignment != null ? this.alignment.toString() : null;
    }

    @Override
    public void setAlign(String alignment) {
        try {
            this.alignment = Align.valueOf(alignment.toUpperCase());
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }

    @Override
    public String getContext() {
        return this.context;
    }

    @Override
    public String getPopup() {
        return this.popup;
    }

    @Override
    public void setContext(String id) {
        this.context = id;
    }

    @Override
    public void setPopup(String id) {
        this.popup = id;
    }

    @Override
    public void setMenu(String id) {
        this.menu = id;
    }

    @Override
    public String getMenu() {
        return this.menu;
    }

    @Override
    public void setOndrag(String ondrag) {
        this.ondrag = ondrag;
    }

    @Override
    public String getOndrag() {
        return this.ondrag;
    }

    @Override
    public void setOndrop(String ondrop) {
        this.ondrop = ondrop;
    }

    @Override
    public String getOndrop() {
        return this.ondrop;
    }

    @Override
    public void setDrageffect(String drageffect) {
        this.drageffect = drageffect;
    }

    @Override
    public String getDrageffect() {
        return this.drageffect;
    }

    @Override
    public void setBindingProvider(BindingProvider bindingProvider) {
        this.bindingProvider = bindingProvider;
    }

    @Override
    public void setDropvetoer(String dropVetoMethod) {
        this.dropVetoMethod = dropVetoMethod;
    }

    @Override
    public String getDropvetoer() {
        return this.dropVetoMethod;
    }
}

