/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.ui.xul.impl;

import groovy.lang.GroovyClassLoader;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.ui.xul.XulComponent;
import org.pentaho.ui.xul.XulDataModel;
import org.pentaho.ui.xul.XulDomContainer;
import org.pentaho.ui.xul.XulEventSource;
import org.pentaho.ui.xul.XulException;
import org.pentaho.ui.xul.XulLoader;
import org.pentaho.ui.xul.XulOverlay;
import org.pentaho.ui.xul.XulPerspective;
import org.pentaho.ui.xul.XulSettingsManager;
import org.pentaho.ui.xul.binding.Binding;
import org.pentaho.ui.xul.binding.BindingContext;
import org.pentaho.ui.xul.binding.DefaultBinding;
import org.pentaho.ui.xul.containers.XulRoot;
import org.pentaho.ui.xul.dom.Document;
import org.pentaho.ui.xul.impl.AbstractXulEventHandler;
import org.pentaho.ui.xul.impl.XulEventHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractXulDomContainer
implements XulDomContainer {
    private static final Log logger = LogFactory.getLog(AbstractXulDomContainer.class);
    protected XulLoader xulLoader;
    protected HashMap<String, XulEventHandler> eventHandlers;
    protected HashMap<String, XulDataModel> models;
    protected Map<String, XulPerspective> perspectives = new HashMap<String, XulPerspective>();
    private XulPerspective currentOverlay;
    private List<Object> resourceBundleList;
    private XulSettingsManager settings;
    protected BindingContext bindings;
    private Object parentContext;
    private boolean initialized;
    private List<ClassLoader> classloaders = new ArrayList<ClassLoader>();

    public AbstractXulDomContainer() {
        this.classloaders.add(this.getClass().getClassLoader());
        this.eventHandlers = new HashMap();
    }

    public AbstractXulDomContainer(XulLoader xulLoader) {
        this();
        this.xulLoader = xulLoader;
    }

    @Override
    public XulLoader getXulLoader() {
        return this.xulLoader;
    }

    private void addGroovyHandler(String id, String location) throws XulException {
        try {
            location = location.replace('.', '/').replace("/groovy", ".groovy");
            InputStream in = this.getClass().getClassLoader().getResourceAsStream(location);
            if (in == null) {
                throw new NullPointerException("Error: Groovy script was not found: " + location);
            }
            GroovyClassLoader gcl = new GroovyClassLoader();
            Class clazz = gcl.parseClass(in);
            Object script = clazz.newInstance();
            XulEventHandler groovyHandler = (XulEventHandler)script;
            groovyHandler.setXulDomContainer(this);
            this.eventHandlers.put(id, groovyHandler);
        }
        catch (Exception e) {
            throw new XulException(e);
        }
    }

    @Override
    @Deprecated
    public void addEventHandler(String id, String eventClassName) throws XulException {
        if (eventClassName.indexOf("groovy") > -1) {
            this.addGroovyHandler(id, eventClassName);
            return;
        }
        try {
            Class<?> cls = Class.forName(eventClassName);
            AbstractXulEventHandler eventHandler = (AbstractXulEventHandler)cls.newInstance();
            eventHandler.setXulDomContainer(this);
            this.eventHandlers.put(id, eventHandler);
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)"Event Handler Class Not Found", (Throwable)e);
            throw new XulException(e);
        }
        catch (Exception e) {
            logger.error((Object)"Error with Backing class creation", (Throwable)e);
            throw new XulException(e);
        }
    }

    @Override
    public XulEventHandler getEventHandler(String key) throws XulException {
        if (this.eventHandlers.containsKey(key)) {
            return this.eventHandlers.get(key);
        }
        throw new XulException(String.format("Could not find Event Handler with the key : %s", key));
    }

    @Override
    public void initialize() {
        XulRoot rootEle = (XulRoot)this.getDocumentRoot().getRootElement();
        logger.debug((Object)("onload: " + rootEle.getOnload()));
        String onLoad = rootEle.getOnload();
        if (onLoad != null) {
            if (onLoad.indexOf(44) > 0) {
                String[] loadCalls;
                for (String load : loadCalls = onLoad.split(",")) {
                    if (!StringUtils.isNotEmpty((String)(load = load.trim()))) continue;
                    try {
                        this.invoke(load, new Object[0]);
                    }
                    catch (XulException e) {
                        logger.error((Object)("Error calling onLoad event: " + load), (Throwable)e);
                    }
                }
            } else if (StringUtils.isNotEmpty((String)rootEle.getOnload())) {
                try {
                    this.invoke(rootEle.getOnload(), new Object[0]);
                }
                catch (XulException e) {
                    logger.error((Object)("Error calling onLoad event: " + onLoad), (Throwable)e);
                }
            }
        }
        this.initialized = true;
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    @Override
    public Map<String, XulEventHandler> getEventHandlers() {
        return this.eventHandlers;
    }

    @Override
    public void mergeContainer(XulDomContainer container) {
        Map<String, XulEventHandler> incomingHandlers = container.getEventHandlers();
        for (Map.Entry<String, XulEventHandler> entry : incomingHandlers.entrySet()) {
            if (this.eventHandlers.containsKey(entry.getKey())) continue;
            this.eventHandlers.put(entry.getKey(), entry.getValue());
            entry.getValue().setXulDomContainer(this);
        }
    }

    @Override
    public abstract Document getDocumentRoot();

    @Override
    public abstract void addDocument(Document var1);

    @Override
    public abstract XulDomContainer loadFragment(String var1) throws XulException;

    @Override
    public abstract void close();

    @Override
    public void addEventHandler(XulEventHandler handler) {
        handler.setXulDomContainer(this);
        this.eventHandlers.put(handler.getName(), handler);
    }

    private Object[] getArgs(String methodCall) {
        if (methodCall.indexOf("()") > -1) {
            return null;
        }
        String argsList = methodCall.substring(methodCall.indexOf("(") + 1, methodCall.indexOf(")"));
        String[] stringArgs = argsList.split(",");
        Object[] args = new Object[stringArgs.length];
        int i = -1;
        for (String obj : stringArgs) {
            ++i;
            obj = obj.trim();
            try {
                Integer num = Integer.valueOf(obj);
                args[i] = num;
            }
            catch (NumberFormatException e) {
                try {
                    Double num = Double.valueOf(obj);
                    args[i] = num;
                }
                catch (NumberFormatException e2) {
                    try {
                        if (obj.indexOf(39) == -1 && obj.indexOf(34) == -1) {
                            throw new IllegalArgumentException("Not a string");
                        }
                        String str = obj.replaceAll("'", "");
                        str = str.replaceAll("\"", "");
                        args[i] = str;
                    }
                    catch (IllegalArgumentException e4) {
                        try {
                            Boolean flag = Boolean.parseBoolean(obj);
                            args[i] = flag;
                        }
                        catch (NumberFormatException e3) {
                            logger.error((Object)("Error parsing event call argument: " + obj), (Throwable)e3);
                        }
                    }
                }
            }
        }
        return args;
    }

    private Class unBoxPrimative(Class clazz) {
        if (clazz == Boolean.class) {
            return Boolean.TYPE;
        }
        if (clazz == Integer.class) {
            return Integer.TYPE;
        }
        if (clazz == Float.class) {
            return Float.TYPE;
        }
        if (clazz == Double.class) {
            return Double.TYPE;
        }
        if (clazz == Short.class) {
            return Short.TYPE;
        }
        if (clazz == Long.class) {
            return Long.TYPE;
        }
        return clazz;
    }

    @Override
    public Object invoke(String method, Object[] args) throws XulException {
        try {
            if (method == null || method.indexOf(46) == -1) {
                throw new XulException("method call does not follow the pattern [EventHandlerID].methodName()");
            }
            String eventID = method.substring(0, method.indexOf("."));
            String methodName = method.substring(method.indexOf(".") + 1);
            Object[] arguments = this.getArgs(methodName);
            if (arguments != null) {
                return this.invoke(method.substring(0, method.indexOf("(")) + "()", arguments);
            }
            methodName = methodName.substring(0, methodName.indexOf("("));
            XulEventHandler evt = this.getEventHandler(eventID);
            if (args.length > 0) {
                Class[] classes = new Class[args.length];
                for (int i = 0; i < args.length; ++i) {
                    classes[i] = this.unBoxPrimative(args[i].getClass());
                }
                try {
                    Method m = evt.getClass().getMethod(methodName, classes);
                    return m.invoke((Object)evt, args);
                }
                catch (NoSuchMethodException e) {
                    Method m = evt.getClass().getMethod(methodName, new Class[0]);
                    return m.invoke((Object)evt, new Object[0]);
                }
            }
            Method m = evt.getClass().getMethod(methodName, new Class[0]);
            return m.invoke((Object)evt, args);
        }
        catch (Exception e) {
            logger.error((Object)("Error invoking method: " + method), (Throwable)e);
            throw new XulException("Error invoking method: " + method, e);
        }
    }

    @Override
    @Deprecated
    public void addBinding(Binding binding) {
        this.bindings.add(binding);
    }

    @Override
    public void addInitializedBinding(Binding binding) {
        this.bindings.addInitializedBinding(binding);
    }

    public void registerBinding(XulComponent comp, String expr) {
    }

    @Override
    @Deprecated
    public Binding createBinding(XulEventSource source, String sourceAttr, String targetId, String targetAttr) {
        DefaultBinding bind = new DefaultBinding(this.getDocumentRoot(), source, sourceAttr, targetId, targetAttr);
        this.bindings.add(bind);
        return bind;
    }

    @Override
    @Deprecated
    public Binding createBinding(String source, String sourceAttr, String targetId, String targetAttr) {
        DefaultBinding bind = new DefaultBinding(this.getDocumentRoot(), source, sourceAttr, targetId, targetAttr);
        this.bindings.add(bind);
        return bind;
    }

    @Override
    public boolean isRegistered(String widgetHandlerName) {
        Boolean handler = this.getXulLoader().isRegistered(widgetHandlerName);
        return handler != null;
    }

    @Override
    public Object getOuterContext() {
        return this.parentContext;
    }

    @Override
    public void setOuterContext(Object context) {
        this.parentContext = context;
    }

    @Override
    public void invokeLater(Runnable runnable) {
        XulRoot rootEle = (XulRoot)this.getDocumentRoot().getRootElement();
        rootEle.invokeLater(runnable);
    }

    @Override
    public List<Object> getResourceBundles() {
        return this.resourceBundleList;
    }

    @Override
    public void setResourceBundles(List<Object> resourceBundles) {
        this.resourceBundleList = resourceBundles;
    }

    @Override
    public void loadPerspective(String id) {
        XulPerspective perspective = this.perspectives.get(id);
        if (perspective != null) {
            for (XulEventHandler handler : perspective.getEventHandlers()) {
                this.addEventHandler(handler);
            }
            if (this.currentOverlay != null) {
                for (XulOverlay overlay : this.currentOverlay.getOverlays()) {
                    try {
                        this.removeOverlay(overlay.getOverlayUri());
                    }
                    catch (XulException e) {
                        logger.error((Object)e);
                    }
                }
            }
            for (XulOverlay overlay : perspective.getOverlays()) {
                try {
                    this.loadOverlay(overlay.getOverlayUri());
                }
                catch (XulException e) {
                    logger.error((Object)e);
                }
            }
            this.currentOverlay = perspective;
        }
    }

    @Override
    public void addPerspective(XulPerspective perspective) {
        this.perspectives.put(perspective.getID(), perspective);
    }

    @Override
    public void registerClassLoader(Object loader) {
        if (!this.classloaders.contains(loader)) {
            this.classloaders.add((ClassLoader)loader);
        }
        this.xulLoader.registerClassLoader(loader);
    }

    public Object getResourceAsStream(String name) {
        return this.xulLoader.getResourceAsStream(name);
    }

    @Override
    public void setSettingsManager(XulSettingsManager settings) {
        this.settings = settings;
    }

    @Override
    public XulSettingsManager getSettingsManager() {
        return this.settings;
    }
}

